!= Nakajima et al. (1992) Ѥ˰漾λ
!
!= Evaluate saturation specific humidity with Nakajima et al. (1992)
!
! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA
! Version::   $Id: saturate_nha1992.f90,v 1.1.1.1 2008-07-30 08:41:33 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_nha1992
  !
  != Nakajima et al. (1992) Ѥ˰漾λ
  !
  != Evaluate saturation specific humidity with Nakajima et al. (1992)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Nakajima et al. (1992) Ѥ줿˰¾ $ p^{*} $ ˴ؤʲμ
  ! Ѥ, ˰漾˰漾βʬͤ򻻽Фޤ. 
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a folloing formula for saturation watar vapor pressure 
  ! $ p^{*} $ in Nakajima et al. (1992). 
  ! 
  ! \[
  !    p^{*} (T) = p_0^{*} \exp \left( - \frac{l}{RT} \right). 
  ! \]
  !
  ! , $ T $ ϲ, $ R $ ׵Ǥ. 
  ! $ R $ Ǯ $ l $ , 
  ! ˰¶ $ p_0^{*} $ ϰʲΤ褦Ϳޤ. 
  !
  ! where $ T $ is temperature, $ R $ is the gas constant. 
  ! $ R $ and latent heat $ l $ , 
  ! constant for the water vapor saturation curve $ p_0^{*} $ are as follows.
  ! 
  ! * $ R = 8.314 $ [J mol-1 K-1]
  ! * $ l = 43655 $ [J mol-1]
  ! * $ p_0^{*} = 1.4 \times 10^{11} $ [Pa]
  !
  ! ˰¿˰漾 $ q^{*} $ ݤˤ, ʲμѤޤ. 
  !
  ! Saturation specific humidity $ q^{*} $ is calculated from 
  ! saturation watar vapor pressure as follows.
  !
  ! \[
  !    q^{*} (T, P) = \varepsilon \frac{p^{*} (T)}{p}
  ! \]
  !
  !  $ \varepsilon $ ϶ŷʬ絤ʬ, 
  ! $ p $ ϵǤ. 
  !
  ! where $ \varepsilon $ is molecular weight ratio of water vapor to air, 
  ! $ p $ is air pressure. 
  ! 
  ! ä, ˰漾, ˰漾βѲ뼰ϰʲΤ褦
  ! ʤޤ. 
  !
  ! Therefore, saturation specific humidity and temperature derivative of it 
  ! are calculated as follows. 
  !
  ! \[
  !    q^{*} (T, P) = \varepsilon \frac{p_0^{*}}{p} \exp \left( - \frac{l}{RT} \right), \] \[
  !    \DP{q^{*} (T, P)}{T} = \varepsilon \frac{p_0^{*}}{p} \frac{l}{RT^2} \exp \left( - \frac{l}{RT} \right).
  ! \]
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_nha1992_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: CalcQVapSat, CalcDQVapSatDTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_nha1992_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), parameter:: LatentHeat = 43655_DP
                              ! $ l $ [J mol-1]. 
                              ! ζŷǮ. Latent heat of condensation of water vapor
  real(DP), parameter:: P0 = 1.4e+11_DP
                              ! $ p_0^{*} $ [Pa]. 
                              ! ˰¶. constant for water vapor saturation curve

  character(*), parameter:: module_name = 'saturate_nha1992'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: saturate_nha1992.f90,v 1.1.1.1 2008-07-30 08:41:33 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface CalcQVapSat
    module procedure CalcQVapSat0  !:doc-priority 40:
    module procedure CalcQVapSat2  !:doc-priority 50:
    module procedure CalcQVapSat3  !:doc-priority 60:
  end interface

  interface CalcDQVapSatDTemp
    module procedure CalcDQVapSatDTemp0  !:doc-priority 40:
    module procedure CalcDQVapSatDTemp2  !:doc-priority 50:
    module procedure CalcDQVapSatDTemp3  !:doc-priority 60:
  end interface

contains

  subroutine CalcQVapSat0( &
    & Temp, Press, &         ! (in)
    & QVapSat &              ! (out)
    & )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! 顼ǡǤϤʤǡͿˤϲ
    ! ֥롼ѤƤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !
    ! If array data is given instead of scalar data, 
    ! use following subroutines. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &           ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: Press
                              ! $ p $ . . Air pressure
    real(DP), intent(out):: QVapSat
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    QVapSat = EpsV * ( P0 / Press ) * exp ( - LatentHeat / ( GasRUniv * Temp ) )

  end subroutine CalcQVapSat0



  subroutine CalcQVapSat2( &
    & xy_Temp, xy_Press, &      ! (in)
    & xy_QVapSat &              ! (out)
    & )
    !
    !  *xy_Temp* ȵ *xy_Press* Ѥ, 
    ! ˰漾 *xy_QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *xy_QVapSat* using
    ! temperature *xy_Temp* and air pressure *xy_Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Temp (0:imax-1, 1:jmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press (0:imax-1, 1:jmax)
                              ! $ p $ . . Air pressure
    real(DP), intent(out):: xy_QVapSat (0:imax-1, 1:jmax)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. saturate_nha1992_inited ) call SaturateInit

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    do i = 0, imax - 1
      do j = 1, jmax
        call CalcQVapSat0( &
          & xy_Temp(i,j), xy_Press(i,j), &    ! (in)
          & xy_QVapSat(i,j) )                 ! (out)
      end do
    end do

  end subroutine CalcQVapSat2



  subroutine CalcQVapSat3( &
    & xyz_Temp, xyz_Press, &     ! (in)
    & xyz_QVapSat &              ! (out)
    & )
    !
    !  *xyz_Temp* ȵ *xyz_Press* Ѥ, 
    ! ˰漾 *xyz_QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *xyz_QVapSat* using
    ! temperature *xyz_Temp* and air pressure *xyz_Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ . . Air pressure
    real(DP), intent(out):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. saturate_nha1992_inited ) call SaturateInit

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    do i = 0, imax - 1
      do j = 1, jmax
        do k = 1, kmax
          call CalcQVapSat0( &
            & xyz_Temp(i,j,k), xyz_Press(i,j,k), &    ! (in)
            & xyz_QVapSat(i,j,k) )                    ! (out)
        end do
      end do
    end do

  end subroutine CalcQVapSat3



  subroutine CalcDQVapSatDTemp0( &
    & Temp, Press, &         ! (in)
    & DQVapSatDTemp &        ! (out)
    & )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! 顼ǡǤϤʤǡͿˤϲ
    ! ֥롼ѤƤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and air pressure *Press*. 
    !
    ! If array data is given instead of scalar data, 
    ! use following subroutines. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &           ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: Press
                              ! $ p $ . . Air pressure
    real(DP), intent(out):: DQVapSatDTemp
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾βʬη׻
    ! Calculate temperature derivative of saturation specific humidity
    !
    DQVapSatDTemp = &
      & EpsV * ( P0 / Press ) &
      &   * ( LatentHeat / ( GasRUniv * Temp**2 ) ) &
      &   * exp ( - LatentHeat / ( GasRUniv * Temp ) )

  end subroutine CalcDQVapSatDTemp0



  subroutine CalcDQVapSatDTemp2( &
    & xy_Temp, xy_Press, &         ! (in)
    & xy_DQVapSatDTemp &           ! (out)
    & )
    !
    !  *xy_Temp* ȵ *xy_Press* Ѥ, 
    ! ˰漾βʬ *xy_DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *xy_DQVapSatDTemp* using
    ! temperature *xy_Temp* and air pressure *xy_Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Temp (0:imax-1, 1:jmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press (0:imax-1, 1:jmax)
                              ! $ p $ . . Air pressure
    real(DP), intent(out):: xy_DQVapSatDTemp (0:imax-1, 1:jmax)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. saturate_nha1992_inited ) call SaturateInit

    ! ˰漾βʬη׻
    ! Calculate saturation specific humidity
    !
    do i = 0, imax - 1
      do j = 1, jmax
        call CalcDQVapSatDTemp0( &
          & xy_Temp(i,j), xy_Press(i,j), &    ! (in)
          & xy_DQVapSatDTemp(i,j) )           ! (out)
      end do
    end do

  end subroutine CalcDQVapSatDTemp2



  subroutine CalcDQVapSatDTemp3( &
    & xyz_Temp, xyz_Press, &         ! (in)
    & xyz_DQVapSatDTemp &            ! (out)
    & )
    !
    !  *xyz_Temp* ȵ *xyz_Press* Ѥ, 
    ! ˰漾βʬ *xyz_DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *xyz_DQVapSatDTemp* using
    ! temperature *xyz_Temp* and air pressure *xyz_Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ . . Air pressure
    real(DP), intent(out):: xyz_DQVapSatDTemp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. saturate_nha1992_inited ) call SaturateInit

    ! ˰漾βʬη׻
    ! Calculate saturation specific humidity
    !
    do i = 0, imax - 1
      do j = 1, jmax
        do k = 1, kmax
          call CalcDQVapSatDTemp( &
            & xyz_Temp(i,j,k), xyz_Press(i,j,k), &    ! (in)
            & xyz_DQVapSatDTemp(i,j,k) )              ! (out)
        end do
      end do
    end do

  end subroutine CalcDQVapSatDTemp3



  subroutine SaturateInit
    !
    ! saturate_nha1992 ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_nha1992_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate_nha1992" module is initialized. 
    !--
    ! "NAMELIST#saturate_nha1992_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_nha1992_nml/ 
          !
          ! ǥեͤˤĤƤϽ³ "saturate_nha1992#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_nha1992#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_nha1992_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = saturate_nha1992_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
    saturate_nha1992_inited = .true.
  end subroutine SaturateInit



  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

  end subroutine InitCheck

end module saturate_nha1992
