!= ɽ̥ǡ
!
!= Prepare surface data
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: surface_data.f90,v 1.1 2008-08-11 21:54:23 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_data
  !
  != ɽ̥ǡ
  !
  != Prepare surface data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! GCM Ѥɽ̥ǡޤ.
  ! ߤϻŪ Hosaka et al. (1998)  SST ʬۤͿޤ.
  !
  ! Surface data for GCM is generated.
  ! Now, SST profile in Hosaka et al. (1998) is provided tentatively.
  !
  !== Procedures List
  !
  ! SurfDataGet   :: ɽ̥ǡμ
  ! ------------  :: ------------
  ! SurfDataGet   :: Get surface data
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_data_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SurfDataGet

  ! ѿ
  ! Public variables
  !
  logical, save, public:: surface_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(STRING), save:: Pattern
                              ! ɽ̥ǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Surface data pattern. 
                              ! Available patterns are as follows.
                              ! 
                              ! * "Hosaka et al. (1998)"
                              ! * "Homogeneous"
                              ! 
  real(DP), save:: SurfTemp
                              ! ɽ̲٤δ. 
                              ! Standard value of surface temperature
  real(DP), save:: SurfAlbedo
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP), save:: SurfHumidCoeff
                              ! ɽ. 
                              ! Surface humidity coefficient
  real(DP), save:: SurfRoughLength
                              ! ɽĹ. 
                              ! Surface rough length
  real(DP), save:: SurfHeatCapacity
                              ! ɽǮ. 
                              ! Surface heat capacity
  real(DP), save:: GroundTempFlux
                              ! Ǯեå. 
                              ! Ground temperature flux
  integer, save:: SurfCondition
                              ! ɽ. 
                              ! Surface condition

  character(*), parameter:: module_name = 'surface_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: surface_data.f90,v 1.1 2008-08-11 21:54:23 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface SurfDataGet
    module procedure SurfDataGet
  end interface

contains

  subroutine SurfDataGet( &
    & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoeff, & ! (out)
    & xy_SurfRoughLength, xy_SurfHeatCapacity, &       ! (out)
    & xy_GroundTempFlux, xy_SurfCondition &            ! (out)
    & )
    !
    ! GCM Ѥɽ̥ǡ֤ޤ.
    !
    ! Return surface data for GCM.
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat                 ! $ \varphi $ [rad.] . . Latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(out), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(out), optional:: xy_SurfHumidCoeff (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(out), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(out), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(out), optional:: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer, intent(out), optional:: xy_SurfCondition (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition

    ! ѿ (Hosaka et al. (1998))
    ! Work variables (Hosaka et al. (1998))
    !
    real(DP):: TempEq         ! ƻ (Τˤ LatCenter ) Ǥβ.
                              ! Temperature on the equator 
                              ! (on LatCenter, to be exact)
    real(DP):: LatCenter      ! ٺǹΰ. 
                              ! Latitude on which temperature is maximum.
    real(DP):: LatFlatWidth   ! ٤ʿó. 
                              ! Latitude width in which temperature is flattened
    integer:: jp
    integer:: jm

    real(DP):: LatA, Alpha, Beta, Gamma

    real(DP):: Phi1, AlphaBeta4, Phi, LatAPlus, LatAMinus
    real(DP):: SurfTempMx

    ! ѿ
    ! Work variables
    !
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. surface_data_inited ) call SurfDataInit

    select case ( LChar( trim(Pattern) ) )

    ! SST 
    ! SST is homogeneous
    !
    case ( 'homogeneous' )

      if ( present(xy_SurfTemp        ) ) xy_SurfTemp         = SurfTemp
      if ( present(xy_SurfAlbedo      ) ) xy_SurfAlbedo       = SurfAlbedo       
      if ( present(xy_SurfHumidCoeff  ) ) xy_SurfHumidCoeff   = SurfHumidCoeff   
      if ( present(xy_SurfRoughLength ) ) xy_SurfRoughLength  = SurfRoughLength  
      if ( present(xy_SurfHeatCapacity) ) xy_SurfHeatCapacity = SurfHeatCapacity 
      if ( present(xy_GroundTempFlux  ) ) xy_GroundTempFlux   = GroundTempFlux   
      if ( present(xy_SurfCondition   ) ) xy_SurfCondition    = SurfCondition    

    ! Hosaka et al. (1998) ˤѤ줿 SST
    ! SST used in Hosaka et al. (1998)
    !
    case ( 'hosaka et al. (1998)' )

      if ( present(xy_SurfAlbedo      ) ) xy_SurfAlbedo       = SurfAlbedo       
      if ( present(xy_SurfHumidCoeff  ) ) xy_SurfHumidCoeff   = SurfHumidCoeff   
      if ( present(xy_SurfRoughLength ) ) xy_SurfRoughLength  = SurfRoughLength  
      if ( present(xy_SurfHeatCapacity) ) xy_SurfHeatCapacity = SurfHeatCapacity 
      if ( present(xy_GroundTempFlux  ) ) xy_GroundTempFlux   = GroundTempFlux   
      if ( present(xy_SurfCondition   ) ) xy_SurfCondition    = SurfCondition    

      if ( present( xy_SurfTemp ) ) then
      
        TempEq       = SurfTemp
        LatCenter    =   0.0_DP
        LatFlatWidth =   7.0_DP

        LatA         =  30.0_DP
        Alpha        =  60.0_DP
        Beta         =  32.0_DP
        Gamma        =   0.0_DP

        Phi1 = abs( LatA * PI / 180.0_DP )
        AlphaBeta4  = 2.0_DP *( Phi1**3 ) * ( Beta / Alpha )

        do j = 1, jmax
          Phi = abs( y_Lat(j) - LatCenter * PI / 180.0_DP )
          xy_SurfTemp (:,j) = &
            & TempEq &
            & - Alpha / 2.0_DP &
            &   * ( Phi - max( sqrt( Phi1**2 + AlphaBeta4 ) - sqrt( ( Phi - Phi1 )**2 + AlphaBeta4 ), 0.0_DP ) ) &
            & + Gamma * ( Phi**3 )
        end do

        ! 濴 LatCenter +/- LatFlatWidth δ֤ʿó
        ! Flatten between LatCenter +/- LatFlatWidth
        ! 
        if ( LatFlatWidth < 0.0_DP ) then
          LatFlatWidth = - LatFlatWidth
        end if
        LatAPlus = ( LatCenter + LatFlatWidth ) * PI / 180.0_DP
        LatAMinus = ( LatCenter - LatFlatWidth ) * PI / 180.0_DP

        jp = 1
        jm = jmax
        do j = 1, jmax
          if ( y_Lat(j) <= LatAPlus ) then
            jp = j
            if ( j == jmax ) jp = jp - 1
          end if
          if ( y_Lat(j) < LatAMinus ) then
            jm = j
            if ( j == jmax ) jm = jm - 1
          end if
        end do

        SurfTempMx = &
          & (   xy_SurfTemp(1,jm) * ( y_Lat(jm+1) - LatAMinus ) &
          &   + xy_SurfTemp(1,jm+1) * ( LatAMinus - y_Lat(jm) ) &
          & ) &
          & / ( y_Lat(jm+1) - y_Lat(jm) )

        xy_SurfTemp(:,jm+1:jp) = SurfTempMx
      end if


    end select

  end subroutine SurfDataGet

  !-------------------------------------------------------------------

  subroutine SurfDataInit

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_data_nml/ Pattern, &
      & SurfTemp, SurfAlbedo, SurfHumidCoeff, SurfRoughLength, &
      & SurfHeatCapacity, GroundTempFlux, SurfCondition
          !
          ! ǥեͤˤĤƤϽ³ "surface_data#SurfDataInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_data#SurfDataInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement

    if ( surface_data_inited ) return
    call InitCheck

    ! ǥեͤ (ޤ Pattern Τ)
    ! Default values settings (At first, "Pattern" only)
    !
    Pattern = 'Hosaka et al. (1998)'

    ! NAMELIST ɤ߹ (ޤ Pattern Τ)
    ! NAMELIST is input (At first, "Pattern" only)
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = surface_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ǥեͤ
    ! Default values settings
    !
    select case ( LChar( trim(Pattern) ) )
    case ( 'hosaka et al. (1998)' )
      SurfTemp         = 302.0_DP
      SurfAlbedo       = 0.15_DP
      SurfHumidCoeff   = 1.0_DP  
      SurfRoughLength  = 1.0e-4_DP
      SurfHeatCapacity = 0.0_DP  
      GroundTempFlux   = 0.0_DP  
      SurfCondition    = 0

    case ( 'homogeneous' )
      SurfTemp         = 273.0_DP
      SurfAlbedo       = 0.15_DP
      SurfHumidCoeff   = 1.0_DP  
      SurfRoughLength  = 1.0e-4_DP
      SurfHeatCapacity = 0.0_DP  
      GroundTempFlux   = 0.0_DP  
      SurfCondition    = 0

    case default
      call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
        & c1 = trim(Pattern) )
    end select

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = surface_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
    call MessageNotify( 'M', module_name, '  SurfTemp         = %f', d = (/ SurfTemp         /) )
    call MessageNotify( 'M', module_name, '  SurfAlbedo       = %f', d = (/ SurfAlbedo       /) )
    call MessageNotify( 'M', module_name, '  SurfHumidCoeff   = %f', d = (/ SurfHumidCoeff   /) )
    call MessageNotify( 'M', module_name, '  SurfRoughLength  = %f', d = (/ SurfRoughLength  /) )
    call MessageNotify( 'M', module_name, '  SurfHeatCapacity = %f', d = (/ SurfHeatCapacity /) )
    call MessageNotify( 'M', module_name, '  GroundTempFlux   = %f', d = (/ GroundTempFlux   /) )
    call MessageNotify( 'M', module_name, '  SurfCondition    = %d', i = (/ SurfCondition    /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_data_inited = .true.
  end subroutine SurfDataInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited


    ! ¹ʸ ; Executable statement

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

  end subroutine InitCheck

end module surface_data
