!= ˡˤʬ
!
!= Time integration with implicit scheme
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: phy_implicit.f90,v 1.2 2008-08-09 15:23:27 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_implicit
  !
  != ˡˤʬ
  !
  != Time integration with implicit scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! PhyImplGetMatrices :: κȼ
  ! PhyImplTendency    :: ѲΨη׻
  ! ------------       :: ------------
  ! PhyImplGetMatrices :: Create and get implicit matrices
  ! PhyImplTendency    :: Calculate tendency
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#phy_implicit_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: PhyImplGetMatrices, PhyImplTendency

  ! ѿ
  ! Public variables
  !
  logical, save, public:: phy_implicit_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !


  character(*), parameter:: module_name = 'phy_implicit'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: phy_implicit.f90,v 1.2 2008-08-09 15:23:27 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface PhyImplGetMatrices
    module procedure PhyImplGetMatrices
  end interface

  interface PhyImplTendency
    module procedure PhyImplTendency
  end interface

contains

  subroutine PhyImplGetMatrices( &
    & xyr_Press, xy_SurfHeatCapacity, xy_SurfCondition, & ! (in)
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (out)
    & xyza_UVMtx, xyra_TempMtx, xyza_QVapMtx &            ! (out)
    & )
    !
    ! κȼԤޤ.
    !
    ! Create and get implicit matrices. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    integer, intent(in):: xy_SurfCondition (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(out):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(out):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(out):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(out):: xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(out):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP), intent(out):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP), intent(out):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_inited ) call PhyImplInit

    ! , Ǯ̤ιη׻
    ! Calculate mass and heat capacity terms
    !
    xyza_UVMtx  = 0.0_DP
    xyra_TempMtx = 0.0_DP
    xyza_QVapMtx = 0.0_DP

    do k = 1, kmax
      xyza_UVMtx(:,:,k,0)  = &
        & ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) &
        &    / Grav / ( 2.0_DP * DelTime )
      xyra_TempMtx(:,:,k,0) = xyza_UVMtx(:,:,k,0) * CpDry
      xyza_QVapMtx(:,:,k,0) = xyza_UVMtx(:,:,k,0) * CpDry
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCondition(i,j) >= 1 ) then
          xyra_TempMtx(i,j,0,0) = &
            & xy_SurfHeatCapacity(i,j) / ( 2.0_DP * DelTime )
        else
          xyra_TempMtx(i,j,0,0) = 1.0_DP
        end if
      end do
    end do

    ! եåꥻå
    ! Reset fluxes
    !
    xyr_UFlux    = 0.0_DP
    xyr_VFlux    = 0.0_DP
    xyr_TempFlux = 0.0_DP
    xyr_QVapFlux = 0.0_DP

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplGetMatrices



  subroutine PhyImplTendency( &
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (in)
    & xy_SurfRadSFlux, xy_SurfRadLFlux, &                 ! (in)
    & xy_GroundTempFlux, &                                ! (in)
    & xyza_UVMtx, xyra_TempMtx, xyza_QVapMtx, &           ! (in)
    & xy_SurfUVMtx, xyaa_SurfTempMtx, &                   ! (in)
    & xyaa_SurfQVapMtx, xya_SurfRadLMtx, &                ! (in)
    & xy_SurfCondition, &                                 ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &     ! (out)
    & xy_DSurfTempDt &                                    ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ. 
    !
    ! Calculate tendencies. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(in):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(in):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(in):: xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux

    real(DP), intent(in):: xy_SurfRadSFlux (0:imax-1, 1:jmax)
                              ! û () եå (ɽ). 
                              ! Shortwave (insolation) flux on surface
    real(DP), intent(in):: xy_SurfRadLFlux (0:imax-1, 1:jmax)
                              ! Ĺȥեå (ɽ). 
                              ! Longwave flux on surface

    real(DP), intent(in):: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux

    real(DP), intent(in):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP), intent(in):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP), intent(in):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity

    real(DP), intent(in):: xy_SurfUVMtx (0:imax-1, 1:jmax)
                              ! ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP), intent(in):: xyaa_SurfTempMtx (0:imax-1, 1:jmax, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP), intent(in):: xyaa_SurfQVapMtx (0:imax-1, 1:jmax, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface
    real(DP), intent(in):: xya_SurfRadLMtx (0:imax-1, 1:jmax, -1:1)
                              ! $ T $ .  : ɽ. 
                              ! implicit matrix: surface
    integer, intent(in):: xy_SurfCondition (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition

    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_DelTempQVap (0:imax-1, 1:jmax, -kmax:kmax)
                              ! $ T q $ λѲ. 
                              ! Tendency of $ T q $ 
    real(DP):: xyza_TempQVapLUMtx (0:imax-1, 1:jmax, -kmax:kmax, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xyza_UVLUMtx (0:imax-1, 1:jmax, 1:kmax,-1:1)
                              ! LU . 
                              ! LU matrix

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: l               !  DO 롼Ѻѿ
                              ! Work variables for DO loop of matrices

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_inited ) call PhyImplInit

    ! ®, ®η׻
    ! Calculate eastward and northward wind
    !
    xyza_UVLUMtx = xyza_UVMtx
    xyza_UVLUMtx(:,:,1,0) = xyza_UVLUMtx(:,:,1,0) + xy_SurfUVMtx
    
    call PhyImplLUDecomp3( &
      & xyza_UVLUMtx, &     ! (inout)
      & imax * jmax, kmax ) ! (in)
    
    do k = 1, kmax
      xyz_DUDt(:,:,k) = xyr_UFlux(:,:,k-1) - xyr_UFlux(:,:,k)
      xyz_DVDt(:,:,k) = xyr_VFlux(:,:,k-1) - xyr_VFlux(:,:,k)
    end do

    call PhyImplLUSolve3( &
      & xyz_DUDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)
    
    call PhyImplLUSolve3( &
      & xyz_DVDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)
    
    ! ٤漾η׻
    ! Calculate temperature and specific humidity
    !
    do l = -1, 1
      
      do k = 1, kmax
        xyza_TempQVapLUMtx(:,:,k,l)   = xyra_TempMtx(:,:,k,l)
        xyza_TempQVapLUMtx(:,:,-k,-l) = xyza_QVapMtx(:,:,k,l)
      end do
      
      xyza_TempQVapLUMtx(:,:, 1, l) =   xyra_TempMtx(:,:,1,l) &
        &                             + xyaa_SurfTempMtx(:,:,1,l)

      xyza_TempQVapLUMtx(:,:,-1,-l) =   xyza_QVapMtx(:,:,1,l) &
        &                             + xyaa_SurfQVapMtx(:,:,1,l)
      
    end do
    
    xyza_TempQVapLUMtx(:,:,0, 0) =   xyra_TempMtx(:,:,0,0) &
      &                            + xyaa_SurfTempMtx(:,:,0,0) &
      &                            + xyaa_SurfQVapMtx(:,:,0,0) &
      &                            + xya_SurfRadLMtx(:,:,0)
    
    xyza_TempQVapLUMtx(:,:,0, 1) =   xyaa_SurfTempMtx(:,:,0,1) &
      &                            + xya_SurfRadLMtx(:,:,1)
    
    xyza_TempQVapLUMtx(:,:,0,-1) =  xyaa_SurfQVapMtx(:,:,0,1)
    
    call PhyImplLUDecomp3( &
      & xyza_TempQVapLUMtx, &         ! (inout)
      & imax * jmax, (2 * kmax) + 1 ) ! (in)
    
    do k = 1, kmax
      xyz_DelTempQVap(:,:, k) = xyr_TempFlux(:,:,k-1) - xyr_TempFlux(:,:,k)
      xyz_DelTempQVap(:,:,-k) = xyr_QVapFlux(:,:,k-1) - xyr_QVapFlux(:,:,k)
    end do
    
    xyz_DelTempQVap(:,:,0) = - xy_SurfRadSFlux     - xy_SurfRadLFlux     &
      &                      - xyr_TempFlux(:,:,0) - xyr_QVapFlux(:,:,0) &
      &                      + xy_GroundTempFlux
    
    call PhyImplLUSolve3( &
      & xyz_DelTempQVap, &                ! (inout)
      & xyza_TempQVapLUMtx, &             ! (in)
      & 1, imax * jmax , (2 * kmax) + 1 ) ! (in)
    
    ! ѲΨη׻
    ! Calculate tendency
    !
    do k = 1, kmax
      xyz_DUDt(:,:,k)    = xyz_DUDt(:,:,k)         / ( 2.0_DP * DelTime )
      xyz_DVDt(:,:,k)    = xyz_DVDt(:,:,k)         / ( 2.0_DP * DelTime )
      xyz_DTempDt(:,:,k) = xyz_DelTempQVap(:,:, k) / ( 2.0_DP * DelTime )
      xyz_DQVapDt(:,:,k) = xyz_DelTempQVap(:,:,-k) / ( 2.0_DP * DelTime ) / LatentHeat * CpDry
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCondition(i,j) >= 1 ) then
          xy_DSurfTempDt(i,j) = xyz_DelTempQVap(i,j,0) / ( 2.0_DP * DelTime )
        else
          xy_DSurfTempDt(i,j) = 0.0_DP
        end if
      end do
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'DUDtVDiff',    xyz_DUDt )
    call HistoryAutoPut( 'DVDtVDiff',    xyz_DVDt )
    call HistoryAutoPut( 'DTempDtVDiff', xyz_DTempDt )
    call HistoryAutoPut( 'DQVapDtVDiff', xyz_DQVapDt )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplTendency



  subroutine PhyImplLUDecomp3( &
    & jna_LUMtx, &            ! (inout)
    & JDim, NDim &            ! (in)
    & )
    !
    ! 3 гѹ LU ʬԤޤ. 
    !
    ! LU decomposition of triple diagonal matrix.
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: JDim
    integer, intent(in):: NDim
    real(DP), intent(inout):: jna_LUMtx(JDim, NDim, -1:1)
                              ! LU . 
                              ! LU matrix

    ! ѿ
    ! Work variables
    ! 
    integer:: j, n            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    ! ¹ʸ ; Executable statement
    !

    ! LU ʬ
    ! LU decomposition
    !
    do j = 1, JDim
      jna_LUMtx(j,1,1) = jna_LUMtx(j,1,1) / jna_LUMtx(j,1,0)
    end do

    do n = 2, NDim-1
      do j = 1, JDim
        jna_LUMtx(j,n,0)  =   jna_LUMtx(j,n,0) &
          &                 - jna_LUMtx(j,n,-1) * jna_LUMtx(j,n-1,1)

        jna_LUMtx(j,n,1)  =   jna_LUMtx(j,n,1) / jna_LUMtx(j,n,0)
      end do
    end do

    do j = 1, JDim
      jna_LUMtx(j,NDim,0) =   jna_LUMtx(j,NDim, 0) &
        &                   - jna_LUMtx(j,NDim,-1) * jna_LUMtx(j,NDim-1,1)
    end do

  end subroutine PhyImplLUDecomp3



  subroutine PhyImplLUSolve3( &
    & ijn_Vector, &       ! (inout)
    & jna_LUMtx, &        ! (in)
    & IDim, JDim, NDim &  ! (in)
    & )
    !
    ! LU ʬˤη׻ (3гѹ) Ԥޤ.
    !
    ! Solve with LU decomposition (For triple diagonal matrix). 
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: IDim
    integer, intent(in):: JDim
    integer, intent(in):: NDim
    real(DP), intent(in):: jna_LUMtx(JDim, NDim, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP), intent(inout):: ijn_Vector(IDim, JDim, NDim)
                              ! ե٥ȥ / . 
                              ! Right-hand side vector / solution

    ! ѿ
    ! Work variables
    ! 
    integer:: i, j, n         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Forward substitution
    !
    do i = 1, IDim
      do j = 1, JDim
        ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jna_LUMtx(j,1,0)
      end do
    end do

    do n = 2, NDim
      do i = 1, IDim
        do j = 1, JDim
          ijn_Vector(i,j,n) = (   ijn_Vector(i,j,n) &
            &                   - ijn_Vector(i,j,n-1) * jna_LUMtx(j,n,-1) &
            &                  ) / jna_LUMtx(j,n,0)
        end do
      end do
    end do

    ! 
    ! Backward substitution
    !
    do n = NDim-1, 1, -1
      do i = 1, IDim
        do j = 1, JDim
          ijn_Vector(i,j,n) =   ijn_Vector(i,j,n) &
            &                 - ijn_Vector(i,j,n+1) * jna_LUMtx(j,n,1)
        end do
      end do
    end do

  end subroutine PhyImplLUSolve3



  subroutine PhyImplInit
    !
    ! phy_implicit ⥸塼νԤޤ. 
    ! NAMELIST#phy_implicit_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "phy_implicit" module is initialized. 
    ! "NAMELIST#phy_implicit_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetIntStepEval

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /phy_implicit_nml/ &
          !
          ! ǥեͤˤĤƤϽ³ "phy_implicit#PhyImplInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "phy_implicit#PhyImplInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( phy_implicit_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = phy_implicit_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DUDtVDiff', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'diffusive force(x)', 'm s-2' )
    call HistoryAutoAddVariable( 'DVDtVDiff', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'diffusive force(y)', 'm s-2' )
    call HistoryAutoAddVariable( 'DTempDtVDiff', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'diffusive heating', 'K s-1' )
    call HistoryAutoAddVariable( 'DQVapDtVDiff', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'diffusive moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    phy_implicit_inited = .true.
  end subroutine PhyImplInit



  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module phy_implicit
