!= dcpam Held and Suarez (1994) ٥ޡƥѼץ
!
!= dcpam main program for Held and Suarez (1994) benchmark test
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcpam_hs94.f90,v 1.3 2008-08-12 09:50:30 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_hs94
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Held and Suarez (1994) ٥ޡƥȤԤʤޤ.
  !
  ! Held and Suarez (1994) benchmark test is performed.
  !
  !== References
  !
  ! * Held, I. M., Suarez, M. J., 1994: 
  !   A proposal for the intercomparison of the dynamical cores of
  !   atmospheric general circuation models.
  !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.

  ! ⥸塼 ; USE statements
  !

  ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
  !
  use dynamics_hspl_vas83, only: Dynamics

  ! Held and Suarez (1994) ˤ붯Ȼ
  ! Forcing and dissipation suggested by Held and Suarez (1994)
  !
  use held_suarez_1994, only: Hs94Forcing

  ! ե륿 (Asselin, 1972)
  ! Time filter (Asselin, 1972)
  !
  use timefilter_asselin1972, only: TimeFilter

  ! 
  ! Time control
  !
  use timeset, only: TimesetProgress, &
    &                Nstep       ! 롼ײ. Number of times of loops

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: RestartFileOutPut

  ! ҥȥǡ
  ! History data output
  !
  use gt4_historyauto, only: HistoryAutoPut, HistoryAutoProgress

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_UB (:,:,:)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_VB (:,:,:)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
  real(DP), allocatable:: xyz_TempB (:,:,:)
                              ! $ T (t-\Delta t) $ .   . Temperature
  real(DP), allocatable:: xyz_QVapB (:,:,:)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
  real(DP), allocatable:: xy_PsB (:,:)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_UN (:,:,:)
                              ! $ u (t) $ .     ®. Eastward wind
  real(DP), allocatable:: xyz_VN (:,:,:)
                              ! $ v (t) $ .     ®. Northward wind
  real(DP), allocatable:: xyz_TempN (:,:,:)
                              ! $ T (t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVapN (:,:,:)
                              ! $ q (t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_PsN (:,:)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_UA (:,:,:)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_VA (:,:,:)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
  real(DP), allocatable:: xyz_TempA (:,:,:)
                              ! $ T (t+\Delta t) $ .   . Temperature
  real(DP), allocatable:: xyz_QVapA (:,:,:)
                              ! $ q (t+\Delta t) $ .   漾. Specific humidity
  real(DP), allocatable:: xy_PsA (:,:)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure


  ! ѿ
  ! Diagnostic variables
  !
  real(DP), allocatable:: xyz_DUDt (:,:,:)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
  real(DP), allocatable:: xyz_DVDt (:,:,:)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
  real(DP), allocatable:: xyz_DTempDt (:,:,:)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
  real(DP), allocatable:: xyz_DQVapDt (:,:,:)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency

  ! ѿ
  ! Work variables
  !
  integer:: i                 ! ˲ DO 롼Ѻѿ. 
                              ! Work variables for DO loop in time
  logical:: firstloop = .true.
                              ! Υ롼פǤ뤳Ȥ򼨤ե饰. 
                              ! Flag implying first loop

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit


  ! ʬ
  ! Time integration
  !
  do i = 1, Nstep

    ! Held and Suarez (1994) ˤ붯Ȼ
    ! Forcing and dissipation suggested by Held and Suarez (1994)
    !
    call Hs94Forcing( &
      & xyz_UB, xyz_VB, xyz_TempB, xy_PsB, & ! (in)
      & xyz_DUDt, xyz_DVDt, xyz_DTempDt )    ! (out)
    xyz_DQVapDt = 0.0_DP

    ! ϳز
    ! Dynamical core
    !
    call Dynamics( &
      & xyz_UB,   xyz_VB,   xyz_TempB,   xyz_QVapB,   xy_PsB, &   ! (in)
      & xyz_UN,   xyz_VN,   xyz_TempN,   xyz_QVapN,   xy_PsN, &   ! (in)
      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &           ! (in)
      & xyz_UA,   xyz_VA,   xyz_TempA,   xyz_QVapA,   xy_PsA  )   ! (out)

    ! ֥ե륿
    ! Time filter
    !
    call TimeFilter( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN, &   ! (inout)
      & xyz_UA, xyz_VA, xyz_TempA, xyz_QVapA, xy_PsA  )   ! (in)

    ! ҥȥǡ
    ! History data output
    !
    if ( .not. firstloop ) then
      call HistoryAutoPut( 'U',    xyz_UN )
      call HistoryAutoPut( 'V',    xyz_VN )
      call HistoryAutoPut( 'Temp', xyz_TempN )
      call HistoryAutoPut( 'QVap', xyz_QVapN )
      call HistoryAutoPut( 'Ps',   xy_PsN )
    end if

    ! ͽѿλդؤ
    ! Exchange time of prediction variables
    !
    xyz_UB    = xyz_UN    ; xyz_UN    = xyz_UA    ; xyz_UA    = 0.0_DP
    xyz_VB    = xyz_VN    ; xyz_VN    = xyz_VA    ; xyz_VA    = 0.0_DP
    xyz_TempB = xyz_TempN ; xyz_TempN = xyz_TempA ; xyz_TempA = 0.0_DP
    xyz_QVapB = xyz_QVapN ; xyz_QVapN = xyz_QVapA ; xyz_QVapA = 0.0_DP
    xy_PsB    = xy_PsN    ; xy_PsN    = xy_PsA    ; xy_PsA    = 0.0_DP

    ! οʹ
    ! Progress time
    !
    call TimesetProgress
    call HistoryAutoProgress

    ! ꥹȥǡ
    ! Restart data output
    !
    if ( .not. firstloop ) then
      call RestartFileOutput( &
        & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
        & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (in)
    end if

    firstloop = .false.
  end do

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate



contains



  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileOpen, RestartFileGet

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen
    use gt4_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ¹ʸ ; Executable statement
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_UB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsB    (0:imax-1, 1:jmax) )

    allocate( xyz_UN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsN    (0:imax-1, 1:jmax) )

    allocate( xyz_UA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsA    (0:imax-1, 1:jmax) )

    ! ꥹȥǡ
    ! Restart data input
    !
    call RestartFileGet( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (out)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (out)

    ! ꥹȥǡ
    ! Restart data output
    !
    call RestartFileOpen

    ! ꥹȥեؽͥǡ
    ! Output initial data to a restart file
    !
    call RestartFileOutput( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (in)

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'U' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'eastward wind', 'm s-1' )

    call HistoryAutoAddVariable( 'V' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'northwardward wind', 'm s-1' )

    call HistoryAutoAddVariable( 'Temp' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'temperature', 'K' )

    call HistoryAutoAddVariable( 'QVap' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'specific humidity', 'kg kg-1' )

    call HistoryAutoAddVariable( 'Ps' , &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface pressure', 'Pa' )

    ! ҥȥǡ (Ȼ)
    ! History data output (Start time)
    !
    call HistoryAutoPut( 'U', xyz_UN )
    call HistoryAutoPut( 'V', xyz_VN )
    call HistoryAutoPut( 'Temp', xyz_TempN )
    call HistoryAutoPut( 'QVap', xyz_QVapN )
    call HistoryAutoPut( 'Ps', xy_PsN )


    ! ѿγ
    ! Allocation of diagnostic variables
    !
    allocate( xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax) )

  end subroutine MainInit



  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data input
    !
    call RestartFileClose

    ! ҥȥǡե륯
    ! Close history data input
    !
    call HistoryFileClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

  end subroutine MainTerminate

end program dcpam_hs94
