!= dcpam ¸Ѽץ
!
!= dcpam main program for aqua planet experiments
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcpam_ape.f90,v 1.12 2008-08-12 09:50:30 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_ape
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! , ʤ夬ʤƤ褦絤η׻
  ! Ԥޤ. 
  !
  ! Calculation of 
  ! atmosphere on a planet covered with water globally is performed. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
  !
  use dynamics_hspl_vas83, only: Dynamics

  ! ͥեå (Хɥǥ)
  ! Radiation flux (band model)
  !
  use radiation_band, only: RadiationFlux, RadiationCorrect, RadiationDTempDt

  ! ľȻեå (Mellor and Yamada, 1974, ٥ 2)
  ! Vertical diffusion flux (Mellor and Yamada, 1974, Level 2)
  !
  use vdiffusion_my1974, only: VerticalDiffusion

  ! ѱѥ᥿ꥼ (ήĴ)
  ! Cumulus parameterization (convection adjust)
  !
  use cumulus_adjust, only: Cumulus

  ! 絬϶ŷ
  ! Large scale condensation
  !
  use lscond, only: LScaleCond

  ! ɽ̥եå
  ! Surface flux
  use surface_flux_bulk, only: SurfaceFlux

  ! ήĴ
  ! Dry convective adjustment
  !
  use dryconv_adjust, only: DryConvectAdjust

  ! ο
  ! Remove negative moisture
  !
  use negative_moist, only: RemoveNegMoist

  ! ٤Ⱦҥ٥, ȥݥƥ󥷥λ
  ! Interpolate temperature on half sigma level, 
  ! and calculate pressure and geo-potential
  !
  use intpol_half, only: IntpolHalfLevel

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
  use phy_implicit, only: PhyImplGetMatrices, PhyImplTendency

  ! ե륿 (Asselin, 1972)
  ! Time filter (Asselin, 1972)
  !
  use timefilter_asselin1972, only: TimeFilter

  ! 
  ! Time control
  !
  use timeset, only: TimesetProgress, &
    &                Nstep       ! 롼ײ. Number of times of loops

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: RestartFileOutPut

  ! ҥȥǡ
  ! History data output
  !
  use gt4_historyauto, only: HistoryAutoPut, HistoryAutoProgress

  ! ɽ̥ǡե
  ! Ground data file input
  !
  use ground_file_io, only: GroundFileGet

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_UB (:,:,:)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_VB (:,:,:)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
  real(DP), allocatable:: xyz_TempB (:,:,:)
                              ! $ T (t-\Delta t) $ .   . Temperature
  real(DP), allocatable:: xyz_QVapB (:,:,:)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
  real(DP), allocatable:: xy_PsB (:,:)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_UN (:,:,:)
                              ! $ u (t) $ .     ®. Eastward wind
  real(DP), allocatable:: xyz_VN (:,:,:)
                              ! $ v (t) $ .     ®. Northward wind
  real(DP), allocatable:: xyz_TempN (:,:,:)
                              ! $ T (t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVapN (:,:,:)
                              ! $ q (t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_PsN (:,:)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_UA (:,:,:)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_VA (:,:,:)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
  real(DP), allocatable:: xyz_TempA (:,:,:)
                              ! $ T (t+\Delta t) $ .   . Temperature
  real(DP), allocatable:: xyz_QVapA (:,:,:)
                              ! $ q (t+\Delta t) $ .   漾. Specific humidity
  real(DP), allocatable:: xy_PsA (:,:)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure


  ! ѿ
  ! Diagnostic variables
  !
  real(DP), allocatable:: xyz_DUDt (:,:,:)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
  real(DP), allocatable:: xyz_DVDt (:,:,:)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
  real(DP), allocatable:: xyz_DTempDt (:,:,:)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
  real(DP), allocatable:: xyz_DQVapDt (:,:,:)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency

  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP), allocatable:: xy_SurfAlbedo (:,:)
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP), allocatable:: xy_SurfHumidCoeff (:,:)
                              ! ɽ. 
                              ! Surface humidity coefficient
  real(DP), allocatable:: xy_SurfRoughLength (:,:)
                              ! ɽĹ. 
                              ! Surface rough length
  real(DP), allocatable:: xy_SurfHeatCapacity (:,:)
                              ! ɽǮ. 
                              ! Surface heat capacity
  integer, allocatable:: xy_SurfCondition (:,:)
                              ! ɽ. 
                              ! Surface condition
  real(DP), allocatable:: xy_GroundTempFlux (:,:)
                              ! Ǯեå. 
                              ! Ground temperature flux


  real(DP), allocatable:: xyza_UVMtx (:,:,:,:)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
  real(DP), allocatable:: xyra_TempMtx (:,:,:,:)
                              ! ٱ. 
                              ! Implicit matrix about temperature
  real(DP), allocatable:: xyza_QVapMtx (:,:,:,:)
                              ! 漾. 
                              ! Implicit matrix about specific humidity

  real(DP), allocatable:: xyr_Temp (:,:,:)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
  real(DP), allocatable:: xyz_GeoPot (:,:,:)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
  real(DP), allocatable:: xyr_GeoPot (:,:,:)
                              ! $ \hat{\phi} $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)

  real(DP), allocatable:: xyr_RadLFlux (:,:,:)
                              ! Ĺȥեå. 
                              ! Longwave flux
  real(DP), allocatable:: xyr_RadSFlux (:,:,:)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
  real(DP), allocatable:: xya_SurfRadLMtx (:,:,:)
                              ! $ T $ .  : ɽ. 
                              ! implicit matrix: surface
  real(DP), allocatable:: xyra_DelRadLFlux (:,:,:,:)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

  real(DP), allocatable:: xyr_UFlux (:,:,:)
                              ! ®եå. 
                              ! Eastward wind flux
  real(DP), allocatable:: xyr_VFlux (:,:,:)
                              ! ®եå. 
                              ! Northward wind flux
  real(DP), allocatable:: xyr_TempFlux (:,:,:)
                              ! ٥եå. 
                              ! Temperature flux
  real(DP), allocatable:: xyr_QVapFlux (:,:,:)
                              ! 漾եå. 
                              ! Specific humidity flux

  real(DP), allocatable:: xy_SurfUVMtx (:,:)
                              ! ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
  real(DP), allocatable:: xyaa_SurfTempMtx (:,:,:,:)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
  real(DP), allocatable:: xyaa_SurfQVapMtx (:,:,:,:)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface

  real(DP), allocatable:: xy_DSurfTempDt (:,:)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency

  real(DP), allocatable:: xyz_DTempDtRadL (:,:,:)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
  real(DP), allocatable:: xyz_DTempDtRadS (:,:,:)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

  real(DP), allocatable:: xyz_DNegQVap1Dt (:,:,:)
                              ! ο˴ؤ漾ѲΨ (1). 
                              ! Specific humidity tendency by elimination of negative moist (1)
  real(DP), allocatable:: xyz_DNegQVap2Dt (:,:,:)
                              ! ο˴ؤ漾ѲΨ (2). 
                              ! Specific humidity tendency by elimination of negative moist (2)


  ! ѿ
  ! Work variables
  !
  integer:: i                 ! ˲ DO 롼Ѻѿ. 
                              ! Work variables for DO loop in time
  logical:: firstloop = .true.
                              ! Υ롼פǤ뤳Ȥ򼨤ե饰. 
                              ! Flag implying first loop

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit


  ! ʬ
  ! Time integration
  !
  do i = 1, Nstep

    ! ɽ̾
    ! Configure surface conditions
    !
    call GroundFileGet( &
      & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoeff, & ! (out)
      & xy_SurfRoughLength, xy_SurfHeatCapacity, &       ! (out)
      & xy_GroundTempFlux, xy_SurfCondition )            ! (out)

    ! ٤Ⱦҥ٥, ȥݥƥ󥷥λ
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and geo-potential
    !
    call IntpolHalfLevel( &
      & xy_PsB,     xyz_TempB, &   ! (in)
      & xyr_Temp, &                ! (out)
      & xyz_Press,  xyr_Press, &   ! (out)
      & xyz_GeoPot, xyr_GeoPot )   ! (out)

    ! ˡΤι
    ! Create matrices for implicit scheme
    !
    call PhyImplGetMatrices( &
      & xyr_Press, xy_SurfHeatCapacity, xy_SurfCondition, & ! (in)
      & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (out)
      & xyza_UVMtx, xyra_TempMtx, xyza_QVapMtx )            ! (out)

    ! ͥեå (Хɥǥ)
    ! Radiation flux (band model)
    !
    call RadiationFlux( & 
      & xyz_TempB, xyz_QVapB, xyr_Press, &       ! (in)
      & xy_SurfTemp, xy_SurfAlbedo, &            ! (in)
      & xyr_RadLFlux, xyr_RadSFlux, &            ! (out)
      & xya_SurfRadLMtx, xyra_DelRadLFlux )      ! (out)

    ! ľȻեå
    ! Vertical diffusion flux
    !
    call VerticalDiffusion( &
      & xyz_UB,    xyz_VB,    xyz_QVapB, &                  ! (in)
      & xyz_TempB, xyr_Temp, &                              ! (in)
      & xyz_Press, xyr_Press, xyz_GeoPot,   xyr_GeoPot, &   ! (in)
      & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (inout)
      & xyza_UVMtx, xyra_TempMtx, xyza_QVapMtx  )           ! (inout)

    ! ɽ̥եå
    ! Surface flux
    !
    call SurfaceFlux( &
      & xyz_UB, xyz_VB, xyz_TempB, xyr_Temp, xyz_QVapB, &   ! (in)
      & xyz_Press, xyr_Press, xyz_GeoPot, &                 ! (in)
      & xy_SurfTemp, xy_SurfHumidCoeff, &                   ! (in)
      & xy_SurfRoughLength, xy_SurfCondition, &             ! (in)
      & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (inout)
      & xy_SurfUVMtx, xyaa_SurfTempMtx, xyaa_SurfQVapMtx )  ! (out)

    ! ʪλѲΨη׻ (ˡ)
    ! Calculate tendency by a part of physical processes (implicit)
    !
    call PhyImplTendency( &
      & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (in)
      & xyr_RadSFlux(:,:,0), xyr_RadLFlux(:,:,0), &         ! (in)
      & xy_GroundTempFlux, &                                ! (in)
      & xyza_UVMtx, xyra_TempMtx, xyza_QVapMtx, &           ! (in)
      & xy_SurfUVMtx, xyaa_SurfTempMtx, &                   ! (in)
      & xyaa_SurfQVapMtx, xya_SurfRadLMtx, &                ! (in)
      & xy_SurfCondition, &                                 ! (in)
      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &     ! (out)
      & xy_DSurfTempDt )                                    ! (out)

    ! ͥեå
    ! Radiation flux correction
    !
    call RadiationCorrect( &
      & xyz_DTempDt, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
      & xyr_RadLFlux )                                   ! (inout)

    ! ͤˤ벹ѲΨ
    ! Temperature tendency with radiation
    !
    call RadiationDTempDt( &
      & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
      & xyz_DTempDtRadL, xyz_DTempDtRadS )       ! (out)

    xyz_DTempDt = xyz_DTempDt + xyz_DTempDtRadL + xyz_DTempDtRadS

    ! ϳز
    ! Dynamical core
    !
    call Dynamics( &
      & xyz_UB,   xyz_VB,   xyz_TempB,   xyz_QVapB,   xy_PsB, &   ! (in)
      & xyz_UN,   xyz_VN,   xyz_TempN,   xyz_QVapN,   xy_PsN, &   ! (in)
      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &           ! (in)
      & xyz_UA,   xyz_VA,   xyz_TempA,   xyz_QVapA,   xy_PsA  )   ! (out)

    ! ٤Ⱦҥ٥, ȥݥƥ󥷥λ
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and geo-potential
    !
    call IntpolHalfLevel( &
      & xy_PsA,     xyz_TempA, &   ! (in)
      & xyr_Temp, &                ! (out)
      & xyz_Press,  xyr_Press, &   ! (out)
      & xyz_GeoPot, xyr_GeoPot )   ! (out)

    ! ο (1)
    ! Remove negative moisture (1)
    !
    xyz_DNegQVap1Dt = 0.0_DP
    call RemoveNegMoist( &
      & xyr_Press = xyr_Press, &                                  ! (in)
      & xyz_QVap = xyz_QVapA, xyz_DNegQVapDt = xyz_DNegQVap1Dt )  ! (inout)

    ! ѱѥ᥿ꥼ
    ! Cumulus parameterization
    !
    call Cumulus( &
      & xyz_TempA, xyz_QVapA, &  ! (inout)
      & xyz_Press, xyr_Press )   ! (in)

    ! 絬϶ŷ
    ! Large scale condensation
    !
    call LScaleCond( &
      & xyz_TempA, xyz_QVapA, &  ! (inout)
      & xyz_Press, xyr_Press )   ! (in)

    ! ήĴ
    ! Dry convective adjustment
    !
    call DryConvectAdjust( &
      & xyz_Press, xyr_Press, & ! (in)
      & xyz_TempA )             ! (inout)

    ! ο (2)
    ! Remove negative moisture (2)
    !
    xyz_DNegQVap2Dt = 0.0_DP
    call RemoveNegMoist( &
      & xyr_Press = xyr_Press, &                                  ! (in)
      & xyz_QVap = xyz_QVapA, xyz_DNegQVapDt = xyz_DNegQVap2Dt )  ! (inout)

    ! ֥ե륿
    ! Time filter
    !
    call TimeFilter( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN, &   ! (inout)
      & xyz_UA, xyz_VA, xyz_TempA, xyz_QVapA, xy_PsA  )   ! (in)

    ! ҥȥǡ
    ! History data output
    !
    if ( .not. firstloop ) then
      call HistoryAutoPut( 'U',    xyz_UN )
      call HistoryAutoPut( 'V',    xyz_VN )
      call HistoryAutoPut( 'Temp', xyz_TempN )
      call HistoryAutoPut( 'QVap', xyz_QVapN )
      call HistoryAutoPut( 'Ps',   xy_PsN )
    end if

    ! ͽѿλդؤ
    ! Exchange time of prediction variables
    !
    xyz_UB    = xyz_UN    ; xyz_UN    = xyz_UA    ; xyz_UA    = 0.0_DP
    xyz_VB    = xyz_VN    ; xyz_VN    = xyz_VA    ; xyz_VA    = 0.0_DP
    xyz_TempB = xyz_TempN ; xyz_TempN = xyz_TempA ; xyz_TempA = 0.0_DP
    xyz_QVapB = xyz_QVapN ; xyz_QVapN = xyz_QVapA ; xyz_QVapA = 0.0_DP
    xy_PsB    = xy_PsN    ; xy_PsN    = xy_PsA    ; xy_PsA    = 0.0_DP

    ! οʹ
    ! Progress time
    !
    call TimesetProgress
    call HistoryAutoProgress

    ! ꥹȥǡ
    ! Restart data output
    !
    if ( .not. firstloop ) then
      call RestartFileOutput( &
        & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
        & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (in)
    end if

    firstloop = .false.
  end do

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate



contains



  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileOpen, RestartFileGet

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen
    use gt4_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ¹ʸ ; Executable statement
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_UB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsB    (0:imax-1, 1:jmax) )

    allocate( xyz_UN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsN    (0:imax-1, 1:jmax) )

    allocate( xyz_UA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_PsA    (0:imax-1, 1:jmax) )

    ! ꥹȥǡ
    ! Restart data input
    !
    call RestartFileGet( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (out)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (out)

    ! ꥹȥǡ
    ! Restart data output
    !
    call RestartFileOpen

    ! ꥹȥեؽͥǡ
    ! Output initial data to a restart file
    !
    call RestartFileOutput( &
      & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  )   ! (in)

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'U' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'eastward wind', 'm s-1' )

    call HistoryAutoAddVariable( 'V' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'northwardward wind', 'm s-1' )

    call HistoryAutoAddVariable( 'Temp' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'temperature', 'K' )

    call HistoryAutoAddVariable( 'QVap' , &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'specific humidity', 'kg kg-1' )

    call HistoryAutoAddVariable( 'Ps' , &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface pressure', 'Pa' )

    ! ҥȥǡ (Ȼ)
    ! History data output (Start time)
    !
    call HistoryAutoPut( 'U', xyz_UN )
    call HistoryAutoPut( 'V', xyz_VN )
    call HistoryAutoPut( 'Temp', xyz_TempN )
    call HistoryAutoPut( 'QVap', xyz_QVapN )
    call HistoryAutoPut( 'Ps', xy_PsN )


    ! ѿγ
    ! Allocation of diagnostic variables
    !
    allocate( xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax) )

    allocate( xy_SurfTemp         (0:imax-1, 1:jmax) )
    allocate( xy_SurfAlbedo       (0:imax-1, 1:jmax) )
    allocate( xy_SurfHumidCoeff   (0:imax-1, 1:jmax) )
    allocate( xy_SurfRoughLength  (0:imax-1, 1:jmax) )
    allocate( xy_SurfHeatCapacity (0:imax-1, 1:jmax) )
    allocate( xy_SurfCondition    (0:imax-1, 1:jmax) )
    allocate( xy_GroundTempFlux   (0:imax-1, 1:jmax) )

    allocate( xyza_UVMtx   (0:imax-1, 1:jmax, 1:kmax, -1:1) )
    allocate( xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1) )
    allocate( xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1) )

    allocate( xyr_Temp   (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyz_GeoPot (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyr_GeoPot (0:imax-1, 1:jmax, 0:kmax) )

    allocate( xyr_RadLFlux     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_RadSFlux     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xya_SurfRadLMtx  (0:imax-1, 1:jmax,         -1:1) )
    allocate( xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1) )

    allocate( xyr_UFlux    (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_VFlux    (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax) )

    allocate( xy_SurfUVMtx     (0:imax-1, 1:jmax) )
    allocate( xyaa_SurfTempMtx (0:imax-1, 1:jmax, 0:1, -1:1) )
    allocate( xyaa_SurfQVapMtx (0:imax-1, 1:jmax, 0:1, -1:1) )

    allocate( xy_DSurfTempDt (0:imax-1, 1:jmax) )

    allocate( xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax) )

    allocate( xyz_DNegQVap1Dt (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DNegQVap2Dt (0:imax-1, 1:jmax, 1:kmax) )

  end subroutine MainInit



  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data input
    !
    call RestartFileClose

    ! ҥȥǡե륯
    ! Close history data input
    !
    call HistoryFileClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

  end subroutine MainTerminate

end program dcpam_ape
