!= 絬϶ŷ
!
!= Large scale condensation
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: lscond.f90,v 1.1 2008-08-10 04:10:20 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module lscond
  !
  != 絬϶ŷ
  !
  != Large scale condensation
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 絬϶ŷˤäƲ٤漾Ĵᤷޤ. 
  ! ˰漾η׻ˤ Nakajima et al. (1992) ѤƤޤ. 
  ! ܤ phy_saturate_nha92 򻲾ȤƤ. 
  !
  ! Adjust temperature and specific humidity by 
  ! a large scale condensation process.
  ! Nakajima et al. (1992) is used for calculation of 
  ! saturation specific humidity. 
  ! For details, see "phy_saturate_nha92". 
  !
  !== Procedures List
  ! 
  ! LScaleCond    :: ٤漾Ĵ
  ! ------------  :: ------------
  ! LScaleCond    :: Adjust temperature and specific humidity
  !
  !== NAMELIST
  !
  ! NAMELIST#lscond_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: LScaleCond

  ! ѿ
  ! Public variables
  !
  logical, save, public:: lscond_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration

  ! Nakajima et al. (1992) Ѥ˰漾η׻Ѥ
  ! Values for calculation of saturation specific humidity with Nakajima et al. (1992) 
  ! 
  real(DP), parameter:: LatHeatNha92 = 43655_DP
                              ! $ l $ [J mol-1].
                              ! ζŷǮ. Latent heat of condensation of water vapor
  real(DP), parameter:: P0Nha92 = 1.4e+11_DP
                              ! $ p_0^{*} $ [Pa].
                              ! ˰¶. constant for water vapor saturation curve

  character(*), parameter:: module_name = 'lscond'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: lscond.f90,v 1.1 2008-08-10 04:10:20 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface LScaleCond
    module procedure LScaleCond
  end interface

contains

  subroutine LScaleCond( &
    & xyz_Temp, xyz_QVap, &  ! (inout)
    & xyz_Press, xyr_Press & ! (in)
    & )
    !
    ! 絬϶ŷ륹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! large scale condensation scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &
                              ! $ R^{*} $ [J K-1 mol-1]. 
                              ! ׵.  Universal gas constant
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & EpsV
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)

    ! ѿ
    ! Work variables
    !
    real(DP):: xy_Rain (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: QVapSat
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: DQVapSatDTemp
                              ! $ \DD{q_{\rm{sat}}}{T} $
    real(DP):: DelQVap
                              ! Ĵˤ漾Ѳ. 
                              ! Specific humidity variation by adjustment
    real(DP):: DelTemp
                              ! Ĵˤ벹Ѳ. 
                              ! Temperature variation by adjustment


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction


    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. lscond_inited ) call LSCondInit

    ! Ĵ "QVap", "Temp" ¸
    ! Store "QVap", "Temp" before adjustment
    !
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp

    ! Ĵ
    ! Adjustment
    !
    do k = kmax, 1, -1
      do i = 0, imax-1
        do j = 1, jmax
          
          ! ˰漾׻
          ! Calculate saturation specific humidity 
          !
          QVapSat = EpsV * ( P0Nha92 / xyz_Press(i,j,k) ) &
            &         * exp ( - LatHeatNha92 / ( GasRUniv * xyz_Temp(i,j,k) ) )

!!$          call CalcQVapSat( phy_lsc % phy_sat, & ! (in)
!!$            &    Temp = xyz_Temp(i,j,k), &       ! (in)
!!$            &   Press = xyz_Press(i,j,k), &      ! (in)
!!$            & QVapSat = QVapSat )                ! (out)
!!$
!!$          QVapSat = &
!!$            & EpsV * ES0 &
!!$            &   * exp( LatentHeat / RVap &
!!$            &           * ( 1.0_DP / 273.0_DP - 1.0_DP / xyz_Temp(i,j,k) ) ) &
!!$            &   / xyz_Press(i,j,k)
          
          ! ˰¤Ƥ, ٤漾Ѳ׻
          ! Calculate tendency of temperature and humidity 
          ! if moist is saturation. 
          !
          if ( ( xyz_QVap(i,j,k) / QVapSat ) >= CrtlRH ) then
            
            do itr = 1, ItrtMax
              
              ! ˰漾׻
              ! Calculate saturation specific humidity
              !
              QVapSat = EpsV * ( P0Nha92 / xyz_Press(i,j,k) ) &
                &         * exp ( - LatHeatNha92 / ( GasRUniv * xyz_Temp(i,j,k) ) )

              DQVapSatDTemp = &
                & QVapSat * ( LatHeatNha92 / ( GasRUniv * xyz_Temp(i,j,k)**2 ) )

!!$              call CalcQVapSat( phy_lsc % phy_sat, & ! (in)
!!$                &    Temp = xyz_Temp(i,j,k), &       ! (in)
!!$                &   Press = xyz_Press(i,j,k), &      ! (in)
!!$                & QVapSat = QVapSat )                ! (out)
!!$
!!$              call CalcDQVapSatDTemp( phy_lsc % phy_sat, & ! (in)
!!$                &          Temp = xyz_Temp(i,j,k), &       ! (in)
!!$                &         Press = xyz_Press(i,j,k), &      ! (in)
!!$                & DQVapSatDTemp = DQVapSatDTemp )          ! (out)
!!$
!!$              QVapSat = &
!!$                & EpsV * ES0  &
!!$                &   * exp( LatentHeat / RVap &
!!$                &           * ( 1.0_DP / 273.0_DP - 1.0_DP / xyz_Temp(i,j,k) ) ) &
!!$                &   / xyz_Press(i,j,k)
!!$
!!$              DQVapSatDTemp = &
!!$                & LatentHeat * QVapSat / ( RVap * xyz_Temp(i,j,k) * xyz_Temp(i,j,k) )
              ! ٤漾Ѳʬ˥塼ȥˡǵ
              ! Calculate variation of temperature and specific humidity 
              ! with Newton method
              !
              DelTemp = &
                & LatentHeat / CpDry * ( xyz_QVap(i,j,k) - QVapSat ) &
                &    / ( 1.0_DP + LatentHeat / CpDry * DQVapSatDTemp )
              DelQVap = DQVapSatDTemp * DelTemp 
              
              ! ٤漾Ĵ
              ! Adjust temperature and specific humidity
              !
              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
              xyz_QVap(i,j,k) = QVapSat + DelQVap
              
            end do
            
          end if
        end do
      end do
    end do
    
    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, 
    ! precipitation
    !
    xy_Rain     = 0.0_DP
    xyz_DTempDt = 0.0_DP
    xyz_DQvapDt = 0.0_DP

    xyz_DQVapDt = xyz_DQVapDt & 
      & + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    xyz_DTempDt = xyz_DTempDt &
      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    do k = kmax, 1, -1
      xy_Rain = xy_Rain &
        & + ( xyz_Temp(:,:,k) - xyz_TempB(:,:,k) ) &
        &     * CpDry / ( 2.0_DP * DelTime ) &
        &     * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do
    

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'RainLsc',    xy_Rain )
    call HistoryAutoPut( 'DTempDtLsc', xyz_DTempDt )
    call HistoryAutoPut( 'DQVapDtLsc', xyz_DQVapDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine LScaleCond

  !-------------------------------------------------------------------

  subroutine LSCondInit
    !
    ! lscond ⥸塼νԤޤ. 
    ! NAMELIST#lscond_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "lscond" module is initialized. 
    ! "NAMELIST#lscond_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetIntStepEval

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /lscond_nml/ &
      & CrtlRH, ItrtMax
          !
          ! ǥեͤˤĤƤϽ³ "lscond#LSCondInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "lscond#LSCondInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( lscond_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    CrtlRH  = 1.0_DP
    ItrtMax = 3

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = lscond_nml, &   ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
    end if

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'RainLsc', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'precipitation by large scale condensation', 'W m-2' )
    call HistoryAutoAddVariable( 'DTempDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation heating', 'K s-1' )
    call HistoryAutoAddVariable( 'DQVapDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  CrtlRH  = %f', d = (/ CrtlRH /) )
    call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    lscond_inited = .true.
  end subroutine LSCondInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module lscond
