!= ꥹȥǡ
!
!= Restart data input/output
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: restart_file_io.f90,v 1.4 2008-08-11 21:51:02 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module restart_file_io
  !
  != ꥹȥǡ
  !
  != Restart data input/output
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ꥹȥǡϤԤޤ. 
  ! ϥե, ϥե, ǡνϤδֳ֤
  ! NAMELIST#restart_file_io_nml ꤷޤ. 
  !
  ! ꥹȥǡϥե뤬ꤵʤ, 
  ! initial_data ⥸塼뤫ͥǡޤ. 
  !
  ! Restart data is input/output. 
  ! Settings of input file, output file, and interval of data output 
  ! is configured by "NAMELIST#restart_file_io_nml". 
  !
  ! If input file of restart data is not set, 
  ! initial data is obtained from "initial_data" module. 
  !
  !== Procedures List
  !
  ! RestartFileOpen   :: ꥹȥեΥץ
  ! RestartFileOutput :: ꥹȥեؤΥǡ
  ! RestartFileClose  :: ꥹȥեΥ
  ! RestartFileGet    :: ꥹȥե
  ! ------------      :: ------------
  ! RestartFileOpen   :: Open restart file
  ! RestartFileOutput :: Data output to restart file
  ! RestartFileClose  :: Close restart file
  ! RestartFileGet    :: Input restart file
  !
  !== NAMELIST
  !
  ! NAMELIST#restart_file_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool4 ǡ
  ! Gtool4 data output
  !
  use gt4_history, only: GT_HISTORY

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RestartFileOpen, RestartFileClose, RestartFileOutPut
  public:: RestartFileGet

  ! ѿ
  ! Public variables
  !
  logical, save, public:: restart_file_io_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  logical, save, public:: restart_file_opened = .false.
                              ! ꥹȥեΥץ˴ؤե饰. 
                              ! Flag of restart file open

  ! ѿ
  ! Private variables
  !
  character(STRING), save:: InputFile
                              ! ϤꥹȥǡΥե̾
                              ! filename of input restart data

  character(STRING), save:: OutputFile
                              ! ϤꥹȥǡΥե̾
                              ! filename of output restart data
  real(DP), save:: IntValue
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output
  character(TOKEN):: IntUnit
                              ! ꥹȥǡνϴֳ֤ñ. 
                              ! Unit for interval of restart data output

  type(GT_HISTORY), save:: gthst_rst
                              ! ꥹȥǡ gt4_history#GT_HISTORY ѿ
                              ! "gt4_history#GT_HISTORY" variable for restart data


  integer:: IntStep
                              ! ꥹȥǡνϴֳ֥ƥå׿
                              ! Number of step of interval of restart data output

  character(*), parameter:: module_name = 'restart_file_io'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: restart_file_io.f90,v 1.4 2008-08-11 21:51:02 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface RestartFileOpen
    module procedure RestartFileOpen
  end interface

  interface RestartFileClose
    module procedure RestartFileClose
  end interface

  interface RestartFileOutput
    module procedure RestartFileOutput
  end interface

  interface RestartFileGet
    module procedure RestartFileGet
  end interface

contains

  subroutine RestartFileOpen
    !
    ! ꥹȥե򥪡ץ󤷤ޤ. 
    !
    ! A restart file is opened. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ.
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: DelTime, & ! $ \Delta t $ [s]
      & TimesetGetStartTime

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: HistoryCreate, HistoryAddVariable, &
      & HistoryPut, HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    real(DP):: origin_time
                              ! ׻ϻ. 
                              ! Start time of calculation

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. restart_file_io_inited ) call RestartFileInit
    if ( restart_file_opened ) return

    ! μ
    ! Get time information
    !
    call TimesetGetStartTime( &
      & origin_time, & ! (out)
      & IntUnit  &     ! (in) optional
      & )

    ! ꥹȥեΥץ
    ! Open a restart file
    !
    call HistoryCreate( &
      &      file = OutputFile,   &
      &     title = trim(FileTitle) // ' restart data', &          ! (in)
      &    source = FileSource, institution = FileInstitution, &   ! (in)
      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
      & longnames = StoA( 'longitude', 'latitude', &
      &                   'sigma at layer midpoints', &
      &                   'sigma at layer end-points (half level)', &
      &                   'time' ), &                              ! (in)
      &     units = StoA( 'degree_east', 'degree_north', &
      &                   '1', '1', IntUnit ), &                   ! (in)
      &    origin = real( origin_time ), &                         ! (in)
      &  interval = real( IntValue ), &                            ! (in)
      &   history = gthst_rst )                                    ! (out)

    ! $ \Delta t $ ˴ؤɲ
    ! Add information about $ \Delta t $
    !
    call HistoryAddVariable( &
      & varname = 'deltime', &            ! (in)
      & dims = StoA(''), &                ! (in)
      & longname = 'delta time', &        ! (in)
      & units = 's', xtype = 'float', &   ! (in)
      & history = gthst_rst )             ! (inout)
    call HistoryPut( &
      & varname = 'deltime', &            ! (in)
      & array = (/ DelTime /), &          ! (in)
      & history = gthst_rst )             ! (inout)

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAddAttr( &
      & varname = 'lon', attrname = 'standard_name', &   ! (in)
      & value = 'longitude', &                           ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'lat', attrname = 'standard_name', &   ! (in)
      & value = 'latitude', &                            ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate', &         ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate', &         ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'time', attrname = 'standard_name', &  ! (in)
      & value = 'time', &                                ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'positive', &        ! (in)
      & value = 'down', &                                ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'sigm', attrname = 'positive', &       ! (in)
      & value = 'down', &                                ! (in)
      & history = gthst_rst )                            ! (inout)

    call HistoryPut( &
      & varname = 'lon', &               ! (in)
      & array = x_Lon / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )            ! (inout)
    call HistoryPut( &
      & varname = 'lat', &               ! (in)
      & array = y_Lat / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )            ! (inout)
    call HistoryPut( &
      & varname = 'sig', &               ! (in)
      & array = z_Sigma, &               ! (in)
      & history = gthst_rst )            ! (inout)
    call HistoryPut( & 
      & varname = 'sigm', &              ! (in)
      & array = r_Sigma, &               ! (in)
      & history = gthst_rst )            ! (inout)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAddVariable( &
      & varname = 'lon_weight', &                           ! (in)
      & dims = StoA('lon'), &                               ! (in)
      & longname = 'weight for integration in longitude', & ! (in)
      & units = 'radian', xtype = 'double', &               ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddAttr( &
      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight', &                             ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryPut( &
      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
      & history = gthst_rst )                               ! (inout)

    call HistoryAddVariable( &
      & varname = 'lat_weight', &                           ! (in)
      & dims = StoA('lat'), &                               ! (in)
      & longname = 'weight for integration in latitude', &  ! (in)
      & units = 'radian', xtype = 'double', &               ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddAttr( &
      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight', &                             ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryPut( &
      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
      & history = gthst_rst )                               ! (inout)

    call HistoryAddVariable( &
      & varname = 'sig_weight', &                           ! (in)
      & dims = StoA('sig'), &                               ! (in)
      & longname = 'weight for integration in sigma', &     ! (in)
      & units = '1', xtype = 'double', &                    ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'sig_weight', &                             ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryPut( &
      & varname = 'sig_weight', array = z_DelSigma, &       ! (in)
      & history = gthst_rst )                               ! (inout)

    ! ͽѿ
    ! Predictional variables settings
    !
    call HistoryAddVariable( &
      & varname = 'UB', &                                   ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'eastward wind (at t-\Delta t)', &       ! (in)
      & units = 'm s-1', xtype = 'double', &                ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'VB', &                                   ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'northward wind (at t-\Delta t)', &      ! (in)
      & units = 'm s-1', xtype = 'double', &                ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'TempB', &                                ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'temperature (at t-\Delta t)', &         ! (in)
      & units = 'K', xtype = 'double', &                    ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'QVapB', &                                ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'specific humidity (at t-\Delta t)', &   ! (in)
      & units = 'kg kg-1', xtype = 'double', &              ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'PsB', &                                  ! (in)
      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
      & longname = 'surface pressure (at t-\Delta t)', &    ! (in)
      & units = 'Pa', xtype = 'double', &                   ! (in)
      & history = gthst_rst )                               ! (inout)

    call HistoryAddVariable( &
      & varname = 'UN', &                                   ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'eastward wind (at t)', &                ! (in)
      & units = 'm s-1', xtype = 'double', &                ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'VN', &                                   ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'northward wind (at t)', &               ! (in)
      & units = 'm s-1', xtype = 'double', &                ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'TempN', &                                ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'temperature (at t)', &                  ! (in)
      & units = 'K', xtype = 'double', &                    ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'QVapN', &                                ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
      & longname = 'specific humidity (at t)', &            ! (in)
      & units = 'kg kg-1', xtype = 'double', &              ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddVariable( &
      & varname = 'PsN', &                                  ! (in)
      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
      & longname = 'surface pressure (at t)', &             ! (in)
      & units = 'Pa', xtype = 'double', &                   ! (in)
      & history = gthst_rst )                               ! (inout)

    restart_file_opened = .true.
  end subroutine RestartFileOpen

  !-------------------------------------------------------------------

  subroutine RestartFileOutput( &
    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
    & )
    !
    ! ꥹȥǡνϤԤޤ. 
    !
    ! Output restart data

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: HistoryPut

    ! 
    ! Time control
    !
    use timeset, only: Cstep  ! ߤΥƥå׿. 
                              ! Current steps

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !


    ! ¹ʸ ; Executable statement
    !

    if ( .not. restart_file_opened ) call RestartFileOpen

    ! ϥߥ󥰤Υå
    ! Check output timing
    !
    if ( mod( Cstep - 1, IntStep ) /= 0 ) return

    ! ǡ
    ! Data output
    !
    call HistoryPut( &
      & 'UB', xyz_UB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'VB', xyz_VB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'TempB', xyz_TempB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'QVapB', xyz_QVapB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'PsB', xy_PsB, history = gthst_rst ) ! (in)

    call HistoryPut( &
      & 'UN', xyz_UN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'VN', xyz_VN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'TempN', xyz_TempN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'QVapN', xyz_QVapN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'PsN', xy_PsN, history = gthst_rst ) ! (in)

  end subroutine RestartFileOutput

  !-------------------------------------------------------------------

  subroutine RestartFileClose
    !
    ! ꥹȥǡեϤνλԤޤ. 
    !
    ! Terminate restart data files output. 

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: HistoryClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) return

    call HistoryClose( history = gthst_rst ) ! (inout)

    restart_file_opened = .false.
  end subroutine RestartFileClose

  !-------------------------------------------------------------------

  subroutine RestartFileGet( &
    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (out)
    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (out)
    & )
    !
    ! ꥹȥǡϤԤޤ. 
    !
    ! Input restart data

    ! ⥸塼 ; USE statements
    !

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    use initial_data, only: InitDataGet

    ! 
    ! Time control
    !
    use timeset, only: TimesetGetStartTime

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gt4_history, only: HistoryGet

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(out):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(out):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(out):: xy_PsB (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(out):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(out):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(out):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(out):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(out):: xy_PsN (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP):: start_time
                              ! ׻ϻ
                              ! Start time of calculation
    character(TOKEN):: time_range
                              ! λ
                              ! Specification of time

    ! ¹ʸ ; Executable statement
    !

    if ( .not. restart_file_io_inited ) call RestartFileInit

    ! ǡ initial_data ⥸塼뤫
    ! Data is input from "initial_data" module
    ! 
    if ( trim(InputFile) == '' ) then
      call InitDataGet( &
        & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &  ! (out)
        & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN )   ! (out)

    ! ǡ InputFile 
    ! Data is input from InputFile
    ! 
    else

      ! μ
      ! Get time information
      !
      call TimesetGetStartTime( start_time ) ! (out)
      time_range = 'time=' // toChar( start_time )

      ! ǡ
      ! Data input
      ! 
      call HistoryGet( &
        & InputFile, 'UB', range = time_range, &  ! (in)
        & array = xyz_UB )                        ! (out)
      call HistoryGet( &
        & InputFile, 'VB', range = time_range, &  ! (in)
        & array = xyz_VB )                        ! (out)
      call HistoryGet( &
        & InputFile, 'TempB', range = time_range, &  ! (in)
        & array = xyz_TempB )                        ! (out)
      call HistoryGet( &
        & InputFile, 'QVapB', range = time_range, &  ! (in)
        & array = xyz_QVapB )                        ! (out)
      call HistoryGet( &
        & InputFile, 'PsB', range = time_range, &  ! (in)
        & array = xy_PsB )                         ! (out)

      call HistoryGet( &
        & InputFile, 'UN', range = time_range, &  ! (in)
        & array = xyz_UN )                        ! (out)
      call HistoryGet( &
        & InputFile, 'VN', range = time_range, &  ! (in)
        & array = xyz_VN )                        ! (out)
      call HistoryGet( &
        & InputFile, 'TempN', range = time_range, &  ! (in)
        & array = xyz_TempN )                        ! (out)
      call HistoryGet( &
        & InputFile, 'QVapN', range = time_range, &  ! (in)
        & array = xyz_QVapN )                        ! (out)
      call HistoryGet( &
        & InputFile, 'PsN', range = time_range, &  ! (in)
        & array = xy_PsN )                         ! (out)

    end if

  end subroutine RestartFileGet

  !-------------------------------------------------------------------

  subroutine RestartFileInit
    !
    ! restart_file_io ⥸塼νԤޤ. 
    ! NAMELIST#restart_file_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "restart_file_io" module is initialized. 
    ! "NAMELIST#restart_file_io_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: DelTime, & ! $ \Delta t $ [s]
      & TimesetGetDelTime

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    real(DP):: delta_time
                              ! $ \Delta t $

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /restart_file_io_nml/ &
      & InputFile, &
      & OutputFile, &
      & IntValue, IntUnit
          !
          ! ǥեͤˤĤƤϽ³ "restart_file_io#RestartFileInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "restart_file_io#RestartFileInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement
    !

    if ( restart_file_io_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    InputFile  = ''
    OutputFile = 'restart.nc'
    IntValue   = 1.0_DP
    IntUnit    = 'day'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = restart_file_io_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = restart_file_io_nml )
    end if


    ! ϥƥå׿λ
    ! Calculate number of step of output 
    !
    call TimesetGetDelTime( &
      & delta_time, & ! (out)
      & IntUnit  &    ! (in) optional
      & )

    IntStep = max( 1, nint( IntValue / delta_time ) )


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
    call MessageNotify( 'M', module_name, 'Output:: ' )
    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
    call MessageNotify( 'M', module_name, '  IntStep    = %d', i = (/ IntStep /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    restart_file_io_inited = .true.
  end subroutine RestartFileInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ϥեδܾ
    ! Management basic information for output files
    !
    use fileset, only: fileset_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited


    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. fileset_inited ) &
      & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )


  end subroutine InitCheck

end module restart_file_io
