!= ɽ̥ǡե
!
!= Ground data file input
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: ground_file_io.f90,v 1.1 2008-08-11 21:58:50 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module ground_file_io
  !
  != ɽ̥ǡե
  !
  != Ground data file input
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤ɽ̤̽˴ؤǡ NetCDF ե뤫Ϥޤ. 
  !
  ! Data about sea surface temperature (SST) or various values on surface
  ! are input from a NetCDF file. 
  !
  !== Procedures List
  !--
  ! GroundFileOpen   :: ɽ̥ǡեΥץ
  ! GroundFileOutput :: ɽ̥ǡեؤΥǡ
  ! GroundFileClose  :: ɽ̥ǡեΥ
  !++
  ! GroundFileGet    :: ɽ̥ǡե
  ! ------------     :: ------------
  !--
  ! GroundFileOpen   :: Open ground data file
  ! GroundFileOutput :: Data output to ground data file
  ! GroundFileClose  :: Close ground data file
  !++
  ! GroundFileGet    :: Input ground data file
  !
  !== NAMELIST
  !
  ! NAMELIST#ground_file_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool4 ǡ
  ! Gtool4 data output
  !
  use gt4_history, only: GT_HISTORY

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
!  public:: GroundFileOpen, GroundFileClose, GroundFileOutPut
  public:: GroundFileGet

  ! ѿ
  ! Public variables
  !
  logical, save, public:: ground_file_io_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  logical, save, public:: ground_file_opened = .false.
                              ! ɽ̥ǡեΥץ˴ؤե饰. 
                              ! Flag of ground data file open

  ! ѿ
  ! Private variables
  !
  character(STRING), save:: InputFile
                              ! Ϥɽ̥ǡΥե̾
                              ! filename of input ground data
  character(TOKEN), save:: SurfTempVarname
                              ! ɽ̲٤ѿ̾. 
                              ! Variable name of surface temperature
  character(TOKEN), save:: SurfAlbedoVarname
                              ! ɽ٥ɤѿ̾. 
                              ! Variable name of surface albedo
  character(TOKEN), save:: SurfHumidCoeffVarname
                              ! ɽ٤ѿ̾. 
                              ! Variable name of surface humidity coefficient
  character(TOKEN), save:: SurfRoughLengthVarname
                              ! ɽĹѿ̾. 
                              ! Variable name of surface rough length
  character(TOKEN), save:: SurfHeatCapacityVarname
                              ! ɽǮ̤ѿ̾. 
                              ! Variable name of surface heat capacity
  character(TOKEN), save:: GroundTempFluxVarname
                              ! Ǯեåѿ̾. 
                              ! Variable name of ground temperature flux
  character(TOKEN), save:: SurfConditionVarname
                              ! ɽ֤ѿ̾. 
                              ! Variable name of surface condition


!!$  character(STRING), save:: OutputFile
!!$                              ! Ϥɽ̥ǡΥե̾
!!$                              ! filename of output ground data
!!$  real(DP), save:: IntValue
!!$                              ! ɽ̥ǡνϴֳ. 
!!$                              ! Interval of ground data output
!!$  character(TOKEN):: IntUnit
!!$                              ! ɽ̥ǡνϴֳ֤ñ. 
!!$                              ! Unit for interval of ground data output
!!$
!!$  type(GT_HISTORY), save:: gthst_grd
!!$                              ! ɽ̥ǡ gt4_history#GT_HISTORY ѿ
!!$                              ! "gt4_history#GT_HISTORY" variable for ground data
!!$
!!$
!!$  integer:: IntStep
!!$                              ! ɽ̥ǡνϴֳ֥ƥå׿
!!$                              ! Number of step of interval of ground data output

  character(*), parameter:: module_name = 'ground_file_io'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: ground_file_io.f90,v 1.1 2008-08-11 21:58:50 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
!!$  interface GroundFileOpen
!!$    module procedure GroundFileOpen
!!$  end interface
!!$
!!$  interface GroundFileClose
!!$    module procedure GroundFileClose
!!$  end interface
!!$
!!$  interface GroundFileOutput
!!$    module procedure GroundFileOutput
!!$  end interface

  interface GroundFileGet
    module procedure GroundFileGet
  end interface

contains

  subroutine GroundFileGet( &
    & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoeff, & ! (out)
    & xy_SurfRoughLength, xy_SurfHeatCapacity, &       ! (out)
    & xy_GroundTempFlux, xy_SurfCondition &            ! (out)
    & )
    !
    ! ɽ̥ǡޤ.
    !
    ! Get data on ground.
    !

    ! ⥸塼 ; USE statements
    !

    ! ɽ̥ǡ
    ! Prepare surface data
    !
    use surface_data, only: SurfDataGet

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gt4_history, only: HistoryGet

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(out), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(out), optional:: xy_SurfHumidCoeff (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(out), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(out), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(out), optional:: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer, intent(out), optional:: xy_SurfCondition (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( .not. ground_file_io_inited ) call GroundFileInit

    ! ǡ (ǥե)  initial_data ⥸塼뤫
    ! Data (default values) is input from "initial_data" module
    ! 
    call SurfDataGet( &
      & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoeff, & ! (out)
      & xy_SurfRoughLength, xy_SurfHeatCapacity, &       ! (out)
      & xy_GroundTempFlux, xy_SurfCondition )            ! (out)

    ! ǡ InputFile 
    ! Data is input from InputFile
    ! 
    if ( trim(InputFile) /= '' ) then

      ! ǡ
      ! Data input
      ! 
      if ( trim(SurfTempVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, SurfTempVarname, xy_SurfTemp )
      end if

      if ( trim(SurfAlbedoVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, SurfAlbedoVarname, xy_SurfAlbedo )
      end if

      if ( trim(SurfHumidcoeffVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, SurfHumidcoeffVarname, xy_SurfHumidcoeff )
      end if

      if ( trim(SurfRoughLengthVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, SurfRoughLengthVarname, xy_SurfRoughLength )
      end if

      if ( trim(SurfHeatCapacityVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, SurfHeatCapacityVarname, xy_SurfHeatCapacity )
      end if

      if ( trim(GroundTempFluxVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, GroundTempFluxVarname, xy_GroundTempFlux )
      end if

      if ( trim(SurfConditionVarname) /= '' ) then
        call HistoryGet( &
          & InputFile, SurfConditionVarname, xy_SurfCondition )
      end if

    end if

  end subroutine GroundFileGet

  !-------------------------------------------------------------------

!!$  subroutine GroundFileOpen
!!$    !
!!$    ! ɽ̥ǡե򥪡ץ󤷤ޤ. 
!!$    !
!!$    ! A ground data file is opened. 
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! ϥեδܾ
!!$    ! Basic information for output files
!!$    ! 
!!$    use fileset, only: &
!!$      & FileTitle, &
!!$                              ! ϥǡեɽ.
!!$                              ! Title of output data files
!!$      & FileSource, &
!!$                              ! ǡեμ. 
!!$                              ! Source of data file
!!$      & FileInstitution
!!$                              ! ǡեǽŪѹȿ/Ŀ. 
!!$                              ! Institution or person that changes data files for the last time
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: PI   ! $ \pi $ .
!!$                              ! ߼Ψ.  Circular constant
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    use axesset, only: &
!!$      & x_Lon, &
!!$                              ! $ \lambda $ [rad.] . . Longitude
!!$      & x_Lon_Weight, &
!!$                              ! $ \Delta \lambda $ [rad.] . 
!!$                              ! ٺɸŤ. 
!!$                              ! Weight of longitude
!!$      & y_Lat, &
!!$                              ! $ \varphi $ [rad.] . . Latitude
!!$      & y_Lat_Weight, &
!!$                              ! $ \Delta \varphi $ [rad.] . 
!!$                              ! ٺɸŤ. 
!!$                              ! Weight of latitude
!!$      & z_Sigma, &
!!$                              ! $ \sigma $ ٥ (). 
!!$                              ! Full $ \sigma $ level
!!$      & r_Sigma, &
!!$                              ! $ \sigma $ ٥ (Ⱦ). 
!!$                              ! Half $ \sigma $ level
!!$      & z_DelSigma
!!$                              ! $ \Delta \sigma $ (). 
!!$                              ! $ \Delta \sigma $ (Full)
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: DelTime, & ! $ \Delta t $ [s]
!!$      & TimesetGetStartTime
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gt4_history, only: HistoryCreate, HistoryAddVariable, &
!!$      & HistoryPut, HistoryAddAttr
!!$
!!$    ! ʸ
!!$    ! Character handling
!!$    !
!!$    use dc_string, only: StoA
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP):: origin_time
!!$                              ! ׻ϻ. 
!!$                              ! Start time of calculation
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. ground_file_io_inited ) call GroundFileInit
!!$    if ( ground_file_opened ) return
!!$
!!$    ! μ
!!$    ! Get time information
!!$    !
!!$    call TimesetGetStartTime( &
!!$      & origin_time, & ! (out)
!!$      & IntUnit  &     ! (in) optional
!!$      & )
!!$
!!$    ! ɽ̥ǡեΥץ
!!$    ! Open a ground data file
!!$    !
!!$    call HistoryCreate( &
!!$      &      file = OutputFile,   &
!!$      &     title = trim(FileTitle) // ' ground data', &          ! (in)
!!$      &    source = FileSource, institution = FileInstitution, &   ! (in)
!!$      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
!!$      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
!!$      & longnames = StoA( 'longitude', 'latitude', &
!!$      &                   'sigma at layer midpoints', &
!!$      &                   'sigma at layer end-points (half level)', &
!!$      &                   'time' ), &                              ! (in)
!!$      &     units = StoA( 'degree_east', 'degree_north', &
!!$      &                   '1', '1', IntUnit ), &                   ! (in)
!!$      &    origin = real( origin_time ), &                         ! (in)
!!$      &  interval = real( IntValue ), &                            ! (in)
!!$      &   history = gthst_grd )                                    ! (out)
!!$
!!$    ! $ \Delta t $ ˴ؤɲ
!!$    ! Add information about $ \Delta t $
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'deltime', &            ! (in)
!!$      & dims = StoA(''), &                ! (in)
!!$      & longname = 'delta time', &        ! (in)
!!$      & units = 's', xtype = 'float', &   ! (in)
!!$      & history = gthst_grd )             ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'deltime', &            ! (in)
!!$      & array = (/ DelTime /), &          ! (in)
!!$      & history = gthst_grd )             ! (inout)
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    call HistoryAddAttr( &
!!$      & varname = 'lon', attrname = 'standard_name', &   ! (in)
!!$      & value = 'longitude', &                           ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lat', attrname = 'standard_name', &   ! (in)
!!$      & value = 'latitude', &                            ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'standard_name', &   ! (in)
!!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
!!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'time', attrname = 'standard_name', &  ! (in)
!!$      & value = 'time', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'positive', &        ! (in)
!!$      & value = 'down', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sigm', attrname = 'positive', &       ! (in)
!!$      & value = 'down', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$
!!$    call HistoryPut( &
!!$      & varname = 'lon', &               ! (in)
!!$      & array = x_Lon / PI * 180.0_DP, & ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lat', &               ! (in)
!!$      & array = y_Lat / PI * 180.0_DP, & ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'sig', &               ! (in)
!!$      & array = z_Sigma, &               ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( & 
!!$      & varname = 'sigm', &              ! (in)
!!$      & array = r_Sigma, &               ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$
!!$    ! ɸŤߤ
!!$    ! Axes weights settings
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'lon_weight', &                           ! (in)
!!$      & dims = StoA('lon'), &                               ! (in)
!!$      & longname = 'weight for integration in longitude', & ! (in)
!!$      & units = 'radian', xtype = 'double', &               ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'lon_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'lat_weight', &                           ! (in)
!!$      & dims = StoA('lat'), &                               ! (in)
!!$      & longname = 'weight for integration in latitude', &  ! (in)
!!$      & units = 'radian', xtype = 'double', &               ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'lat_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'sig_weight', &                           ! (in)
!!$      & dims = StoA('sig'), &                               ! (in)
!!$      & longname = 'weight for integration in sigma', &     ! (in)
!!$      & units = '1', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'sig_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'sig_weight', array = z_DelSigma, &       ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    ! ͽѿ
!!$    ! Predictional variables settings
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'UB', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'eastward wind (at t-\Delta t)', &       ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'VB', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'northward wind (at t-\Delta t)', &      ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'TempB', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'temperature (at t-\Delta t)', &         ! (in)
!!$      & units = 'K', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'QVapB', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'specific humidity (at t-\Delta t)', &   ! (in)
!!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'PsB', &                                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
!!$      & longname = 'surface pressure (at t-\Delta t)', &    ! (in)
!!$      & units = 'Pa', xtype = 'double', &                   ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'UN', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'eastward wind (at t)', &                ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'VN', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'northward wind (at t)', &               ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'TempN', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'temperature (at t)', &                  ! (in)
!!$      & units = 'K', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'QVapN', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'specific humidity (at t)', &            ! (in)
!!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'PsN', &                                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
!!$      & longname = 'surface pressure (at t)', &             ! (in)
!!$      & units = 'Pa', xtype = 'double', &                   ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    ground_file_opened = .true.
!!$  end subroutine GroundFileOpen
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  subroutine GroundFileOutput( &
!!$    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
!!$    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
!!$    & )
!!$    !
!!$    ! ɽ̥ǡνϤԤޤ. 
!!$    !
!!$    ! Output ground data
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gt4_history, only: HistoryPut
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: Cstep  ! ߤΥƥå׿. 
!!$                              ! Current steps
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
!!$    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ v (t-\Delta t) $ .   ®. Northward wind
!!$    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T (t-\Delta t) $ .   . Temperature
!!$    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
!!$    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
!!$                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
!!$    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ u (t) $ .     ®. Eastward wind
!!$    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ v (t) $ .     ®. Northward wind
!!$    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T (t) $ .     . Temperature
!!$    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q (t) $ .     漾. Specific humidity
!!$    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
!!$                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    if ( .not. ground_file_opened ) call GroundFileOpen
!!$
!!$    ! ϥߥ󥰤Υå
!!$    ! Check output timing
!!$    !
!!$    if ( mod( Cstep - 1, IntStep ) /= 0 ) return
!!$
!!$    ! ǡ
!!$    ! Data output
!!$    !
!!$    call HistoryPut( &
!!$      & 'UB', xyz_UB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'VB', xyz_VB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'TempB', xyz_TempB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'QVapB', xyz_QVapB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'PsB', xy_PsB, history = gthst_grd ) ! (in)
!!$
!!$    call HistoryPut( &
!!$      & 'UN', xyz_UN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'VN', xyz_VN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'TempN', xyz_TempN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'QVapN', xyz_QVapN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'PsN', xy_PsN, history = gthst_grd ) ! (in)
!!$
!!$  end subroutine GroundFileOutput
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  subroutine GroundFileClose
!!$    !
!!$    ! ɽ̥ǡեϤνλԤޤ. 
!!$    !
!!$    ! Terminate ground data files output. 
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gt4_history, only: HistoryClose
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    if ( .not. ground_file_opened ) return
!!$
!!$    call HistoryClose( history = gthst_grd ) ! (inout)
!!$
!!$    ground_file_opened = .false.
!!$  end subroutine GroundFileClose

  !-------------------------------------------------------------------

  subroutine GroundFileInit
    !
    ! ground_file_io ⥸塼νԤޤ. 
    ! NAMELIST#ground_file_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "ground_file_io" module is initialized. 
    ! "NAMELIST#ground_file_io_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: DelTime, & ! $ \Delta t $ [s]
      & TimesetGetDelTime

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /ground_file_io_nml/ &
      & InputFile, &
      & SurfTempVarname, &        
      & SurfAlbedoVarname, &      
      & SurfHumidCoeffVarname, &  
      & SurfRoughLengthVarname, &
      & SurfHeatCapacityVarname, & 
      & GroundTempFluxVarname, &  
      & SurfConditionVarname
          !
          ! ǥեͤˤĤƤϽ³ "ground_file_io#GroundFileInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "ground_file_io#GroundFileInit" for the default values. 
          !

!!$      & OutputFile, &
!!$      & IntValue, IntUnit


    ! ¹ʸ ; Executable statement
    !

    if ( ground_file_io_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    InputFile  = ''
    SurfTempVarname         = ''
    SurfAlbedoVarname       = ''
    SurfHumidCoeffVarname   = ''
    SurfRoughLengthVarname  = ''
    SurfHeatCapacityVarname = ''
    GroundTempFluxVarname   = ''
    SurfConditionVarname    = ''

!!$    OutputFile = 'sst.nc'
!!$    IntValue   = 1.0_DP
!!$    IntUnit    = 'day'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = ground_file_io_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = ground_file_io_nml )
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
    call MessageNotify( 'M', module_name, '  SurfTempVarname         = %c', c1 = trim(SurfTempVarname        ) )
    call MessageNotify( 'M', module_name, '  SurfAlbedoVarname       = %c', c1 = trim(SurfAlbedoVarname      ) )
    call MessageNotify( 'M', module_name, '  SurfHumidCoeffVarname   = %c', c1 = trim(SurfHumidCoeffVarname  ) )
    call MessageNotify( 'M', module_name, '  SurfRoughLengthVarname  = %c', c1 = trim(SurfRoughLengthVarname ) )
    call MessageNotify( 'M', module_name, '  SurfHeatCapacityVarname = %c', c1 = trim(SurfHeatCapacityVarname) )
    call MessageNotify( 'M', module_name, '  GroundTempFluxVarname   = %c', c1 = trim(GroundTempFluxVarname  ) )
    call MessageNotify( 'M', module_name, '  SurfConditionVarname    = %c', c1 = trim(SurfConditionVarname   ) )


!!$    call MessageNotify( 'M', module_name, 'Output:: ' )
!!$    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
!!$    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
!!$    call MessageNotify( 'M', module_name, '  IntStep    = %d', i = (/ IntStep /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    ground_file_io_inited = .true.
  end subroutine GroundFileInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ϥեδܾ
    ! Management basic information for output files
    !
    use fileset, only: fileset_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited


    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. fileset_inited ) &
      & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )


  end subroutine InitCheck

end module ground_file_io
