!= ϳز (ڥȥˡ, Arakawa and Suarez (1983))
!
!= Dynamical process (Spectral method, Arakawa and Suarez (1983))
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dynamics_hspl_vas83.f90,v 1.7 2008-08-09 15:23:28 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dynamics_hspl_vas83
  !
  != ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  !
  != Dynamical Core (Spectral method, Arakawa and Suarez (1983))
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϳز黻⥸塼Ǥ. 
  ! ʿΥ˥ڥȥˡ, ľΥˤ Arakawa and Suarez (1983)
  ! ѤƤޤ.
  !
  ! ʬˡˤϥ꡼ץեåѤƤޤ.
  ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
  ! ߥץꥷåˡŬѤƤޤ. 
  ! NAMELIST#dynamics_hspl_vas83_nml  TimeIntegScheme ѹ뤳Ȥ, 
  ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
  !
  ! This is a dynamical core module. Spectral method (for horizontal) and 
  ! Arakawa and Suarez (1983) method (for vertical) are used.
  !
  ! Leap-frog scheme is used as time integration. 
  ! By default, semi-implicit scheme is applied to gravitational terms 
  ! for extension of $ \Delta t $ . 
  ! Explicit scheme can be applied to gravitational terms by changing
  ! "TimeIntegScheme" in "NAMELIST#dynamics_hspl_vas83_nml". 
  !
  !== Procedures List
  !
  ! Dynamics      :: ϳط׻
  ! ------------  :: ------------
  ! Dynamics      :: Calculate dynamics
  !
  !== NAMELIST
  !
  ! NAMELIST#dynamics_hspl_vas83_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: nmax, & ! ȿ. 
                             ! Maximum truncated wavenumber
    &                imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &  ! ټ¿. Double precision. 
    &                 TOKEN  ! .   Keywords. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: Dynamics

  ! ѿ
  ! Public variables
  !
  logical, save, public:: dynamics_hspl_vas83_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !

  character(TOKEN):: TimeIntegScheme
                              ! ʬˡ. 
                              ! ʲˡǽ. 
                              !
                              ! Time integration scheme. 
                              ! Available schemes are as follows.
                              ! 
                              ! * "Semi-implicit"
                              ! * "Explicit"
                              ! 

  ! ʿȻ
  ! Coefficient of horizontal diffusion
  !
  real(DP), allocatable:: wz_rn (:,:)
                              ! $ -n \times (n+1) $ . ץ饷η. 
                              ! Laplacian coefficient
  real(DP), allocatable:: wz_DiffVorDiv (:,:)
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion
  real(DP), allocatable:: wz_DiffTherm (:,:)
                              ! $ -(-1)^{N_D/2}K_{HD}\nabla^{N_D} $ . 
                              ! Ǯ, ʿȻ. 
                              ! Coefficient of horizontal thermal and water diffusion

  ! NonLinearOnGrid ǻѤ뷸
  ! Coefficients for "NonLinearOnGrid", etc.
  !
  real(DP), allocatable:: xy_Cori (:,:)
                              ! $ f\equiv 2\Omega\sin\varphi $ . 
                              ! ꥪѥ᡼. Coriolis parameter
  real(DP), allocatable:: z_HydroAlpha (:)
                              ! $ \alpha $ . ſ尵μη. 
                              ! Coefficient in hydrostatic equation.
  real(DP), allocatable:: z_HydroBeta (:)
                              ! $ \beta $ . ſ尵μη. 
                              ! Coefficient in hydrostatic equation.
  real(DP), allocatable:: z_TempInpolA (:)
                              ! $ a $ . ٱľ֤η. 
                              ! Coefficient for vertical interpolation of temperature
  real(DP), allocatable:: z_TempInpolB (:)
                              ! $ b $ . ٱľ֤η. 
                              ! Coefficient for vertical interpolation of temperature
  real(DP), allocatable:: z_TempInpolKappa (:)
                              ! $ \kappa $ . ٱľ֤η. 
                              ! Coefficient for vertical interpolation of temperature
  real(DP), allocatable:: z_TempAvrXY (:)
                              ! ʿѲ (٥). 
                              ! Average temperature on full sigma level
  real(DP), allocatable:: r_TempAvrXY (:)
                              ! ʿѲ (Ⱦ٥). 
                              ! Average temperature on half sigma level

  ! ɽݥƥ󥷥
  ! Surface geo-potential
  !
  real(DP), allocatable:: w_Phis (:)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

  ! TimeIntegration ǻѤ뷸
  ! Coefficients for "TimeIntegration"
  !
  real(DP), allocatable:: z_siMtxG (:)
                              ! $ G = C_p \kappa T $
  real(DP), allocatable:: zz_siMtxH (:,:)
                              ! $ h = QS - R $
  real(DP), allocatable:: zz_siMtxWH (:,:)
                              ! $ W h $
  real(DP), allocatable:: zz_siMtxGCt (:,:)
                              ! $ G C^{T} $ ( $ C = \Delta \sigma $ )

  real(DP), allocatable:: wzz_siMtxLU(:,:,:)
                              ! ߥץꥷåȹ LU ʬ. 
                              ! LU decomposition for semi-implicit matrix
  integer, allocatable:: wz_siMtxPiv(:,:)
                              ! ߥץꥷåȹΥԥܥå. 
                              ! Pivot for semi-implicit matrix


  character(*), parameter:: module_name = 'dynamics_hspl_vas83'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: dynamics_hspl_vas83.f90,v 1.7 2008-08-09 15:23:28 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface Dynamics
    module procedure Dynamics
  end interface

contains

  subroutine Dynamics( &
    & xyz_UB,   xyz_VB,   xyz_TempB,   xyz_QVapB,   xy_PsB, &   ! (in)
    & xyz_UN,   xyz_VN,   xyz_TempN,   xyz_QVapN,   xy_PsN, &   ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &           ! (in)
    & xyz_UA,   xyz_VA,   xyz_TempA,   xyz_QVapA,   xy_PsA  &   ! (out)
    & )
    !
    ! ϳزα黻Ԥ, Ϳ줿 $ t-\Delta t $  $ t $ 
    ! ® (xyz_UB, xyz_VN), ® (xyz_VB, xyz_VN), 
    !  (xyz_TempB, xyz_TempN), 漾 (xyz_QVapB, xyz_QVapN), 
    ! ɽ̵ (xyz_PsB, xyz_PsN) , 
    ! $ t+\Delta t $ 
    ! ® (xyz_UA), ® (xyz_VA),  (xyz_TempA), 
    ! 漾 (xyz_QVapA), ɽ̵ (xyz_PsA) ֤ޤ.
    !
    ! ̤ʪץˤ뱲, ȯ, , 漾Ѳ, 
    ! ϳزѲ­ƼΥƥåפ׻ˤ, 
    ! Ѳ xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt
    ! ͿƤ. 
    !
    ! ʬˡˤϥ꡼ץեåѤƤޤ.
    ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
    ! ߥץꥷåˡŬѤƤޤ.
    ! NAMELIST#dynamics_hspl_vas83_nml  TimeIntegScheme ѹ뤳Ȥ, 
    ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
    !
    ! Calculating dynamical core, 
    ! from eastward wind (xyz_UB, xyz_UN), 
    ! northward wind (xyz_VB, xyz_VN), 
    ! temperature (xyz_TempB, xyz_TempN), 
    ! specific humidity (xyz_QVapB, xyz_QVapN), 
    ! surface pressure (xyz_PsB, xyz_PsN) at $ t-\Delta t $ and $ t $, 
    ! eastward wind (xyz_UA), northward wind (xyz_VA), 
    ! temperature (xyz_TempA), 
    ! specific humidity (xyz_QVapA), surface pressure (xyz_PsA) 
    ! are returned.
    !
    ! In order to add tendencies of vorticity, divergence, 
    ! temperature and specific humidity by another physical process to 
    ! tendencies of this dynamical process 
    ! and to calculate the values at next time step, 
    ! give these tendencies to 
    ! "xyz_DUDt", "xyz_DVDt", "xyz_DTempDt", "xyz_DQVapDt"
    !
    ! Leap-frog scheme is used as time integration. 
    ! By default, semi-implicit scheme is applied to gravitational terms 
    ! for extension of $ \Delta t $ . 
    ! Explicit scheme can be applied to gravitational terms by changing
    ! "TimeIntegScheme" in "NAMELIST#dynamics_hspl_vas83_nml". 
    !

    ! ⥸塼 ; USE statements
    !

    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: xy_GradLon_w, xy_GradLat_w, w_xy, &
      & wa_Div_xya_xya, wa_Lapla_wa, w_Lapla_w, wa_xya, wa_LaplaInv_wa, &
      & xya_GradLon_wa, xya_GradLat_wa, xya_wa, xy_w

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: DP      ! ټ¿. Double precision. 

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_UB    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(in):: xy_PsB    (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure

    real(DP), intent(in):: xyz_UN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_VN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(in):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xyz_QVapN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(in):: xy_PsN    (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

    real(DP), intent(in):: xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(in):: xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(in):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency

    real(DP), intent(out):: xyz_UA    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_VA    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
    real(DP), intent(out):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t+\Delta t) $ .   . Temperature
    real(DP), intent(out):: xyz_QVapA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t+\Delta t) $ .   漾. Specific humidity
    real(DP), intent(out):: xy_PsA    (0:imax-1, 1:jmax)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_VorN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \zeta (t) $ . . Vorticity
    real(DP):: xyz_DivN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ D (t) $ .     ȯ. Divergence

    real(DP):: xy_PiN (0:imax-1, 1:jmax)
                              ! $ \pi = \ln p_s $
    real(DP):: w_PiN ((nmax+1)**2)
                              ! $ \pi $ ڥȥ
    real(DP):: xy_GradLonPiN (0:imax-1, 1:jmax)
                              ! $ \frac{1}{\cos \varphi} \DP{\pi}{\lambda} $
    real(DP):: xy_GradLatPiN (0:imax-1, 1:jmax)
                              ! $ \DP{\pi}{\varphi} $

    real(DP):: xyz_UAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u_A (t) $ . ư̰ή. 
                              ! Eastward advection of momentum
    real(DP):: xyz_VAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v_A (t) $ . ̱ư̰ή. 
                              ! Northward advection of momentum
    real(DP):: xyz_DTempDtN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ H (t) $ . ٻѲ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ R (t) $ . 漾Ѳ. 
                              ! Specific humidity tendency
    real(DP):: xyz_KinEngyN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ KE (t) $ . ưͥ륮. 
                              ! Kinetic energy
    real(DP):: xyz_TempUAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ uT (t) $ . ή. 
                              ! Eastward advection of temperature
    real(DP):: xyz_TempVAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ vT (t) $ . ̰ή. 
                              ! Northward advection of temperature
    real(DP):: xyr_SigmaDotN (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή. Vertical flow
    real(DP):: xy_DPiDtN (0:imax-1, 1:jmax)
                              ! $ Z $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency
    real(DP):: xyz_QVapUAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ uq (t) $ . 漾ή. 
                              ! Eastward advection of specific humidity
    real(DP):: xyz_QVapVAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ vq (t) $ . 漾̰ή. 
                              ! Northward advection of specific humidity
    real(DP):: wz_DVorDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{\zeta}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP):: wz_DDivDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{D}{t} (t) $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP):: wz_DTempDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP):: wz_DQVapDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{q}{t} (t) $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)
    real(DP):: w_DPiDtN ((nmax+1)**2)
                              ! $ \DD{p_s}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP):: wz_VorB ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t-\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP):: wz_DivB ((nmax+1)**2, 1:kmax)
                              ! $ D (t-\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP):: wz_TempB ((nmax+1)**2, 1:kmax)
                              ! $ T (t-\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP):: w_PiB ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t-\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP):: wz_QVapB ((nmax+1)**2, 1:kmax)
                              ! $ q (t-\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)
    real(DP):: wz_VorA ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t+\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP):: wz_DivA ((nmax+1)**2, 1:kmax)
                              ! $ D (t+\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP):: wz_TempA ((nmax+1)**2, 1:kmax)
                              ! $ T (t+\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP):: w_PiA ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t+\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP):: wz_QVapA ((nmax+1)**2, 1:kmax)
                              ! $ q (t+\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)

    real(DP):: wz_Psi ((nmax+1)**2, 1:kmax)
                              ! $ \psi $ . ήؿ. Streamline function 
    real(DP):: wz_Chi ((nmax+1)**2, 1:kmax)
                              ! $ \chi $ . ݥƥ󥷥. Potential

    real(DP):: wz_VorDiffA ((nmax+1)**2, 1:kmax)
                              ! $ \mathscr{D}(\zeta) $ . 
                              ! ư̿ʿȻˤ뱲Ѳ (ڥȥ). 
                              ! Vorticity tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP):: wz_DivDiffA ((nmax+1)**2, 1:kmax)
                              ! $ \mathscr{D}(D) $ . 
                              ! ư̿ʿȻˤȯѲ (ڥȥ). 
                              ! Divergence tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP):: wz_PsiDiff ((nmax+1)**2, 1:kmax)
                              ! ư̿ʿȻˤήؿ $ \psi $ Ѳ
                              ! Streamline function tendency by 
                              ! horizontal momentum diffusion
    real(DP):: wz_ChiDiff ((nmax+1)**2, 1:kmax)
                              ! ư̿ʿȻˤݥƥ󥷥 $ \chi $ Ѳ
                              ! Potential tendency by 
                              ! horizontal momentum diffusion
    real(DP):: xyz_UDiff (0:imax-1, 1:jmax, 1:kmax)
                              ! ư̿ʿȻˤѲ. 
                              ! Eastward wind tendency by 
                              ! horizontal momentum diffusion
    real(DP):: xyz_VDiff (0:imax-1, 1:jmax, 1:kmax)
                              ! ư̿ʿȻˤѲ. 
                              ! Northward wind tendency by 
                              ! horizontal momentum diffusion

    ! ΥץλѲΤκѿ
    ! Work variables for tendency of external processes
    !
    real(DP):: wz_DVorDtWork ((nmax+1)**2, 1:kmax)
                              ! $ \DD{\zeta}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP):: wz_DDivDtWork ((nmax+1)**2, 1:kmax)
                              ! $ \DD{D}{t} (t) $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP):: wz_DTempDtWork ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP):: wz_DQVapDtWork ((nmax+1)**2, 1:kmax)
                              ! $ \DD{q}{t} (t) $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)

    ! ץꥷåˡΤκѿ
    ! Work variables for explicit scheme
    !
    real(DP):: xyz_exWTGPi (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ .
    real(DP):: xyz_exWT (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \underline{W} \Dvect{T} $ .
    real(DP):: xyz_exGPi (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Dvect{G} \pi $ .

    real(DP):: xyz_exHDiv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \underline{h} \Dvect{D} $ .


    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. dynamics_hspl_vas83_inited ) call DynamicsInit

    ! ɽ̵ζѲη׻
    ! Calculate spatial surface pressure tendency
    !
    xy_PiN = log( xy_PsN )
    w_PiN = w_xy( xy_PiN )
    xy_GradLonPiN = xy_GradLon_w( w_PiN )
    xy_GradLatPiN = xy_GradLat_w( w_PiN )

    ! ®鱲ȯη׻
    ! Calculate vorticity and divergence from wind velocity
    ! 
    xyz_VorN = xya_wa( wa_Div_xya_xya( xyz_VN , - xyz_UN ) / RPlanet )
    xyz_DivN = xya_wa( wa_Div_xya_xya( xyz_UN ,   xyz_VN ) / RPlanet )

    ! ʻǤϳعη׻
    ! Calculate non-linear dynamical terms on grid points
    !
    call NonLinearOnGrid( &
      & xyz_UN,        xyz_VN, &        ! (in)
      & xyz_VorN,      xyz_DivN, &      ! (in)
      & xyz_TempN,     xyz_QVapN, &     ! (in)
      & xy_GradLonPiN, xy_GradLatPiN, & ! (in)
!
      & xyz_UAdvN,     xyz_VAdvN, &     ! (out)
      & xyz_DTempDtN,  xyz_DQVapDtN, &  ! (out)
      & xyz_KinEngyN, &                 ! (out)
      & xyz_TempUAdvN, xyz_TempVAdvN, & ! (out)
      & xyr_SigmaDotN, xy_DPiDtN, &     ! (out)
      & xyz_QVapUAdvN, xyz_QVapVAdvN )  ! (out)


    ! ڥȥѲη׻
    ! Calculate spectral tendency terms
    !

    ! ٤λѲ (ڥȥ) η׻
    ! Calculate vorticity tendency (spectral)
    !
    wz_DVorDtN = wa_Div_xya_xya( xyz_VAdvN, - xyz_UAdvN ) / RPlanet

    ! ȯλѲ (ڥȥ) η׻
    ! Calculate divergence tendency (spectral)
    !
    wz_DDivDtN = &
      &   wa_Div_xya_xya( xyz_UAdvN, xyz_VAdvN ) / RPlanet &
      & - wa_Lapla_wa( wa_xya(xyz_KinEngyN) ) / RPlanet**2

    ! ٤λѲ (ڥȥ) η׻
    ! Calculate temperature tendency (spectral)
    !
    wz_DTempDtN = &
      & - wa_Div_xya_xya( xyz_TempUAdvN, xyz_TempVAdvN ) / RPlanet &
      & + wa_xya( xyz_DTempDtN )

    ! ɽ̵λѲ (ڥȥ) η׻
    ! Calculate surface pressure tendency (spectral)
    !
    w_DPiDtN = w_xy( xy_DPiDtN )

    ! 漾λѲ (ڥȥ) η׻
    ! Calculate specific humidity tendency (spectral)
    !
    wz_DQVapDtN = &
      & - wa_Div_xya_xya( xyz_QVapUAdvN, xyz_QVapVAdvN ) / RPlanet &
      & + wa_xya( xyz_DQVapDtN )


    ! ץꥷåˡѤݤη׻
    ! Calculate for explicit scheme
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('explicit')

      ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ γʻͤη׻
      ! Calculate $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ on grid
      !

      ! $ \underline{W} \Dvect{T} $ η׻
      ! Calculate $ \underline{W} \Dvect{T} $
      !
      call HydroGrid( xyz_TempN, & ! (in)
        &             xyz_exWT )   ! (out)

      ! $ \Dvect{G} \pi $ η׻
      ! Calculate $ \Dvect{G} \pi $
      !
      do k = 1, kmax
        xyz_exGPi(:,:,k) = &
          & CpDry * z_TempInpolKappa(k) * z_TempAvrXY(k) * xy_PiN
      enddo

      ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ η׻
      ! Calculate $ \underline{W} \Dvect{T} + \Dvect{G} \pi $
      !
      xyz_exWTGPi = xyz_exWT + xyz_exGPi


      ! $ \underline{h} \Dvect{D} $ γʻͤη׻
      ! Calculate $ \underline{h} \Dvect{D} $ on grid
      !
      xyz_exHDiv = 0.0_DP

      do k = 1, kmax
        do kk = 1, kmax
          xyz_exHDiv (:,:,k) = xyz_exHDiv (:,:,k) &
            & + zz_siMtxH (k,kk) * xyz_DivN (:,:,kk)
        enddo
      enddo


      ! ȯ,  (ڥȥ) λѲν
      ! Modify divergence and temperature tencency (spectral)
      !

      ! ȯλѲ (ڥȥ) η׻
      ! Calculate divergence tendency (spectral)
      !
      wz_DDivDtN = wz_DDivDtN &
        & - wa_Lapla_wa( wa_xya( xyz_exWTGPi ) ) / RPlanet**2

      do k = 1, kmax
        wz_DDivDtN(:,k) = wz_DDivDtN(:,k) &
          & - w_Lapla_w( w_Phis ) / RPlanet**2
      end do

      ! ٤λѲ (ڥȥ) η׻
      ! Calculate temperature tendency (spectral)
      !
      wz_DTempDtN = wz_DTempDtN - wa_xya( xyz_exHDiv )

    end select


    ! ʻͤ򥹥ڥȥͤ ( $ t-\Delta t$ )
    ! Exchange grid values to spectral values ( $ t-\Delta t$ )
    !
    wz_VorB  = wa_Div_xya_xya( xyz_VB, - xyz_UB ) / RPlanet
    wz_DivB  = wa_Div_xya_xya( xyz_UB,   xyz_VB ) / RPlanet
    wz_TempB = wa_xya( xyz_TempB )
    wz_QVapB = wa_xya( xyz_QVapB )
    w_PiB    = w_xy( log( xy_PsB ) )


    ! ץˤѲʻҥǡ򥹥ڥȥǡѴ
    ! Convert tendency data on grid by external processes into spectral data
    !
    wz_DVorDtWork  = wa_Div_xya_xya( xyz_DVDt, - xyz_DUDt ) / RPlanet
    wz_DDivDtWork  = wa_Div_xya_xya( xyz_DUDt,   xyz_DVDt ) / RPlanet
    wz_DTempDtWork = wa_xya( xyz_DTempDt )
    wz_DQVapDtWork = wa_xya( xyz_DQVapDt )

    ! ʬ
    ! Time integration
    !
    call TimeIntegration( &
      & wz_DVorDtN + wz_DVorDtWork, &                  ! (in)
      & wz_DDivDtN + wz_DDivDtWork, &                  ! (in)
      & wz_DTempDtN + wz_DTempDtWork, &                ! (in)
      & wz_DQVapDtN + wz_DQVapDtWork, &                ! (in)
      & w_DPiDtN, &                                    ! (in)
      & wz_VorB, wz_DivB, wz_TempB, wz_QVapB, w_PiB, & ! (in)
      & wz_VorA, wz_DivA, wz_TempA, wz_QVapA, w_PiA )  ! (out)


    ! ڥȥͤʻͤ ( $ t+\Delta t$ )
    ! Exchange spectral values to grid values ( $ t+\Delta t$ )
    !
    wz_Psi = wa_LaplaInv_wa( wz_VorA ) * RPlanet**2
    wz_Chi = wa_LaplaInv_wa( wz_DivA ) * RPlanet**2

    xyz_UA = &
      & (   xya_GradLon_wa( wz_Chi ) &
      &   - xya_GradLat_wa( wz_Psi )    ) / RPlanet

    xyz_VA = &
      & (   xya_GradLon_wa( wz_Psi ) &
      &   + xya_GradLat_wa( wz_Chi )    ) / RPlanet

    xyz_TempA = xya_wa( wz_TempA )
    xyz_QVapA = xya_wa( wz_QVapA )
    xy_PsA = exp( xy_w( w_PiA ) )

    ! Ȼˤ
    ! Correction by diffusion
    !

    ! ư̿ʿȻˤ뱲ȯλѲ
    ! Vorticity and divergence tendency by horizontal diffusion of momentum
    !
    wz_VorDiffA = - wz_VorA * wz_DiffVorDiv
    wz_DivDiffA = - wz_DivA * wz_DiffVorDiv


    ! ư̿ʿȻˤ໤Ǯ
    ! Frictional thermal correction by horizontal momentum diffusion
    !
    wz_PsiDiff = wa_LaplaInv_wa( wz_VorDiffA ) * RPlanet**2
    wz_ChiDiff = wa_LaplaInv_wa( wz_DivDiffA ) * RPlanet**2

    xyz_UDiff = &
      & (   xya_GradLon_wa( wz_ChiDiff ) &
      &   - xya_GradLat_wa( wz_PsiDiff )    ) / RPlanet

    xyz_VDiff = &
      & (   xya_GradLon_wa( wz_PsiDiff ) &
      &   + xya_GradLat_wa( wz_ChiDiff )    ) / RPlanet

    xyz_TempA = xyz_TempA &
      & - (   xyz_UA * xyz_UDiff &
      &     + xyz_VA * xyz_VDiff   ) / CpDry * 2.0_DP * DelTime

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'SigmaDot', xyr_SigmaDotN )
    call HistoryAutoPut( 'DPiDt',    xy_DPiDtN )
    call DiagOutput( &
      & xyz_UA, xyz_VA, xyz_TempA, xyz_QVapA, xy_PsA ) ! (in)


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine Dynamics

  !-------------------------------------------------------------------

  subroutine NonLinearOnGrid( &
    & xyz_U,        xyz_V, &        ! (in)
    & xyz_Vor,      xyz_Div, &      ! (in)
    & xyz_Temp,     xyz_QVap, &     ! (in)
    & xy_GradLonPi, xy_GradLatPi, & ! (in)
!
    & xyz_UAdv,     xyz_VAdv, &     ! (out)
    & xyz_DTempDt,  xyz_DQVapDt, &  ! (out)
    & xyz_KinEngy, &                ! (out)
    & xyz_TempUAdv, xyz_TempVAdv, & ! (out)
    & xyr_SigmaDot, xy_DPiDt, &     ! (out)
    & xyz_QVapUAdv, xyz_QVapVAdv &  ! (out)
    & )
    !
    !  (ȹ) ʻǷ׻ޤ.
    !
    ! Non-linear terms (non gravitational terms) are calculated on
    ! grid points
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & r_Sigma, &            ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & EpsV
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    implicit none
    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind
    real(DP), intent(in):: xyz_Vor (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \zeta $ . . Vorticity
    real(DP), intent(in):: xyz_Div (0:imax-1, 1:jmax, 1:kmax)
                              ! $ D $ . ȯ. Divergence
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ . 漾. Specific humidity
    real(DP), intent(in):: xy_GradLonPi (0:imax-1, 1:jmax)
                              ! $ \frac{1}{\cos \varphi} \DP{\pi}{\lambda} $
    real(DP), intent(in):: xy_GradLatPi (0:imax-1, 1:jmax)
                              ! $ \DP{\pi}{\varphi} $
    real(DP), intent(out):: xyz_UAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u_A $ . ư̰ή.
                              ! Eastward advection of momentum
    real(DP), intent(out):: xyz_VAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v_A $ . ̱ư̰ή. 
                              ! Northward advection of momentum
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ H $ . ٻѲ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ R $ . 漾Ѳ. 
                              ! Specific humidity tendency
    real(DP), intent(out):: xyz_KinEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ KE $ . ưͥ륮. 
                              ! Kinetic energy
    real(DP), intent(out):: xyz_TempUAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ uT $ . ή. 
                              ! Eastward advection of temperature
    real(DP), intent(out):: xyz_TempVAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ vT $ . ̰ή. 
                              ! Northward advection of temperature
    real(DP), intent(out):: xyr_SigmaDot (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή. Vertical flow
    real(DP), intent(out):: xy_DPiDt (0:imax-1, 1:jmax)
                              ! $ Z $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency
    real(DP), intent(out):: xyz_QVapUAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ uq $ . 漾ή. 
                              ! Eastward advection of specific humidity
    real(DP), intent(out):: xyz_QVapVAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ vq $ . 漾̰ή. 
                              ! Northward advection of specific humidity

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: xyz_PiAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Dvect{v} \cdot \nabla \pi $ . 
                              ! $ \pi $ ΰή. Advection of $ \pi $
    real(DP):: xyz_PiAdvSum (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \sum_k^K(\Dvect{v}\cdot\nabla\pi)\Delta\sigma $ . 
                              ! $ \pi $ ήѲ. Integral downward of advection of $ \pi $
    real(DP):: xyz_DivSum (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \sum_k^K D\Delta\sigma $ .
                              ! ȯѲ. Integral downward of divergence
    real(DP):: xyr_SigmaDotNonGrav (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή (). Vertical flow (non gravitational)
    real(DP):: xyz_TempEdd (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T' = T - \bar{T} $ . 
                              ! ٤ξ (٥). Temperature eddy (full level)
    real(DP):: xyr_TempEdd (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T}' $ . 
                              ! ٤ξ (Ⱦ٥). Temperature eddy (half level)
    real(DP):: xyz_TempVir (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T_v $ . 
                              ! . Virtual temperature
    real(DP):: xyz_TempVirEdd (0:imax-1, 1:jmax, 1:kmax)
                              ! $ {T_v}' = T_v - \bar{T} $ . 
                              ! ٤ξ. Virtual temperature eddy

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! $ \pi $ ΰή, $ \pi $ ήѲ, ȯѲη׻
    ! Calculate advection of $ \pi $, integral downward of advection 
    !   of $ \pi $, integral downward of divergence
    !
    do k = 1, kmax
      xyz_PiAdv(:,:,k) = &
        & ( xyz_U(:,:,k) * xy_GradLonPi + xyz_V(:,:,k) * xy_GradLatPi ) &
        & / RPlanet
    enddo

    xyz_PiAdvSum(:,:,kmax) = xyz_PiAdv(:,:,kmax) * z_DelSigma(kmax)
    do k = kmax-1, 1, -1
      xyz_PiAdvSum(:,:,k) = &
        & xyz_PiAdvSum(:,:,k+1) + xyz_PiAdv(:,:,k) * z_DelSigma(k)
    enddo

    xyz_DivSum(:,:,kmax) = xyz_Div(:,:,kmax) * z_DelSigma(kmax)
    do k = kmax-1, 1, -1
      xyz_DivSum(:,:,k) = &
        & xyz_DivSum(:,:,k+1) + xyz_Div(:,:,k) * z_DelSigma(k)
    enddo

    ! ɽ̵Ѳ $ Z $ η׻
    ! Calculate surface pressure tendency $ Z $
    !
    xy_DPiDt = - xyz_PiAdvSum(:,:,1)

    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('explicit')

      xy_DPiDt = xy_DPiDt - xyz_DivSum(:,:,1)

    end select

    ! $ \dot{\sigma} $ η׻
    ! Calculate $ \dot{\sigma} $
    !
    do k = 1, kmax-1
      xyr_SigmaDot(:,:,k) = &
        & r_Sigma(k) * ( xyz_PiAdvSum(:,:,1) + xyz_DivSum(:,:,1) ) &
        & - ( xyz_PiAdvSum(:,:,k+1) + xyz_DivSum(:,:,k+1) )

      xyr_SigmaDotNonGrav(:,:,k) = &
        & r_Sigma(k) * xyz_PiAdvSum(:,:,1) - xyz_PiAdvSum(:,:,k+1)
    enddo

    ! $ \dot{\sigma} $ ξ岼
    ! $ \dot{\sigma} $ on upper and lower boundary
    !
    xyr_SigmaDot(:,:,0)    = 0.0_DP
    xyr_SigmaDot(:,:,kmax) = 0.0_DP
    xyr_SigmaDotNonGrav(:,:,0)    = 0.0_DP
    xyr_SigmaDotNonGrav(:,:,kmax) = 0.0_DP

    ! ٤ξ (٥), , ٤ξη׻
    ! Calculate temperature eddy (full level), virtual temperature, 
    !   virtual temperature eddy
    !
    do k = 1, kmax
      xyz_TempVir(:,:,k) = &
        & xyz_Temp(:,:,k) &
        &   * (   1.0_DP &
        &       + ( ( ( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap(:,:,k) ) &
        &     )

      xyz_TempEdd(:,:,k) = xyz_Temp(:,:,k) - z_TempAvrXY(k)
      xyz_TempVirEdd(:,:,k) = xyz_TempVir(:,:,k) - z_TempAvrXY(k)
    enddo

    ! ٤ξ (Ⱦ٥) η׻
    ! Calculate temperature eddy (half level)
    !
    xyr_TempEdd(:,:,0) = 0.0_DP
    xyr_TempEdd(:,:,kmax) = 0.0_DP
    do k = 1, kmax-1
      xyr_TempEdd(:,:,k) = &
        &   z_TempInpolA(k+1) * xyz_Temp(:,:,k+1) &
        & + z_TempInpolB( k ) * xyz_Temp(:,:, k ) &
        & - r_TempAvrXY(k)
    enddo

    ! ư̰ή, ̱ư̰ήη׻
    ! Calculate advection of eastward momentum and northward momentum
    !
    do k = 1, kmax
      xyz_UAdv(:,:,k) = &
        & ( xyz_Vor(:,:,k) + xy_Cori ) * xyz_V(:,:,k) &
        & - CpDry * z_TempInpolKappa(k) &
        &         * xyz_TempVirEdd(:,:,k) * xy_GradLonPi / RPlanet

      xyz_VAdv(:,:,k) = &
        & - ( xyz_Vor(:,:,k) + xy_Cori ) * xyz_U(:,:,k) &
        & - CpDry * z_TempInpolKappa(k) &
        &          * xyz_TempVirEdd(:,:,k) * xy_GradLatPi / RPlanet
    end do

    do k = 2, kmax
      xyz_UAdv(:,:,k) = xyz_UAdv(:,:,k) &
        & - 1.0_DP / ( 2.0_DP * z_DelSigma(k) ) &
        &    * xyr_SigmaDot(:,:,k-1) * ( xyz_U(:,:,k-1) - xyz_U(:,:,k) )

      xyz_VAdv(:,:,k) = xyz_VAdv(:,:,k) &
        & - 1.0_DP / ( 2.0_DP * z_DelSigma(k) ) &
        &    * xyr_SigmaDot(:,:,k-1) * ( xyz_V(:,:,k-1) - xyz_V(:,:,k) )
    end do

    do k = 1, kmax-1
      xyz_UAdv(:,:,k) = xyz_UAdv(:,:,k) &
        & - 1.0_DP / ( 2.0_DP * z_DelSigma(k) ) &
        &    * xyr_SigmaDot(:,:,k) * ( xyz_U(:,:,k) - xyz_U(:,:,k+1) )

      xyz_VAdv(:,:,k) = xyz_VAdv(:,:,k) &
        & - 1.0_DP / ( 2.0_DP * z_DelSigma(k) ) &
        &    * xyr_SigmaDot(:,:,k) * ( xyz_V(:,:,k) - xyz_V(:,:,k+1) )
    end do

    ! ưͥ륮 (ޤ) η׻
    ! Calculate kinematic energy term 
    !   (including virtual temperature correction)
    !
    call HydroGrid( xyz_TempVir - xyz_Temp, & ! (in)
      &             xyz_KinEngy )             ! (out)

    xyz_KinEngy = xyz_KinEngy + ( xyz_U**2 + xyz_V**2 ) / 2.0_DP


    ! ή, ̰ήη׻
    ! Calculate eastward and northward advection of temperature
    !
    do k = 1, kmax
      xyz_TempUAdv(:,:,k) =  xyz_U(:,:,k) * xyz_TempEdd(:,:,k)
      xyz_TempVAdv(:,:,k) =  xyz_V(:,:,k) * xyz_TempEdd(:,:,k)
    end do

    ! ٤λѲ $ H $ η׻
    ! Calculate temperature tendency term $ H $
    !
    do k = 1, kmax
      xyz_DTempDt(:,:,k) = &
        & xyz_TempEdd(:,:,k) * xyz_Div(:,:,k) &
!
        & + z_TempInpolKappa(k) * xyz_TempVir(:,:,k) * xyz_PiAdv(:,:,k) &
!
        & - z_HydroAlpha(k) / z_DelSigma(k) &
        &    * ( xyz_TempVir(:,:,k) * xyz_PiAdvSum(:,:,k) &
        &        + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k) )
    enddo

    do k = 2, kmax
      xyz_DTempDt(:,:,k) = xyz_DTempDt(:,:,k) &
!
        & - xyr_SigmaDot(:,:,k-1) / z_DelSigma(k) &
        &     * ( xyr_TempEdd(:,:,k-1) - xyz_TempEdd(:,:,k) ) &
!
        & - xyr_SigmaDotNonGrav(:,:,k-1) / z_DelSigma(k) &
        &     * ( r_TempAvrXY(k-1) - z_TempAvrXY(k) )
    enddo

    do k = 1, kmax-1
      xyz_DTempDt(:,:,k) = xyz_DTempDt(:,:,k) &
!
        & - xyr_SigmaDot(:,:,k) / z_DelSigma(k) &
        &     * ( xyz_TempEdd(:,:,k) - xyr_TempEdd(:,:,k) ) &
!
        & - xyr_SigmaDotNonGrav(:,:,k) / z_DelSigma(k) &
        &     * ( z_TempAvrXY(k) - r_TempAvrXY(k) ) &
!
        & - z_HydroBeta(k) / z_DelSigma(k) &
        &    * (   xyz_TempVir(:,:,k) * xyz_PiAdvSum(:,:,k+1) &
        &        + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k+1) )
    enddo

    ! 漾ή, 漾̰ήη׻
    ! Calculate eastward and northward advection of specific humidity
    !
    do k = 1, kmax
      xyz_QVapUAdv(:,:,k) =  xyz_U(:,:,k) * xyz_QVap(:,:,k)
      xyz_QVapVAdv(:,:,k) =  xyz_V(:,:,k) * xyz_QVap(:,:,k)
    end do

    ! 漾Ѳ $ R $ η׻
    ! Calculate specific humidity tendency $ R $
    !
    xyz_DQVapDt = xyz_QVap * xyz_Div

    do k = 2, kmax
      xyz_DQVapDt(:,:,k) = xyz_DQVapDt(:,:,k) &
        & - xyr_SigmaDot(:,:,k-1) / ( 2.0_DP * z_DelSigma(k) )  &
        &      * ( xyz_QVap(:,:,k-1)  - xyz_QVap(:,:,k) )
    enddo

    do k = 1, kmax-1
      xyz_DQVapDt(:,:,k) = xyz_DQVapDt(:,:,k)  &
        & - xyr_SigmaDot(:,:,k) / ( 2.0_DP * z_DelSigma(k) ) &
        &      * ( xyz_QVap(:,:,k) - xyz_QVap(:,:,k+1) )
    enddo

  end subroutine NonLinearOnGrid

  !-------------------------------------------------------------------

  subroutine HydroGrid( xyz_Temp, & ! (in)
    &                   xyz_Phi   & ! (out)
    & )
    !
    ! ʻǡǤ벹 $ T $ , ſ尵μѤ
    ! ʻǡΥݥƥ󥷥 $ \Phi $ ޤ. 
    !

    ! ⥸塼 ; USE statements
    !

    use constants, only: &
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(out):: xyz_Phi (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Phi $ .  ݥƥ󥷥. 
                              ! Getpotential height

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    
    ! ¹ʸ ; Executable statement
    !
    xyz_Phi(:,:,1) = CpDry * z_HydroAlpha(1) * xyz_Temp(:,:,1)
    
    do k = 2, kmax
      xyz_Phi(:,:,k) =   xyz_Phi(:,:,k-1) &
        &              + CpDry * z_HydroAlpha(k)  * xyz_Temp(:,:,k)   &
        &              + CpDry * z_HydroBeta(k-1) * xyz_Temp(:,:,k-1)
    enddo

  end subroutine HydroGrid

  !-------------------------------------------------------------------

  subroutine TimeIntegration( &
    & wz_DVorDtN, wz_DDivDtN, wz_DTempDtN, wz_DQVapDtN, w_DPiDtN, & ! (in)
    & wz_VorB,    wz_DivB,    wz_TempB,    wz_QVapB,    w_PiB, &    ! (in)
    & wz_VorA,    wz_DivA,    wz_TempA,    wz_QVapA,    w_PiA  &    ! (out)
    & )
    !
    ! ʬԤ, 
    !  $ t $ ʪ̤λѲ $ t-\Delta t$ ʪ̤
    !  $ t+\Delta t $ ʪ̤׻ޤ.
    !
    ! ʬˡˤϥ꡼ץեåѤƤޤ. 
    ! ȻˤʬѤƤޤ. 
    ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
    ! ߥץꥷåˡŬѤƤޤ.
    ! NAMELIST#dynamics_hspl_vas83_nml  TimeIntegScheme ѹ뤳Ȥ, 
    ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
    ! 
    ! With time integration, calculate physical values at $ t+\Delta t $
    ! from tendency at $ t $ and physical values at $ t-\Delta t $ .
    !
    ! Leap-frog scheme is used as time integration scheme. 
    ! And forward difference is used to diffusion terms.
    ! By default, semi-implicit scheme is applied to gravitational terms 
    ! for extension of $ \Delta t $ . 
    ! Explicit scheme can be applied to gravitational terms by changing
    ! "TimeIntegScheme" in "NAMELIST#dynamics_hspl_vas83_nml". 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: DelTime ! $ \Delta t $ [s]

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! LU ʬˡˤϢΩ 1 򤯤δؿ
    ! Functions to solve linear simultaneous equation by LU decomposition
    !
    use lumatrix, only: LUSolve

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    implicit none
    real(DP), intent(in):: wz_DVorDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{\zeta}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP), intent(in):: wz_DDivDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{D}{t} (t) $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP), intent(in):: wz_DTempDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP), intent(in):: wz_DQVapDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{q}{t} (t) $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)
    real(DP), intent(in):: w_DPiDtN ((nmax+1)**2)
                              ! $ \DD{p_s}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP), intent(in):: wz_VorB ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t-\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP), intent(in):: wz_DivB ((nmax+1)**2, 1:kmax)
                              ! $ D (t-\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP), intent(in):: wz_TempB ((nmax+1)**2, 1:kmax)
                              ! $ T (t-\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP), intent(in):: w_PiB ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t-\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP), intent(in):: wz_QVapB ((nmax+1)**2, 1:kmax)
                              ! $ q (t-\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)
    real(DP), intent(out):: wz_VorA ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t+\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP), intent(out):: wz_DivA ((nmax+1)**2, 1:kmax)
                              ! $ D (t+\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP), intent(out):: wz_TempA ((nmax+1)**2, 1:kmax)
                              ! $ T (t+\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP), intent(out):: w_PiA ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t+\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP), intent(out):: wz_QVapA ((nmax+1)**2, 1:kmax)
                              ! $ q (t+\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)

    ! ѿ
    ! Work variables
    !
    real(DP):: wz_siTempW ((nmax+1)**2, 1:kmax)
                              !  (ߥץꥷåˡΤκѿ). 
                              ! Temperature (work variable for semi-implicit scheme)
    real(DP):: wz_siDTempDtW ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ) κѿ. 
                              ! Temperature tendency (spectral) work variable

    real(DP):: w_siPiW ((nmax+1)**2)
                              ! $ \pi $ (ߥץꥷåˡΤκѿ). 
                              ! $ \pi $ (work variable for semi-implicit scheme)
    real(DP):: w_siDPiDtW ((nmax+1)**2)
                              ! $ \DD{p_s}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP):: wz_siPhiW ((nmax+1)**2, 1:kmax)
                              ! $ \Phi = \underline{W} \overline{ \Dvect{T} }^{t}$ .
                              ! (ߥץꥷåˡΤκѿ). 
                              ! (Work variable for semi-implicit scheme)
    real(DP):: wz_siDivAvrTime ((nmax+1)**2, 1:kmax)
                              ! ʿѤ $ \Dvect{D} $ (ߥץꥷåˡΤκѿ). 
                              ! Time average $ \Dvect{D} $ (work variable for semi-implicit scheme)

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ȹβʬ
    ! Integration non gravitational terms temporarily
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siTempW = &
        &   wz_TempB * ( 1.0_DP - DelTime * wz_DiffTherm ) &
        & + wz_DTempDtN * DelTime

      w_siPiW = w_PiB + w_DPiDtN * DelTime

    end select

    ! ݥƥ󥷥η׻
    ! Calculate geopotential
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siPhiW (:,1) = CpDry * z_HydroAlpha(1) * wz_siTempW (:,1)

      do k = 2, kmax
        wz_siPhiW (:,k) = wz_siPhiW(:,k-1) &
          & + CpDry * z_HydroAlpha(k) * wz_siTempW (:,k) &
          & + CpDry * z_HydroBeta (k-1) * wz_siTempW (:,k-1)
      end do

    case ('explicit')

    end select

    ! ȯαդη׻
    ! Calculate right side of divergence equation
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      do k = 1, kmax
        wz_siDivAvrTime(:,k) = &
          &   wz_DivB(:,k) * ( 1.0_DP + DelTime * wz_DiffVorDiv(:,k) ) &
          &                * ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm(:,k) ) &
!
          & + DelTime &
          &     * (   wz_DDivDtN(:,k) &
          &         - wz_rn(:,k) / RPlanet**2  &
          &             * (   wz_siPhiW(:,k) &
          &                 + ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm(:,k) ) &
          &                       * ( w_Phis + w_siPiW * z_siMtxG(k) ) &
          &               ) &
          &       )
      end do

    end select

    ! ʿѤ $ \Dvect{D} $  LU ǲ
    ! Solve time average $ \Dvect{D} $ with LU matrix
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siDivAvrTime = LUSolve( wzz_siMtxLU, wz_siMtxPiv, wz_siDivAvrTime )

    end select

    ! , ɽλѲη׻
    ! Calculate tendency of temperature and surface pressure
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siDTempDtW = wz_DTempDtN
      do k = 1, kmax
        do kk = 1, kmax
          wz_siDTempDtW(:,k) = &
            &   wz_siDTempDtW(:,k) &
            & - zz_siMtxH(k,kk) * wz_siDivAvrTime(:,kk)
        end do
      end do

      w_siDPiDtW = w_DPiDtN
      do kk = 1, kmax
        w_siDPiDtW = &
          &   w_siDPiDtW &
          & - z_DelSigma(kk) * wz_siDivAvrTime(:,kk)
      end do

    end select

    ! ʬ. Ȼʬ
    ! Time integration. Forward difference is applied to diffusion
    !

    !  ; Vorticity
    !
    wz_VorA = &
      & ( wz_VorB + wz_DVorDtN * DelTime * 2.0_DP ) &
      &    / ( 1.0_DP + DelTime * 2.0_DP * wz_DiffVorDiv )

    ! ȯ ; Divergence
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_DivA  = &
        & wz_siDivAvrTime * 2.0_DP - wz_DivB

    case ('explicit')

      wz_DivA  = &
        & ( wz_DivB + wz_DDivDtN * DelTime * 2.0_DP ) &
        &    / ( 1.0_DP + DelTime * 2.0_DP * wz_DiffVorDiv )

    end select

    !  ; Temperature
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_TempA = &
        & ( wz_TempB + wz_siDTempDtW * DelTime * 2.0_DP ) &
        &    / ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm )

    case ('explicit')

      wz_TempA = &
        & ( wz_TempB + wz_DTempDtN * DelTime * 2.0_DP ) &
        &    / ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm )

    end select

    ! 漾 ; Specific humidity
    !
    wz_QVapA = &
      & ( wz_QVapB + wz_DQVapDtN * DelTime * 2.0_DP ) &
      &    / ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm )

    ! ɽ̵ ; Surface pressure
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      w_PiA  = w_PiB + w_siDPiDtW * DelTime * 2.0_DP

    case ('explicit')

      w_PiA  = w_PiB + w_DPiDtN * DelTime * 2.0_DP

    end select

  end subroutine TimeIntegration

  !-------------------------------------------------------------------

  subroutine DiagOutput( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps & ! (in)
    & )
    !
    ! ̤νϤԤޤ. 
    !
    ! Diagnostic variables are output. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & Grav, &
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: &
      & wa_Div_xya_xya, xya_wa

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(in):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(in):: xy_Ps    (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_Vor (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \zeta $ . . Vorticity
    real(DP):: xyz_Div (0:imax-1, 1:jmax, 1:kmax)
                              ! $ D $ . ȯ. Divergence
    real(DP):: xy_Mass (0:imax-1, 1:jmax)
                              ! . 
                              ! Mass
    real(DP):: xyz_KinEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ KE $ . ưͥ륮.
                              ! Kinetic energy
    real(DP):: xyz_IntEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ IE $ . ͥ륮. 
                              ! Internal energy
    real(DP):: xyz_PotEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ PE $ . ݥƥ󥷥륨ͥ륮. 
                              ! Potential energy
    real(DP):: xyz_LatEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ LE $ . Ǯͥ륮. 
                              ! Latent heat energy
    real(DP):: xyz_TotEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ TE $ . ͥ륮. 
                              ! Total energy
    real(DP):: xyz_Enstro (0:imax-1, 1:jmax, 1:kmax)
                              ! 󥹥ȥե. 
                              ! Enstrophy

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ®鱲ȯη׻
    ! Calculate vorticity and divergence from wind velocity
    ! 
    xyz_Vor = xya_wa( wa_Div_xya_xya( xyz_V , - xyz_U ) / RPlanet )
    xyz_Div = xya_wa( wa_Div_xya_xya( xyz_U ,   xyz_V ) / RPlanet )

    call HistoryAutoPut( 'Vor', xyz_Vor )
    call HistoryAutoPut( 'Div', xyz_Div )

    ! ̤η׻
    ! Calculate mass
    !
    xy_Mass = xy_Ps / Grav

    ! ͥ륮, 󥹥ȥեη׻
    ! Calculate energy and enstrophy
    !
    call HydroGrid( xyz_Temp, &   ! (in)
      &             xyz_PotEngy ) ! (out)

    do k = 1, kmax
      xyz_KinEngy(:,:,k) = ( xyz_U(:,:,k) ** 2 + xyz_V(:,:,k) ** 2 ) / 2.0_DP &
        &                    * xy_Mass

      xyz_IntEngy(:,:,k) = CpDry * xyz_Temp(:,:,k) &
        &                    * xy_Mass

      xyz_PotEngy(:,:,k) = xyz_PotEngy(:,:,k) & 
        &                    * xy_Mass

      xyz_LatEngy(:,:,k) = LatentHeat * xyz_QVap(:,:,k) &
        &                    * xy_Mass
    end do

    xyz_TotEngy = xyz_KinEngy + xyz_IntEngy + xyz_PotEngy + xyz_LatEngy

    do k = 1, kmax
      xyz_Enstro(:,:,k) = xyz_Vor(:,:,k) ** 2 &
        &                   * xy_Mass
    end do

    call HistoryAutoPut( 'Mass',    xy_Mass     )
    call HistoryAutoPut( 'KinEngy', xyz_KinEngy )
    call HistoryAutoPut( 'IntEngy', xyz_IntEngy )
    call HistoryAutoPut( 'PotEngy', xyz_PotEngy )
    call HistoryAutoPut( 'LatEngy', xyz_LatEngy )
    call HistoryAutoPut( 'TotEngy', xyz_TotEngy )
    call HistoryAutoPut( 'Enstro',  xyz_Enstro  )

  end subroutine DiagOutput

  !-------------------------------------------------------------------

  subroutine DynamicsInit

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & Omega, &
                              ! $ \Omega $ [s-1]. 
                              ! ž®. 
                              ! Angular velocity
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &            ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &            ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: DelTime ! $ \Delta t $ [s]

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: xy_Lat, l_nm, w_xy
    use w_module, only: rn

    ! LU ʬˡˤϢΩ 1 򤯤δؿ
    ! Functions to solve linear simultaneous equation by LU decomposition
    !
    use lumatrix, only: LUDecomp

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gt4_history, only: HistoryGet

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT, &             ! ɸϤֹ. Unit number of standard output
      & STRING                ! ʸ.       Strings. 

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_not_empty

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    implicit none

    ! Ϸǡ (ɽ $ \Phi $ ) ե
    ! File of geography data (surface $ \Phi $ )
    ! 
    character(STRING):: GeoPotentialFile
                              ! Ϸǡ (ɽ $ \Phi $ ) ե
                              ! File of geography data (surface $ \Phi $ )
    character(TOKEN):: GeoPotentialVarname
                              ! Ϸǡ (ɽ $ \Phi $ ) ѿ̾
                              ! Variable name of geography data (surface $ \Phi $ )

    ! ʿȻΤκѿ
    ! Work variable for coefficient of horizontal diffusion
    !
    integer:: VisOrder        ! ĶǴμ.  Order of hyper-viscosity
    real(DP):: VisCoef        ! ĶǴ. Hyper-viscosity coefficient
    real(DP):: EFoldTimeValue ! ȿФ e-folding time. 
                              ! ͤͿ, ʿȻ򥼥ˤޤ. 
                              ! 
                              ! E-folding time for maximum wavenumber. 
                              ! If negative value is given, 
                              ! coefficients of horizontal diffusion become zero. 
    character(TOKEN):: EFoldTimeUnit
                              ! ȿФ e-folding time ñ. 
                              ! Unit of e-folding time for maximum wavenumber
    real(DP):: EFoldTime      ! ȿФ e-folding time [ñ: ]. 
                              ! E-folding time for maximum wavenumber [Unit: sec]
    type(DC_DIFFTIME):: dcdiff_efold

    ! NonLinearOnGrid ǻѤ뷸Τκѿ
    ! Work variable for coefficients for "NonLinearOnGrid", etc.
    !
    real(DP):: Kappa          ! $ \kappa = R/C_p $ .
                              ! 갵ǮФ. 
                              ! Ratio of gas constant to specific heat

    ! ɽݥƥ󥷥Τκѿ
    ! Work variable for surface geo-potential
    !
    real(DP), allocatable:: xy_Phis (:,:)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

    ! TimeIntegration ǻѤ뷸Τκѿ
    ! Work variable for coefficients for "TimeIntegration", etc.
    !
    real(DP), allocatable:: zz_siMtxW (:,:)
                              ! $ W $ . 
                              ! ȯμǤȹθ̤ˤ벹η. 
                              ! Coefficient for correction of temperature 
                              ! by effort of linear gravitational terms

    real(DP), allocatable:: zz_siMtxQ (:,:)
                              ! $ Q = \DD{T}{\sigma} $
    real(DP), allocatable:: zz_siMtxS (:,:)
                              ! $ S = \DD{\sigma}{t} $
    real(DP), allocatable:: zz_siMtxQS (:,:)
                              ! $ QS $ . 
                              ! ѿ $ \sigma $ ήθ̤. 
                              ! This variable  corresponds to effort of $ \sigma $ advection
    real(DP), allocatable:: zz_siMtxR (:,:)
                              ! $ R $ . 
                              ! ȯȳݤ碌뤳ȤǵѲθ̤Ȥʤ.
                              ! Product R and divergence become effort of 
                              ! surface pressure tendency.
                              ! $ RD = \kappa T 
                              ! (\DD{\pi}{t} + \Dinv{\sigma}\DD{\sigma}{t}) $ .

    integer, allocatable:: nmo (:,:,:)
                              ! ڥȥź. 
                              ! Spectral subscript expression
    real(DP), allocatable:: zz_siMtxM (:,:)
                              !  $ \underline{M} $. 
                              ! Matrix $ \underline{M} $
    integer, allocatable:: z_siMtxPivWork(:)
                              ! ΥԥܥåȺκѿ. 
                              ! Work variable for pivot
    real(DP):: flapla         ! $ \nabla_{\sigma}^{2} $


    integer:: k, l, kk        ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: mmax            ! ȿ. 
                              ! Maximum truncated eastward wavenumber
    integer:: lmax            ! ȿ. 
                              ! Maximum truncated northward wavenumber
    integer:: n, m, nm, mxnm
                              ! ȿ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber direction

    logical:: lmax_err        ! ȿ˴ؤ륨顼ե饰. 
                              ! Erro flag for maximum truncated northward wavenumber

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dynamics_hspl_vas83_nml/ &
      & TimeIntegScheme, &
      & VisOrder, &
      & EFoldTimeValue, EFoldTimeUnit, &
      & GeoPotentialFile, GeoPotentialVarname
          !
          ! ǥեͤˤĤƤϽ³ "dynamics_hspl_vas83#DynamicsInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "dynamics_hspl_vas83#DynamicsInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement
    !

    if ( dynamics_hspl_vas83_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    TimeIntegScheme = 'Semi-implicit'

    VisOrder = 8
    EFoldTimeValue = 8640.0_DP
    EFoldTimeUnit  = 'sec'

    GeoPotentialFile = ''
    GeoPotentialVarname = ''


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = dynamics_hspl_vas83_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = dynamics_hspl_vas83_nml )
    end if

    ! ʬˡΥå
    ! Check time integration scheme
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')
    case ('explicit')
    case default
      call MessageNotify( 'E', module_name, &
        & '"TimeIntegScheme" must be "Semi-Implicit" or "Explicit".' )
    end select

    ! NonLinearOnGrid ǻѤ뷸
    ! Configure coefficients for "NonLinearOnGrid", etc.
    !

    ! ꥪѥ᡼η׻׻
    ! Calculate Coriolis parameter
    !
    allocate( xy_Cori (0:imax-1, 1:jmax) )
    xy_Cori = 2.0_DP * Omega * sin( xy_Lat )


    ! ſ尵μη $ \alpha $ , $ \beta $ η׻
    ! Calculate coefficients $ \alpha $ and $ \beta $ in hydrostatic equation.
    !
    allocate( z_HydroAlpha     (1:kmax) )
    allocate( z_HydroBeta      (1:kmax) )

    Kappa = GasRDry / CpDry

    do k = 1, kmax
      z_HydroAlpha(k) = &
        & ( r_Sigma(k-1) / z_Sigma(k) ) ** Kappa - 1.0_DP

      z_HydroBeta(k) = &
        & 1.0_DP - ( r_Sigma(k) / z_Sigma(k) ) ** Kappa
    enddo

    ! ٱľ֤η $ \kappa $, $ a $ , $ b $ η׻
    ! Calculate coefficients $ \kappa $, $ a $ , $ b $ 
    !   for interpolation of temperature
    !
    allocate( z_TempInpolA     (1:kmax) )
    allocate( z_TempInpolB     (1:kmax) )
    allocate( z_TempInpolKappa (1:kmax) )

    do k = 1, kmax
      z_TempInpolKappa(k) = &
        & (   r_Sigma(k-1) * z_HydroAlpha(k) &
        &   + r_Sigma(k  ) * z_HydroBeta(k)    ) / z_DelSigma(k)
    enddo

    z_TempInpolA = 0.0_DP
    do k = 2, kmax
      z_TempInpolA(k) = &
        & z_HydroAlpha(k) &
        &  / ( 1.0_DP - (z_Sigma(k) / z_Sigma(k-1)) ** Kappa )
    end do

    z_TempInpolB = 0.0_DP
    do k = 1, kmax - 1
      z_TempInpolB(k) = &
        & z_HydroBeta(k) / ( (z_Sigma(k) / z_Sigma(k+1) ) ** Kappa - 1.0_DP )
    end do

    ! ʿѲ (٥롢Ⱦ٥) η׻
    ! Calculate average temperature about level and half level.
    !
    allocate( z_TempAvrXY      (1:kmax) )
    allocate( r_TempAvrXY      (0:kmax) )

    z_TempAvrXY = 300.0_DP
    r_TempAvrXY = 0.0_DP

    do k = 1, kmax - 1
      r_TempAvrXY(k) = &
        &   z_TempInpolA(k+1) * z_TempAvrXY(k+1)   &
        & + z_TempInpolB( k ) * z_TempAvrXY( k )
    enddo


    ! ʿȻ
    ! Configure coefficient of horizontal diffusion
    !
    allocate( wz_rn         ((nmax+1)**2, 1:kmax) )
    allocate( wz_DiffVorDiv ((nmax+1)**2, 1:kmax) )
    allocate( wz_DiffTherm  ((nmax+1)**2, 1:kmax) )

    do k = 1, kmax
      wz_rn(:,k) = rn(:,1)
    enddo

    ! Ǵη׻ (ȿ e-folding time  EFoldTime Ȥʤ褦)
    ! Calculate viscosity coefficient
    !
    call DCDiffTimeCreate( dcdiff_efold, &    ! (out)
      & EFoldTimeValue, EFoldTimeUnit )       ! (in)
    EFoldTime = EvalSec( dcdiff_efold )

    if ( EFoldTimeValue > 0.0_DP ) then
      VisCoef = ( (nmax*(nmax+1)) / RPlanet**2 )**(-VisOrder / 2) &
        &        / EFoldTime
    else
      VisCoef = 0.0_DP
    end if

    wz_DiffTherm = &
      &   VisCoef * ( (-wz_rn / RPlanet**2)**(VisOrder / 2) )

    wz_DiffVorDiv = wz_DiffTherm &
      & + VisCoef * ( - (2.0_DP / RPlanet**2)**(VisOrder / 2))


    ! ɽݥƥ󥷥
    ! Configure surface geo-potential
    !
    allocate( xy_Phis (0:imax-1, 1:jmax) )
    allocate( w_Phis  ((nmax+1)**2) )

    if (       present_and_not_empty( GeoPotentialFile ) &
      &  .and. present_and_not_empty( GeoPotentialVarname ) ) then

      call HistoryGet( &
        & GeoPotentialFile, GeoPotentialVarname, & ! (in)
        & xy_Phis )                                ! (out)

      w_Phis = w_xy( xy_Phis )

    else
      w_Phis = 0.0_DP
    end if

    ! TimeIntegration ǻѤ뷸
    ! Configure coefficients for "TimeIntegration"
    !
    allocate( z_siMtxG    (1:kmax) )
    allocate( zz_siMtxH   (1:kmax, 1:kmax) )
    allocate( zz_siMtxWH  (1:kmax, 1:kmax) )
    allocate( zz_siMtxGCt (1:kmax, 1:kmax) )

    allocate( zz_siMtxW  (1:kmax, 1:kmax) )
    allocate( zz_siMtxQ  (1:kmax, 1:kmax) )
    allocate( zz_siMtxS  (1:kmax, 1:kmax) )
    allocate( zz_siMtxQS (1:kmax, 1:kmax) )
    allocate( zz_siMtxR  (1:kmax, 1:kmax) )

    z_siMtxG = CpDry * z_TempInpolKappa * z_TempAvrXY

    do k = 1, kmax
      do l = 1, kmax
        zz_siMtxGCt(k,l) = z_siMtxG(k) * z_DelSigma(l)
      end do
    end do

    zz_siMtxW = 0.0_DP
    do k = 1, kmax
      do l = 1, k
        zz_siMtxW(k,l) = CpDry * z_HydroAlpha(l)
      enddo

      do l = 1, k-1
        zz_siMtxW(k,l) = zz_siMtxW(k,l) + CpDry * z_HydroBeta(l)
      enddo
    enddo

    zz_siMtxS = 0.0_DP
    do k = 1, kmax
      do l = 1, kmax
        zz_siMtxS(k,l) = r_Sigma(k-1) * z_DelSigma(l)
      enddo
      do l = k, kmax
        zz_siMtxS(k,l) = zz_siMtxS(k,l) - z_DelSigma(l)
      enddo
    enddo

    zz_siMtxQ = 0.0_DP
    do k = 1, kmax
      zz_siMtxQ(k,k) = ( r_TempAvrXY(k-1) - z_TempAvrXY(k) ) / z_DelSigma(k)
    enddo
    do k = 1, kmax-1
      zz_siMtxQ(k,k+1) = ( z_TempAvrXY(k) - r_TempAvrXY(k) ) / z_DelSigma(k)
    enddo

    zz_siMtxQS = 0.0_DP
    zz_siMtxQS = matmul(zz_siMtxQ, zz_siMtxS)

    zz_siMtxR = 0.0_DP
    do k = 1, kmax
      do l = k, kmax
        zz_siMtxR(k,l) = &
          & - z_HydroAlpha(k) / z_DelSigma(k) * z_DelSigma(l) * z_TempAvrXY(k)
      enddo
      do l = k + 1, kmax
        zz_siMtxR(k,l) = zz_siMtxR(k,l)  &
          & - z_HydroBeta(k) / z_DelSigma(k) * z_DelSigma(l) * z_TempAvrXY(k)
      enddo
    enddo

    zz_siMtxH = 0.0_DP
    zz_siMtxH = zz_siMtxQS - zz_siMtxR

    zz_siMtxWH = 0.0_DP
    zz_siMtxWH = matmul(zz_siMtxW, zz_siMtxH)


    allocate( nmo (1:2, 0:nmax, 0:nmax) )
    allocate( zz_siMtxM (1:kmax, 1:kmax) )
    allocate( z_siMtxPivWork(1:kmax) )
    allocate( wzz_siMtxLU((nmax+1)**2, 1:kmax, 1:kmax) )
    allocate( wz_siMtxPiv((nmax+1)**2, 1:kmax) )

    mmax = nmax
    lmax = nmax
    mxnm = 0

    ! ڥȥźμФ
    ! Fetch spectral subscript expression
    !
    nmo = 0
    do l = 0, lmax
      do m = 0, min(mmax, nmax-l)
        nmo(1,m,l) = l_nm(m+l,  m)
        nmo(2,m,l) = l_nm(m+l, -m)
      enddo
    enddo

    Loop_n: do n = 0, nmax
      flapla = - real(n) * real(n+1) / RPlanet**2

      ! ڥȥźμФ
      ! Fetch spectral subscript expression
      !
      lmax_err = .true.
      do m = 0, min(n,mmax)
        if ( n-m <= lmax ) then
          nm = nmo(1,m,n-m)
          lmax_err = .false.
          exit
        endif
      end do
      if ( lmax_err ) then
        call MessageNotify( 'E', module_name, &
          & 'n-m=<%d> must be less than or equal to lmax=<%d>.', &
          & i = (/ n-m, lmax /) )
      end if

      !  $ \underline{M} $ η׻
      ! Calculate matrix $ \underline{M} $
      !
      do k = 1, kmax
        do kk = 1, kmax
          zz_siMtxM ( k,kk ) = &
            & - DelTime**2 * flapla &
            &   * (   zz_siMtxWH( k,kk ) &
            &       + zz_siMtxGCt( k,kk ) &
            &         * ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm(nm,1) )  )
          if ( k == kk ) then
            zz_siMtxM ( k,kk ) = &
              & zz_siMtxM ( k,kk ) &
              & +   ( 1.0_DP + DelTime * 2.0_DP * wz_DiffVorDiv(nm,1) ) &
              &   * ( 1.0_DP + DelTime * 2.0_DP * wz_DiffTherm(nm,1) )
          endif
        end do
      end do

      ! LU ׻
      ! LU matrix calculation
      !
      call LUDecomp( &
        & zz_siMtxM, &     ! (inout)
        & z_siMtxPivWork ) ! (out)

      ! ߡͤ. ( kmax Ϥޤ̤ʤ).
      ! Dummy value is subtituted. (Because position kmax is undefined yet).
      !
      z_siMtxPivWork(kmax) = 0

!!$      write(*,*) 'n= ', n
!!$
!!$      do k = 1, kmax
!!$        do kk = 1, kmax
!!$          write(*,*) 'zz_siMtxM(', k+1, ',', kk+1, ')= ', zz_siMtxM(k,kk)
!!$        end do
!!$      end do

!!$      do k = 1, kmax
!!$        write(*,*) 'z_siMtxPivWork(', k, ')= ', z_siMtxPivWork(k)
!!$      end do

      ! εͤؤ
      ! Repack matrices
      !
      do m = 0, mmax
        l = n - m
        if ( ( l >= 0 ) .and. ( l <= lmax ) ) then
          do k = 1, kmax
            do kk = 1, kmax
              wzz_siMtxLU ( nmo(1,m,l),k,kk ) = zz_siMtxM ( k,kk )
              wzz_siMtxLU ( nmo(2,m,l),k,kk ) = zz_siMtxM ( k,kk )
            end do
            wz_siMtxPiv ( nmo(1,m,l),k ) = z_siMtxPivWork ( k )
            wz_siMtxPiv ( nmo(2,m,l),k ) = z_siMtxPivWork ( k )
            mxnm = max( mxnm, nmo(1,m,l) )
            mxnm = max( mxnm, nmo(2,m,l) )
          end do
        endif
      end do

    end do Loop_n

    do nm = mxnm+1, (nmax+1)**2
      do k = 1, kmax
        do kk = 1, kmax
          wzz_siMtxLU ( nm,k,kk ) = zz_siMtxM ( k,kk )
        end do
        wz_siMtxPiv ( nm,k ) = z_siMtxPivWork ( k )
      end do
    end do

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'SigmaDot', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'sigma-vertical velocity', '1 s-1' )
    call HistoryAutoAddVariable( 'DPiDt', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'Pi (log Ps) tendency)', 'Pa s-1' )

    call HistoryAutoAddVariable( 'Vor', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'vorticity', 's-1' )
    call HistoryAutoAddVariable( 'Div', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'divergence', 's-1' )

    call HistoryAutoAddVariable( 'Mass', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'mass', 'kg' )
    call HistoryAutoAddVariable( 'KinEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'kinetic energy', 'J' )
    call HistoryAutoAddVariable( 'IntEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'internal energy', 'J' )
    call HistoryAutoAddVariable( 'PotEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'potential energy', 'J' )
    call HistoryAutoAddVariable( 'LatEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'latent energy', 'J' )
    call HistoryAutoAddVariable( 'TotEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'total energy', 'J' )
    call HistoryAutoAddVariable( 'Enstro', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'enstrophy', 'kg' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  TimeIntegScheme  = %c', c1 = trim( TimeIntegScheme ) )
    call MessageNotify( 'M', module_name, '  EFoldTime = %f [%c]', d = (/ EFoldTimeValue /), c1 = trim(EFoldTimeUnit) )
    call MessageNotify( 'M', module_name, '  VisOrder  = %d', i = (/ VisOrder /) )
    call MessageNotify( 'M', module_name, '  VisCoef   = %f', d = (/ VisCoef /) )
    call MessageNotify( 'M', module_name, '  GeoPotentialFile    = %c', c1 = trim( GeoPotentialFile ) )
    call MessageNotify( 'M', module_name, '  GeoPotentialVarname = %c', c1 = trim( GeoPotentialVarname ) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dynamics_hspl_vas83_inited = .true.
  end subroutine DynamicsInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module dynamics_hspl_vas83
