!= ήĴ
!
!= Dry convective adjustment
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: dryconv_adjust.f90,v 1.1 2008-08-10 17:16:39 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dryconv_adjust
  !
  != ήĴ
  !
  != Dry convective adjustment
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ήĴԤޤ. 
  !
  ! Dry convective adjustment is performed. 
  !
  !== Procedures List
  ! 
  ! DryConvectAdjust :: ήĴԤ
  ! ------------     :: ------------
  ! DryConvectAdjust :: Dry convective adjustment is performed. 
  !
  !== NAMELIST
  !
  ! NAMELIST#dryconv_adjust_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: DryConvectAdjust

  ! ѿ
  ! Public variables
  !
  logical, save, public:: dryconv_adjust_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration

  real(DP), save:: TempSatMax(1:MaxNmlArySize)
                              ! ԰εƸ. 
                              ! Admissible error of unstability
  
  character(*), parameter:: module_name = 'dryconv_adjust'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: dryconv_adjust.f90,v 1.1 2008-08-10 17:16:39 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface DryConvectAdjust
    module procedure DryConvectAdjust
  end interface

contains

  subroutine DryConvectAdjust( &
    & xyz_Press, xyr_Press, & ! (in)
    & xyz_Temp &              ! (inout)
    & )
    !
    ! ήĴ᥹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! convective adjustment scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . ήĴˤ벹ѲΨ. 
                              ! Temperature tendency by dry convective adjustment

    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
    logical:: xy_Adjust (0:imax-1, 1:jmax)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted this time or not?
    logical:: xy_AdjustB (0:imax-1, 1:jmax)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted last time or not?
    real(DP):: xyz_DPressDz (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DD{p}{z} $
                              !
    real(DP):: xyz_DDPressDDPress (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DD{p_{k}}{p_{k-1}} $
                              !
    real(DP):: xyz_DPFact (0:imax-1, 1:jmax, 1:kmax)
                              ! $ (R / C_p)
                              ! \frac{p_{k-1} - p_{k}}{2 p_{k-1/2}} $ . 
                              !
                              ! ե. 
                              ! Factor
    real(DP):: TempSat        ! $ S_t $ .
                              ! ˰². 
                              ! Saturation temperature
    real(DP):: DelTemp
                              ! Ĵˤ벹٤Ѳ. 
                              ! Temperature variation by adjustment
    logical:: Adjust
                              ! ΰˤư٤ǤĴᤵ줿ݤ?. 
                              ! Whether it was adjusted even once in global 
                              ! this time or not?

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction


    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. dryconv_adjust_inited ) call DryConvAdjInit

    ! Ĵ "Temp" ¸
    ! Store "Temp" before adjustment
    !
    xyz_TempB  = xyz_Temp
    
    ! եη׻
    ! Calculate factor
    !
    do k = 1, kmax
      xyz_DPressDz(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
    end do
    
    do k = 2, kmax

      xyz_DDPressDDPress(:,:,k) = xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
      
      xyz_DPFact(:,:,k) = &
        &   GasRDry / CpDry &
        &   * ( xyz_Press(:,:,k-1) - xyz_Press(:,:,k) ) &
        &   / ( xyz_DPressDz(:,:,k-1) + xyz_DPressDz(:,:,k) ) &
        &   / xyr_Press(:,:,k-1)

    end do
    
    ! Ĵ
    ! Adjustment
    !
    xy_AdjustB = .true.
    
    ! ƥ졼
    ! iteration
    !
    do itr = 1, ItrtMax
      xy_Adjust = .false.
      
      do k = 2, kmax
        do i = 0, imax-1
          do j = 1, jmax
            if ( xy_AdjustB(i,j) ) then
              
              TempSat = xyz_Temp(i,j,k-1) - xyz_Temp(i,j,k) &
                & - xyz_DPFact(i,j,k) &
                &    * (   xyz_DPressDz(i,j,k-1) * xyz_Temp(i,j,k-1) &
                &        + xyz_DPressDz(i,j,k)   * xyz_Temp(i,j,k)     )
              
              ! ԰Ǥʤ
              ! If it is unstable
              !
              if ( TempSat > TempSatMax(itr) ) then
                
                DelTemp = TempSat / ( 1.0_DP + xyz_DDPressDDPress(i,j,k) )
                xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
                xyz_Temp(i,j,k-1) = &
                  &   xyz_Temp(i,j,k-1) &
                  & - DelTemp * xyz_DDPressDDPress(i,j,k)
                
                ! Ĵᤷݤ?
                ! Whether it was adjusted or not?
                !
                xy_Adjust(i,j) = .true.
              end if
              
            end if
          end do
        end do
      end do
      
      Adjust = .false.
      do i = 0, imax-1
        do j = 1, jmax
          xy_AdjustB(i,j) = xy_Adjust(i,j)
          Adjust          = Adjust .or. xy_Adjust(i,j)
        end do
      end do
      
      if ( .not. Adjust ) exit
      
    end do
    
    ! ѲΨλ
    ! Calculate temperature tendency
    !
    xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'DTempDtDryConv', xyz_DTempDt)


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine DryConvectAdjust

  !-------------------------------------------------------------------

  subroutine DryConvAdjInit
    !
    ! dryconv_adjust ⥸塼νԤޤ. 
    ! NAMELIST#dryconv_adjust_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "dryconv_adjust" module is initialized. 
    ! "NAMELIST#dryconv_adjust_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetIntStepEval

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dryconv_adjust_nml/ &
      & ItrtMax, TempSatMax
          !
          ! ǥեͤˤĤƤϽ³ "dryconv_adjust#DryConvAdjInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "dryconv_adjust#DryConvAdjInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( dryconv_adjust_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    ItrtMax = 10
    TempSatMax(1:ItrtMax) = &
      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = dryconv_adjust_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$      if ( iostat_nml == 0 ) write( STDOUT, nml = dryconv_adjust_nml )
    end if

    ! ƥ졼, ԰εƸΥå
    ! Check number of iteration, admissible error of unstability
    !
    call NmlutilAryValid( module_name, & ! (in)
      & TempSatMax, 'TempSatMax', &      ! (in)
      & ItrtMax,    'ItrtMax' )          ! (in)


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DTempDtDryConv', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'temperature tendency by dry convective adjustment', 'K s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '  TempSatMax = (/ %*r /)', &
      & r = real( TempSatMax(1:ItrtMax) ), n = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dryconv_adjust_inited = .true.
  end subroutine DryConvAdjInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module dryconv_adjust
