!= ѱѥ᥿ꥼ: ήĴ᥹
!
!= Cumulus parameterization: Convective adjustment scheme
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: cumulus_adjust.f90,v 1.2 2008-08-05 19:33:03 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module cumulus_adjust
  !
  != ѱѥ᥿ꥼ: ήĴ᥹
  !
  != Cumulus parameterization: Convective adjustment scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ήĴ᥹ˤ, ٤漾Ĵᤷޤ. 
  ! ˰漾η׻ˤ Nakajima et al. (1992) ѤƤޤ. 
  ! ܤ saturate_nha1992 򻲾ȤƤ. 
  !
  ! Adjust temperature and specific humidity by 
  ! convective adjustment scheme.
  ! Nakajima et al. (1992) is used for calculation of 
  ! saturation specific humidity. 
  ! For details, see "saturate_nha1992". 
  !
  !== Procedures List
  ! 
  ! Cumulus       :: ٤漾Ĵ
  ! ------------  :: ------------
  ! Cumulus       :: Adjust temperature and specific humidity
  !
  !== NAMELIST
  !
  ! NAMELIST#cumulus_adjust_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: Cumulus

  ! ѿ
  ! Public variables
  !
  logical, save, public:: cumulus_adjust_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration

  real(DP), save:: TempSatMax(1:MaxNmlArySize)
                              ! ԰εƸ. 
                              ! Admissible error of unstability
  
  ! Nakajima et al. (1992) Ѥ˰漾η׻Ѥ
  ! Values for calculation of saturation specific humidity with Nakajima et al. (1992) 
  ! 
  real(DP), parameter:: LatHeatNha92 = 43655_DP
                              ! $ l $ [J mol-1].
                              ! ζŷǮ. Latent heat of condensation of water vapor
  real(DP), parameter:: P0Nha92 = 1.4e+11_DP
                              ! $ p_0^{*} $ [Pa].
                              ! ˰¶. constant for water vapor saturation curve

  character(*), parameter:: module_name = 'cumulus_adjust'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: cumulus_adjust.f90,v 1.2 2008-08-05 19:33:03 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface Cumulus
    module procedure Cumulus
  end interface

contains

  subroutine Cumulus( &
    & xyz_Temp, xyz_QVap, &  ! (inout)
    & xyz_Press, xyr_Press & ! (in)
    & )
    !
    ! ήĴ᥹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! convective adjustment scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &
                              ! $ R^{*} $ [J K-1 mol-1]. 
                              ! ׵.  Universal gas constant
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & EpsV
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)

    ! ѿ
    ! Work variables
    !
    real(DP):: xy_Rain (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
    logical:: xy_Adjust (0:imax-1, 1:jmax)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted this time or not?
    logical:: xy_AdjustB (0:imax-1, 1:jmax)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted last time or not?
    real(DP):: xyz_DPressDz (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DD{p}{z} $
                              !
    real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: xyz_DDPressDDPress (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DD{p_{k}}{p_{k-1}} $
                              !
    real(DP):: xyz_DPFact (0:imax-1, 1:jmax, 1:kmax)
                              ! $ (R / C_p)
                              ! \frac{p_{k-1} - p_{k}}{2 p_{k-1/2}} $ . 
                              !
                              ! ե. 
                              ! Factor
    real(DP):: TempSat        ! $ S_t $ .
                              ! ˰². 
                              ! Saturation temperature
    real(DP):: DelTempSat
                              ! Ĵˤ˰²٤Ѳ. 
                              ! Saturation temperature variation by adjustment
    real(DP):: DelQVap
                              ! Ĵˤ漾Ѳ. 
                              ! Specific humidity variation by adjustment
    real(DP):: DelTempUpper
                              ! Ĵˤ벹 (k) Ѳ. 
                              ! Temperature (k) variation by adjustment
    real(DP):: DelTempLower
                              ! Ĵˤ벹 (k-1) Ѳ. 
                              ! Temperature (k-1) variation by adjustment
    real(DP):: DQVapSatDTempUpper
                              ! $ \DD{q^{*}} (k)}{T} $
    real(DP):: DQVapSatDTempLower
                              ! $ \DD{q^{*}} (k-1)}{T} $
    real(DP):: DHDTempUpper
                              ! $ 1 + \gamma_{k} =
                              ! 1 + \frac{L}{C_p} \DP{q^{*}}{T}_{k} $
    real(DP):: DHDTempLower
                              ! $ 1 + \gamma_{k-1} =
                              ! 1 + \frac{L}{C_p} \DP{q^{*}}{T}_{k-1} $
    logical:: Adjust
                              ! ΰˤư٤ǤĴᤵ줿ݤ?. 
                              ! Whether it was adjusted even once in global 
                              ! this time or not?

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction


    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. cumulus_adjust_inited ) call CumAdjInit

    ! Ĵ "QVap", "Temp" ¸
    ! Store "QVap", "Temp" before adjustment
    !
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp
    
    ! եη׻
    ! Calculate factor
    !
    do k = 1, kmax
      xyz_DPressDz(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
    end do

    ! ˰漾׻
    ! Calculate saturation specific humidity
    !

    ! Nakajima et al. (1992) Ѥ˰漾η׻
    ! Calculate saturation specific humidity with Nakajima et al. (1992) 
    !
    xyz_QVapSat = EpsV * ( P0Nha92 / xyz_Press ) &
      &             * exp ( - LatHeatNha92 / ( GasRUniv * xyz_Temp ) )

!!$    call CalcQVapSat( phy_cumad % phy_sat, & ! (in)
!!$      &    xyz_Temp = xyz_Temp, &            ! (in)
!!$      &   xyz_Press = xyz_Press, &           ! (in)
!!$      & xyz_QVapSat = xyz_QVapSat, &         ! (out)
!!$      &         err = err )                  ! (out)

!!$    !  饦ڥμ˰漾׻
!!$    !  * 273 K λ˰¿ ES0 (= 611 Pa) ȤƤ
!!$    !    *  ,  , ¼ ε, 1981: 
!!$    !      絤ʳعֺ 2 ߿ȼ絤, ؽǲ, 249pp. 
!!$    !  Calculate saturation specific humidity with Clausius Clapeyron equation
!!$    !  * Saturation vapor pressure is ES0 (= 611 Pa) at 273 K
!!$    !
!!$    xyz_QVapSat = EpsV * ES0  &
!!$      & * exp( EL / RVap * ( 1.0_DP / 273.0_DP - 1.0_DP / xyz_Temp ) ) &
!!$      &    / xyz_Press

    xyz_DDPressDDPress(:,:,1) = 0.0_DP
    do k = 2, kmax
      xyz_DDPressDDPress(:,:,k) = xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
      xyz_DPFact(:,:,k) = &
        &   GasRDry / CpDry &
        &   * ( xyz_Press(:,:,k-1) - xyz_Press(:,:,k) ) &
        &   / xyr_Press(:,:,k-1) / 2.0_DP
    end do

    ! Ĵ
    ! Adjustment
    !
    xy_AdjustB = .true.
    
    ! ƥ졼
    ! Iteration
    !
    do itr = 1, ItrtMax
      xy_Adjust = .false.
      
      do k = 2, kmax
        do j = 1, jmax
          do i = 0, imax-1
            if ( xy_AdjustB(i,j) ) then
              
              TempSat = &
                &   xyz_Temp(i,j,k-1) - xyz_Temp(i,j,k) &
                & + ( xyz_QVapSat(i,j,k-1) - xyz_QVapSat(i,j,k) ) * LatentHeat / CpDry &
                & - xyz_DPFact(i,j,k) * ( xyz_Temp(i,j,k-1) + xyz_Temp(i,j,k) )
              
              ! ԰Ǥʤ
              ! If it is unstable
              !
              if ( TempSat > TempSatMax(itr) ) then

                ! .. , ˰¤Ƥʤ
                ! .. and, if it is saturated
                !
                if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) >= CrtlRH ) &
                  &  .and. &
                  &  ( xyz_QVap(i,j,k-1) / xyz_QVapSat(i,j,k-1) >= CrtlRH ) &
                  &    ) then
                  
                  DelQVap = &
                    &   xyz_DPressDz(i,j,k-1) &
                    &     * (xyz_QVap(i,j,k-1) - xyz_QVapSat(i,j,k-1) ) &
                    & + xyz_DPressDz(i,j,k) &
                    &     * (xyz_QVap(i,j,k) - xyz_QVapSat(i,j,k) ) 

                  DQVapSatDTempUpper = &
                    & xyz_QVapSat(i,j,k) &
                    &   * ( LatHeatNha92 / ( GasRUniv * xyz_Temp(i,j,k)**2 ) )
                  
                  DQVapSatDTempLower = &
                    & xyz_QVapSat(i,j,k-1) &
                    &   * ( LatHeatNha92 / ( GasRUniv * xyz_Temp(i,j,k-1)**2 ) )

!!$                  call CalcDQVapSatDTemp( phy_cumad % phy_sat, &  ! (in)
!!$                    &          Temp = xyz_Temp(i,j,k), &          ! (in)
!!$                    &         Press = xyz_Press(i,j,k), &         ! (in)
!!$                    & DQVapSatDTemp = DQVapSatDTempUpper )        ! (out)
!!$
!!$                  call CalcDQVapSatDTemp( phy_cumad % phy_sat, &  ! (in)
!!$                    &          Temp = xyz_Temp(i,j,k-1), &        ! (in)
!!$                    &         Press = xyz_Press(i,j,k-1), &       ! (in)
!!$                    & DQVapSatDTemp = DQVapSatDTempLower )        ! (out)
!!$
!!$                  DQvapSatDTempUpper = LatentHeat * xyz_QvapSat(i,j,k) &
!!$                    & / ( RVap * xyz_Temp(i,j,k) * xyz_Temp(i,j,k) )
!!$                  
!!$                  DQvapSatDTempLower = LatentHeat * xyz_QvapSat(i,j,k-1) &
!!$                    & / ( RVap * xyz_Temp(i,j,k-1) * xyz_Temp(i,j,k-1) )
                  
                  DHDTempUpper = 1.0_DP + LatentHeat/CpDry * DQVapSatDTempUpper
                  DHDTempLower = 1.0_DP + LatentHeat/CpDry * DQVapSatDTempLower
                  
                  DelTempSat = &
                    &   TempSat &
                    & + ( 1.0_DP - xyz_DPFact(i,j,k) / DHDTempLower ) &
                    &     * LatentHeat/CpDry * DelQVap / xyz_DPressDz(i,j,k-1)
                  
                  ! ٤Ĵ
                  ! Adjust temperature
                  !
                  DelTempUpper = &
                    & DelTempSat &
                    & / ( & 
                    &       ( 1.0_DP + xyz_DDPressDDPress(i,j,k) ) &
                    &        * DHDTempUpper &
                    &     + xyz_DPFact(i,j,k) &
                    &        * ( 1.0_DP - xyz_DDPressDDPress(i,j,k)  &
                    &                       * DHDTempUpper / DHDTempLower ) &
                    &   )
                  
                  DelTempLower = &
                    & - DHDTempUpper / DHDTempLower &
                    &    * xyz_DDPressDDPress(i,j,k) * DelTempUpper &
                    & + LatentHeat / CpDry * DelQVap & 
                    &    / ( xyz_DPressDz(i,j,k-1) * DHDTempLower )
                  
                  xyz_Temp(i,j,k)   = xyz_Temp(i,j,k) + DelTempUpper
                  xyz_Temp(i,j,k-1) = xyz_Temp(i,j,k-1) + DelTempLower
                  
                  ! 漾Ĵ
                  ! Adjust specific humidity
                  !
                  xyz_QVap(i,j,k) = &
                    &   xyz_QVapSat(i,j,k) &
                    & + DQVapSatDTempUpper * DelTempUpper

                  xyz_QVap(i,j,k-1) = &
                    &   xyz_QVapSat(i,j,k-1) &
                    & + DQVapSatDTempLower * DelTempLower

                  xyz_QVapSat(i,j,k)   = xyz_QVap(i,j,k)
                  xyz_QVapSat(i,j,k-1) = xyz_QVap(i,j,k-1)
                  
                  ! Ĵᤷݤ?
                  ! Whether it was adjusted or not?
                  !
                  xy_Adjust(i,j) = .true.
                end if
                
              end if
              
            end if
          end do
        end do
      end do
      
      Adjust = .false.
      do i = 0, imax-1
        do j = 1, jmax
          xy_AdjustB(i,j) = xy_Adjust(i,j)
          Adjust          = Adjust .or. xy_Adjust(i,j)
        end do
      end do
      
      if ( .not. Adjust ) exit
      
    end do
    
    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, precipitation
    !
    xy_Rain     = 0.0_DP
    xyz_DTempDt = 0.0_DP
    xyz_DQVapDt = 0.0_DP

    xyz_DQVapDt = xyz_DQVapDt & 
      & + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    xyz_DTempDt = xyz_DTempDt &
      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    do k = 1, kmax
      xy_Rain = xy_Rain  &
        & + ( xyz_QVapB(:,:,k) - xyz_QVap(:,:,k) ) &
        &       * xyz_DPressDz(:,:,k) / Grav * LatentHeat / ( 2.0_DP * DelTime )
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'RainCumulus',    xy_Rain )
    call HistoryAutoPut( 'DTempDtCumulus', xyz_DTempDt )
    call HistoryAutoPut( 'DQVapDtCumulus', xyz_DQVapDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine Cumulus

  !-------------------------------------------------------------------

  subroutine CumAdjInit
    !
    ! cumulus_adjust ⥸塼νԤޤ. 
    ! NAMELIST#cumulus_adjust_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "cumulus_adjust" module is initialized. 
    ! "NAMELIST#cumulus_adjust_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetIntStepEval

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /cumulus_adjust_nml/ &
      & CrtlRH, ItrtMax, TempSatMax
          !
          ! ǥեͤˤĤƤϽ³ "cumulus_adjust#CumAdjInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "cumulus_adjust#CumAdjInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( cumulus_adjust_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    CrtlRH  = 0.990_DP
    ItrtMax = 10
    TempSatMax(1:ItrtMax) = &
      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = cumulus_adjust_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
    end if

    ! ƥ졼, ԰εƸΥå
    ! Check number of iteration, admissible error of unstability
    !
    call NmlutilAryValid( module_name, & ! (in)
      & TempSatMax, 'TempSatMax', &      ! (in)
      & ItrtMax,    'ItrtMax' )          ! (in)


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'RainCumulus', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'precipitation by cumulus scheme', 'W m-2' )
    call HistoryAutoAddVariable( 'DTempDtCumulus', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'cumulus condensation heating', 'K s-1' )
    call HistoryAutoAddVariable( 'DQVapDtCumulus', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'cumulus condensation moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  CrtlRH  = %f', d = (/ CrtlRH /) )
    call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '  TempSatMax = (/ %*r /)', &
      & r = real( TempSatMax(1:ItrtMax) ), n = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    cumulus_adjust_inited = .true.
  end subroutine CumAdjInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module cumulus_adjust
