#!/bin/sh
#
#= Comment lines cleaner from NAMELIST file (for Fujitsu Fortran Compiler)
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: nmlcmtcleaner.sh,v 1.1 2008-08-10 17:09:25 morikawa Exp $
# Tag Name::  $Name: dcpam5-20080812 $
# Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
# License::   See COPYRIGHT[link:../COPYRIGHT]
#
######################################################################
#
#== Settings

# End Settings
######################################################################

nmlcmthelp(){
    cat <<EOF

  Usage: 
    `basename $0` input_file output_file

  Options
       -h,-H: print this message
       -V: print version

EOF

  nmlcmtprintversion
}

nmlcmtprintversion(){
    cat <<EOF
  `basename $0` Version $Id: nmlcmtcleaner.sh,v 1.1 2008-08-10 17:09:25 morikawa Exp $

  GFD Dennou Club All Right Reserved.

EOF
}


if [ X"$1" = X"" ]; then
    nmlcmthelp
    exit 1
fi

set -e


##############################
#== Parse options
#

while [ $# -gt 0 ]; do
    case $1 in
	"-h")
	    nmlcmthelp
	    exit
	    ;;
	"-H")
	    nmlcmthelp
	    exit
	    ;;
	"-V")
	    nmlcmtprintversion
	    exit
	    ;;
	"-"*)
	    nmlcmthelp
	    echo "Error: \"$1\" is invalid option."
	    echo ""
	    exit 1
	    ;;
	*)
	    break
	    ;;
    esac
done

######################################################################
#== input file, output file
input=$1
output=$2

if [ -z "$input" ]; then
    nmlcmthelp
    exit
fi

if [ -z "$output" ]; then
    nmlcmthelp
    exit
fi


######################################################################
#== check of input file
if [ ! -f "$input" ]; then
    echo ""
    echo "  Error: \"${input}\" is not found or not a regular file"
    echo ""
fi

######################################################################
#== create output file

cleand_lines=`grep -v '^ *!' $input | wc -l`
grep -v '^ *!' $input > $output

echo ""
echo "  `basename $0`: \"$output\" is created."
echo "                      ${cleand_lines} comment lines are cleaned."
echo ""


exit 0
