!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module time_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: time.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!This module set "Time" and "Step".
!
!ַ׻ƥåספ˴ؤꤹ뤿Υ⥸塼Ǥ롣
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
                                                                 !=end
module time_mod
                                                                 !=begin
  !== Dependency
  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: time_init, time_progress, time_end,  & ! subroutines
       &    InitTime, DelTime,                   & ! variables
       &    StepInterval, OutputStep,            & ! variables
       &    CurrentTime, CurrentLoop,            & ! variables
       &    tvar, ttype, tname, tunit              ! variables

  !== Public Data
  !
  !ǡϤκݤΥƥå״ֳ֤ϲʤɤ˴ؤ
  !((< time_init >)) ꡣ
  !
  real(DBKIND)     , save ::  &
       & InitTime = 0.0     , & ! ʬϻ
       & DelTime  = 300         ! ֥ƥå

  integer(INTKIND) , save ::  & 
       & StepInterval = 1   , & ! ϥƥå״ֳ
       & OutputStep   = 1       ! ϲ

  character(STRING), save ::  &
       & tvar  = 'time'     , & ! ѿ̾
       & ttype = 'float'    , & ! ѿη
       & tname = 'time'     , & ! ̾
       & tunit = 'seconds'      ! ñ
  !
  !ߤλ롼ײݻƤѿ
  !((< time_init >)) ǽꤵ졢((< time_progress >))
  !ǹ롣
  !
  real(DBKIND)     , save :: CurrentTime = 0.0  ! ߻
  integer(INTKIND) , save :: CurrentLoop = 1    ! ߤΥ롼ײ
                                                                 !=end

  logical, save :: time_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: time.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine time_init
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use nmlfile_mod, only : nmlfile_init, nmlfile_open, nmlfile_close
    use dc_trace,    only : BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !
    !==== NAMELIST
    !
    !InitTime Ϳ줿ͤ DelTime äͤ
    !CurrentTime 롣
    !
    namelist /time_nml/    &

         & InitTime      , &   ! ʬϻ
         & DelTime       , &   ! ֥ƥå

         & StepInterval  , &   ! ϲ
         & OutputStep    , &   ! ϥƥå״ֳ

         & tvar          , &   ! ѿ̾
         & ttype         , &   ! ѿη
         & tname         , &   ! ̾
         & tunit               ! ñ
                                                                 !=end

    !----- ѿ -----
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable
    character(STRING), parameter:: subname = "time_init"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (time_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       time_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read time_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=time_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST time_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=time_nml)
    else
       call DbgMessage('Not Read NAMELIST time_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST time_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    !----------------------------------------------------------------
    !   Set CurrentTime
    !----------------------------------------------------------------
    CurrentTime = InitTime + DelTime

    call EndSub(subname)
  end subroutine time_init


                                                                 !=begin
  !=== Progress Time and Number of Loop
  !
  !CurrentTime  ((< time_init >)) ǻꤵ줿 DelTime ʬʤᡢ
  !CurrentLoop  1 䤹
  !νꡢ֤ꤷ괬ᤷǤʤ
  !
  subroutine time_progress
  !==== Dependency
    use type_mod,    only : STRING
    use dc_trace,    only : BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "time_progress"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. time_initialized) then
       call EndSub( subname, 'Call time_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   Set CurrentTime and CurrentLoop
    !----------------------------------------------------------------
    CurrentTime = CurrentTime + DelTime
    CurrentLoop = CurrentLoop + 1

    call EndSub(subname, 'CurrentLoop=<%d>, CurrentTime=<%f>', &
         & i=(/CurrentLoop/), d=(/CurrentTime/))
  end subroutine time_progress


                                                                 !=begin
  !=== Terminate module
  !
  !NAMELIST ɤ߹ͤ˴ǥեȤ᤹ͤ
  !
  subroutine time_end
  !==== Dependency
    use type_mod,    only : STRING
    use dc_trace,    only : BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "time_end"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. time_initialized) then
       call EndSub( subname, 'time_init was not called', &
            &       c1=trim(subname) )
       return
    else
       time_initialized = .false.
    endif

    !----------------------------------------------------------------
    !   Reset to default value
    !----------------------------------------------------------------
    InitTime = 0.0      ! ʬϻ
    DelTime  = 300      ! ֥ƥå

    StepInterval = 1    ! ϥƥå״ֳ
    OutputStep   = 1    ! ϲ

    tvar  = 'time'      ! ѿ̾
    ttype = 'float'     ! ѿη
    tname = 'time'      ! ̾
    tunit = 'seconds'   ! ñ

    CurrentTime = 0.0   ! ߻
    CurrentLoop = 1     ! ߤΥ롼ײ


    call EndSub(subname)
  end subroutine time_end

end module time_mod
