!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module grid_wavenumber_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: grid_wavenumber.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!This module set maximum wavenumber of harmonic function in spectral method.
!
!ڥȥˡѤݤεĴ´ؿκȿԤ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
                                                                 !=end

module grid_wavenumber_mod

                                                                 !=begin
  !== Dependency
  use type_mod, only : INTKIND, STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: grid_wavenumber_init, grid_wavenumber_end ! subroutine
  public :: nm                                        ! variables
                                                                 !=end

  logical,   save :: grid_wavenumber_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: grid_wavenumber.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

                                                                 !=begin
  !== Public Data
  !
  !grid_wavenumber_init ˤͤꤵ롣ʲϥǥե͡
  !
  integer(INTKIND), save :: nm = 21      ! ȿ
                                                                 !=end

contains

                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !NAMELIST ȿ롣
  !Ǥʤ硢ޤϥʲͤͿ줿硢
  !嵭ΥǥեͤŪꤵ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine grid_wavenumber_init
  !
  !==== Dependency
  !
    use type_mod,   only: INTKIND
    use nmlfile_mod,only: nmlfile_init, nmlfile_open, nmlfile_close
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
    use dc_message, only: MessageNotify
                                                                 !=end
    implicit none

    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
    logical                     :: invalid_number = .false.
    logical                     :: nmlreadable
    integer(INTKIND)            :: nmlunit, nmlstat
    character(STRING), parameter:: subname = "grid_wavenumber_init"

                                                                 !=begin
    !
    !==== NAMELIST
    !
    namelist /grid_wavenumber_nml/ nm ! ȿ
                                                                 !=end

  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (grid_wavenumber_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       grid_wavenumber_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read grid_wavenumber_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=grid_wavenumber_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST grid_wavenumber_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=grid_wavenumber_nml)
    else
       call DbgMessage('Not Read NAMELIST grid_wavenumber_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST grid_wavenumber_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    !----------------------------------------------------------------
    !   Exception handling
    !----------------------------------------------------------------
    invalid_number = .false.
    if (nm < 1) then
       nm = 12 ; invalid_number = .true.
    endif

    if (invalid_number) then
       call MessageNotify('W', subname, &
            & 'Invalid wavenumber is exist. Force Set nm=<%d>', &
            & i=(/nm/) )
       call DbgMessage( &
            & 'Invalid wavenumber is exist. Force Set nm=<%d>', &
            & i=(/nm/) )
    endif

    call EndSub( subname, 'nm=<%d>', i=(/nm/) )
  end subroutine grid_wavenumber_init


                                                                 !=begin
  !=== Terminate module
  !
  !NAMELIST ɤ߹ͤ˴ǥեȤ᤹ͤ
  !
  subroutine grid_wavenumber_end
  !==== Dependency
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "grid_wavenumber_end"

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. grid_wavenumber_initialized) then
       call EndSub( subname, 'grid_wavenumber_init was not called', &
            &       c1=trim(subname) )
       return
    else
       grid_wavenumber_initialized = .false.
    endif

    !----------------------------------------------------------------
    !   Reset to default value
    !----------------------------------------------------------------
    nm = 12

    call EndSub( subname, 'nm=<%d>', i=(/nm/) )
  end subroutine grid_wavenumber_end

end module grid_wavenumber_mod
