!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module axis_x_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: axis_x.f90,v 1.4 2006/09/29 14:19:30 morikawa Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!This module set axis X or axis Longitude.
!
!X ޤϷټꤹ롣
!
!== Error Handling
!
!== Known Bugs
!
!netCDF ǡ X Ϥ axis_x_netcdf ˤơ
!ǡ radians Ǥ degrees Ǥ⡢ΤޤϤ褦
!ʤäƤ롣ϸǡ units Ƚꤹ٤
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module axis_x_mod
                                                                 !=begin
  !== Dependency
  use type_mod,      only : INTKIND, STRING
  use axis_type_mod, only : AXISINFO
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: axis_x_init, axis_x_weight, axis_x_spectral ! subroutines
  public :: axis_x_manual, axis_x_netcdf, axis_x_end    ! subroutines
                                                                 !=end

  type(AXISINFO)   ,save:: x_Dim        ! 礹ѿ
  type(AXISINFO)   ,save:: x_Dim_Weight ! Ť߾礹ѿ

  logical          ,save:: axis_x_data_from_spectral = .false.
  logical          ,save:: axis_x_data_from_manual   = .false.
  character(STRING),save:: axis_x_data_from_netcdf   = ''

  logical          ,save:: axis_x_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: axis_x.f90,v 1.4 2006/09/29 14:19:30 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine axis_x_init
  !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND, REKIND, DBKIND, NMLARRAY
    use nmlfile_mod,only: nmlfile_init, nmlfile_open, nmlfile_close
    use grid_3d_mod,only: im, grid_3d_init
    use spml_mod,   only: spml_init
!    use axis_type_mod, only : axis_attrs_copy, axis_attrs_init
!    use gt4_history, only: GT_HISTORY_ATTR
    use dc_types,  only: GT_TOKEN => TOKEN, GT_STRING => STRING
    use dc_url,    only: GT_ATMARK, GT_QUESTION
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
    use dc_message,only: MessageNotify
    use gt4_history, only: HistoryAxisCreate, HistoryAxisAddAttr
    use dc_string, only: StrHead
                                                                 !=end
    implicit none
    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
                                                                 !=begin
    !
    !==== NAMELIST
    !
    !X μѿ˴ؤͿ롣
    !ͤͿʤΤ˴ؤƤϰʲΥǥեȤͤѤ롣
    !
    !ѿ decision ˤ X ΥǡɤΤ褦Ϳ뤫ꤹ롣
    !
    !* (({ 'manual' }))
    !  * Data ˳Ǽǡ򤽤Τޤ X ȤͿ롣
    !
    !* (({ 'spectral' }))
    !  * ڥȥˡѤꤷ length ˱ƼưŪ
    !    X Υǡޤ롣
    !
    !* gtool4 ѿ (㤨 (({ 'foo.nc@lon' })) ʤ)
    !  * ѿ X Υǡ롣
    !
    !ѿ length ˤϡ ((<grid_3d_mod>)) θ ((< im >)) Ʊ
    !ͤͿʤФʤʤ
    !
    character(TOKEN)  :: name     = 'lon'          ! ѿ̾
    integer(INTKIND)  :: length   = 64             ! Ĺ (󥵥)
    character(STRING) :: longname = 'Longitude'    ! ѿεŪ̾
    character(STRING) :: units    = 'degrees_east' ! ѿñ
    character(TOKEN)  :: xtype    = 'float'        ! ѿη
    character(STRING) :: decision = 'spectral'     ! ǡμˡ
    real(REKIND)      :: Data(NMLARRAY)  = 0.0        ! ǡ

    namelist /axis_x_nml/ &
         & name         , &  ! ѿ̾
         & length       , &  ! Ĺ (󥵥)
         & longname     , &  ! ѿεŪ̾
         & units        , &  ! ѿñ
         & xtype        , &  ! ѿη
         & decision     , &  ! ǡμˡ
         & Data              ! ǡ
                                                                 !=end
                                                                 !=begin
    !
    !X μѿ°˴ؤͿ롣
    !NAMELIST ʣ axis_x_attr_nml ѰդƤ
    !ʣξͿǽǤ롣
    !Ϳʤˤ°ղäʤ
    !
    !attrtype ˤͿ°ͤμꤹ롣
    !((<URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
    !򻲾Ȥ衣ʤarraysize  1 ʾͤꤹȡ
    !ǡͥ褵°ͤꤵ롣
    !
    character(GT_TOKEN)  :: attrname = '' ! °̾
    character(GT_TOKEN)  :: attrtype = '' ! °ͤη
    character(GT_STRING) :: cvalue   = '' ! ° (ʸ)
    integer(INTKIND)     :: ivalue   = 0      ! ° ()
    real(REKIND)         :: rvalue   = 0.0    ! ° (ñټ¿)
    real(DBKIND)         :: dvalue   = 0.0d0  ! ° (ټ¿)
    logical              :: lvalue   = .false.! ° ()
    integer(INTKIND)     :: arraysize= 0      ! Υ
    integer(INTKIND) :: iarray(NMLARRAY)  = 0    ! ° ()
    real(REKIND)     :: rarray(NMLARRAY)  = 0.0  ! ° (ñټ¿)
    real(DBKIND)     :: darray(NMLARRAY)  = 0.0d0! ° (ټ¿)

    namelist /axis_x_attr_nml/ &
         & attrname     , &  ! °̾
         & attrtype     , &  ! °ͤη
         & cvalue       , &  ! ° (ʸ)
         & ivalue       , &  ! ° ()
         & rvalue       , &  ! ° (ñټ¿)
         & dvalue       , &  ! ° (ټ¿)
         & lvalue       , &  ! ° ()
         & arraysize    , &  ! Υ
         & iarray       , &  ! ° ()
         & rarray       , &  ! ° (ñټ¿)
         & darray            ! ° (ټ¿)
                                                                 !=end

    !-----------------------------------------------------------------
    !   ѿΰǼѿ
    !-----------------------------------------------------------------
!    type(GT_HISTORY_ATTR), allocatable :: attrs_tmp(:)

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    integer(INTKIND)            :: i, k
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable, next
    character(TOKEN)            :: position
    character(STRING), parameter:: subname = "axis_x_init"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (axis_x_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       axis_x_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !-----------------------------------------------------------------
    !   Initialize Dependent Modules
    !-----------------------------------------------------------------
    call grid_3d_init
    call spml_init

    !----------------------------------------------------------------
    !   read axis_x_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=axis_x_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST axis_x_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=axis_x_nml)
    else
       call DbgMessage('Not Read NAMELIST axis_x_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_x_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    x_Dim%stored   = .false.
    !  ѿξ¤ѿ x_Dim ؤ
    call HistoryAxisCreate(x_Dim % axisinfo, &
      & name, length, longname, units, xtype)
!!$    x_Dim%axisinfo%name     = name
!!$    x_Dim%axisinfo%length   = length
!!$    x_Dim%axisinfo%longname = longname
!!$    x_Dim%axisinfo%units    = units
!!$    x_Dim%axisinfo%xtype    = xtype
!!$    allocate( x_Dim%a_Dim(x_Dim%axisinfo%length) )
    allocate( x_Dim%a_Dim(length) )

    !  ѿξ¤ѿ x_Dim ؤ
    select case(decision)

    ! manual: NAMELIST  Data 
    case('manual')
       x_Dim%a_Dim(:)                       = 0
       x_Dim%a_Dim(1:length) = Data(1:length)
       x_Dim%stored                         = .true.
       axis_x_data_from_manual              = .true.

    ! spectral: SPMODEL  wa_module ˤ
    case('spectral')
       axis_x_data_from_spectral = .true.
       x_Dim%stored              = .false.

    ! foo.nc@lon: foo.nc ե lon ѿ
    ! ¾    : spectral Ʊ
    case default
       ! ʸ '@'  '?' ޤޤ gtool4 ѿȤ
       ! ǧ nc ե뤫ѿ򥳥ԡ롣
       if (   index(decision, GT_ATMARK)   > 0 .or.  &
            & index(decision, GT_QUESTION) > 0) then
          axis_x_data_from_netcdf  = decision
          x_Dim%stored             = .false.
       ! ʳ 'spectral' Ʊ褦˽
       else
          axis_x_data_from_spectral = .true.
          x_Dim%stored         = .false.
       endif
    end select

    !----------------------------------------------------------------
    !   read axis_x_attr_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)

    if (.not. nmlreadable) then
       call DbgMessage('Not Read NAMELIST axis_x_attr_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_x_attr_nml.')
    else

       i = 0
       next = .false.
       axis_x_attr_nml_input : do
          i = i + 1
          call DbgMessage('NAMELIST axis_x_attr_nml Input, <%d> time', i=(/i/))
          ! 
          attrname  = ''     ! °̾
          attrtype  = ''     ! °ͤη
          cvalue    = ''     ! ° (ʸ)
          ivalue    = 0      ! ° ()
          rvalue    = 0.0    ! ° (ñټ¿)
          dvalue    = 0.0d0  ! ° (ټ¿)
          lvalue    = .false.! ° ()
          arraysize = 0      ! Υ
          iarray(:) = 0      ! ° ()
          rarray(:) = 0.0    ! ° (ñټ¿)
          darray(:) = 0.0d0  ! ° (ټ¿)

          ! read nml
          read(nmlunit, nml=axis_x_attr_nml, iostat=nmlstat)
          call DbgMessage('Stat of NAMELIST axis_x_attr_nml Input is <%d>', &
               &           i=(/nmlstat/))
          write(0, nml=axis_x_attr_nml)

          ! Inquire access position
          inquire(nmlunit, position=position)
          if ( trim(position) /= 'APPEND' .and. nmlstat == 0 ) then
             next = .true.
          else
             next = .false.
          endif

          ! ͭǤʤͤޤΤ˴ؤƤ̵롣
          if (attrname == '') then
             call DbgMessage('attrname is blank. so this axis_x_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          elseif (attrtype == '') then
             call DbgMessage('attrtype is blank. so this axis_x_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          endif

          !-----------------------------------------------------------
          ! x_Dim%attrs ؤγǼ
          !-----------------------------------------------------------
          ! attrs(:) γĥ
!!$          if ( .not. associated(x_Dim%attrs) ) then
!!$             allocate( x_Dim%attrs(1) )
!!$             k = 1
!!$          else
!!$             k = size( x_Dim%attrs ) + 1
!!$             ! ǡΰ
!!$             allocate( attrs_tmp(k-1) )
!!$             call axis_attrs_copy(from=x_Dim%attrs(1:k-1), to=attrs_tmp(1:k-1))
!!$             deallocate( x_Dim%attrs )
!!$             allocate( x_Dim%attrs(k) )
!!$             call axis_attrs_copy(from=attrs_tmp(1:k-1), to=x_Dim%attrs(1:k-1))
!!$             deallocate( attrs_tmp )
!!$          endif
!!$
!!$          if (arraysize > 0) then
!!$             call axis_attrs_init(x_Dim%attrs(k))
!!$
!!$             deallocate(  x_Dim%attrs(k)%iarray  )
!!$             deallocate(  x_Dim%attrs(k)%rarray  )
!!$             deallocate(  x_Dim%attrs(k)%darray  )
!!$
!!$             allocate(  x_Dim%attrs(k)%iarray( arraysize )  )
!!$             allocate(  x_Dim%attrs(k)%rarray( arraysize )  )
!!$             allocate(  x_Dim%attrs(k)%darray( arraysize )  )
!!$
!!$             x_Dim%attrs(k)%array = .true.
!!$
!!$          else
!!$             call axis_attrs_init(x_Dim%attrs(k))
!!$          endif

          if (StrHead(attrtype, 'char')) then
            call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, cvalue)
          elseif (StrHead(attrtype, 'logical')) then
            call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, lvalue)
          elseif (StrHead(attrtype, 'int')) then
            if (arraysize > 0) then
              call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, iarray)
            else
              call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, ivalue)
            end if
          elseif (StrHead(attrtype, 'real')) then
            if (arraysize > 0) then
              call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, rarray)
            else
              call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, rvalue)
            end if
          elseif (StrHead(attrtype, 'double')) then
            if (arraysize > 0) then
              call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, darray)
            else
              call HistoryAxisAddAttr(x_Dim % axisinfo, attrname, dvalue)
            end if
          end if

!!$          x_Dim%attrs(k)%attrname  = attrname
!!$          x_Dim%attrs(k)%attrtype  = attrtype
!!$          x_Dim%attrs(k)%cvalue    = cvalue
!!$          x_Dim%attrs(k)%ivalue    = ivalue
!!$          x_Dim%attrs(k)%rvalue    = rvalue
!!$          x_Dim%attrs(k)%dvalue    = dvalue
!!$          x_Dim%attrs(k)%lvalue    = lvalue
!!$          x_Dim%attrs(k)%iarray(1:max(1,arraysize)) = iarray(1:max(1,arraysize))
!!$          x_Dim%attrs(k)%rarray(1:max(1,arraysize)) = rarray(1:max(1,arraysize))
!!$          x_Dim%attrs(k)%darray(1:max(1,arraysize)) = darray(1:max(1,arraysize))

!!$          call DbgMessage('x_Dim-attrs(%d) [attrname=<%c> '            // &
!!$               & 'attrtype=<%c> array=<%b> cvalue=<%c>  '         // &
!!$               & 'ivalue=<%d> rvalue=<%r> dvalue=<%f> '           // &
!!$               & 'iarray(1:%d)=<%d, ...> '                        // &
!!$               & 'rarray(1:%d)=<%r, ...> darray(1:%d)=<%f, ...>'   , &
!!$               & c1=trim( x_Dim%attrs(k)%attrname )                  , &
!!$               & c2=trim( x_Dim%attrs(k)%attrtype )                  , &
!!$               & c3=trim( x_Dim%attrs(k)%cvalue )                    , &
!!$               & i=(/ k, x_Dim%attrs(k)%ivalue    ,                    &
!!$               &      size(x_Dim%attrs(k)%iarray) ,                    &
!!$               &      x_Dim%attrs(k)%iarray       ,                    &
!!$               &      size(x_Dim%attrs(k)%rarray) ,                    &
!!$               &      size(x_Dim%attrs(k)%darray)                      &
!!$               &   /)                                                , &
!!$               & r=(/x_Dim%attrs(k)%rvalue, x_Dim%attrs(k)%rarray/)    , &
!!$               & d=(/x_Dim%attrs(k)%dvalue, x_Dim%attrs(k)%darray/)    , &
!!$               & l=(/x_Dim%attrs(k)%lvalue/)                      )

          if (.not. next) exit axis_x_attr_nml_input
          next      = .false.  ! Τν

       enddo axis_x_attr_nml_input

    end if

    call nmlfile_close

    !----------------------------------------------------------------
    !   grid_3d_mod Ȥå
    !----------------------------------------------------------------
    call grid_3d_init
    if (length /= im) then
       call MessageNotify('E', subname, &
            & message='axis length is inconsistent with im in grid_3d_mod')
    endif

    !----------------------------------------------------------------
    !   㳰
    !----------------------------------------------------------------
    if (length < 1) then
       call MessageNotify('E', subname, message='Invalid grid number.')
    endif


    call EndSub( subname )
  end subroutine axis_x_init


                                                                 !=begin
  !=== Return Weight of axis X
  !
  !ŤߥǡȤղþ֤
  !((< axis_x_init >))  NAMELIST axis_x_nml  decision ѿ
  !(({ 'spectral' })) ʳͿ줿ͤʤ֤
  !
  !ޤX μѿ˽Ťߥǡ˴ؤղþä롣
  !
  subroutine axis_x_weight(Dim_Weight)
  !==== Dependency
    use constants_mod, only: constants_init, pi
    use axis_type_mod, only: axis_type_copy
!    use axis_type_mod, only: axis_type_copy, axis_attrs_copy, axis_attrs_init
    use spml_mod,   only: wa_module_x_Lon_Weight => x_Lon_Weight
    use grid_3d_mod,only: im
!    use gt4_history,only: GT_HISTORY_ATTR
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
    use gt4_history,only: HistoryAxisCopy, HistoryAxisInquire
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Output
    !
    type(AXISINFO), intent(out) :: Dim_Weight ! 礹ѿ
                                                                 !=end
!    type(GT_HISTORY_ATTR), allocatable :: attrs_tmp(:) ! Ǽ

    character(STRING) :: name, longname
    character(STRING), parameter:: subname = "axis_x_weight"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_x_initialized) then
       call EndSub( subname, 'Call axis_x_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'spectral' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_x_data_from_spectral) then
       call EndSub( subname, &
            & 'In axis_x_nml, configurated to not generate from spmodel')
       return
    endif

    !----------------------------------------------------------------
    !   Initialize Dependent module
    !----------------------------------------------------------------
    call constants_init()

    !----------------------------------------------------------------
    !   x_Dim ξ󤫤 x_Dim_Weight ξ
    !----------------------------------------------------------------
    call HistoryAxisInquire(x_Dim % axisinfo, name=name, longname=longname)
    call HistoryAxisCopy(&
      & axis_dest=x_Dim_Weight % axisinfo, &
      & axis_src=x_Dim % axisinfo, &
      & name=trim(name) // '_weight', longname=trim(longname) // ' weight')
!!$    x_Dim_Weight%axisinfo%name     = trim(x_Dim%axisinfo%name) // '_weight'
!!$    x_Dim_Weight%axisinfo%length   = x_Dim%axisinfo%length
!!$    x_Dim_Weight%axisinfo%longname = trim(x_Dim%axisinfo%longname) // ' weight'
!!$    x_Dim_Weight%axisinfo%units    = trim(x_Dim%axisinfo%units)
!!$    x_Dim_Weight%axisinfo%xtype    = trim(x_Dim%axisinfo%xtype)
!!$    if ( associated(x_Dim_Weight%attrs) ) then
!!$       deallocate( x_Dim_Weight%attrs )
!!$    endif
!!$
!!$    ! x_Dim ˤղ
!!$    if ( associated(x_Dim%attrs) ) then
!!$       allocate( attrs_tmp(size(x_Dim%attrs)) )
!!$       call axis_attrs_copy(from=x_Dim%attrs(:), to=attrs_tmp(:))
!!$       deallocate( x_Dim%attrs )
!!$       allocate( x_Dim%attrs(size(attrs_tmp)+1) )
!!$       call axis_attrs_copy(from=attrs_tmp(:), to=x_Dim%attrs(1:size(attrs_tmp)) )
!!$
!!$       call axis_attrs_init( x_Dim%attrs(size(attrs_tmp)+1) )
!!$       x_Dim%attrs(size(attrs_tmp)+1)%attrname = 'gt_calc_weight'
!!$       x_Dim%attrs(size(attrs_tmp)+1)%attrtype = 'char'
!!$       x_Dim%attrs(size(attrs_tmp)+1)%cvalue   = x_Dim_Weight%axisinfo%name
!!$       x_Dim%attrs(size(attrs_tmp)+1)%array    = .false.
!!$    else
!!$       allocate( x_Dim%attrs(1) )
!!$       call axis_attrs_init( x_Dim%attrs(1) )
!!$       x_Dim%attrs(1)%attrname = 'gt_calc_weight'
!!$       x_Dim%attrs(1)%attrtype = 'char'
!!$       x_Dim%attrs(1)%cvalue   = x_Dim_Weight%axisinfo%name
!!$       x_Dim%attrs(1)%array    = .false.
!!$    endif

    !----------------------------------------------------------------
    !   wa_module 饹ڥȥǡ롣
    !----------------------------------------------------------------
    allocate( x_Dim_Weight%a_Dim(im) )
    ! 饸ٿѴ
    x_Dim_Weight%a_Dim(:) = wa_module_x_Lon_Weight(:) * 180. / pi
    x_Dim_Weight%stored   = .true.

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(x_Dim_Weight, Dim_Weight)
    call EndSub( subname )
  end subroutine axis_x_weight


                                                                 !=begin
  !=== Return Data of axis X for Spectral Method.
  !
  !ڥȥˡѤꤷ X Υǡ֤
  !
  !((< axis_x_init >))  NAMELIST axis_x_nml  units  
  !(({ 'radian' })) ޤ (({ 'rad.' })) Ϳˤ
  !ñ̤饸ǥǡ֤롣ʳǤٿǥǡ֤롣
  !
  !((< axis_x_init >))  NAMELIST axis_x_nml  decision ѿ
  !(({ 'spectral' })) ʳͿ줿ͤʤ֤
  !
  subroutine axis_x_spectral(Dim)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use constants_mod, only: constants_init, pi
    use spml_mod,   only: wa_module_x_Lon => x_Lon
    use dc_string,  only: toChar, StrHead, LChar
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
    use gt4_history, only: HistoryAxisInquire
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING) :: units
    character(STRING), parameter:: subname = "axis_x_spectral"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_x_initialized) then
       call EndSub( subname, 'Call axis_x_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'spectral' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_x_data_from_spectral) then
       call EndSub( subname, &
            & 'In axis_x_nml, configurated to not generate from spmodel')
       return
    endif

    !----------------------------------------------------------------
    !   Initialize Dependent module
    !----------------------------------------------------------------
    call constants_init()

    !----------------------------------------------------------------
    !   wa_module 饹ڥȥǡ롣
    !----------------------------------------------------------------
    call HistoryAxisInquire(x_Dim % axisinfo, units=units)
    if (  StrHead( 'radians', trim(LChar(units)) ) .or.&
         & StrHead( 'rad.', trim(LChar(units)) ) ) then
       ! radian ǤΤޤ
       x_Dim%a_Dim(:) = wa_module_x_Lon(:)
    else
       ! radian  degree Ѵ
       x_Dim%a_Dim(:) = wa_module_x_Lon(:) * 180. / pi
    end if

    x_Dim%stored   = .true.

    call DbgMessage('x_Lon=<%c>', c1=trim(toChar(x_Dim%a_Dim)) )

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(x_Dim, Dim)
    call EndSub( subname )
  end subroutine axis_x_spectral


                                                                 !=begin
  !=== Return Data of axis X from NAMELIST
  !
  !NAMELIST 줿ǡ X ǡȤ֤
  !
  !((< axis_x_init >))  NAMELIST axis_x_nml  decision ѿ
  !(({ 'manual' })) ʳͿ줿ͤʤ֤
  !
  subroutine axis_x_manual(Dim)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use spml_mod,   only: wa_module_x_Lon => x_Lon
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING), parameter:: subname = "axis_x_manual"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_x_initialized) then
       call EndSub( subname, 'Call axis_x_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'manual' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_x_data_from_manual) then
       call EndSub( subname, &
            & 'In axis_x_nml, configurated to not generate from manual')
       return
    endif

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(x_Dim, Dim)
    call EndSub( subname )
  end subroutine axis_x_manual


                                                                 !=begin
  !=== Return Data of axis X from netCDF file
  !
  !netCDF ǡǡ X ΥǡȤ֤
  !
  !ߡΥǡñ̤˴ؤ餺Τޤޥǡ
  !Ϥ롣((<Known Bugs>)) ȡ
  !
  !((< axis_x_init >))  NAMELIST axis_x_nml  decision ѿ
  !gtool4 ѿʳͿ줿ͤʤ֤
  !
  subroutine axis_x_netcdf(Dim)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use gt4_history,only: HistoryGet
    use dc_url  ,   only: UrlSplit
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING)           :: file
    character(STRING)           :: varname

    character(STRING), parameter:: subname = "axis_x_netcdf"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_x_initialized) then
       call EndSub( subname, 'Call axis_x_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  '***@lon' ʤɤǤʤߤ֤
    !----------------------------------------------------------------
    if (axis_x_data_from_netcdf == '') then
       call EndSub( subname, &
            & 'In axis_x_nml, configurated to not generate from netcdf data')
       return
    endif

    !----------------------------------------------------------------
    !   HistoryGet ˤǡ
    !----------------------------------------------------------------
    call UrlSplit(axis_x_data_from_netcdf, file=file, var=varname)
    call HistoryGet(file, varname, x_Dim%a_Dim)
    x_Dim%stored   = .true.

    !  Ϥǡ units  'degree'  'radian' Ĵ١
    !  'radian' Ѵθ塢x_Dim%axisinfo%units 
    ! 'degree'  'radian' ˱ 180. / pi ݤ뤫ɤ
    ! Ƚꤹ٤

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(x_Dim, Dim)
    call EndSub( subname )
  end subroutine axis_x_netcdf


                                                                 !=begin
  !=== Terminate module
  !
  !((<axis_x_init>)) ꤵ줿ͤ˴ǥեȤ᤹
  !
  subroutine axis_x_end()
  !==== Dependency
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
    use gt4_history, only: HistoryAxisClear
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "axis_x_end"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. axis_x_initialized) then
       call EndSub( subname, 'axis_x_init was not called', &
            &       c1=trim(subname) )
       return
    else
       axis_x_initialized = .false.
       axis_x_data_from_spectral = .false.
       axis_x_data_from_manual   = .false.
       axis_x_data_from_netcdf   = ''

       !--------------------------------------------------------------
       !   Initialize x_Dim
       !--------------------------------------------------------------
       x_Dim%stored   = .false.
       call HistoryAxisClear(x_Dim % axisinfo)
!!$       x_Dim%axisinfo%name     = ''
!!$       x_Dim%axisinfo%length   = 0
!!$       x_Dim%axisinfo%longname = ''
!!$       x_Dim%axisinfo%units    = ''
!!$       x_Dim%axisinfo%xtype    = ''
!!$       if ( associated(x_Dim%a_Dim) ) then
!!$          deallocate( x_Dim%a_Dim )
!!$       endif
!!$
!!$       if ( associated(x_Dim%attrs) ) then
!!$          deallocate( x_Dim%attrs )
!!$       end if

       !--------------------------------------------------------------
       !   Initialize x_Dim_Weight
       !--------------------------------------------------------------
       call HistoryAxisClear(x_Dim_Weight % axisinfo)
!!$       x_Dim_Weight%axisinfo%name     = ''
!!$       x_Dim_Weight%axisinfo%length   = 0
!!$       x_Dim_Weight%axisinfo%longname = ''
!!$       x_Dim_Weight%axisinfo%units    = ''
!!$       x_Dim_Weight%axisinfo%xtype    = ''
!!$
!!$       if ( associated(x_Dim%a_Dim) ) then
!!$          deallocate( x_Dim%a_Dim )
!!$       end if
!!$
!!$       if ( associated(x_Dim%attrs) ) then
!!$          deallocate( x_Dim%attrs )
!!$       end if

    endif

    call EndSub( subname )
  end subroutine axis_x_end

end module axis_x_mod
