!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_surface_main.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_surface_main_mod

  implicit none

  private
  public :: physics_surface_main

contains

  subroutine physics_surface_main( &
         & xyr_VelLonFlux       , & ! (inout) ®ٷʬեå
         & xyr_VelLatFlux       , & ! (inout) ®ٰʬեå
         & xyr_TempFlux         , & ! (inout) ٥եå
         & xyr_QvapFlux         , & ! (inout) 漾եå
         & xy_SurfVelMatrix     , & ! (out) ®ٱ: ɽ
         & xyoo_SurfTempMatrix  , & ! (out) ٱ: ɽ
         & xyoo_SurfQvapMatrix  , & ! (out) 漾: ɽ
         & xyz_VelLon           , & ! (in) ®ٷʬ
         & xyz_VelLat           , & ! (in) ®ٰʬ
         & xyz_Temp             , & ! (in)  ()
         & xyr_Temp             , & ! (in)  (Ⱦ)
         & xy_SurfTemp          , & ! (in) ɽ̲ 
         & xyz_Qvap             , & ! (in) 漾 ()
         & xyz_Press            , & ! (in)  ()
         & xyr_Press            , & ! (in)  (Ⱦ)
         & xyz_GeoPot           , & ! (in)  ()
         & xy_SurfHumidCoeff    , & ! (in) ɽ
         & xy_SurfRoughLength   , & ! (in) ɽĹ
         & xy_SurfCondition       ) ! (in) ɽ

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: RAir, Cp, Grav, EL, ES0, RVap, EpsV
    use physics_surface_coeff_mod,  only: physics_surface_coeff
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Output
    !
    real(DBKIND), intent(out) :: &
         & xy_SurfVelMatrix(im,jm)             , & ! (out) ®ٱ: ɽ
         & xyoo_SurfTempMatrix(im,jm,0:1,-1:1) , & ! (out) ٱ: ɽ
         & xyoo_SurfQvapMatrix(im,jm,0:1,-1:1)     ! (out) 漾: ɽ

    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & xyz_VelLon(im,jm,km)              , & ! (in) ®ٷʬ
         & xyz_VelLat(im,jm,km)              , & ! (in) ®ٰʬ
         & xyz_Temp(im,jm,km)                , & ! (in)  ()
         & xyr_Temp(im,jm,km+1)              , & ! (in)  (Ⱦ)
         & xy_SurfTemp(im,jm)                , & ! (in) ɽ̲ 
         & xyz_Qvap(im,jm,km)                , & ! (in) 漾 ()
         & xyz_Press(im,jm,km)               , & ! (in)  ()
         & xyr_Press(im,jm,km+1)             , & ! (in)  (Ⱦ)
         & xyz_GeoPot(im,jm,km)              , & ! (in)  ()
         & xy_SurfHumidCoeff(im,jm)          , & ! (in) ɽ
         & xy_SurfRoughLength(im,jm)             ! (in) ɽĹ
    integer(INTKIND), intent(in) :: &
         & xy_SurfCondition(im,jm)               ! (in) ɽ

    !==== In/Out
    !
    real(DBKIND), intent(inout) :: &
         & xyr_VelLonFlux(im,jm,km+1)        , & ! (inout) ®ٷʬեå
         & xyr_VelLatFlux(im,jm,km+1)        , & ! (inout) ®ٰʬեå
         & xyr_TempFlux(im,jm,km+1)          , & ! (inout) ٥եå
         & xyr_QvapFlux(im,jm,km+1)              ! (inout) 漾եå

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_surface_main"

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j

!    real(DBKIND), parameter :: RefPress        = 100000.0D0 ! ȵ
    real(DBKIND), parameter :: BasePotTemp     = 300.0D0    ! ܲ
    real(DBKIND), parameter :: VelMinForRi     = 0.01       ! ңǾ
    real(DBKIND), parameter :: VelMinForVel    = 0.01       ! ưǾ
    real(DBKIND), parameter :: VelMinForTemp   = 0.01       ! ǮǾ
    real(DBKIND), parameter :: VelMinForQvap   = 0.01       ! Ǿ
    real(DBKIND), parameter :: VelMaxForVel    = 1000.      ! ưǾ
    real(DBKIND), parameter :: VelMaxForTemp   = 1000.      ! ǮǾ
    real(DBKIND), parameter :: VelMaxForQvap   = 1000.      ! Ǿ

    real(DBKIND) :: &
         & xy_SurfBulkRiNum(im,jm)         , & ! Х륯ң
         & xy_SurfTempTransCoeff(im,jm)    , & ! ͢
         & xy_SurfQvapTransCoeff(im,jm)    , & ! ͢漾
         & xy_SurfVelTransCoeff(im,jm)     , & ! ͢ư
         & xy_SurfTempBulkCoeff(im,jm)     , & ! Х륯
         & xy_SurfQvapBulkCoeff(im,jm)     , & ! Х륯漾
         & xy_SurfVelBulkCoeff(im,jm)      , & ! Х륯ư
         & xy_SurfExner(im,jm)             , & ! Exnerؿ
         & xy_SurfVelAbs(im,jm)            , & ! ®
         & xy_SurfSatQvap(im,jm)           , & ! ɽ˰漾
         & xy_SurfDSatQvapDTemp(im,jm)         ! ɽ˰漾Ѳ

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ɽ̥եå׻
    !----------------------------------------------------------------

    ! ---- 1. ׻ ----
    xy_SurfExner = ( xyz_Press(:,:,1) / xyr_Press(:,:,1)  ) ** (RAir/Cp)

    ! ---- 2. Х륯ң ----

    do i = 1, im
       do j = 1, jm
          xy_SurfVelAbs(i,j)    = SQRT ( xyz_VelLon(i,j,1)**2 + xyz_VelLat(i,j,1)**2  )
          xy_SurfBulkRiNum(i,j) = Grav / BasePotTemp &
               &        * ( xyz_Temp(i,j,1) / xy_SurfExner(i,j) - xy_SurfTemp(i,j)  ) &
               &        / MAX ( xy_SurfVelAbs(i,j) , VelMinForRi )**2 & 
               &        * xyz_GeoPot(i,j,1) 
       end do
    end do

    ! ---- 3. Х륯 ----    

    call physics_surface_coeff( &
       & xy_SurfVelBulkCoeff , & ! (out) 
       & xy_SurfTempBulkCoeff, & ! (out) 
       & xy_SurfQvapBulkCoeff, & ! (out) 
       & xy_SurfBulkRiNum    , & ! (in) 
       & xy_SurfVelAbs       , & ! (in) 
       & xy_SurfRoughLength  , & ! (in) 
       & xy_SurfRoughLength  , & ! (in) 
       & xyz_GeoPot(:,:,1)     ) ! (in) 

   ! ----  5. ͢ ----
    
    do i = 1, im
       do j = 1, jm

          xy_SurfVelTransCoeff(i,j) = xy_SurfVelBulkCoeff(i,j) &
               &    * xyr_Press(i,j,1) / (RAir * xyr_Temp(i,j,1) ) &
               &    * MIN ( MAX (xy_SurfVelAbs(i,j) , VelMinForVel ) , VelMaxForVel )
          
          xy_SurfTempTransCoeff(i,j) = xy_SurfTempBulkCoeff(i,j) &
               &    * xyr_Press(i,j,1) / (RAir * xyr_Temp(i,j,1) ) &
               &    * MIN ( MAX (xy_SurfVelAbs(i,j) , VelMinForTemp ) , VelMaxForTemp )
          
          xy_SurfQvapTransCoeff(i,j) = xy_SurfQvapBulkCoeff(i,j) &
               &    * xyr_Press(i,j,1) / (RAir * xyr_Temp(i,j,1) ) &
               &    * MIN ( MAX (xy_SurfVelAbs(i,j) , VelMinForQvap ) , VelMaxForQvap )

       end do
    end do

   ! ----  5. ˰漾----

    xy_SurfSatQvap = EpsV * ES0  &
         & *  EXP( EL / RVap * (1./273. - 1./xy_SurfTemp ) ) &
         & / xyr_Press(:,:,1)
    xy_SurfDSatQvapDTemp = EL * xy_SurfSatQvap &
         & / ( RVap * xy_SurfTemp * xy_SurfTemp )

   ! ----  6. եå----

    xyr_VelLonFlux(:,:,1) = xyr_VelLonFlux(:,:,1) &
         &                 - xy_SurfVelTransCoeff * xyz_VelLon(:,:,1) 
    xyr_VelLatFlux(:,:,1) = xyr_VelLatFlux(:,:,1) &
         &                 - xy_SurfVelTransCoeff * xyz_VelLat(:,:,1) 
    xyr_TempFlux(:,:,1) = xyr_TempFlux(:,:,1) &
         &               + Cp * xy_SurfTempTransCoeff &
         &                * (   xy_SurfTemp           &
         &                    - xyz_Temp(:,:,1) / xy_SurfExner  )
    xyr_QvapFlux(:,:,1) = xyr_QvapFlux(:,:,1) &
         &                 + EL * xy_SurfQvapTransCoeff * xy_SurfHumidCoeff &
         &                   * ( xy_SurfSatQvap - xyz_Qvap(:,:,1) )

   ! ----  5. ѹ ----


    xyoo_SurfTempMatrix = 0.0d0
    xyoo_SurfQvapMatrix = 0.0d0


    xy_SurfVelMatrix = xy_SurfVelTransCoeff

    xyoo_SurfTempMatrix(:,:,1,0) =   Cp * xy_SurfTempTransCoeff / xy_SurfExner
    xyoo_SurfTempMatrix(:,:,0,1) = - Cp * xy_SurfTempTransCoeff / xy_SurfExner

    xyoo_SurfQvapMatrix(:,:,1,0) =   Cp * xy_SurfQvapTransCoeff * xy_SurfHumidCoeff
    xyoo_SurfQvapMatrix(:,:,0,1) = - Cp * xy_SurfQvapTransCoeff * xy_SurfHumidCoeff


    do i = 1, im
       do j = 1, jm
          if ( xy_SurfCondition(i,j) .GE. 1 ) then 

             xyoo_SurfTempMatrix(i,j,1,-1) = - Cp * xy_SurfTempTransCoeff(i,j)
             xyoo_SurfTempMatrix(i,j,0,0)  =   Cp * xy_SurfTempTransCoeff(i,j)

             xyoo_SurfQvapMatrix(i,j,1,-1) = - EL * xy_SurfQvapTransCoeff(i,j) &
                  &        * xy_SurfHumidCoeff(i,j) * xy_SurfDSatQvapDTemp(i,j)
             xyoo_SurfQvapMatrix(i,j,0,0)  =   EL * xy_SurfQvapTransCoeff(i,j) &
                  &        * xy_SurfHumidCoeff(i,j) * xy_SurfDSatQvapDTemp(i,j)

          end if
       end do
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_surface_main


end module physics_surface_main_mod
















