!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_radiation_short.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_radiation_short_mod

  implicit none

  private
  public :: physics_radiation_short

contains

    subroutine physics_radiation_short( &
         & xyr_RadSFlux         , & ! (inout) Ĺȥեå
         & xyr_TauQvap          , & ! (in) Ū
         & xyr_TauDryAir        , & ! (in) Ū
         & xy_InAngle           , & ! (in) sec(ͳ)
         & xy_SurfAlbedo          ) ! (in) ɽ٥

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: PI  
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Output
    !
    real(DBKIND), intent(inout) :: &
         & xyr_RadSFlux(im,jm,km+1) ! (inout) ûȥեå

    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & xyr_TauQvap(im,jm,km+1)   , & ! (in) Ū
         & xyr_TauDryAir(im,jm,km+1) , & ! (in) Ū
         & xy_InAngle(im,jm)         , & ! (in) sec(ͳ)
         & xy_SurfAlbedo(im,jm)          ! (in) ɽ٥

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_radiation_short"

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j, k
    integer(INTKIND)    :: bn
    real(DBKIND)        :: BandWeightSum

    integer(INTKIND), parameter :: BandNumber = 1     ! ĹȥХɿ
    real(DBKIND) :: &
         & AbsorpCoeffQvap(BandNumber)    , &         ! εۼ
         & AbsorpCoeffDryAir(BandNumber)  , &         ! εۼ
         & BandWeight(BandNumber)         , &         ! Хɥ
         & SECSCT                                     !  sec
    Data AbsorpCoeffQvap / 0.002  /
    Data AbsorpCoeffDryAir / 0.0  /
    Data BandWeight  / 1.0   /
    Data SECSCT / 1.66 /
    
    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ͷ׻
    !----------------------------------------------------------------

    ! ---- 1. ХɥȤ ----

    BandWeightSum = 0.0d0

    do bn = 1, BandNumber
       BandWeightSum =  BandWeightSum +  BandWeight(bn)
    end do

    do bn = 1, BandNumber
       BandWeight(bn) = BandWeight(bn) / BandWeightSum
    end do


    ! ----------------------------------------------------------
    xyr_RadSFlux(:,:,1:km) = 0.0d0

    do bn = 1, BandNumber
       do k = 1, km+1    
          ! ----  2. ƥ٥ǤβƩ ----
          
          if (k .NE. km+1) then 
             
             xyr_RadSFlux(:,:,k) = xyr_RadSFlux(:,:,k) & 
                  & +  BandWeight(bn) * xyr_RadSFlux(:,:,km+1) &
                  &  * EXP( - xy_InAngle(:,:) &
                  &      * ( AbsorpCoeffQvap(bn) * xyr_TauQvap(:,:,k) &
                  &      + AbsorpCoeffDryAir(bn) * xyr_TauDryAir(:,:,k) ) &
                  &       )
          end if
          
          ! ----  3. ƥ٥ǤξƩ ----
          xyr_RadSFlux(:,:,k) = xyr_RadSFlux(:,:,k) & 
               & -  BandWeight(bn) * xyr_RadSFlux(:,:,km+1) &
               &  * EXP( - xy_InAngle(:,:) &
               &      * ( AbsorpCoeffQvap(bn) * xyr_TauQvap(:,:,1) &
               &      + AbsorpCoeffDryAir(bn) * xyr_TauDryAir(:,:,1) ) &
               &       ) &
               &  * xy_SurfAlbedo(:,:) &                        
               &  * EXP( - SECSCT &
               &      * ( AbsorpCoeffQvap(bn) * ( xyr_TauQvap(:,:,1) &
               &                                - xyr_TauQvap(:,:,k) ) &
               &      + AbsorpCoeffDryAir(bn) * ( xyr_TauDryAir(:,:,1) &
               &                               - xyr_TauDryAir(:,:,k) ) &
               &       ) ) 
       end do
    end do
    ! ----------------------------------------------------------

    ! ----  4. ۼʤΤȤ ----

    if ( BandNumber .EQ. 0 ) then 

       do k = 1, km+1
          xyr_RadSFlux(:,:,k) = (1.0d0 - xy_SurfAlbedo(:,:) ) &
               &               * xyr_RadSFlux(:,:,km+1) 
       end do

    end if


    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_radiation_short


end module physics_radiation_short_mod
















