!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_radiation_long.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_radiation_long_mod

  implicit none

  private
  public :: physics_radiation_long

contains

  subroutine physics_radiation_long( &
    & xyr_RadLFlux          , & ! (out) Ĺȥեå
    & xyro_DelRadLFlux      , & ! (out) ĹɽѲ
    & xyz_Temp              , & ! (in)  ()
    & xy_SurfTemp          , & ! (in) ɽ̲
    & xyr_TauQvap           , & ! (in) Ū
    & xyr_TauDryAir           ) ! (in) Ū
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only:   StB     ! Stefan-Boltzman
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    implicit none
    real(DBKIND), intent(out) :: xyr_RadLFlux(im,jm,km+1) ! Ĺȥեå
    real(DBKIND), intent(out) :: xyro_DelRadLFlux(im,jm,km+1,0:1)  
                                             ! ĹɽѲ
    real(DBKIND), intent(in) :: xyz_Temp(im,jm,km) !  ()
    real(DBKIND), intent(in) :: xy_SurfTemp(im,jm) ! ɽ̲
    real(DBKIND), intent(in) :: xyr_TauQvap(im,jm,km+1) !  Ū
    real(DBKIND), intent(in) :: xyr_TauDryAir(im,jm,km+1) ! Ū

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_radiation_long"
    integer(INTKIND)    :: i, j, k
            ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    real(DBKIND) :: &
         & xyr_Trans(im,jm,km+1)     , & ! Ʃ᷸
         & xyr_Trans1(im,jm,km+1)    , & !  1/2 ٥뤫Ʃ᷸
         & xyr_Trans2(im,jm,km+1)    , & ! 3/2 ٥뤫Ʃ᷸
         & xyz_PiB(im,jm,km  )       , &  ! У¡ң**4
         & xy_SurfPiB(im,jm)              ! ɽΦУ

    integer(INTKIND)    :: kk , bn
    real(DBKIND)        :: BandWeightSum

    integer(INTKIND), parameter :: BandNumber = 4    ! ĹȥХɿ
    real(DBKIND) :: &
         & AbsorpCoeffQvap(BandNumber)    , &         ! εۼ
         & AbsorpCoeffDryAir(BandNumber)  , &         ! εۼ
         & BandWeight(BandNumber)         , &         ! Хɥ
         & PathLengthFact                             ! ϩĹΥե
    data AbsorpCoeffQvap / 8.0  , 1.0  , 0.1  , 0.0  /
    data AbsorpCoeffDryAir  / 0.0  , 0.0  , 0.0  , 5.E-5 /
    data BandWeight / 0.2  , 0.1  , 0.1  , 0.6 /
    PathLengthFact = 1.5 

    continue


    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ͷ׻
    !----------------------------------------------------------------

    ! ---- 1. ХɥȤ ----

    BandWeightSum = 0.0d0

    do bn = 1, BandNumber
       BandWeightSum =  BandWeightSum +  BandWeight(bn)
    end do

    do bn = 1, BandNumber
       BandWeight(bn) = BandWeight(bn) / BandWeightSum
    end do

    ! ---- 2. У¤η׻ ----
    xyz_PiB(:,:,:) = StB * ( xyz_Temp(:,:,:)**4 )
    xy_SurfPiB(:,:)  = StB * ( xy_SurfTemp(:,:)**4 )


    ! --------------------------------------------------
    do k = 1, km+1

       ! ---- 3. Ʃؿ׻ ----

       xyr_Trans = 0.0d0
       
       do bn = 1, BandNumber
          do kk = 1, km+1
             xyr_Trans(:,:,kk) = &
                  & xyr_Trans(:,:,kk) &
                  & + BandWeight(bn) &
                  & * EXP( - PathLengthFact &
                  &        * ( AbsorpCoeffQvap(bn) &
                  &            * ABS( xyr_TauQvap(:,:,kk) &
                  &                 - xyr_TauQvap(:,:,k)  ) &
                  &          + AbsorpCoeffDryAir(bn) &
                  &            * ABS( xyr_TauDryAir(:,:,kk) &
                  &                 - xyr_TauDryAir(:,:,k)  ) ) )
          end do
       end do
       

       ! ---- 4. ͥեå׻ ----
       xyr_RadLFlux(:,:,k) = xy_SurfPiB(:,:) * xyr_Trans(:,:,1) 
 
       do kk = 1, km
          xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k) &
               & - xyz_PiB(:,:,kk) &
               &   * ( xyr_Trans(:,:,kk) - xyr_Trans(:,:,kk+1) ) 
       end do

    ! ---- 5.  ׻Ʃؿ  ----
       xyr_Trans1(:,:,k) = xyr_Trans(:,:,1)
       xyr_Trans2(:,:,k) = xyr_Trans(:,:,2)

    end do
    ! --------------------------------------------------

    ! ---- 6. ɽ ----
    do k = 1, km+1
       xyro_DelRadLFlux(:,:,k,0) = 4.0d0 * xy_SurfPiB(:,:) &
            & / xy_SurfTemp(:,:) * xyr_Trans1(:,:,k)
       
       xyro_DelRadLFlux(:,:,k,1) = 4.0d0 * xyz_PiB(:,:,1) &
            & / xyz_Temp(:,:,1) * ( xyr_Trans2(:,:,k) - xyr_Trans1(:,:,k) )
    end do


    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_radiation_long


end module physics_radiation_long_mod
















