!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_radiation_incoming.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_radiation_incoming_mod

  implicit none

  private
  public :: physics_radiation_incoming

contains

  subroutine physics_radiation_incoming( &
         & xy_IncomRadSFlux        , & ! (out) Ĺȥեå
         & xy_InAngle              , &! (out) sec(ͳ)
         & y_Lat                    )

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: PI  
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Output
    !
    real(DBKIND), intent(out) :: &
         & xy_IncomRadSFlux(im,jm) , & ! (out) Ĺȥեå
         & xy_InAngle(im,jm)           ! (out) sec(ͳ)

    !==== Input
    !
    real(DBKIND), intent(in) :: y_Lat(jm)

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_radiation_incoming"

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j

    real(DBKIND), parameter :: SolarCoeff = 1380.0d0 !" 
    real(DBKIND), parameter :: AtmosAlbedo = 0.2     !" 絤٥
    real(DBKIND), parameter :: EPSORB = 23.5          !" ƻг
    real(DBKIND), parameter :: EQNORB = 110.         !" 
    real(DBKIND), parameter :: AINS   = 0.127        !" ǯʿͤη
    real(DBKIND), parameter :: BINS   = 0.183        !" ǯʿͤη
    real(DBKIND), parameter :: AZET   = 0.410        !" ǯʿͳѤη
    real(DBKIND), parameter :: BZET   = 0.590        !" ǯʿͳѤη
    
    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ͷ׻
    !----------------------------------------------------------------

    ! ---- ǯʿ ----
    do i = 1, im
       do j = 1, jm
          xy_IncomRadSFlux(i,j) = - SolarCoeff * (1. - AtmosAlbedo ) &
               &  * ( AINS + BINS * Cos( y_Lat( J )*PI/180. )**2 )
          
          if ( xy_IncomRadSFlux(i,j) .LT. 0. ) then
             xy_InAngle(i,j) = &
                  & 1. / ( AZET + BZET * Cos( y_Lat( J )*PI/180. )**2 )
          else
             xy_IncomRadSFlux(i,j) = 0.0d0
             xy_InAngle(i,j) = 0.0d0
          ENDIF
       end do
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_radiation_incoming


end module physics_radiation_incoming_mod
















