!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_qvapsat_tetens.f90 
!
! History
!   2006/10/31 ISHIWATARI Masaki

module physics_qvapsat_tetens

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: QvapSat

contains

  real(DBKIND) function QvapSat(Temp, Press) result(result)
    !
    !== ˰¾η׻
    ! Tetens μѤ˰¾׻.
    !
    !==TODO
    ! * Ȥ, ǤѿǤ褦ˤƤ.
    !   interface ȤȤɤ???
    !
    use type_mod,  only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,  only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use constants_mod, only: &
         &                   EL    ,& ! ζŷǮ 
         &                   EpsV  ,& ! 絤ʬ
         &                   ES0   ,& ! ˰¾У
         &                   RVap     ! 


    implicit none

    real(DBKIND),intent(in) :: Temp
    real(DBKIND),intent(in) :: Press
    character(STRING), parameter:: subname = "QvapSat"
  continue

    ! Ͻ
    call BeginSub( subname )

    result = EpsV * ES0  &
         & *  EXP( EL / RVap * ( 1.0d0/273.0d0 - 1.0d0/Temp ) ) / Press

    ! λ
    call EndSub( subname )

  end function QvapSat
end module physics_qvapsat_tetens
