!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_qvapsat_tetens.f90 
!
! History
!   2006/10/31 ISHIWATARI Masaki

module physics_qvapsat_nha92

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: QvapSat, DQvapSatDTemp

contains

  real(DBKIND) function QvapSat(Temp, Press) result(result)
    !
    !== ˰¾η׻
    ! Nakajima et al. (1992) μѤ˰¾׻.
    !
    !==TODO
    ! * Ȥ, ǤѿǤ褦ˤƤ.
    !   interface ȤȤɤ???
    !
    use type_mod,  only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,  only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use constants_mod, only: &
         &                   EL    ,& ! ζŷǮ 
         &                   EpsV  ,& ! 絤ʬ
         &                   RVap     ! 


    implicit none

    real(DBKIND),intent(in) :: Temp
    real(DBKIND),intent(in) :: Press
    character(STRING), parameter:: subname = "QvapSat"
  continue

    ! Ͻ
    call BeginSub( subname )

    result = Epsv  &
            & * 1.4d+11* EXP( - 5250.87d0/Temp ) &
            & / Press

    ! λ
    call EndSub( subname )

  end function QvapSat

  real(DBKIND) function DQvapSatDTemp(Temp, Press) result(result)
    !
    !== ˰¾ʬη׻
    ! * Nakajima et al. (1992) μѤƻ.
    ! * AGCM5 Ǥ, Ȥ,  ٤˰漾ͿƤ, ٤ȰϤѹ.
    !==TODO
    ! * Ȥ, ǤѿǤ褦ˤƤ.
    !   interface ȤȤɤ???
    !
    use type_mod,  only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,  only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use constants_mod, only: &
         &                   EL    ,& ! ζŷǮ 
         &                   EpsV  ,& ! 絤ʬ
         &                   RVap     ! 


    implicit none

    real(DBKIND),intent(in) :: Temp
    real(DBKIND),intent(in) :: Press
    character(STRING), parameter:: subname = "QvapSat"
  continue

    ! Ͻ
    call BeginSub( subname )

    result = 5250.87d0/(Temp * Temp) &
      & * Epsv  &
      & * 1.4d+11* EXP( - 5250.87d0/Temp ) &
      & / Press

    ! λ
    call EndSub( subname )

  end function DQvapSatDTemp

end module physics_qvapsat_nha92
