!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_negq.f90 
!
! History
!   2005/09/18 Yamada Yukiko     create
!

module physics_negq_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_negq

contains

  subroutine physics_negq(xyz_Qvap, xyz_DNegQvapDt, xyr_Press, DelTimePhy)

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use spml_mod,    only: AvrLonLat_xy
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Input
    !
    real(DBKIND), intent(in) ::   &
         & xyr_Press(im,jm,km+1) ,& ! intent(in):  (Ⱦ)
         & DelTimePhy               ! intent(in): 2t

    !==== In/Out
    !
    real(DBKIND), intent(inout) :: &
         & xyz_Qvap(im,jm,km)     ,& ! intent(inout): 漾
         & xyz_DNegQvapDt(im,jm,km)     ! intent(inout): 漾ѲΨ

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_negq"
    real(DBKIND)        ::  &
         & xyz_Qvap_b(im,jm,km)              ,&  ! Ĵ漾
         & xyz_DPressDz(im,jm,km)            ,&  ! p
         & xyz_Qvap_DPressDz(im,jm,km)       ,&  ! qp
         & xyz_DelQvap_DPressDz(im,jm,km)    ,&  ! qp
         & Qvap_DPressDz_AvrXYZ              ,&  ! \int<qp>dz 
         & DelQvap_DPressDz_AvrXYZ               ! \int<qp>dz

    real(DBKIND)        :: Work
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i,j, k


    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ο
    !----------------------------------------------------------------

    !----- Ĵ Qvap ¸, Press η׻ -----
    do k = 1, km
       do i = 1, im
          do j = 1, jm
             xyz_Qvap_b(i,j,k)   = xyz_Qvap(i,j,k)
             xyz_DPressDz(i,j,k) = xyr_Press(i,j,k) - xyr_Press(i,j,k+1)
          end do
       end do
    end do

    !----- ɽ ----- (ǲؤͤɤ?)
    do k = km, 2, -1
       do i = 1, im
          do j = 1, jm
             if ( xyz_Qvap(i,j,k) < 0 ) then 
                Work = - xyz_Qvap(i,j,k) &
                     &    * xyz_DPressDz(i,j,k) / xyz_DPressDz(i,j,k-1) 
                xyz_Qvap(i,j,k) = 0.0d0
                xyz_Qvap(i,j,k-1) = xyz_Qvap(i,j,k-1) - Work
             end if
          end do
       end do
    end do

    !-----  ----- 
    ! ؤˤ̤λ
    do k = 1, km
       do i = 1, im
          do j = 1, jm
             xyz_Qvap_DPressDz(i,j,k) = xyz_Qvap(i,j,k) * xyz_DPressDz(i,j,k) 
             if ( xyz_Qvap_DPressDz(i,j,k) < 0 ) then 
                xyz_DelQvap_DPressDz(i,j,k) = - xyz_Qvap_DPressDz(i,j,k)
             else
                xyz_DelQvap_DPressDz(i,j,k) = 0.0d0
             end if
          end do
       end do
    end do

    ! ̤̱ľʿ
    Qvap_DPressDz_AvrXYZ = 0.0d0
    DelQvap_DPressDz_AvrXYZ = 0.0d0
    do k = 1, km
       Qvap_DPressDz_AvrXYZ    = Qvap_DPressDz_AvrXYZ  &
            &              + AvrLonLat_xy( xyz_Qvap_DPressDz(:,:,k) )
       DelQvap_DPressDz_AvrXYZ = DelQvap_DPressDz_AvrXYZ  &
            &              + AvrLonLat_xy( xyz_DelQvap_DPressDz(:,:,k) )
    end do


    ! Τ, ͤ򥼥ˤ
    if ( Qvap_DPressDz_AvrXYZ .ne. 0.0d0 ) then 
       do k = 1, km
          do i = 1, im
             do j = 1, jm
                xyz_Qvap(i,j,k) = Qvap_DPressDz_AvrXYZ                       &
                     &   / (Qvap_DPressDz_AvrXYZ + DelQvap_DPressDz_AvrXYZ)  &
                     &   * Max( xyz_Qvap(i,j,k) , 0.0d0 )             
             end do
          end do
       end do
    end if

    !----- 漾Ѳλ ----- 
    do k = 1, km
       do i = 1, im
          do j = 1, jm
             xyz_DNegQvapDt(i,j,k) = xyz_DNegQvapDt(i,j,k)   &
                  & + ( xyz_Qvap(i,j,k) - xyz_Qvap_b(i,j,k) ) / DelTimePhy
          end do
       end do
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_negq

end module physics_negq_mod




