!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_lscond.f90 
! Ƿ絬϶ŷ
!
! History
!   2005/09/19 Yamada Yukiko     create
!

module physics_lscond_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_lscond

contains

  subroutine physics_lscond( xyz_Temp, xyz_Qvap, xy_LscRain, &
       &               xyz_DLscTempDt, xyz_DLscQvapDt,    &
       &               xyz_Press, xyr_Press, DelTimePhy    )

    !==== Dependency
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use constants_mod, only: Cp    ,& ! 絤갵Ǯ 
         &                   EL    ,& ! ζŷǮ 
         &                   EpsV  ,& ! 絤ʬ
         &                   ES0   ,& ! ˰¾У
         &                   RVap  ,& ! 
         &                   Grav     ! ϲ®
    use dc_trace,      only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Input
    !
    real(DBKIND), intent(in) ::   &
         & xyz_Press(im,jm,km)   ,& ! (in)  ()
         & xyr_Press(im,jm,km+1) ,& ! (in)  (Ⱦ)
         & DelTimePhy               ! (in) 2t

    !==== Output
    !
    real(DBKIND), intent(out) ::  &
         & xy_LscRain(im,jm)       ,& ! (out) ߿
         & xyz_DLscTempDt(im,jm,km),& ! (out) ѲΨ
         & xyz_DLscQvapDt(im,jm,km)   ! (out) 漾ѲΨ

    !==== In/Out
    !
    real(DBKIND), intent(inout) ::  &
         & xyz_Temp(im,jm,km)      ,& ! (inout) 
         & xyz_Qvap(im,jm,km)         ! (inout) 漾

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_lscond"
    real(DBKIND)        ::  & 
         & xyz_Qvap_b(im,jm,km)              ,&  ! Ĵ漾
         & xyz_Temp_b(im,jm,km)              ,&  ! Ĵβ
         & QvapSat                           ,&  ! ˰漾  ˰º
         & DQvapSatDTemp                     ,&  ! D(˰漾)/D()
         & DelTemp, DelQvap 

    real(DBKIND), parameter     :: CrtlRH = 1.0d0   ! ׳м
    integer(INTKIND), parameter :: IterationMax = 3 ! ƥ졼

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j, k
    integer(INTKIND)    :: Iteration 

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   絬϶ŷ
    !----------------------------------------------------------------

    !----- Ĵ Qvap ¸ -----    
    xyz_Qvap_b  = xyz_Qvap
    xyz_Temp_b  = xyz_Temp

    !----- ѿ -----    
    xy_LscRain     = 0.0d0
    xyz_DLscTempDt = 0.0d0
    xyz_DLscQvapDt = 0.0d0
    
    !----- Ĵ ------    
    do k = km, 1, -1
       do i = 1, im
          do j = 1, jm
             
             ! 饦ڥμ˰漾׻
             QvapSat = EpsV * ES0  &
                  & *  EXP( EL / RVap * ( 1./273. - 1./xyz_Temp(i,j,k) ) ) &
                  & / xyz_Press(i,j,k)

             ! ˰¤Ƥ, ٤漾Ѳμ«׻
             if ( ( xyz_Qvap(i,j,k) / QvapSat ) .GE. CrtlRH ) then

                do Iteration = 1, IterationMax

                   ! ˰漾׻
                   QvapSat = EpsV * ES0  &
                        & *  EXP( EL / RVap * (1./273. - 1./xyz_Temp(i,j,k))) &
                        & / xyz_Press(i,j,k)
                   DQvapSatDTemp = EL * QvapSat &
                        & / ( RVap * xyz_Temp(i,j,k) * xyz_Temp(i,j,k) )
                   
                   ! ٤漾Ѳʬ Newton ˡǵ
                   DelTemp = EL / Cp * ( xyz_Qvap(i,j,k) - QvapSat ) &
                        &   / ( 1. + EL / Cp * DQvapSatDTemp )
                   DelQvap  = DQvapSatDTemp * DelTemp 

                   ! Ĵ
                   xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
                   xyz_Qvap(i,j,k) = QvapSat + DelQvap

                end do

            end if
          end do
       end do
    end do

    !----- 漾ѲΨ, ѲΨ, ߿̤λ ----- 
    do k = km, 1, -1
       do i = 1, im
          do j = 1, jm

             ! 漾ѲΨ
             xyz_DLscQvapDt(i,j,k) = xyz_DLscQvapDt(i,j,k) & 
                  &  + ( xyz_Qvap(i,j,k) - xyz_Qvap_b(i,j,k) ) / DelTimePhy

             ! ѲΨ
             xyz_DLscTempDt(i,j,k) = xyz_DLscTempDt(i,j,k) &
                  & + ( xyz_Temp(i,j,k) - xyz_Temp_b(i,j,k) ) / DelTimePhy

             ! ߿
             xy_LscRain(i,j) = xy_LscRain(i,j)  &
                  & + ( xyz_Temp(i,j,k) - xyz_Temp_b(i,j,k) ) &
                  & * CP / DelTimePhy                         &
                  & * ( xyr_Press(i,j,k) - xyr_Press(i,j,k+1) ) /Grav
 
          end do
       end do
    end do
    
    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_lscond

end module physics_lscond_mod




