!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_ground.f90 
! SST, ڤɽ̤̽ɤ߹
!
! History
!   2005/09/20 Yamada Yukiko     create
!
! TODO
! * Ƽѥ᡼ϥե뤫ɤ߹褦ˤǤ褦ˤ٤
! * 1 ꤹɤ襹ƥåꤷʤȤʤν?

module physics_ground_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
  implicit none
  private
  public :: physics_ground

contains

  subroutine physics_ground( &
    & xy_SurfTemp   ,& ! (out) ɽ
    & xy_SurfAlbedo, &        !(out) ɽ٥
    & xy_SurfHumidCoeff, &    !(out) ɽ
    & xy_SurfRoughLength, &   !(out) ɽĹ
    & xy_SurfCondition, &     !(out) ɽ. 
    & xy_SurfHeatCapacity, &  !(out) ɽǮ
    & xy_GroundTempFlux, &    !(out) Ǯեå
    &  y_Lat         ) ! (in) ٺɸ
    !
    != ɽ̥ѥ᡼
    ! 
    != TODO (2006-8-16 )
    ! * ¾ˤǤѥ᡼䤹٤.
    !   㤨, AGCM5 Ǥ
    !       REAL       GRZSD  ( IDIM*JDIM )    !" ɽʬ = 0.0
    !   ȤΤǤ褦ˤʤäƤ.
    ! * ˡȤƲѰդ٤ʤȤʤ.
    !   ͤˡϰʲ̤.
    !   * namelist ɤ߹ǥե(single value).
    !   * nc ե뤫ʬۤɤ߹
    !   * ǥʬۤ׻
    !     㤨, SST ξ SurfCond ˤ¸, 
    !     ٥ɤ SST ˰¸etc
    ! * ѥ᡼ꥵ֥롼Ѱդ٤⤷ʤ.
    !
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use nmlfile_mod, only : nmlfile_init, nmlfile_open, nmlfile_close
    use dc_trace,      only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use dc_message , only : MessageNotify
 
    implicit none
    real(DBKIND), intent(in) :: y_Lat(:)               ! ٺɸ
    real(DBKIND), intent(out) :: xy_SurfTemp(im,jm)       ! ɽ̲
    real(DBKIND), intent(out) :: xy_SurfAlbedo(im,jm)        ! ɽ٥
    real(DBKIND), intent(out) :: xy_SurfHumidCoeff(im,jm)    ! ɽ
    real(DBKIND), intent(out) :: xy_SurfRoughLength(im,jm)   ! ɽĹ
    real(DBKIND), intent(out) :: xy_SurfHeatCapacity(im,jm)  ! ɽǮ
    real(DBKIND), intent(out) :: xy_GroundTempFlux(im,jm) ! Ǯեå
    integer(INTKIND), intent(out) :: xy_SurfCondition(im,jm)    ! ɽ
                                       ! 1 ̤ SST . 1 ʾ swamp

    character(STRING),  parameter:: subname = "physics_ground"
    integer(INTKIND) :: DefaultSurfCondition ! ɽ֥ǥե
    real(DBKIND) :: xy_SeaSurfaceTemp(im,jm)            ! ɽ̲
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable

    ! Hosaka et al. (1998) SST ѥѥ᡼
    !   (2006-8-16 )  ޤǻ
    real(DBKIND), parameter :: TEQ   = 302.0d0
    real(DBKIND), parameter :: ALAT0 =   0.0d0
    real(DBKIND), parameter :: ALAT1 =  30.0d0
    real(DBKIND), parameter :: ALPHA =  60.0d0
    real(DBKIND), parameter :: BETA  =  32.0d0
    real(DBKIND), parameter :: GAMMA =   0.0d0
    real(DBKIND), parameter :: ALACON = 7.0d0

    namelist /ground_nml/ &
      & DefaultSurfCondition ! ɽ֥ǥե

    continue

    !   Ͻ
    call BeginSub(subname)

    ! ɽ֤
    DefaultSurfCondition = 0 
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=ground_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST ground_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=ground_nml)
    else
       call DbgMessage('Not Read NAMELIST ground_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST ground_nml. Force Use Default Value.')
    end if
    call nmlfile_close
    ! ե뤫ϤǤ褦ˤ٤.
    xy_SurfCondition = DefaultSurfCondition


    ! ¾ɽ̥ѥ᡼.
    ! ɽ֤Ʊͤ˽٤.
    xy_SurfAlbedo = 0.15         ! ɽ٥
    xy_SurfHumidCoeff = 1.0      ! ɽ
    xy_SurfRoughLength = 0.0001  ! ɽĹ
    xy_SurfHeatCapacity = 0.0    ! ɽǮ
    xy_GroundTempFlux  = 0.0     ! Ǯեå

    !----------------------------------------------------------------
    !   ɽ̲٤
    !----------------------------------------------------------------
    
    !----- ̲٤ -----
    ! Hosaka et al. (1998)  SST ʬۤͿƤޤ.
    ! ϻŪ. 
    ! 
    !   1. SST ե뤬ꤵƤФ
    !   2. ǤʤХǥեȤʬۤͿ
    ! Ȥ٤.
    
    call mksst( &
         & xy_SeaSurfaceTemp                           , &
         & y_Lat                                       , &
         & TEQ , ALAT0 , ALAT1 , ALPHA , BETA  , GAMMA , &
         & ALACON                                       )


    !----- ɽ̲٤̲٤֤-----
    !   (2006-8-16 )  xy_SurfCondition 򻲾Ȥ
    !      SST ꥰåɤ SST ͤͿ褦
    !      ʤȤʤ.
    xy_SurfTemp = xy_SeaSurfaceTemp


    !   λ
    call EndSub(subname)

  end subroutine physics_ground


  subroutine mksst( &
    & xy_SeaSurfaceTemp                           , &
    & y_Lat                                       , &
    & TEQ , ALAT0 , ALAT1 , ALPHA , BETA  , GAMMA , &
    & ALACON                                       )
    !
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use constants_mod, only: PI 
    use dc_trace,      only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    implicit none
    real(DBKIND), intent(in) ::   &
         &  y_Lat(:)             ,& ! (in) ٺɸ
         &  TEQ , ALAT0 , ALAT1 , ALPHA , BETA  , GAMMA , ALACON
    real(DBKIND), intent(out) ::  &
         & xy_SeaSurfaceTemp(im,jm)       ! (out) ɽ̲
    character(STRING),  parameter:: subname = "mksst"
    integer(INTKIND)    :: i, j
            ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    real(DBKIND) :: PHI1, AB4, PHI, GSSTP, ALATP, ALATM, GSSTMX
    integer(INTKIND)    :: JP, JMM

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ɽ̲٤
    !----------------------------------------------------------------

    PHI1 = ABS( ALAT1 * PI/180. )
    AB4  = 2. *( PHI1**3 )*BETA/ALPHA
    
    do j = 1, jm
       PHI   = ABS( y_Lat( J )*PI/180. - ALAT0 *PI/180. )
       GSSTP = TEQ                                                      &
            &         - ALPHA/2.                                        &
            &           * ( PHI - MAX(   SQRT(  PHI1**2+AB4 )      &
            &                     - SQRT( (PHI-PHI1)**2+AB4 ), 0.  )  ) &
            &         + GAMMA *( PHI**3 )
       do i = 1, im
          xy_SeaSurfaceTemp(i,j) = GSSTP
       end do
    end do
        
    ! ---- 濴 ALAT0 +/- ALACON δ֤ʿó -----
    ALATP = ( ALAT0 + ALACON )*PI/180.
    ALATM = ( ALAT0 - ALACON )*PI/180.

    JP = 1
    JMM = jm
    do  j = 1, jm
       IF ( (-y_Lat( J )*PI/180.) .GT. ALATP ) THEN
          JMM = J
       ENDIF
       IF ( (-y_Lat( J )*PI/180.) .GE. ALATM ) THEN
          JP = J
       ENDIF
    end do

    GSSTMX = ( xy_SeaSurfaceTemp(1,JP) * ( ALATP - y_Lat(JP+1)*PI/180.)     &
         &   +  xy_SeaSurfaceTemp(1,JP+1) * ( y_Lat(JP)*PI/180. - ALATP ))  &
         &        /( y_Lat(JP)*PI/180. - y_Lat(JP+1)*PI/180. ) 

    do j = JMM+1, JP 
       do i = 1, im 
          xy_SeaSurfaceTemp(i,j) = GSSTMX
       end do
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine mksst

end module physics_ground_mod




