!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_dryadjust.f90 
!
! History
!   2005/09/19 Yamada Yukiko     create
!

module physics_dryadjust_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_dryadjust

contains

  subroutine physics_dryadjust( & 
       & xyz_Temp          , & ! (inout) 
       & xyz_DDryTempDt    , & ! (out) ѲΨ
       & xyz_Press         , & ! (in)  ()
       & xyr_Press         , & ! (in)  (Ⱦ)
       & DelTimePhy         )  ! (in) 2t

    !==== Dependency
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use constants_mod, only: Cp    ,& ! 絤갵Ǯ 
         &                   RAir     ! 絤
    use dc_trace,      only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Input
    !
    real(DBKIND), intent(in) ::   &
         & xyz_Press(im,jm,km)   ,& ! (in)  ()
         & xyr_Press(im,jm,km+1) ,& ! (in)  (Ⱦ)
         & DelTimePhy               ! (in) 2t

    !==== Output
    !
    real(DBKIND), intent(out) ::  &
         & xyz_DDryTempDt(im,jm,km) ! (out) ѲΨ

    !==== In/Out
    !
    real(DBKIND), intent(inout) ::  &
         & xyz_Temp(im,jm,km)         ! (inout) 

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_dryadjust"
    real(DBKIND)        ::  & 
         & xyz_Temp_b(im,jm,km)              , & ! Ĵβ
         & xy_Adjust(im,jm)                  , & ! Ĵᤵ줿ݤ
         & xy_Adjust_b(im,jm)                , & ! Ĵᤵ줿ݤ
         & xyz_DPressDz(im,jm,km)            , & ! 
         & xyz_DDPressDDPress(im,jm,km)      , & ! /
         & xyz_DPFact(im,jm,km)              , & ! ե
         & TempSat                           , & ! ˰²
         & DelTemp                           , & ! Ĵ᤹벹
         & Adjust                ! ΰˤư٤ǤĴᤵ줿ݤ


    integer(INTKIND), parameter :: IterationMax = 10 ! ƥ졼
    
    real(DBKIND) ::  TempSatMax(IterationMax)   ! ԰εƸ
    data TempSatMax  / 0.01  , 0.02  , 0.02  , 0.05  , 0.05  , &
         &             0.10  , 0.10  , 0.20  , 0.20  , 0.40  /

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j, k
    integer(INTKIND)    :: Iteration 

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !  ήĴ
    !----------------------------------------------------------------

    !----- Ĵ Qvap ¸ -----    
    xyz_Temp_b  = xyz_Temp

    !----- ѿ -----    
    xyz_DDryTempDt = 0.0d0
    
    !----- ե׻ -----    
    do k = 1, km
       xyz_DPressDz(:,:,k) = xyr_Press(:,:,k) - xyr_Press(:,:,k+1)
    end do

    do k = 2, km
       xyz_DDPressDDPress(:,:,k) = xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
       xyz_DPFact(:,:,k) = RAir / Cp &
            & * ( xyz_Press(:,:,k-1) - xyz_Press(:,:,k) ) &
            & / ( xyz_DPressDz(:,:,k-1) + xyz_DPressDz(:,:,k) ) &
            & / xyr_Press(:,:,k)
    end do

    !----- Ĵ ------    
    xy_Adjust_b = 1.0d0

    !----- 3.1 ƥ졼 ------    
    do Iteration = 1, IterationMax
       xy_Adjust = 0.0d0

       do k = 2, km
          do i = 1, im
             do j = 1, jm 
                if ( xy_Adjust_b(i,j) .GT. 0.9 ) then
                   
                   TempSat = xyz_Temp(i,j,k-1) - xyz_Temp(i,j,k) &
                        & - xyz_DPFact(i,j,k) &
                        &  * ( xyz_DPressDz(i,j,k-1) * xyz_Temp(i,j,k-1) &
                        &     + xyz_DPressDz(i,j,k) * xyz_Temp(i,j,k) )
                   
                   ! ԰Ǥʤ
                   if ( TempSat .GT. TempSatMax(Iteration) ) then
                      
                      DelTemp = TempSat / ( 1. + xyz_DDPressDDPress(i,j,k) )
                      xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
                      xyz_Temp(i,j,k-1) = xyz_Temp(i,j,k-1) & 
                           & - DelTemp * xyz_DDPressDDPress(i,j,k)
                      
                      ! Ĵᤷݤ
                      xy_Adjust(i,j) = 1.
                   end if

                end if
             end do
          end do
       end do

       Adjust = 0. 
       do i = 1, im
          do j = 1, jm
             xy_Adjust_b(i,j) = xy_Adjust(i,j)
             Adjust           = Adjust +  xy_Adjust(i,j)
          end do
       end do
       
       if ( Adjust .LT. 1. ) exit
       
    end do

    !----- 漾ѲΨ, ѲΨ, ߿̤λ ----- 

    ! ѲΨ
    xyz_DDryTempDt = xyz_DDryTempDt &
         & + ( xyz_Temp - xyz_Temp_b ) / DelTimePhy
    
    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_dryadjust

end module physics_dryadjust_mod




