!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module dycore_time_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: dycore_time.f90,v 1.1.1.1 2005/11/08 14:10:24 morikawa Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!Time manage module directly called by GCM run program.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module dycore_time_mod
                                                                 !=begin
  !== Dependency
  use dycore_type_mod , only: STRING
  use time_mod        , only: StepInterval, OutputStep  , &
       &                      CurrentLoop , CurrentTime , &
       &                      DelTime
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: dycore_time_init, dycore_time_progress ! subroutines
  public :: dycore_time_filter                     ! subroutines
  public :: dycore_time_end                        ! subroutines
  public :: StepInterval, OutputStep               ! variables
  public :: CurrentLoop , CurrentTime              ! variables
  public :: DelTime                                ! variables
                                                                 !=end

  logical, save :: dycore_time_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: dycore_time.f90,v 1.1.1.1 2005/11/08 14:10:24 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module
  !
  !((< time_mod >)) νԤʤ
  !
  subroutine dycore_time_init
  !==== Dependency
    use time_mod,        only: time_init
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, &
         &                     STRING, DBKIND, INTKIND
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_time_init"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (dycore_time_initialized) then
       call EndSub( subname, '%c is already called.', c1=trim(subname) )
       return
    else
       dycore_time_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   time_init θƤӽФ
    !----------------------------------------------------------------
    call time_init

    call EndSub(subname)
  end subroutine dycore_time_init



                                                                 !=begin
  !=== Progress Time
  !
  !Vars_a γƼǡ Vars ˡ
  !Vars_n γƼǡ Vas_b ˰ܤ
  !Vars_a Υǡƥ˥ꥢ롣
  !
  !ޤ((< time_mod >))  ((< time_progress >)) Ƥֻˤä
  !((< time_mod >))  CurrentTime  CurrentLoop ʤ롣
  !
  subroutine dycore_time_progress( Vars_b, Vars_n, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS,  &
         &                     STRING, REKIND, DBKIND, INTKIND
    use time_mod       , only: time_progress
    use dc_trace       , only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(DYCORE_VARS), intent(inout):: Vars_b ! ʻǡ(t-t)
    type(DYCORE_VARS), intent(inout):: Vars_n ! ʻǡ(t)
    type(DYCORE_VARS), intent(inout):: Vars_a ! ʻǡ(t+t)
                                                                 !=end

    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_time_progress"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_time_initialized) then
       call EndSub( subname, 'Call dycore_time_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !    t-t   =   t
    !----------------------------------------------------------------
    Vars_b%xyz_VelLon = Vars_n%xyz_VelLon  ! ®ٷʬ
    Vars_b%xyz_VelLat = Vars_n%xyz_VelLat  ! ®ٰʬ
    Vars_b%xyz_Vor  = Vars_n%xyz_Vor   ! 
    Vars_b%xyz_Div  = Vars_n%xyz_Div   ! ȯ
    Vars_b%xyz_Temp = Vars_n%xyz_Temp  ! 
    Vars_b%xyz_QVap = Vars_n%xyz_QVap  ! 漾
    Vars_b%xy_Ps    = Vars_n%xy_Ps     ! ɽ̵

    !----------------------------------------------------------------
    !   t     = t+t
    !----------------------------------------------------------------
    Vars_n%xyz_VelLon = Vars_a%xyz_VelLon  ! ®ٷʬ
    Vars_n%xyz_VelLat = Vars_a%xyz_VelLat  ! ®ٰʬ
    Vars_n%xyz_Vor  = Vars_a%xyz_Vor   ! 
    Vars_n%xyz_Div  = Vars_a%xyz_Div   ! ȯ
    Vars_n%xyz_Temp = Vars_a%xyz_Temp  ! 
    Vars_n%xyz_QVap = Vars_a%xyz_QVap  ! 漾
    Vars_n%xy_Ps    = Vars_a%xy_Ps     ! ɽ̵


    !----------------------------------------------------------------
    !   Clear Vars_a
    !----------------------------------------------------------------
    Vars_a%xyz_VelLon = 0.0d0  ! ®ٷʬ
    Vars_a%xyz_VelLat = 0.0d0  ! ®ٰʬ
    Vars_a%xyz_Vor  = 0.0d0  ! 
    Vars_a%xyz_Div  = 0.0d0  ! ȯ
    Vars_a%xyz_Temp = 0.0d0  ! 
    Vars_a%xyz_QVap = 0.0d0  ! 漾
    Vars_a%xy_Ps    = 0.0d0  ! ɽ̵

    !----------------------------------------------------------------
    !   Progress Time
    !----------------------------------------------------------------
    call time_progress()

    call EndSub(subname)
  end subroutine dycore_time_progress



                                                                 !=begin
  !=== Time Filter
  !
  !Vars_b, Vars_n, Vars_a ѤVars_n ˻֥ե륿򤫤
  !
  !((< constants_mod >))  TimeFilter ֥ե륿ηȤ
  !Ѥ롣ξϼ¼Ū˥ե륿ʤ
  !
  !((< constants_mod >))  TimeFilterStepInt 顢ƥå
  !ե륿뤫椵롣
  !
  subroutine dycore_time_filter( Vars_b, Vars_n, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS,  &
         &                     STRING, REKIND, DBKIND, INTKIND
    use constants_mod  , only: TimeFilter, TimeFilterStepInt
    use dc_trace       , only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(DYCORE_VARS), intent(in)   :: Vars_b ! ʻǡ(t-t)
    type(DYCORE_VARS), intent(inout):: Vars_n ! ʻǡ(t)
    type(DYCORE_VARS), intent(in)   :: Vars_a ! ʻǡ(t+t)
                                                                 !=end

    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_time_filter"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_time_initialized) then
       call EndSub( subname, 'Call dycore_time_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( mod(CurrentLoop, TimeFilterStepInt) /= 0 ) then
       call EndSub( subname, &
            & 'This is not TimeFilter Step. ' // &
            & '[CurrentLoop=<%d>, TimeFilterStepInt=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, TimeFilterStepInt/) )
       return
    end if

    !----------------------------------------------------------------
    !    Time Filter
    !----------------------------------------------------------------
    ! ®ٷʬ
    Vars_n%xyz_VelLon = ( 1. - 2. * TimeFilter ) * Vars_n%xyz_VelLon  &
         & + TimeFilter * ( Vars_b%xyz_VelLon + Vars_a%xyz_VelLon )

    ! ®ٰʬ
    Vars_n%xyz_VelLat = ( 1. - 2. * TimeFilter ) * Vars_n%xyz_VelLat  &
         & + TimeFilter * ( Vars_b%xyz_VelLat + Vars_a%xyz_VelLat )

    ! 
    Vars_n%xyz_Vor = ( 1. - 2. * TimeFilter ) * Vars_n%xyz_Vor  &
         & + TimeFilter * ( Vars_b%xyz_Vor + Vars_a%xyz_Vor )

    ! ȯ
    Vars_n%xyz_Div = ( 1. - 2. * TimeFilter ) * Vars_n%xyz_Div  &
         & + TimeFilter * ( Vars_b%xyz_Div + Vars_a%xyz_Div )

    ! 
    Vars_n%xyz_Temp = ( 1. - 2. * TimeFilter ) * Vars_n%xyz_Temp  &
         & + TimeFilter * ( Vars_b%xyz_Temp + Vars_a%xyz_Temp )

    ! 漾
    Vars_n%xyz_QVap = ( 1. - 2. * TimeFilter ) * Vars_n%xyz_QVap  &
         & + TimeFilter * ( Vars_b%xyz_QVap + Vars_a%xyz_QVap )

    ! ɽ̵
    Vars_n%xy_Ps = ( 1. - 2. * TimeFilter ) * Vars_n%xy_Ps  &
         & + TimeFilter * ( Vars_b%xy_Ps + Vars_a%xy_Ps )

    call EndSub( subname, &
         & 'This is Just TimeFilter Step. ' // &
         & '[CurrentLoop=<%d>, TimeFilterStepInt=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, TimeFilterStepInt/) )
  end subroutine dycore_time_filter



                                                                 !=begin
  !=== Terminate module
  !
  !νꡢ⤷ʤ
  !
  subroutine dycore_time_end
  !==== Dependency
    use time_mod       , only: time_end
    use dycore_type_mod, only: STRING, REKIND, DBKIND, INTKIND
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_time_end"

  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. dycore_time_initialized) then
       call EndSub( subname, 'dycore_time_init was not called', &
            &       c1=trim(subname) )
       return
    else
       dycore_time_initialized = .false.
    endif

!!$    call time_end

    call EndSub(subname)
  end subroutine dycore_time_end

end module dycore_time_mod
