!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module dycore_grid_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: dycore_grid.f90,v 1.1.1.1 2005/11/08 14:10:24 morikawa Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!Provide Grid Information.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module dycore_grid_mod
                                                                 !=begin
  !== Dependency
  use dycore_type_mod    , only : STRING
  use grid_3d_mod        , only : im, jm, km
  use grid_wavenumber_mod, only : nm
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: dycore_grid_init, dycore_grid_end  ! subroutines
  public :: im, jm, km, nm                     ! variables
                                                                 !=end

  logical,          save :: dycore_grid_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: dycore_grid.f90,v 1.1.1.1 2005/11/08 14:10:24 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module
  !
  !((< grid_3d_mod >))  ((< grid_wavenumber_mod >)) νԤʤ
  !
  subroutine dycore_grid_init
  !==== Dependency
    use dycore_type_mod    , only: STRING
    use grid_3d_mod        , only: grid_3d_init
    use grid_wavenumber_mod, only: grid_wavenumber_init
    use dc_trace           , only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    character(STRING), parameter:: subname = "dycore_grid_init"

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (dycore_grid_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       dycore_grid_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    call grid_3d_init
    call grid_wavenumber_init

    call EndSub( subname, 'im=<%d>, jm=<%d>, km=<%d>, nm=<%d>', &
         &       i=(/im, jm, km, nm/) )
  end subroutine dycore_grid_init


                                                                 !=begin
  !=== Terminate module
  !
  !((< grid_3d_mod >))  ((< grid_wavenumber_mod >)) νλԤʤ
  !
  subroutine dycore_grid_end
  !==== Dependency
    use grid_3d_mod        , only: grid_3d_end
    use grid_wavenumber_mod, only: grid_wavenumber_end
    use dc_trace           , only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "dycore_grid_end"

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. dycore_grid_initialized) then
       call EndSub( subname, 'dycore_grid_init was not called', &
            &       c1=trim(subname) )
       return
    else
       dycore_grid_initialized = .false.
    endif

    call grid_3d_end
    call grid_wavenumber_end

    call EndSub( subname, 'im=<%d>, jm=<%d>, km=<%d>, nm=<%d>', &
         &       i=(/im, jm, km, nm/) )
  end subroutine dycore_grid_end

end module dycore_grid_mod
