!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module dycore_dynamics_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: dycore_dynamics.f90,v 1.1.1.1 2005/11/08 14:10:24 morikawa Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!Call ((< dynamics_mod >))
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module dycore_dynamics_mod
                                                                 !=begin
  !== Dependency
  use type_mod,      only : STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: dycore_dynamics_init       ! subroutines
  public :: dycore_dynamics_prediction ! subroutines
  public :: dycore_dynamics_diagnostic ! subroutines
  public :: dycore_dynamics_diffusion  ! subroutines
  public :: dycore_dynamics_end        ! subroutines
                                                                 !=end

  logical, save :: dycore_dynamics_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: dycore_dynamics.f90,v 1.1.1.1 2005/11/08 14:10:24 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

contains

                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and
  !
  !((< dynamics_mod >)) Vars_a ѿ allocate 롣
  !
  subroutine dycore_dynamics_init( Dims, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, &
         &                     STRING, DBKIND, INTKIND
    use dycore_grid_mod, only: im, jm, km
    use dynamics_mod,    only: dynamics_init
    use spml_mod,        only: spml_init
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(DYCORE_DIMS), intent(in) :: Dims   ! ǡ
    !
    !==== Output
    !
    type(DYCORE_VARS), intent(out):: Vars_a ! ʻǡ(t+t)
                                                                 !=end

    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_dynamics_init"

  continue

    !----------------------------------------------------------------
    !   ǧ
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (dycore_dynamics_initialized) then
       call EndSub( subname, '%c is already called.', c1=trim(subname) )
       return
    else
       dycore_dynamics_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !-------------------------------------------------------------------
    !  SPMODEL 3⥸塼֥롼 wa_initial
    !-------------------------------------------------------------------
    call spml_init

    !----------------------------------------------------------------
    !   Vars_a γѿ allocate ӽ
    !----------------------------------------------------------------
    allocate( Vars_a%xyz_VelLon(im,jm,km) )
    allocate( Vars_a%xyz_VelLat(im,jm,km) )
    allocate( Vars_a%xyz_Vor(im,jm,km)  )
    allocate( Vars_a%xyz_Div(im,jm,km)  )
    allocate( Vars_a%xyz_Temp(im,jm,km) )
    allocate( Vars_a%xyz_QVap(im,jm,km) )
    allocate( Vars_a%xy_Ps(im,jm)       )

    Vars_a%xyz_VelLon = 0.0d0
    Vars_a%xyz_VelLat = 0.0d0
    Vars_a%xyz_Vor    = 0.0d0
    Vars_a%xyz_Div    = 0.0d0
    Vars_a%xyz_Temp   = 0.0d0
    Vars_a%xyz_QVap   = 0.0d0
    Vars_a%xy_Ps      = 0.0d0

    !----------------------------------------------------------------
    !   dynamics_init ؼѿΰϤ
    !----------------------------------------------------------------
    call dynamics_init               &
         & ( Dims%x_Lon%a_Dim(:)   , & ! intent(in): ٺɸ
         &   Dims%y_Lat%a_Dim(:)   , & ! intent(in): ٺɸ
         &   Dims%z_Sigma%a_Dim(:) , & ! intent(in): ҥ٥()ɸ
         &   Dims%r_Sigma%a_Dim(:) ) ! intent(in): ҥ٥(Ⱦ)ɸ

    call EndSub(subname)
  end subroutine dycore_dynamics_init




                                                                 !=begin
  !=== Calculate Predictional Values
  !
  !ͽѿ׻Vars_a ֤
  !
  subroutine dycore_dynamics_prediction( Dims, Vars_b, Vars_n, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, &
         &                     STRING, DBKIND, INTKIND
    use dynamics_mod,    only: dynamics_leapfrog
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(DYCORE_DIMS), intent(in)   :: Dims   ! ǡ
    type(DYCORE_VARS), intent(in)   :: Vars_b ! ʻǡ
    type(DYCORE_VARS), intent(in)   :: Vars_n ! ʻǡ
    !
    !==== Output
    !
    type(DYCORE_VARS), intent(inout):: Vars_a ! ʻǡ(t+t)
                                                                 !=end
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_dynamics_prediction"

  continue

    !----------------------------------------------------------------
    !   ǧ
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_dynamics_initialized) then
       call EndSub( subname, 'Call dycore_dynamics_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    call dynamics_leapfrog            &
         & ( Dims%x_Lon%a_Dim(:)    , & ! intent(in): ٺɸ
         &   Dims%y_Lat%a_Dim(:)    , & ! intent(in): ٺɸ
         &   Dims%z_Sigma%a_Dim(:)  , & ! intent(in): ҥ٥()ɸ
         &   Dims%r_Sigma%a_Dim(:),& ! intent(in): ҥ٥(Ⱦ)ɸ

         &   Vars_b%xyz_VelLon(:,:,:) , & ! intent(in): ®ٷʬ (t-t)
         &   Vars_b%xyz_VelLat(:,:,:) , & ! intent(in): ®ٰʬ (t-t)
         &   Vars_b%xyz_Vor(:,:,:)    , & ! intent(in):          (t-t)
         &   Vars_b%xyz_Div(:,:,:)    , & ! intent(in): ȯ         (t-t)
         &   Vars_b%xyz_Temp(:,:,:)   , & ! intent(in):          (t-t)
         &   Vars_b%xyz_QVap(:,:,:)   , & ! intent(in): 漾         (t-t)
         &   Vars_b%xy_Ps(:,:)        , & ! intent(in): ɽ̵   (t-t)

         &   Vars_n%xyz_VelLon(:,:,:) , & ! intent(in): ®ٷʬ (t)
         &   Vars_n%xyz_VelLat(:,:,:) , & ! intent(in): ®ٰʬ (t)
         &   Vars_n%xyz_Vor(:,:,:)    , & ! intent(in):          (t)
         &   Vars_n%xyz_Div(:,:,:)    , & ! intent(in): ȯ         (t)
         &   Vars_n%xyz_Temp(:,:,:)   , & ! intent(in):          (t)
         &   Vars_n%xyz_QVap(:,:,:)   , & ! intent(in): 漾         (t)
         &   Vars_n%xy_Ps(:,:)        , & ! intent(in): ɽ̵   (t)

         &   Vars_a%xyz_VelLon(:,:,:) , & ! intent(out): ®ٷʬ (t+t)
         &   Vars_a%xyz_VelLat(:,:,:) , & ! intent(out): ®ٰʬ (t+t)
         &   Vars_a%xyz_Vor(:,:,:)    , & ! intent(out):          (t+t)
         &   Vars_a%xyz_Div(:,:,:)    , & ! intent(out): ȯ         (t+t)
         &   Vars_a%xyz_Temp(:,:,:)   , & ! intent(out):          (t+t)
         &   Vars_a%xyz_QVap(:,:,:)   , & ! intent(out): 漾         (t+t)
         &   Vars_a%xy_Ps(:,:)      )     ! intent(out): ɽ̵   (t+t)

    call EndSub(subname)
  end subroutine dycore_dynamics_prediction







                                                                 !=begin
  !=== Calculate Diagnostic Values
  !
  !ȯ顢® (ʬʬ) 롣
  !
  subroutine dycore_dynamics_diagnostic( Dims, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, &
         &                     STRING, DBKIND, INTKIND
    use dynamics_mod,    only: dynamics_diagnostic
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(DYCORE_DIMS), intent(in)   :: Dims   ! ǡ
    !
    !==== In/Out
    !
    type(DYCORE_VARS), intent(inout):: Vars_a ! ʻǡ(t+t)
                                                                 !=end
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_dynamics_diagnostic"

  continue

    !-----------------------------------------------------------------
    !   ǧ
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_dynamics_initialized) then
       call EndSub( subname, 'Call dycore_dynamics_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    call dynamics_diagnostic          &
         & ( Dims%x_Lon%a_Dim(:)    , & ! intent(in): ٺɸ
         &   Dims%y_Lat%a_Dim(:)    , & ! intent(in): ٺɸ
         &   Dims%z_Sigma%a_Dim(:)  , & ! intent(in): ҥ٥()ɸ
         &   Dims%r_Sigma%a_Dim(:),& ! intent(in): ҥ٥(Ⱦ)ɸ

         &   Vars_a%xyz_VelLon(:,:,:) , & ! intent(out): ®ٷʬ (t+t)
         &   Vars_a%xyz_VelLat(:,:,:) , & ! intent(out): ®ٰʬ (t+t)
         &   Vars_a%xyz_Vor(:,:,:)  , & ! intent(in) :          (t+t)
         &   Vars_a%xyz_Div(:,:,:)  , & ! intent(in) : ȯ         (t+t)
         &   Vars_a%xyz_Temp(:,:,:) , & ! intent(in) :          (t+t)
         &   Vars_a%xyz_QVap(:,:,:) , & ! intent(in) : 漾         (t+t)
         &   Vars_a%xy_Ps(:,:)      )   ! intent(in) : ɽ̵   (t+t)

    call EndSub(subname)
  end subroutine dycore_dynamics_diagnostic



                                                                 !=begin
  !=== Calculate Diffusion Terms
  !
  !ʿȻη׻
  !
  subroutine dycore_dynamics_diffusion( Vars_b, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, &
         &                     STRING, DBKIND, INTKIND
    use dynamics_mod,    only: dynamics_diffusion
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(DYCORE_VARS), intent(in)   :: Vars_b ! ʻǡ(t-t)
    !
    !==== In/Out
    !
    type(DYCORE_VARS), intent(inout):: Vars_a ! ʻǡ(t+t)
                                                                 !=end
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_dynamics_diffusion"

  continue

    !-----------------------------------------------------------------
    !   ǧ
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_dynamics_initialized) then
       call EndSub( subname, 'Call dycore_dynamics_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    call dynamics_diffusion(   &
         & Vars_b%xyz_Vor    , & ! intent(in) :          (t-t)
         & Vars_b%xyz_Div    , & ! intent(in) : ȯ         (t-t)
         & Vars_b%xyz_Temp   , & ! intent(in) :          (t-t)
         & Vars_b%xyz_QVap   , & ! intent(in) : 漾         (t-t)

         & Vars_a%xyz_Vor    , & ! intent(inout) :          (t+t)
         & Vars_a%xyz_Div    , & ! intent(inout) : ȯ         (t+t)
         & Vars_a%xyz_Temp   , & ! intent(inout) :          (t+t)
         & Vars_a%xyz_QVap   )   ! intent(inout) : 漾         (t+t)

    call EndSub(subname)
  end subroutine dycore_dynamics_diffusion



                                                                 !=begin
  !=== Terminate module
  !
  !((< dynamics_mod >)) νλԤʤ
  !
  subroutine dycore_dynamics_end
  !==== Dependency
    use dycore_type_mod, only: STRING, DBKIND, INTKIND
    use dynamics_mod,    only: dynamics_end
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dycore_dynamics_end"

  continue

    !-----------------------------------------------------------------
    !   ǧ
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. dycore_dynamics_initialized) then
       call EndSub( subname, 'dycore_dynamics_init was not called', &
            &       c1=trim(subname) )
       return
    else
       dycore_dynamics_initialized = .false.
    endif

    call dynamics_end

    call EndSub(subname)
  end subroutine dycore_dynamics_end

end module dycore_dynamics_mod
