!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
!
!= Module dcpam_ape_dynamics_mod
!
!   * Developers: Morikawa Yasuhiro, Yamada Yukiko
!   * Version: $Id: dcpam_ape_dynamics.f90,v 1.1 2005/11/29 14:47:21 yukiko Exp $
!   * Tag Name: $Name: dcpam3-20061118 $
!   * Change History: 
!
!== Overview
!
!DCPAM-APE Dynamics Main module
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module dcpam_ape_dynamics_mod

  !== Dependency
  use type_mod,      only : STRING

  implicit none

  !== Public Interface
  private
  public :: dcpam_ape_dynamics       ! subroutines

  character(STRING),parameter:: version = &
       & '$Id: dcpam_ape_dynamics.f90,v 1.1 2005/11/29 14:47:21 yukiko Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam3-20061118 $'

contains

  !== Dynamics main module
  !
  !=== Dynamics main module
  !
  !DCPAM-APE Dynamics Main module
  !
  subroutine dcpam_ape_dynamics( Dims, Vars_b, Vars_n, Vars_a )
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, STRING, INTKIND, REKIND
    use dycore_dynamics_mod, only: dycore_dynamics_prediction, &
         &                     dycore_dynamics_diagnostic,     &
         &                     dycore_dynamics_diffusion 
    use dc_trace,        only: BeginSub, EndSub, DbgMessage

    implicit none

    !==== Input
    !
    type(DYCORE_DIMS), intent(in)   :: Dims   ! ǡ
    type(DYCORE_VARS), intent(in)   :: Vars_b ! ʻǡ(t-t)
    type(DYCORE_VARS), intent(in)   :: Vars_n ! ʻǡ(t)
    !
    !==== Output
    !
    type(DYCORE_VARS), intent(inout):: Vars_a ! ʻǡ(t+t)

    !----- ѿ -----
    character(STRING),  parameter:: subname = "dcpam_ape_dynamics"

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)  
  
    !----------------------------------------------------------------
    !   ϳر黻 (ʿȻ) 
    !----------------------------------------------------------------
    call dycore_dynamics_prediction( &
         & Dims          , &   ! intent(in)   : ǡ
         & Vars_b        , &   ! intent(in)   : ʻǡ(t-t)
         & Vars_n        , &   ! intent(in)   : ʻǡ(t)
         & Vars_a  )           ! intent(inout): ʻǡ(t+t)

!!$    call DbgMessage('Not Calculate Dynamics.')
!!$    Vars_a%xyz_VelLon = Vars_b%xyz_VelLon  ! ®ٷʬ
!!$    Vars_a%xyz_VelLat = Vars_b%xyz_VelLat  ! ®ٰʬ
!!$    Vars_a%xyz_Vor    = Vars_b%xyz_Vor   ! 
!!$    Vars_a%xyz_Div    = Vars_b%xyz_Div   ! ȯ
!!$    Vars_a%xyz_Temp   = Vars_b%xyz_Temp  ! 
!!$    Vars_a%xyz_QVap   = Vars_b%xyz_QVap  ! 漾
!!$    Vars_a%xy_Ps      = Vars_b%xy_Ps     ! ɽ̵

    !----------------------------------------------------------------
    !   ʿȻˤѲ
    !----------------------------------------------------------------
    call dycore_dynamics_diffusion( &
         & Vars_b    , &  ! intent(in)   : ʻǡ(t-t)
         & Vars_a  )      ! intent(inout): ʻǡ(t+t)

    !----------------------------------------------------------------
    !   ̱黻
    !----------------------------------------------------------------
    call dycore_dynamics_diagnostic( &
         & Dims            , & ! intent(in)   : ǡ
         & Vars_a  )           ! intent(inout): ʻǡ(t+t)
       
    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine dcpam_ape_dynamics


end module dcpam_ape_dynamics_mod


