#= Rules for GNU make
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: rules.make,v 1.1 2006/09/09 04:51:28 morikawa Exp $
# Tag Name::  $Name: dcpam3-20061118 $
# Copyright:: Copyright (C) GFD Dennou Club, 2006-. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#== Overview
#
# This file provides general rules for Makefiles.
# To use, "include" this file.
#
# [JAPANESE]
# Υեˤ Makefile ƤӽФ붦̥롼뤬
# ҤƤޤ. ΥեѤˤ,  Makefile 
# Υե include Ƥ.
#
############################################################

%.o: %.f90
	$(FC) -o $@ -c $(FFLAGS) -I$(MODDIR) $(SYSFFLAGS) $<

%: %.o
	$(LINKF) -o $@ $+ $(SYSLDFLAGS) $(SYSLDLIBS)

$(LIBDIR)/$(DCPAMLIB): $(OBJS)
	test -d $(LIBDIR) || $(INSTALLDIR) $(LIBDIR)
	test -z "$+" || $(AR) $(ARFLAGS) $@ $+
	test -f $@ && $(RANLIB) $@
	test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR)
	test -z "`ls $(MODS)`" || $(INSTALL) $(MODS) $(MODDIR)

clean:
	-$(RM) $(MODS) $(OBJS) $(TARGETS) *~

clean.lib:
	-$(RM) $(LIBDIR)/$(DCPAMLIB)
	-$(RM) $(MODDIR)/$(MODS)

clean.bin:
	-cd $(BINDIR) ; $(RM) $(TARGETS)

depend: $(F90DEPEND) Makefile
	$(RUBY) -v > /dev/null 2>&1 && \
	    $(RUBY) $< -q *.f90 ../*/*.f90 > $@ || \
	    touch $@



######################################################################
#== Mode setting for Emacs
#Local Variables:
#mode: makefile
#End:
#
