#!/usr/bin/env ruby
#
#= Remove Preamble from Latex Format
#
#  Developers :: Yasuhiro Morikawa
#  Version    :: $Id: latex2body.rb,v 1.1.1.1 2005/11/08 14:10:22 morikawa Exp $
#
#== Overview
#
#Remove Preamble from Latex Format Contents. Input data is STDIN.
#And Output to STDOUT.
#
#
#= Operation Environment
#
#This program is operated in ruby 1.8.2 (2005-01-10) [i386-linux].
#
#== Usage
#
#   $ latex2body.rb < latex > body
#
#== Desctiption
#
#None
#
#== Future Plans
#
#None
#
#== Notes
#
#None
#
#== Acknowledgements
#
#None
#
#== History
#
#These entries is generated by CVS automatically.
#So do not add new information manually.
#(But please adjust old log format to latest log format manually,
#if format gap between them causes).
#
#$Log: latex2body.rb,v $
#Revision 1.1.1.1  2005/11/08 14:10:22  morikawa
#dcpam (Dennou Club Planetary Atmospheric Model) version 3
#
#Revision 1.1  2005/05/16 14:09:46  morikawa
#* This script output latex body (without preamble) from entire latex
#  format.
#
#
##################################################

require "kconv"

##################################################

#
#== Latex2Body
#
module Latex2Body

  #
  # 
  #

  # CopyRight
  COPYRIGHT = "GFD Dennou Club"

  # ʸϤޤΥޡ
  BEGINDOC = '\begin{document}'

  # ʸΥޡ
  ENDDOC = '\end{document}'

  # CVSHOST
  CVS_HOST       = "www.gfd-dennou.org"

  # CVSROOT
  CVS_ROOT       = "/GFD_Dennou_Club/ftp/arch/dcpam/cvsroot"

  # CVS Υץ̾
  CVS_PROJECT    = "dcpam2"

  # СʥС (CVS ˤ꼫ư)
  VER = "$Revision: 1.1.1.1 $"

  #
  # Ƥ֤Ȥǡ \begin{document} 
  # \end{document} ֤
  #
  def remove_preamble(all=nil)
    return nil    unless str_and_notspace?(all)

    begindoc = Regexp.quote(BEGINDOC)
    enddoc   = Regexp.quote(ENDDOC)

    latex_body_each_line = all.split(/\n/)
    debug(latex_body_each_line)

    latex_body = ""
    bodyflag = false
    latex_body_each_line.each{ |line|
      if /#{begindoc}/ =~ line then
        bodyflag  = true
        next
      elsif /#{enddoc}/ =~ line
        bodyflag  = false
      else
        latex_body << line + "\n" if bodyflag
      end
    }

    debug(latex_body)
    return latex_body
  end

  #
  # ǥХåѥ᥽åɡȤ߹ߴؿ $DEBUG ξ (Ĥޤꡢ
  # ץ $ ruby -d ./xxxxxx.rb ȤƸƤӽФ) 
  # debug ᥽åɤ줿ѿϤ롣
  #
  def debug(*args)
    p [caller.first, *args] if $DEBUG
  end
  private :debug

  #
  # ٹޤϥ顼
  # err  nil  false ξ硢mes Ϳ줿å
  # ٹȤɽ롣err ξϤΥåν
  # Ʊ˥顼ȯץλ롣
  # errvar ѿͿȡ顼μǤ롣
  # quiet  true ˤȡerr  nil ξ硢ưʤʤ롣
  #
  def warn_or_err(mes=nil, err=nil, quiet=nil, errvar=nil)
    return nil if !mes

    errvar = RuntimeError if !errvar

    if err then
      raise errvar, "Error: #{mes}"
    elsif !quiet
      $stdout.print "[#{caller.first}] \n     Warning: #{mes}"
      return nil
    end
  end
  private :warn_or_err

  #
  # 줿ѿʸǡĶʸΤߤǤϤʤȤ
  # Ĵ٤᥽åɡܸǤäƤ⡢ʸäƤ true ֤
  #
  def str_and_notspace?(obj)
    debug(obj)

    if !obj.instance_of?(String) then
      return false
    end

    # ܸʸбǤ褦
    Kconv::toeuc(obj)

    if /\S+/e =~ obj.chomp.strip then
      return true
    else
      return false
    end
  end
  private :str_and_notspace?

end

######################################################
if $0 == __FILE__
  include Latex2Body

  body = remove_preamble($stdin.read)

  $stdout.print body
end
