!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module varinfo_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: varinfo.f90,v 1.8 2005/01/19 08:52:45 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!This module store Variable Infomation from NAMELIST and Provide.
!These Information is expected to be used by ((< io_gt4_out_mod >)).
!
!NAMELIST Ϥѿ˴ؤ롣
!ξ ((< io_gt4_out_mod >)) ˤѤ뤳ȤꤵƤ롣
!
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!⤷ȡ((< io_gt4_out_mod >)) ⥸塼˳Ǽ
!٤Τޤ
!
                                                                 !=end
module varinfo_mod
                                                                 !=begin
  !== Dependency
  use type_mod,      only : INTKIND, STRING, TOKEN
  use gt4_history,   only : GT_HISTORY_VARINFO, GT_HISTORY_ATTR
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: VAR_INFO                                   ! derived types
  public :: varinfo_init, varinfo_inquire, varinfo_end ! subroutines
  !
  !== Generic Procedure
  !
  interface varinfo_attrs_init
     module procedure varinfo_attrs_init0, varinfo_attrs_init1
  end interface

  !== Derived Types
  !
  !ѿ˴ؤƾǼ (ǡΤϴޤޤʤ)
  !
  type VAR_INFO
     character(STRING)       :: varkey  = '' ! ѿ
     character(STRING)       :: file    = '' ! Ϥե
     integer(INTKIND)        :: StepInterval = 0 ! ϥƥå״ֳ
     integer(INTKIND)        :: OutputStep   = 0 ! ϲ
     type(GT_HISTORY_VARINFO):: varinfo      ! gt4 ѿ
     type(GT_HISTORY_ATTR), allocatable &
          &                  :: attrs(:)     ! °
  end type VAR_INFO
                                                                 !=end

  ! ѿǼƤѿ
  type(VAR_INFO), allocatable ,save:: vars_store(:)

  logical                     ,save:: varinfo_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: varinfo.f90,v 1.8 2005/01/19 08:52:45 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine varinfo_init
  !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND, REKIND, DBKIND, &
         &               NMLARRAY
    use nmlfile_mod,only: nmlfile_init, nmlfile_open, nmlfile_close
    use dc_types,  only: GT_TOKEN => TOKEN, GT_STRING => STRING
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
    use dc_message,only: MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !
    !==== NAMELIST varinfo_nml
    !
    !ѿ˴ؤܾꤹ뤿 NAMELIST ǡ
    !ʣ varinfo_nml Ѱդǡʣѿ꤬ǽǤ롣
    !ѿ varkey ϥǥ
    !ꤵʪ̤ΥޡǡŪˤ
    !((< io_gt4_out_mod >)) ⥸塼
    !((< io_gt4_out_SetVars >)) ֥롼ǥޡꤷ
    !((< io_gt4_out_Put >)) ֥롼ǥǡ file 
    !ꤵ줿ե˽Ϥ롣⤷ file Ϳʤ
    !ޤ϶ʸͿˤϡ((< io_gt4_out_nml >))
    !Ϳ default_output ѿǻꤵ줿ե˽Ϥ롣
    !
    !varname, dimnum, dimnames, longname, units, xtype
    !ϽϤѿղäǤ롣
    !
    !StepInterval, OutputStep Ϳʤޤϥʲͤ
    !Ϳˤ ((< time_mod >))  time_nml Ϳ
    !StepInterval, OutputStep Ѥ롣
    !
    character(STRING)    :: varkey   = '' ! ѿ
    character(STRING)    :: file     = '' ! Ϥե

    character(GT_TOKEN)  :: varname  = '' ! ѿ̾
    integer(INTKIND)     :: dimnum   = 0  ! ¸뼡
    character(GT_TOKEN)  :: dimnames(NMLARRAY) = '' ! ¸뼡
    character(GT_STRING) :: longname = '' ! ѿεŪ̾
    character(GT_STRING) :: units    = '' ! ѿñ
    character(GT_TOKEN)  :: xtype    = '' ! ѿη

    integer(INTKIND)     :: StepInterval = 0 ! ϥƥå״ֳ
    integer(INTKIND)     :: OutputStep   = 0 ! ϲ

    namelist /varinfo_nml/ &
         & varkey       , &  ! ѿ
         & file         , &  ! Ϥե
         &
         & varname      , &  ! ѿ̾
         & dimnum       , &  ! ¸뼡ο
         & dimnames     , &  ! ¸뼡ѿ̾
         & longname     , &  ! ѿεŪ̾
         & units        , &  ! ѿñ
         & xtype        , &  ! ѿη
         &
         & StepInterval , &  ! ϲ
         & OutputStep        ! ϥƥå״ֳ

    !
    !==== NAMELIST varinfo_attr_nml
    !
    !ѿ varattr °Ϳ롣
    !NAMELIST ʣ varinfo_attr_nml ѰդƤ
    !ʣѿФʣξͿǽǤ롣
    !Ϳʤˤ°ղäʤ
    !
    !attrtype ˤͿ°ͤμꤹ롣
    !((<URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
    !򻲾Ȥ衣ʤarraysize  1 ʾͤꤹȡ
    !ǡͥ褵°ͤꤵ롣
    !
    character(GT_STRING) :: varattr  = '' ! °ղäѿ̾
    character(GT_TOKEN)  :: attrname = '' ! °̾
    character(GT_TOKEN)  :: attrtype = '' ! °ͤη
    character(GT_STRING) :: cvalue   = '' ! ° (ʸ)
    integer(INTKIND)     :: ivalue   = 0      ! ° ()
    real(REKIND)         :: rvalue   = 0.0    ! ° (ñټ¿)
    real(DBKIND)         :: dvalue   = 0.0d0  ! ° (ټ¿)
    logical              :: lvalue   = .false.! ° ()
    integer(INTKIND)     :: arraysize= 0      ! Υ
    integer(INTKIND) :: iarray(NMLARRAY)  = 0    ! ° ()
    real(REKIND)     :: rarray(NMLARRAY)  = 0.0  ! ° (ñټ¿)
    real(DBKIND)     :: darray(NMLARRAY)  = 0.0d0! ° (ټ¿)

    namelist /varinfo_attr_nml/ &
         & varattr      , &  ! °ղäѿ̾
         & attrname     , &  ! °̾
         & attrtype     , &  ! °ͤη
         & cvalue       , &  ! ° (ʸ)
         & ivalue       , &  ! ° ()
         & rvalue       , &  ! ° (ñټ¿)
         & dvalue       , &  ! ° (ټ¿)
         & lvalue       , &  ! ° ()
         & arraysize    , &  ! Υ
         & iarray       , &  ! ° ()
         & rarray       , &  ! ° (ñټ¿)
         & darray            ! ° (ټ¿)

                                                                 !=end

    !-------------------------------------------------------------------
    !   ѿΰǼѿ
    !-------------------------------------------------------------------
    type(VAR_INFO)       , allocatable :: vars_store_tmp(:)
    type(GT_HISTORY_ATTR), allocatable :: attrs_tmp(:)

    !----------------------------------------------------------------
    !   ѿ
    !----------------------------------------------------------------
    integer(INTKIND)            :: i, j, k
    logical                     :: err
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable, next
    character(TOKEN)            :: position
    character(STRING), parameter:: subname = "varinfo_init"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (varinfo_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       varinfo_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read varinfo_nml
    !----------------------------------------------------------------
    if ( allocated(vars_store) ) then
       deallocate(vars_store)
    endif

    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)

    if (.not. nmlreadable) then
       call DbgMessage('Not Read NAMELIST varinfo_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST varinfo_nml.')
    else

       i = 0
       j = 0
       next = .false.
       varinfo_nml_input : do
          i = i + 1
          call DbgMessage('NAMELIST varinfo_nml Input, <%d> time', i=(/i/))
          ! 
          varkey    = ''  ! ѿ
          file      = ''  ! Ϥե

          varname   = ''  ! ѿ̾
          dimnum    = 0   ! ¸뼡
          dimnames(:)= ''  ! ¸뼡
          longname  = ''  ! ѿεŪ̾
          units     = ''  ! ѿñ
          xtype     = ''  ! ѿη

          StepInterval = 0 ! ϥƥå״ֳ
          OutputStep   = 0 ! ϲ

          ! read nml
          read(nmlunit, nml=varinfo_nml, iostat=nmlstat)
          call DbgMessage('Stat of NAMELIST varinfo_nml Input is <%d>', &
               &           i=(/nmlstat/))
          write(0, nml=varinfo_nml)

          ! Inquire access position
          inquire(nmlunit, position=position)
          if ( trim(position) /= 'APPEND' ) then
             next = .true.
          else
             next = .false.
          endif

          ! ͭǤʤͤޤΤ˴ؤƤ̵롣
          if (varkey == '' ) then
             call DbgMessage('var is blank. so this varinfo_nml is ignored.')
             if (next) cycle varinfo_nml_input
             if (.not. next) exit varinfo_nml_input
          elseif (dimnum < 1) then
             call DbgMessage('dimnum < 1. so this varinfo_nml is ignored.')
             if (next) cycle varinfo_nml_input
             if (.not. next) exit varinfo_nml_input
          endif

          !--------------------------------------------------------------
          ! vars_store ؤγǼ
          !--------------------------------------------------------------
          ! vars_store νĥ
          j = j + 1

          if ( .not. allocated(vars_store) ) then
             allocate( vars_store(1) )
             ! 
             if ( allocated(vars_store(1)%attrs) ) then
                deallocate( vars_store(1)%attrs )
             endif
          else
             allocate( vars_store_tmp(j-1) )
             call varinfo_copy( vars_store(1:j-1), vars_store_tmp(1:j-1) )
             deallocate( vars_store )
             allocate( vars_store(j) )
             call varinfo_copy( vars_store_tmp(1:j-1), vars_store(1:j-1) )
             deallocate( vars_store_tmp )

             ! 
             if ( allocated(vars_store(j)%attrs) ) then
                deallocate( vars_store(j)%attrs )
             endif
          endif


          vars_store(j)%varkey           = varkey
          vars_store(j)%file             = file
          vars_store(j)%StepInterval     = StepInterval
          vars_store(j)%OutputStep       = OutputStep
          vars_store(j)%varinfo%name     = varname
          allocate(  vars_store(j)%varinfo%dims( dimnum )  )
          vars_store(j)%varinfo%dims     = dimnames(1:dimnum)
          vars_store(j)%varinfo%longname = longname
          vars_store(j)%varinfo%units    = units
          vars_store(j)%varinfo%xtype    = xtype

          if (.not. next) exit varinfo_nml_input
          next      = .false.  ! Τν
       enddo varinfo_nml_input
    endif

    call nmlfile_close

    !----------------------------------------------------------------
    !   read varinfo_attr_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)

    if (.not. nmlreadable) then
       call DbgMessage('Not Read NAMELIST varinfo_attr_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST varinfo_attr_nml.')
    else

       i = 0
       next = .false.

       varinfo_attr_nml_input : do
          if ( .not. allocated(vars_store) ) then
             call DbgMessage('variables are not defined, so varinfo_attr_nml is ignored')
             exit varinfo_attr_nml_input
          endif
          i = i + 1
          call DbgMessage('NAMELIST varinfo_attr_nml Input, <%d> time', i=(/i/))
          ! 
          varattr   = ''     ! °ղäѿ̾
          attrname  = ''     ! °̾
          attrtype  = ''     ! °ͤη
          cvalue    = ''     ! ° (ʸ)
          ivalue    = 0      ! ° ()
          rvalue    = 0.0    ! ° (ñټ¿)
          dvalue    = 0.0d0  ! ° (ټ¿)
          lvalue    = .false.! ° ()
          arraysize = 0      ! Υ
          iarray(:) = 0      ! ° ()
          rarray(:) = 0.0    ! ° (ñټ¿)
          darray(:) = 0.0d0  ! ° (ټ¿)

          ! read nml
          read(nmlunit, nml=varinfo_attr_nml, iostat=nmlstat)
          call DbgMessage('Stat of NAMELIST varinfo_attr_nml Input is <%d>', &
               &           i=(/nmlstat/))
          write(0, nml=varinfo_attr_nml)

          ! Inquire access position
          inquire(nmlunit, position=position)
          if ( trim(position) /= 'APPEND' ) then
             next = .true.
          else
             next = .false.
          endif

          ! ͭǤʤͤޤΤ˴ؤƤ̵롣
          if (varattr == '') then
             call DbgMessage('varattr is blank. so this varinfo_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit varinfo_attr_nml_input
          elseif (attrname == '') then
             call DbgMessage('attrname is blank. so this varinfo_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit varinfo_attr_nml_input
          elseif (attrtype == '') then
             call DbgMessage('attrtype is blank. so this varinfo_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit varinfo_attr_nml_input
          endif

          ! varattr  vars_store Τɤ˳Ǽ٤õ j ˳Ǽ
          ! бΤ vars_store ̵̵롣
          j = 0
          do j = 1, size(vars_store)
             err = .false.
             call DbgMessage('Search varname=<%c> in vars_store (<%c>)', &
                  &        c1=trim(varattr)                         , & 
                  &        c2=trim(vars_store(j)%varinfo%name)     )
             if ( trim(varattr) == trim(vars_store(j)%varinfo%name) ) then
                exit
             endif
             err = .true.
          enddo
          if (err) then
             call DbgMessage('variable <%c> is not defined in varinfo_nml.'// &
                  &       ' So this varinfo_attr_nml is ignored.'     , &
                  &       c1=trim(varattr)                             )
             if (next) cycle
             if (.not. next) exit
          endif

          !--------------------------------------------------------------
          ! vars_store%attrs ؤγǼ
          !--------------------------------------------------------------
          ! attrs(:) γĥ
          if ( .not. allocated(vars_store(j)%attrs) ) then
             allocate( vars_store(j)%attrs(1) )
             k = 1
          else
             k = size( vars_store(j)%attrs ) + 1
             allocate( attrs_tmp(k-1) )
             call varinfo_attrs_copy(vars_store(j)%attrs(1:k-1), attrs_tmp(1:k-1))
             deallocate( vars_store(j)%attrs )
             allocate( vars_store(j)%attrs(k) )
             call varinfo_attrs_copy(attrs_tmp(1:k-1), vars_store(j)%attrs(1:k-1))
             deallocate( attrs_tmp )
          endif

          if (arraysize > 0) then
             call varinfo_attrs_init(vars_store(j)%attrs(k))

             deallocate(  vars_store(j)%attrs(k)%iarray  )
             deallocate(  vars_store(j)%attrs(k)%rarray  )
             deallocate(  vars_store(j)%attrs(k)%darray  )

             allocate(  vars_store(j)%attrs(k)%iarray( arraysize )  )
             allocate(  vars_store(j)%attrs(k)%rarray( arraysize )  )
             allocate(  vars_store(j)%attrs(k)%darray( arraysize )  )

             vars_store(j)%attrs(k)%array = .true.

          else
             call varinfo_attrs_init(vars_store(j)%attrs(k))
          endif

          vars_store(j)%attrs(k)%attrname  = attrname
          vars_store(j)%attrs(k)%attrtype  = attrtype
          vars_store(j)%attrs(k)%cvalue    = cvalue
          vars_store(j)%attrs(k)%ivalue    = ivalue
          vars_store(j)%attrs(k)%rvalue    = rvalue
          vars_store(j)%attrs(k)%dvalue    = dvalue
          vars_store(j)%attrs(k)%lvalue    = lvalue
          vars_store(j)%attrs(k)%iarray(1:max(1,arraysize)) = iarray(1:max(1,arraysize))
          vars_store(j)%attrs(k)%rarray(1:max(1,arraysize)) = rarray(1:max(1,arraysize))
          vars_store(j)%attrs(k)%darray(1:max(1,arraysize)) = darray(1:max(1,arraysize))

          if (.not. next) exit varinfo_attr_nml_input
          next      = .false.  ! Τν

       enddo varinfo_attr_nml_input

    end if

    call nmlfile_close

    call EndSub( subname )
  end subroutine varinfo_init


                                                                 !=begin
  !=== Return Variable Information about varkey.
  !
  !ѿ varkey бѿ info ֤
  !stat ˤϥơ֤ѿ֤ 0,
  !varkey б̵ 1, ((< varinfo_init >))
  !ˤԤʤƤʤ -1 ֤
  !
  subroutine varinfo_inquire(varkey, info, stat)
  !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND, REKIND, DBKIND
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
    use dc_error,  only: StoreError, USR_ECHAR
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),     intent(in)  :: varkey ! ѿ
    !
    !==== Output
    !
    type(VAR_INFO),   intent(out) :: info   ! VAR_INFO ѿ
    integer(INTKIND), intent(out) :: stat   ! ơ
                                                                 !=end
    integer(INTKIND)            :: i
    character(STRING), parameter:: subname = "varinfo_inquire"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. varinfo_initialized) then
       stat = -1
       call EndSub( subname, 'Call varinfo_init before call %c. status=<%d>', &
            &       c1=trim(subname), i=(/stat/) )
       return
    endif

    !----------------------------------------------------------------
    !   vars_store ⤫顢varkey ˳Τõ롣
    !----------------------------------------------------------------
    do i = 1, size( vars_store )
       ! varkey ˳ΤĤä餽 info ֤
       if ( trim(vars_store(i)%varkey) == trim(varkey) ) then
          info = vars_store(i)
          stat = 0
          call EndSub( subname, 'varkey=<%c> is found. status=<%d>', &
               &       c1=trim(varkey), i=(/stat/) )
          return
       endif
    enddo

    !----------------------------------------------------------------
    !   varkey ˳Τ̵ stat = 1 Ȥ֤
    !----------------------------------------------------------------
    stat = 1
    call EndSub( subname, 'varkey=<%c> is not found. status=<%d>', &
         &       c1=trim(varkey), i=(/stat/) )
  end subroutine varinfo_inquire



                                                                 !=begin
  !=== Terminate module
  !
  !((<varinfo_init>)) ꤵ줿ͤ˴ǥեȤ᤹
  !
  subroutine varinfo_end
  !==== Dependency
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "varinfo_end"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. varinfo_initialized) then
       call EndSub( subname, 'varinfo_init was not called', &
            &       c1=trim(subname) )
       return
    else
       varinfo_initialized = .false.
    endif

    deallocate(vars_store)

    call EndSub( subname, 'vars_store is deallocated.' )
  end subroutine varinfo_end



                                                                 !=begin
  !=== Copy VAR_INFO array.
  !
  !varinfo_mod ֥롼
  !¤ ((< VAR_INFO >)) 1ΥԡԤʤ
  !
  subroutine varinfo_copy(from, to)
  !==== Dependency
    use type_mod   , only: STRING, INTKIND
    use dc_trace   , only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(VAR_INFO), intent(in)  :: from(:)
    !
    !==== Output
    !
    type(VAR_INFO), intent(out) :: to(:)
                                                                 !=end
    integer(INTKIND)                   :: i
    character(STRING), parameter:: subname = "varinfo_copy"
  continue

    call BeginSub(subname)

    call DbgMessage('size(from)=<%d>, size(to)=<%d>, So copy <%d> times.', &
         &       i=(/ size(from), size(to), min(size(from),size(to)) /) )

    do i = 1, min( size(from), size(to) )
       call DbgMessage('from(%d) [varkey=<%c> '                // &
            & 'file=<%c> varinfo-name=<%c>]'                 , &
            & c1=trim( from(i)%varkey )                      , &
            & c2=trim( from(i)%file )                        , &
            & c3=trim( from(i)%varinfo%name )                , &
            & i=(/ i /)                         )

       to(i)%varkey     = from(i)%varkey 
       to(i)%file       = from(i)%file

       to(i)%StepInterval = from(i)%StepInterval
       to(i)%OutputStep   = from(i)%OutputStep  

       to(i)%varinfo%name     = from(i)%varinfo%name    
       to(i)%varinfo%longname = from(i)%varinfo%longname
       to(i)%varinfo%units    = from(i)%varinfo%units   
       to(i)%varinfo%xtype    = from(i)%varinfo%xtype   

       if ( allocated(to(i)%varinfo%dims) ) then
          deallocate(  to(i)%varinfo%dims  )
       endif
       if ( allocated(from(i)%varinfo%dims) ) then
          allocate(  to(i)%varinfo%dims( size(from(i)%varinfo%dims) )  )
          to(i)%varinfo%dims(:)  = from(i)%varinfo%dims(:)
       endif

       if ( allocated(to(i)%attrs) ) then
          deallocate(  to(i)%attrs  )
       endif
       if ( allocated(from(i)%attrs) ) then
          allocate(  to(i)%attrs( size(from(i)%attrs) )  )
          call varinfo_attrs_copy(  from(i)%attrs(:), to(i)%attrs(:)  )
       endif

    enddo

    call EndSub(subname)
  end subroutine varinfo_copy


                                                                 !=begin
  !=== Copy GT_HISTORY_ATTR array.
  !
  !varinfo_mod ֥롼
  !¤ ((<GT_HISTORY_ATTR|URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
  !1ΥԡԤʤ
  !
  subroutine varinfo_attrs_copy(from, to)
  !==== Dependency
    use type_mod, only: STRING, INTKIND
    use gt4_history, only: GT_HISTORY_ATTR
    use dc_trace, only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(GT_HISTORY_ATTR), intent(in)  :: from(:)
    !
    !==== Output
    !
    type(GT_HISTORY_ATTR), intent(out) :: to(:)
                                                                 !=end
    integer(INTKIND)                   :: i
    character(STRING), parameter:: subname = "varinfo_attrs_copy"
  continue

    call BeginSub(subname)

    call DbgMessage('size(from)=<%d>, size(to)=<%d>, So copy <%d> times.', &
         &       i=(/ size(from), size(to), min(size(from),size(to)) /) )

    do i = 1, min( size(from), size(to) )
       call DbgMessage('from(%d) [attrname=<%c> '                // &
            & 'attrtype=<%c> array=<%b> cvalue=<%c>  '        // &
            & 'ivalue=<%d> rvalue=<%r> dvalue=<%f> '          // &
            & 'iarray(1:%d)=<%d, ...> '                       // &
            & 'rarray(1:%d)=<%r, ...> darray(1:%d)=<%f, ...>'  , &
            & c1=trim( from(i)%attrname )                      , &
            & c2=trim( from(i)%attrtype )                      , &
            & c3=trim( from(i)%cvalue )                        , &
            & i=(/ i, from(i)%ivalue                           , &
            &      size(from(i)%iarray)                        , &
            &      from(i)%iarray                              , &
            &      size(from(i)%rarray)                        , &
            &      size(from(i)%darray)                          &
            &   /)                                             , &
            & r=(/from(i)%rvalue, from(i)%rarray/)    , &
            & d=(/from(i)%dvalue, from(i)%darray/)    , &
            & l=(/from(i)%lvalue/)                      )

       allocate(  to(i)%iarray( size(from(i)%iarray) )  )
       allocate(  to(i)%rarray( size(from(i)%rarray) )  )
       allocate(  to(i)%darray( size(from(i)%darray) )  )

       to(i)%attrname  = from(i)%attrname 
       to(i)%attrtype  = from(i)%attrtype 
       to(i)%array     = from(i)%array    
       to(i)%cvalue    = from(i)%cvalue   
       to(i)%ivalue    = from(i)%ivalue   
       to(i)%rvalue    = from(i)%rvalue   
       to(i)%dvalue    = from(i)%dvalue   
       to(i)%lvalue    = from(i)%lvalue   
       to(i)%iarray(:) = from(i)%iarray(:)
       to(i)%rarray(:) = from(i)%rarray(:)
       to(i)%darray(:) = from(i)%darray(:)
    enddo

    call EndSub(subname)
  end subroutine varinfo_attrs_copy

                                                                 !=begin
  !=== Initialize GT_HISTORY_ATTR variable.
  !
  !varinfo_mod ֥롼
  !¤ ((<GT_HISTORY_ATTR|URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
  !ѿνԤʤ
  !
  subroutine varinfo_attrs_init0(attrs)
  !==== Dependency
    use type_mod, only: STRING, INTKIND
    use gt4_history, only: GT_HISTORY_ATTR
    use dc_trace, only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(GT_HISTORY_ATTR), intent(inout):: attrs
                                                                 !=end
    character(STRING), parameter:: subname = "varinfo_attrs_init0"
  continue

    call BeginSub(subname)

    allocate(  attrs%iarray( 1 )  )
    allocate(  attrs%rarray( 1 )  )
    allocate(  attrs%darray( 1 )  )

    attrs%attrname  = ''     
    attrs%attrtype  = ''     
    attrs%array     = .false.
    attrs%cvalue    = ''     
    attrs%ivalue    = 0      
    attrs%rvalue    = 0.0    
    attrs%dvalue    = 0.0d0  
    attrs%lvalue    = .false.
    attrs%iarray(:) = 0      
    attrs%rarray(:) = 0.0    
    attrs%darray(:) = 0.0d0  

    call DbgMessage('Initialize attrs [attrname=<%c> '        // &
         & 'attrtype=<%c> array=<%b> cvalue=<%c>  '        // &
         & 'ivalue=<%d> rvalue=<%r> dvalue=<%f> '          // &
         & 'iarray(1:%d)=<%d, ...> '                       // &
         & 'rarray(1:%d)=<%r, ...> darray(1:%d)=<%f, ...>'  , &
         & c1=trim( attrs%attrname )                        , &
         & c2=trim( attrs%attrtype )                        , &
         & c3=trim( attrs%cvalue )                          , &
         & i=(/ attrs%ivalue                                , &
         &      size(attrs%iarray)                          , &
         &      attrs%iarray                                , &
         &      size(attrs%rarray)                          , &
         &      size(attrs%darray)                            &
         &   /)                                             , &
         & r=(/attrs%rvalue, attrs%rarray/)                 , &
         & d=(/attrs%dvalue, attrs%darray/)                 , &
         & l=(/attrs%lvalue/)                      )

    call EndSub(subname)
  end subroutine varinfo_attrs_init0


                                                                 !=begin
  !=== Initialize GT_HISTORY_ATTR variable.
  !
  !varinfo_mod ֥롼
  !¤ ((<GT_HISTORY_ATTR|URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
  !1νԤʤ
  !
  subroutine varinfo_attrs_init1(attrs)
  !==== Dependency
    use type_mod, only: STRING, INTKIND
    use gt4_history, only: GT_HISTORY_ATTR
    use dc_trace, only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(GT_HISTORY_ATTR), intent(inout):: attrs(:)
                                                                 !=end
    integer(INTKIND)                    :: i
    character(STRING), parameter:: subname = "varinfo_attrs_init1"
  continue

    call BeginSub(subname)

    call DbgMessage('size(attrs)=<%d>' , i=(/size(attrs)/) )

    do i = 1, size(attrs)
       call varinfo_attrs_init(attrs(i))
    enddo

    call EndSub(subname)
  end subroutine varinfo_attrs_init1


end module varinfo_mod
