!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module spml_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: spml.f90,v 1.6 2005/01/20 11:02:09 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!This module is wrapper of
!((<wa_module|URL:http://www.gfd-dennou.org/arch/spmodel/spml/doc/wa_module.htm>))
!in ((<SPMODEL|URL:http://www.gfd-dennou.org/arch/spmodel>)).
!
!
!((<SPMODEL 饤֥|URL:http://www.gfd-dennou.org/arch/spmodel>))
!((<wa_module|URL:http://www.gfd-dennou.org/arch/spmodel/spml/doc/wa_module.htm>))
!Υåѡ⥸塼Ǥ롣
!¾Υ⥸塼뤫 SPMODEL Υ֥롼󤪤Ӵؿ
!Ƥ־ˤϡ§ŪˤΥ⥸塼𤷤ƸƤӽФ
!
!
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!((<wa_module|URL:http://www.gfd-dennou.org/arch/spmodel/spml/doc/wa_module.htm>))
!Ƥδؿ򤽤ΤޤѤǤ褦private ĤƤʤ
!ºݤˤΥ⥸塼ǹԤʤäƤΤϡʣԤʤʤ褦
!ƤǤ롣
!
!== Future Plans
!
                                                                 !=end
module spml_mod
                                                                 !=begin
  !== Dependency
  !
  !Υ⥸塼ѤǤʤϳإʤɤ wa_module 
  !ؿ󶡤Ȥ̣ǡ only °ĤƤʤ
  !(ɬפƤδؿꤹ٤Ǥ)
  !
  use wa_module
  use w_module,   only : rn
  use type_mod,   only : STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  public :: spml_init, spml_end  ! subroutines

  !¾((<wa_module|URL:http://www.gfd-dennou.org/arch/spmodel/spml/doc/wa_module.htm>))
  !󶡤ؿ
                                                                 !=end
!!$  private
!!$  public :: spml_init, spml_end

  logical, private, save :: spml_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: spml.f90,v 1.6 2005/01/20 11:02:09 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize wa_module
  !
  !((<wa_module|URL:http://www.gfd-dennou.org/arch/spmodel/spml/doc/wa_module.htm>))
  !νؿ
  !((<wa_Initial|URL:http://www.gfd-dennou.org/arch/spmodel/spml/doc/wa_module.htm#wa_Initial>))
  !Ƥ֡
  !
  subroutine spml_init
  !
  !==== Dependency
  !
    use type_mod           , only: INTKIND, STRING
    use grid_3d_mod        , only: im, jm, km, grid_3d_init
    use grid_wavenumber_mod, only: nm, grid_wavenumber_init
    use dc_trace,    only: DbgMessage, BeginSub, EndSub
    use dc_error,    only: StoreError, USR_ECHAR
    use wa_module,   only: wa_Initial
                                                                 !=end
    implicit none

    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
    character(STRING), parameter:: subname = "spml_init"

  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (spml_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       spml_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   grid_3d_mod  grid_wavenumber ˤ
    !----------------------------------------------------------------
    call grid_3d_init
    call grid_wavenumber_init

    !----------------------------------------------------------------
    !   wa_initial ˤ
    !----------------------------------------------------------------
    call wa_Initial(nm,im,jm,km)

    call EndSub( subname, 'wa_initial(nm=<%d>, im=<%d>, jm=<%d>, km=<%d>)', &
         &       i=(/nm, im, jm, km/) )
  end subroutine spml_init


                                                                 !=begin
  !=== Terminate module
  !
  !Ǥ wa_Initial ǤʤΤǡ
  !⤷ʤ
  !wa_Initial ˤǤΤʤ顢
  !((<spml_init>)) ˤե饰򥪥դˤ٤Ǥ롣
  !
  subroutine spml_end
  !==== Dependency
    use type_mod,  only: INTKIND, STRING
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "spml_end"

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. spml_initialized) then
       call EndSub( subname, 'spml_init was not called', &
            &       c1=trim(subname) )
       return
    else
       ! ǤʤΤ .true. Τޤ
!       spml_initialized = .false.
       spml_initialized = .true.
    endif

    call EndSub( subname, 'spml_init can not release')
  end subroutine spml_end

end module spml_mod
