!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics.f90 - physics process module
!
! History
!   2004/11/25 Morikawa Yasuhiro     create
!

module physics_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_init, physics_end,                       &
       &    R0, Omega, Grav, Cp, RAir, EL, CpVap, RVap,      &
       &    DH2O, EpsV, ES0, StB, FKarm, EpsVT, Nu, TempAve, &
       &    TimeFilter, ViscosOrder

  !----------------------------------------------------------------
  !   ʪȻե륿physics_init Ǽ
  !----------------------------------------------------------------
  real(DBKIND), save  ::  &
       &
       & R0             , & ! Ⱦ
       & Omega          , & ! ž®
       & Grav           , & ! ϲ®
       &
       & Cp             , & ! 絤갵Ǯ
       & RAir           , & ! 絤
       & EL             , & ! ζŷǮ
       & CpVap          , & ! 갵Ǯ
       & RVap           , & ! 
       & DH2O           , & ! ̩
       & EpsV           , & ! 絤ʬ
       & ES0            , & ! ˰¾У
       & StB            , & ! Stefan-Boltzman
       & FKarm          , & ! Karman 
       & EpsVT          , & ! 1/-1
       &
       & Nu             , & ! ĶǴ
       & TempAve        , & ! ʿѲ
       & TimeFilter         ! ֥ե륿

  integer(INTKIND), save ::  ViscosOrder  ! ĶǴμ

  logical, save :: physics_initialized = .false.

contains

  subroutine physics_init
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    implicit none

    !----------------------------------------------------------------
    !   ϥե  (gtool4 netCDF ǡ)
    !----------------------------------------------------------------
    namelist /physics_nml/ &
         &
         & R0            , & ! Ⱦ
         & Omega         , & ! ž®
         & Grav          , & ! ϲ®
         &
         & Cp            , & ! 絤갵Ǯ
         & RAir          , & ! 絤
         & EL            , & ! ζŷǮ
         & CpVap         , & ! 갵Ǯ
         & RVap          , & ! 
         & DH2O          , & ! ̩
         & EpsV          , & ! 絤ʬ
         & ES0           , & ! ˰¾У
         & StB           , & ! Stefan-Boltzman
         & FKarm         , & ! Karman 
         & EpsVT         , & ! 1/-1
         &
         & Nu            , & ! ĶǴ
         & TempAve       , & ! ʿѲ
         & TimeFilter    , & ! ֥ե륿
         & ViscosOrder       ! ĶǴμ

    !----- ѿ -----
    character(len = *),  parameter:: subname = "physics_init"

  continue

    !----------------------------------------------------------------
    !   ǧ
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (physics_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       physics_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   NAMELIST ɤ߹
    !----------------------------------------------------------------
    read(5,nml=physics_nml)   ; write(6,nml=physics_nml)

    call EndSub(subname)
  end subroutine physics_init


  subroutine physics_end
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(len = *),  parameter:: subname = "physics_end"
  continue

    !-----------------------------------------------------------------
    !   ǧ
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. physics_initialized) then
       call EndSub( subname, 'physics_init was not called', &
            &       c1=trim(subname) )
       return
    else
       physics_initialized = .false.
    endif

    call EndSub(subname)
  end subroutine physics_end

end module physics_mod
