!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module io_gt4_out_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: io_gt4_out.f90,v 1.10 2005/01/19 08:52:36 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!This module output data with gtool4 netCDF conventions.
!
!gtool4 netCDF ˴ŤǡϤ롣
!
!== Error Handling
!
!== Known Bugs
!
!  * 1ĤΥե˰ۤʤ StepInterval ꤵ硢
!    HistoryCreate ˤꤵ줿Τ StepInterval ǻֳִ֤
!    뤿ᡢꤷѿ StepInterval ΤΤ
!    ˤŪǤʤʤ롣
!
!    * ˡ
!      * ۤʤ StepInterval ꤹˤϤ
!        ̸ĤΥեʬ롣
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module io_gt4_out_mod
                                                                 !=begin
  !== Dependency
  use type_mod,      only : REKIND, DBKIND, INTKIND, TOKEN, STRING
  use axis_type_mod, only : AXISINFO
  use gt4_history,   only : GT_HISTORY
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: io_gt4_out_init, io_gt4_out_end    ! subroutines
  public :: io_gt4_out_SetDims                 ! subroutines
  public :: io_gt4_out_SetVars, io_gt4_out_Put ! subroutines
  !
  !== Generic Procedure
  !
  interface io_gt4_out_Put
     module procedure io_gt4_out_Put3Real
     module procedure io_gt4_out_Put2Real
     module procedure io_gt4_out_Put0Real
     module procedure io_gt4_out_Put3Double
     module procedure io_gt4_out_Put2Double
     module procedure io_gt4_out_Put0Double
  end interface
  !
  !== Derived Types
  !
  !ѿǡǼѹ¤Ρ((< io_gt4_out_SetVars >)) ꡣ
  !
  type IO_GT4_OUT_VARS
     character(STRING), allocatable :: varkeys(:) ! ѿ
     character(STRING)              :: file       ! ϥե
     type(GT_HISTORY)               :: gt_history ! GT_HISTORY ѿ
     logical                        :: created    ! HistoryCreate Ѥɤ
     type(IO_GT4_OUT_VARS), pointer :: next
  end type IO_GT4_OUT_VARS
                                                                 !=end

  !-------------------------------------------------------------------
  !   ϥեꡣ(⥸塼ݻ)
  !-------------------------------------------------------------------
  character(STRING), save :: &
       & file_save         , & ! ϥե̾ (ǥե)
       & title_save        , & ! ȥ
       & source_save       , & ! ǥ̾ ()
       & institution_save      ! ¹Լ̾ ()

  !-------------------------------------------------------------------
  !   ǡǼѹ¤Ρio_gt4_out_SetDims ꡣ
  !-------------------------------------------------------------------
  type(AXISINFO), save, allocatable :: axes_store(:)
  logical       , save              :: axes_store_used = .false.

  type(IO_GT4_OUT_VARS), save, pointer:: vars_output
  logical, save                       :: vars_output_used

  logical, save :: io_gt4_out_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: io_gt4_out.f90,v 1.10 2005/01/19 08:52:36 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains

                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine io_gt4_out_init
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use nmlfile_mod, only : nmlfile_init, nmlfile_open, nmlfile_close
    use time_mod,    only : time_init
    use varinfo_mod, only : varinfo_init
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !
    !==== NAMELIST
    !
    !ϥեꡣ
    !file ͿΤǥեȤνϥեȤʤ롣
    !¾ξϽϤ gtool4 netCDF ǡǡȤ
    !Ϳ롣
    !
    character(STRING) ::                      &
         & file         = 'result.nc'       , & ! ϥե̾ (ǥե)
         & title        = 'GCM Test'        , & ! ȥ
         & source       = 'DCPAM'           , & ! ǥ̾ ()
         & institution  = 'GFD Dennou Club'     ! ¹Լ̾ ()

    namelist /io_gt4_out_nml/ &
         & file        , & ! ϥե̾ (ǥե)
         & title       , & ! ȥ
         & source      , & ! ǥ̾ ()
         & institution     ! ¹Լ̾ ()
                                                                 !=end
    !----- ѿ -----
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable
    character(STRING), parameter:: subname = "io_gt4_out_init"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (io_gt4_out_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       io_gt4_out_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read io_gt4_out_nml
    !----------------------------------------------------------------
    ! Initialization
    file         = 'result.nc'       ! ϥե̾ (ǥե)
    title        = 'GCM Test'        ! ȥ
    source       = 'DCPAM'           ! ǥ̾ ()
    institution  = 'GFD Dennou Club' ! ¹Լ̾ ()

    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=io_gt4_out_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST io_gt4_out_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=io_gt4_out_nml)
    else
       call DbgMessage('Not Read NAMELIST io_gt4_out_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST io_gt4_out_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    !----------------------------------------------------------------
    !   receive NAMELIST information
    !----------------------------------------------------------------
    file_save        = file
    title_save       = title
    source_save      = source
    institution_save = institution

    !----------------------------------------------------------------
    !   time_mod ν롼 time_init Ƥ֡
    !----------------------------------------------------------------
    call time_init

    !----------------------------------------------------------------
    !   varinfo_mod ν롼 varinfo_init Ƥ֡
    !----------------------------------------------------------------
    call varinfo_init

    call EndSub(subname)
  end subroutine io_gt4_out_init

                                                                 !=begin
  !=== Set Dimension
  !
  !Ϥ gtool4 netCDF ǡκɸꤹ롣
  !ʣƤֻʣκɸꤹ롣
  !ߤνꡢꤷɸϽϤƤ netCDF ե
  !Ϥ롣
  !
  subroutine io_gt4_out_SetDims(axis)
  !==== Dependency
    use type_mod,      only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use axis_type_mod, only : AXISINFO, axis_type_copy
    use dc_trace,      only : SetDebug, BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(AXISINFO), intent(in)   :: axis
                                                                 !=end
    !----- ѿ -----
    type(AXISINFO), allocatable  :: axes_store_tmp(:)
    character(STRING),  parameter:: subname = "io_gt4_out_SetDims"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname, 'dimname=<%c>', c1=trim(axis%axisinfo%name) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   ̾ȼǡ axes_store ¤Τ˳Ǽ
    !----------------------------------------------------------------
    ! Υǡ
    if (.not. axes_store_used) then
       call DbgMessage('axes_store_used = %b. allocate(axes_store_used(1))', &
            &        l=(/axes_store_used/))

       allocate( axes_store(1) )
       axes_store_used = .true.

       call axis_type_copy( axis, axes_store(1) )

       call DbgMessage('Store axis=<%c> to axes_store(1).', &
            &        c1=trim(axis%axisinfo%name) )
    ! 2 ܰʹ
    else
       call DbgMessage('axes_store_used = %b. allocate(axes_store_used(%d))', &
            &        l=(/axes_store_used/), i=(/size(axes_store)+1/))

       allocate( axes_store_tmp(size(axes_store)) )
       call axis_type_copy(                   &
            & axes_store(1:size(axes_store)),     &
            & axes_store_tmp(1:size(axes_store)) )
       deallocate(axes_store)
       allocate( axes_store(size(axes_store_tmp)+1) )
       call axis_type_copy(                       &
            & axes_store_tmp(1:size(axes_store_tmp)), &
            & axes_store(1:size(axes_store_tmp))        )
       call axis_type_copy( axis, axes_store(size(axes_store)) )

       call DbgMessage('Store axis=<%c> to axes_store(%d).', &
            &        c1=trim(axis%axisinfo%name), i=(/size(axes_store)/))
    endif

    call EndSub(subname)
  end subroutine io_gt4_out_SetDims


                                                                 !=begin
  !=== Set Variables
  !
  !Ϥѿꤹ롣
  !ʣƤֻʣѿǤ롣
  !Υ֥롼ꤹΤѿ varkey ΤߤǤꡢ
  !Ūʾ ((< varinfo_mod >))  ((< varinfo_init >)) ˤ
  !NAMELIST ((< varinfo_nml >)) ꤵ롣
  !(ϡǥեȤͤϥץ̵˥ϡɥɤ٤Τʤ)
  !
  subroutine io_gt4_out_SetVars(varkey)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : InitTime, DelTime, StepInterval,    &
         &                  tvar, ttype, tname, tunit
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : GT_HISTORY   , GT_HISTORY_AXIS    , &
         &                  HistoryCreate, HistoryAddVariable , &
         &                  HistoryCopyVariable               , &
         &                  HistoryAddAttr, HistoryPut
    use dc_string,   only : JoinChar
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*), intent(in)      :: varkey      ! ѿ
                                                                 !=end

    !----- ѿ -----
    type(VAR_INFO)                :: info        ! varinfo_mod ǡǼ
    character(STRING)             :: output_file ! ǥեȽϥե
    character(STRING), allocatable:: var_tmp(:)
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp2
    type(GT_HISTORY_AXIS), allocatable :: axes_gt4(:) ! Ǽѿ
    integer(INTKIND)              :: i, stat
    integer(INTKIND)              :: StepIntervalTmp

    character(STRING),  parameter:: subname = "io_gt4_out_SetVars"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif


    !-----------------------------------------------------------------
    !   varinfo ⥸塼ꡢvar 򥭡ˤƾ
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    !-----------------------------------------------------------------
    !   ե̾ (ޤ϶) ξϥǥեȤͤѤ롣
    !-----------------------------------------------------------------
    if ( trim(info%file) == '' ) then
       output_file = file_save
    else
       output_file = info%file
    endif

    call DbgMessage('Varkey=<%c> is output to file=<%c>.'     , &
         &        c1=trim(varkey), c2=(trim(output_file))    )

    !-----------------------------------------------------------------
    !   ѿȽϥե vars_output ¤Τ˳Ǽ
    !-----------------------------------------------------------------
    ! Υǡ
    if (.not. vars_output_used) then
       call DbgMessage('vars_output_used = %b. allocate(vars_output_used(1))', &
            &       l=(/vars_output_used/)   )
       allocate(vars_output)
       vars_output_used = .true.

       ! ѿȥǡγǼ
       allocate(vars_output%next)
       allocate(vars_output%next%varkeys(1))
       vars_output%next%varkeys(1)  = varkey
       vars_output%next%file        = output_file
       vars_output%next%created     = .false.

       nullify(vars_output%next%next)

       vars_tmp1 => vars_output%next

       call DbgMessage('store vars_output [varkeys(1)=<%c>, file=<%c>]' , &
            & c1=trim(vars_tmp1%varkeys(1)), c2=trim(vars_tmp1%file) )

    ! 2 ܰʹ
    else
       call DbgMessage('vars_output_used = %b.', l=(/vars_output_used/) )
       vars_tmp1 => vars_output
       vars_tmp2 => vars_tmp1%next

       ! ǡǼƤʤfile ƱȤޤǿʤ
       do
          if ( associated(vars_tmp2) ) then
             call DbgMessage('Search vars_output ' //                 &
                  & '[varkeys(:)=<%c>, file=<%c>, created=<%b>].', &
                  & c1=trim( JoinChar(vars_tmp2%varkeys(:)) )    , &
                  & c2=trim( vars_tmp2%file )                    , &
                  & l=(/vars_tmp2%created/)                           )

             if ( trim(vars_tmp2%file) == trim(output_file) ) then
                call DbgMessage('file=<%c> is already created. ' //   &
                     & 'Existing vars=<%c> ', &
                     & c1=trim( vars_tmp2%file )                  , &
                     & c2=trim( JoinChar(vars_tmp2%varkeys(:)) )       )

                vars_tmp1 => vars_tmp2
                exit
             endif

          elseif ( .not. associated(vars_tmp2) ) then
             call DbgMessage('file=<%c> is not created. ', &
                  & c1=trim( vars_tmp1%file )              )
             allocate(vars_tmp1%next)
             vars_tmp1 => vars_tmp1%next
             exit
          endif
          vars_tmp1 => vars_tmp2
          vars_tmp2 => vars_tmp1%next
       enddo

       !
       ! ѿȽϥեγǼ
       !
       ! Ʊϥե̾¸ߤ
       if ( allocated(vars_tmp1%varkeys) ) then
          allocate( var_tmp(size(vars_tmp1%varkeys)) )
          var_tmp(:) = vars_tmp1%varkeys(:)
          deallocate(vars_tmp1%varkeys)
          allocate( vars_tmp1%varkeys(size(var_tmp) + 1) )
          vars_tmp1%varkeys(1:size(var_tmp))    = var_tmp(:)
          vars_tmp1%varkeys( size(var_tmp) + 1) = varkey
          deallocate(var_tmp)
       ! νϥե̾ξ
       else
          allocate( vars_tmp1%varkeys(1) )
          vars_tmp1%varkeys(1) = varkey
          vars_tmp1%file        = output_file
          vars_tmp1%created     = .false.
       endif

       call DbgMessage('store vars_output [varkeys(%d)=<%c>, file=<%c>]', &
            & i=(/size(vars_tmp1%varkeys)/)                          , &
            & c1=trim( vars_tmp1%varkeys(size(vars_tmp1%varkeys)) )  , &
            & c2=trim( vars_tmp1%file )                               )

       nullify(vars_tmp1%next)
    endif

    !-----------------------------------------------------------------
    !   axes_store 鼡Ǽ¤ GT_HISTORY_AXIS ѿ
    !-----------------------------------------------------------------
    if (axes_store_used) then
       call DbgMessage('Generate gtool4 axes data from axes_store(1:%d).', &
            &        i=(/size(axes_store)/))
       ! ּѤ1¿˳
       allocate( axes_gt4(size(axes_store) + 1) )

       do i = 1, size(axes_store)
          axes_gt4(i) = axes_store(i)%axisinfo
       enddo

    else
       call DbgMessage('Can not Generate gtool4 axes data Because axes_store is not found.')
    endif

    !-----------------------------------------------------------------
    !   axes_gt4 ˻֤μɲ
    !-----------------------------------------------------------------
    if (.not. allocated(axes_gt4)) then
       allocate( axes_gt4(1) )
    endif

    axes_gt4( size(axes_gt4) )%name     = tvar
    axes_gt4( size(axes_gt4) )%length   = 0
    axes_gt4( size(axes_gt4) )%longname = tname
    axes_gt4( size(axes_gt4) )%units    = tunit
    axes_gt4( size(axes_gt4) )%xtype    = ttype


    !-----------------------------------------------------------------
    !   HistoryCreate (io_gt4_out_init ǼѤ)
    !-----------------------------------------------------------------
    if ( .not. vars_tmp1%created) then
       call HistoryCreate( &               ! ҥȥ꡼
            & file=trim(vars_tmp1%file), & ! intent(in) : ϥե̾
            & title=trim(title_save)   , & ! intent(in) : ȥ
            & source=trim(source_save) , & ! intent(in) : 
            & institution=trim(institution_save) , &
            &                              ! intent(in) : 
            & axes=axes_gt4            , & ! intent(in) : ǡ
            & origin=real(InitTime)    , & ! intent(in) : ֤θ
            & interval=real(StepIntervalTmp*DelTime), & 
            &                              ! intent(in) : ϻֳִ
            & history=vars_tmp1%gt_history  ) ! intent(out): GT_HISTORY

       vars_tmp1%created = .true.
    else
       call DbgMessage('file=<%c> is already created', c1=trim(vars_tmp1%file) )
    endif

    !-----------------------------------------------------------------
    !  HistoryPut [in gt4f90io] ˤ뼡ǡ
    !-----------------------------------------------------------------
    do i = 1, size(axes_store)
       call HistoryPut                        & 
            & ( axes_store(i)%axisinfo%name , & ! intent(in)   : ̾
            &   axes_store(i)%a_Dim         , & ! intent(in)   : ǡ
            &   vars_tmp1%gt_history     ) ! intent(inout): GT_HISTORY
    enddo

    !-----------------------------------------------------------------
    !  HistoryAddAttr [in gt4f90io] ˤ뼡ǡؤ°
    !-----------------------------------------------------------------
    do i = 1, size(axes_store)
       if (allocated(axes_store(i)%attrs) ) then
          call HistoryAddAttr                    &
               & ( axes_store(i)%axisinfo%name , & ! intent(in): ̾
               &   axes_store(i)%attrs         , & ! intent(in): °
               &   vars_tmp1%gt_history     )   ! intent(inout): GT_HISTORY
       endif
    enddo

    !-----------------------------------------------------------------
    !  HistoryAddVariable [in gt4f90io] ˤѿ
    !-----------------------------------------------------------------
    call HistoryAddVariable(         &
         & varinfo=info%varinfo    , & ! intent(in): GT_HISTORY_VARINFO
         & history=vars_tmp1%gt_history ) ! intent(inout) : GT_HISTORY

    !-----------------------------------------------------------------
    !  HistoryCopyVariable [in gt4f90io] ˤѿ
    !-----------------------------------------------------------------
!!$    call HistoryCopyVariable(         &
!!$         & file=trim(info_file)     , & ! intent(in)    : ԡե
!!$         & varkey=trim( vars_tmp1%varkeys(size(vars_tmp1%varkeys)) ), &
!!$         &                              ! intent(in)    : ѿ̾
!!$         & history=vars_tmp1%gt_history  ) ! intent(inout) : GT_HISTORY

    !-----------------------------------------------------------------
    !  HistoryAddAttr [in gt4f90io] ˤѿؤ°ղ
    !-----------------------------------------------------------------
    if (allocated(info%attrs) ) then
       call HistoryAddAttr(                &
            & varname=info%varinfo%name  , & ! intent(in): ѿ̾
            & attrs=info%attrs           , & ! intent(in): GT_HISTORY_ATTR
            & history=vars_tmp1%gt_history  )! intent(inout) : GT_HISTORY
    endif

    call EndSub(subname)
  end subroutine io_gt4_out_SetVars


                                                                 !=begin
  !=== Put 3-Dimensional Single Precision Data to netCDF file
  !
  !ѿ varkey ˥ǡ xyz_Var Ϥ롣
  !((< varinfo_mod >))  ((< varinfo_init >)) 
  !NAMELIST ((< varinfo_nml >)) б varkey 
  !ͿƤʤ硢ǡϽϤʤ
  !
  ! varkey б ((< varinfo_mod >))  StepInterval 
  !OutputStep ȡ((< time_mod >))  CurrentLoop 顢
  !Ϥ륿ߥ󥰤ɤåƽϤ롣
  !Ϥ륿ߥ󥰤ǤʤȽꤵ줿ϲ⤻˽λ롣
  !ʤ((< varinfo_mod >))  StepInterval  OutputStep 
  !̵ (ʲ) ξˤ ((< time_mod >))  StepInterval 
  ! OutputStep Ѥ롣ŪȽˡϰʲ̤Ǥ롣
  !
  !  * CurrentLoop  StepInterval ǳꡢ;꤬ 0 ξˤϽϡ
  !  * CurrentLoop  StepInterval * OutputStep 
  !    礭ʤäƤޤäʹ߽ϤϹԤʤʤ
  !
  subroutine io_gt4_out_Put3Real(varkey, xyz_Var)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : StepInterval, OutputStep, CurrentLoop
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : HistoryPut
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),      intent(in):: varkey         ! ѿ̾
    real(REKIND),      intent(in):: xyz_Var(:,:,:) ! ϥǡ
                                                                 !=end
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    integer(INTKIND)              :: i, stat
    logical                       :: hit_vars_output = .false.
    type(VAR_INFO)                :: info
    integer(INTKIND)              :: StepIntervalTmp
    integer(INTKIND)              :: OutputStepTmp
    character(STRING),  parameter:: subname = "io_gt4_out_Put3Real"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Get Information from varinfo_mod about varkey.
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    if ( info%OutputStep < 1 ) then
       OutputStepTmp = OutputStep       ! in time_mod
    else
       OutputStepTmp = info%OutputStep  ! in varinfo_mod
    end if

    if ( mod(CurrentLoop, StepIntervalTmp) /= 0 ) then
       call EndSub( subname, &
            & 'This is not Output Step. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    if ( CurrentLoop > StepIntervalTmp * OutputStepTmp ) then
       call EndSub( subname, &
            & 'Already CurrentLoop exceed StepInterval*OutputStep. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    !-----------------------------------------------------------------
    !   Search vars_output for varkey's infomation.
    !-----------------------------------------------------------------
    hit_vars_output = .false.
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          call MessageNotify('E', subname, &
               &             message='Varkey is not found.')
       elseif ( allocated(vars_tmp1%varkeys) ) then
          do i = 1, size(vars_tmp1%varkeys)
             if ( varkey == vars_tmp1%varkeys(i) ) then
                hit_vars_output = .true.
             endif
             call DbgMessage('search vars_output [varkeys(%d)=<%c>, file=<%c>]', &
                  & i=(/i/)                                                 , &
                  & c1=trim( vars_tmp1%varkeys(i) )                         , &
                  & c2=trim( vars_tmp1%file )               )
             call DbgMessage('  hit_vars_output=<%b>', L=(/hit_vars_output/) )
          enddo
       endif

       if (hit_vars_output) exit
       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Output by HistoryPut [in gt4f90io]
    !-----------------------------------------------------------------
    call HistoryPut(                    &
         & varname=info%varinfo%name  , & ! intent(in) : ѿ̾
         & array=xyz_Var             , & ! intent(in) : 
         & history=vars_tmp1%gt_history   ) ! intent(inout) : GT_HISTORY

    call EndSub( subname, &
         & 'This is Just Output Step. ' // &
         & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
  end subroutine io_gt4_out_Put3Real


                                                                 !=begin
  !=== Put 2-Dimensional Single Precision Data to netCDF file
  !
  !ǽ ((< io_gt4_out_Put3Real >)) ȴŪƱ
  !ñټ¿ 2 ΥǡϤ롣
  !
  subroutine io_gt4_out_Put2Real(varkey, xy_Var)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : StepInterval, OutputStep, CurrentLoop
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : HistoryPut
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),      intent(in):: varkey         ! ѿ̾
    real(REKIND),      intent(in):: xy_Var(:,:) ! ϥǡ
                                                                 !=end
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    integer(INTKIND)              :: i, stat
    logical                       :: hit_vars_output = .false.
    type(VAR_INFO)                :: info
    integer(INTKIND)              :: StepIntervalTmp
    integer(INTKIND)              :: OutputStepTmp
    character(STRING),  parameter:: subname = "io_gt4_out_Put2Real"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Get Information from varinfo_mod about varkey.
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    if ( info%OutputStep < 1 ) then
       OutputStepTmp = OutputStep       ! in time_mod
    else
       OutputStepTmp = info%OutputStep  ! in varinfo_mod
    end if

    if ( mod(CurrentLoop, StepIntervalTmp) /= 0 ) then
       call EndSub( subname, &
            & 'This is not Output Step. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    if ( CurrentLoop > StepIntervalTmp * OutputStepTmp ) then
       call EndSub( subname, &
            & 'Already CurrentLoop exceed StepInterval*OutputStep. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    !-----------------------------------------------------------------
    !   Search vars_output for varkey's infomation.
    !-----------------------------------------------------------------
    hit_vars_output = .false.
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          call MessageNotify('E', subname, &
               &             message='Varkey is not found.')
       elseif ( allocated(vars_tmp1%varkeys) ) then
          do i = 1, size(vars_tmp1%varkeys)
             if ( varkey == vars_tmp1%varkeys(i) ) then
                hit_vars_output = .true.
             endif
             call DbgMessage('search vars_output [varkeys(%d)=<%c>, file=<%c>]', &
                  & i=(/i/)                                                 , &
                  & c1=trim( vars_tmp1%varkeys(i) )                         , &
                  & c2=trim( vars_tmp1%file )               )
             call DbgMessage('  hit_vars_output=<%b>', L=(/hit_vars_output/) )
          enddo
       endif

       if (hit_vars_output) exit
       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Output by HistoryPut [in gt4f90io]
    !-----------------------------------------------------------------
    call HistoryPut(                    &
         & varname=info%varinfo%name  , & ! intent(in) : ѿ̾
         & array=xy_Var             , & ! intent(in) : 
         & history=vars_tmp1%gt_history   ) ! intent(inout) : GT_HISTORY

    call EndSub( subname, &
         & 'This is Just Output Step. ' // &
         & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
  end subroutine io_gt4_out_Put2Real



                                                                 !=begin
  !=== Put 0-Dimensional Single Precision Data to netCDF file
  !
  !ǽ ((< io_gt4_out_Put3Real >)) ȴŪƱ
  !ñټ¿ 0 ΥǡϤ롣
  !
  subroutine io_gt4_out_Put0Real(varkey, Var)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : StepInterval, OutputStep, CurrentLoop
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : HistoryPut
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),      intent(in):: varkey         ! ѿ̾
    real(REKIND),      intent(in):: Var ! ϥǡ
                                                                 !=end
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    integer(INTKIND)              :: i, stat
    logical                       :: hit_vars_output = .false.
    type(VAR_INFO)                :: info
    integer(INTKIND)              :: StepIntervalTmp
    integer(INTKIND)              :: OutputStepTmp
    character(STRING),  parameter:: subname = "io_gt4_out_Put0Real"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Get Information from varinfo_mod about varkey.
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    if ( info%OutputStep < 1 ) then
       OutputStepTmp = OutputStep       ! in time_mod
    else
       OutputStepTmp = info%OutputStep  ! in varinfo_mod
    end if

    if ( mod(CurrentLoop, StepIntervalTmp) /= 0 ) then
       call EndSub( subname, &
            & 'This is not Output Step. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    if ( CurrentLoop > StepIntervalTmp * OutputStepTmp ) then
       call EndSub( subname, &
            & 'Already CurrentLoop exceed StepInterval*OutputStep. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    !-----------------------------------------------------------------
    !   Search vars_output for varkey's infomation.
    !-----------------------------------------------------------------
    hit_vars_output = .false.
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          call MessageNotify('E', subname, &
               &             message='Varkey is not found.')
       elseif ( allocated(vars_tmp1%varkeys) ) then
          do i = 1, size(vars_tmp1%varkeys)
             if ( varkey == vars_tmp1%varkeys(i) ) then
                hit_vars_output = .true.
             endif
             call DbgMessage('search vars_output [varkeys(%d)=<%c>, file=<%c>]', &
                  & i=(/i/)                                                 , &
                  & c1=trim( vars_tmp1%varkeys(i) )                         , &
                  & c2=trim( vars_tmp1%file )               )
             call DbgMessage('  hit_vars_output=<%b>', L=(/hit_vars_output/) )
          enddo
       endif

       if (hit_vars_output) exit
       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Output by HistoryPut [in gt4f90io]
    !-----------------------------------------------------------------
    call HistoryPut(                    &
         & varname=info%varinfo%name  , & ! intent(in) : ѿ̾
         & value=Var             , & ! intent(in) : 
         & history=vars_tmp1%gt_history   ) ! intent(inout) : GT_HISTORY

    call EndSub( subname, &
         & 'This is Just Output Step. ' // &
         & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
  end subroutine io_gt4_out_Put0Real


                                                                 !=begin
  !=== Put 3-Dimensional Double Precision Data to netCDF file
  !
  !ǽ ((< io_gt4_out_Put3Real >)) ȴŪƱ
  !ټ¿ 3 ΥǡϤ롣
  !
  subroutine io_gt4_out_Put3Double(varkey, xyz_Var)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : StepInterval, OutputStep, CurrentLoop
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : HistoryPut
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),      intent(in):: varkey         ! ѿ̾
    real(DBKIND),      intent(in):: xyz_Var(:,:,:) ! ϥǡ
                                                                 !=end
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    integer(INTKIND)              :: i, stat
    logical                       :: hit_vars_output = .false.
    type(VAR_INFO)                :: info
    integer(INTKIND)              :: StepIntervalTmp
    integer(INTKIND)              :: OutputStepTmp
    character(STRING),  parameter:: subname = "io_gt4_out_Put3Double"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Get Information from varinfo_mod about varkey.
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    if ( info%OutputStep < 1 ) then
       OutputStepTmp = OutputStep       ! in time_mod
    else
       OutputStepTmp = info%OutputStep  ! in varinfo_mod
    end if

    if ( mod(CurrentLoop, StepIntervalTmp) /= 0 ) then
       call EndSub( subname, &
            & 'This is not Output Step. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    if ( CurrentLoop > StepIntervalTmp * OutputStepTmp ) then
       call EndSub( subname, &
            & 'Already CurrentLoop exceed StepInterval*OutputStep. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    !-----------------------------------------------------------------
    !   Search vars_output for varkey's infomation.
    !-----------------------------------------------------------------
    hit_vars_output = .false.
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          call MessageNotify('E', subname, &
               &             message='Varkey is not found.')
       elseif ( allocated(vars_tmp1%varkeys) ) then
          do i = 1, size(vars_tmp1%varkeys)
             if ( varkey == vars_tmp1%varkeys(i) ) then
                hit_vars_output = .true.
             endif
             call DbgMessage('search vars_output [varkeys(%d)=<%c>, file=<%c>]', &
                  & i=(/i/)                                                 , &
                  & c1=trim( vars_tmp1%varkeys(i) )                         , &
                  & c2=trim( vars_tmp1%file )               )
             call DbgMessage('  hit_vars_output=<%b>', L=(/hit_vars_output/) )
          enddo
       endif

       if (hit_vars_output) exit
       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Output by HistoryPut [in gt4f90io]
    !-----------------------------------------------------------------
    call HistoryPut(                    &
         & varname=info%varinfo%name  , & ! intent(in) : ѿ̾
         & array=xyz_Var             , & ! intent(in) : 
         & history=vars_tmp1%gt_history   ) ! intent(inout) : GT_HISTORY

    call EndSub( subname, &
         & 'This is Just Output Step. ' // &
         & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
  end subroutine io_gt4_out_Put3Double


                                                                 !=begin
  !=== Put 2-Dimensional Double Precision Data to netCDF file
  !
  !ǽ ((< io_gt4_out_Put3Real >)) ȴŪƱ
  !ټ¿ 2 ΥǡϤ롣
  !
  subroutine io_gt4_out_Put2Double(varkey, xy_Var)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : StepInterval, OutputStep, CurrentLoop
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : HistoryPut
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),      intent(in):: varkey         ! ѿ̾
    real(DBKIND),      intent(in):: xy_Var(:,:) ! ϥǡ
                                                                 !=end
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    integer(INTKIND)              :: i, stat
    logical                       :: hit_vars_output = .false.
    type(VAR_INFO)                :: info
    integer(INTKIND)              :: StepIntervalTmp
    integer(INTKIND)              :: OutputStepTmp
    character(STRING),  parameter:: subname = "io_gt4_out_Put2Double"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Get Information from varinfo_mod about varkey.
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    if ( info%OutputStep < 1 ) then
       OutputStepTmp = OutputStep       ! in time_mod
    else
       OutputStepTmp = info%OutputStep  ! in varinfo_mod
    end if

    if ( mod(CurrentLoop, StepIntervalTmp) /= 0 ) then
       call EndSub( subname, &
            & 'This is not Output Step. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    if ( CurrentLoop > StepIntervalTmp * OutputStepTmp ) then
       call EndSub( subname, &
            & 'Already CurrentLoop exceed StepInterval*OutputStep. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    !-----------------------------------------------------------------
    !   Search vars_output for varkey's infomation.
    !-----------------------------------------------------------------
    hit_vars_output = .false.
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          call MessageNotify('E', subname, &
               &             message='Varkey is not found.')
       elseif ( allocated(vars_tmp1%varkeys) ) then
          do i = 1, size(vars_tmp1%varkeys)
             if ( varkey == vars_tmp1%varkeys(i) ) then
                hit_vars_output = .true.
             endif
             call DbgMessage('search vars_output [varkeys(%d)=<%c>, file=<%c>]', &
                  & i=(/i/)                                                 , &
                  & c1=trim( vars_tmp1%varkeys(i) )                         , &
                  & c2=trim( vars_tmp1%file )               )
             call DbgMessage('  hit_vars_output=<%b>', L=(/hit_vars_output/) )
          enddo
       endif

       if (hit_vars_output) exit
       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Output by HistoryPut [in gt4f90io]
    !-----------------------------------------------------------------
    call HistoryPut(                    &
         & varname=info%varinfo%name  , & ! intent(in) : ѿ̾
         & array=xy_Var             , & ! intent(in) : 
         & history=vars_tmp1%gt_history   ) ! intent(inout) : GT_HISTORY

    call EndSub( subname, &
         & 'This is Just Output Step. ' // &
         & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
  end subroutine io_gt4_out_Put2Double



                                                                 !=begin
  !=== Put 2-Dimensional Double Precision Data to netCDF file
  !
  !ǽ ((< io_gt4_out_Put3Real >)) ȴŪƱ
  !ټ¿ 2 ΥǡϤ롣
  !
  subroutine io_gt4_out_Put0Double(varkey, Var)
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use time_mod,    only : StepInterval, OutputStep, CurrentLoop
    use varinfo_mod, only : varinfo_inquire, VAR_INFO
    use gt4_history, only : HistoryPut
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
    use dc_message,  only : MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*),      intent(in):: varkey         ! ѿ̾
    real(DBKIND),      intent(in):: Var ! ϥǡ
                                                                 !=end
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    integer(INTKIND)              :: i, stat
    logical                       :: hit_vars_output = .false.
    type(VAR_INFO)                :: info
    integer(INTKIND)              :: StepIntervalTmp
    integer(INTKIND)              :: OutputStepTmp
    character(STRING),  parameter:: subname = "io_gt4_out_Put0Double"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname, 'varkey=<%c>', c1=trim(varkey) )
    if (.not. io_gt4_out_initialized) then
       call EndSub( subname, 'Call io_gt4_out_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   Get Information from varinfo_mod about varkey.
    !-----------------------------------------------------------------
    call varinfo_inquire    &
         &  (  varkey     , & ! intent(in) : ѿ
         &     info       , & ! intent(out): VAR_INFO ǡ
         &     stat      )    ! intent(out): ơ

    if (stat > 0) then
       call EndSub(subname, 'varkey=<%c> is not found in varinfo_mod', &
            &                c1=trim(varkey) )
       return
    endif

    !-----------------------------------------------------------------
    !   Check CurrentLoop in time_mod
    !-----------------------------------------------------------------
    if ( info%StepInterval < 1 ) then
       StepIntervalTmp = StepInterval       ! in time_mod
    else
       StepIntervalTmp = info%StepInterval  ! in varinfo_mod
    end if

    if ( info%OutputStep < 1 ) then
       OutputStepTmp = OutputStep       ! in time_mod
    else
       OutputStepTmp = info%OutputStep  ! in varinfo_mod
    end if

    if ( mod(CurrentLoop, StepIntervalTmp) /= 0 ) then
       call EndSub( subname, &
            & 'This is not Output Step. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    if ( CurrentLoop > StepIntervalTmp * OutputStepTmp ) then
       call EndSub( subname, &
            & 'Already CurrentLoop exceed StepInterval*OutputStep. ' // &
            & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
            & c1=trim(subname), &
            & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
       return
    end if

    !-----------------------------------------------------------------
    !   Search vars_output for varkey's infomation.
    !-----------------------------------------------------------------
    hit_vars_output = .false.
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          call MessageNotify('E', subname, &
               &             message='Varkey is not found.')
       elseif ( allocated(vars_tmp1%varkeys) ) then
          do i = 1, size(vars_tmp1%varkeys)
             if ( varkey == vars_tmp1%varkeys(i) ) then
                hit_vars_output = .true.
             endif
             call DbgMessage('search vars_output [varkeys(%d)=<%c>, file=<%c>]', &
                  & i=(/i/)                                                 , &
                  & c1=trim( vars_tmp1%varkeys(i) )                         , &
                  & c2=trim( vars_tmp1%file )               )
             call DbgMessage('  hit_vars_output=<%b>', L=(/hit_vars_output/) )
          enddo
       endif

       if (hit_vars_output) exit
       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Output by HistoryPut [in gt4f90io]
    !-----------------------------------------------------------------
    call HistoryPut(                    &
         & varname=info%varinfo%name  , & ! intent(in) : ѿ̾
         & value=Var             , & ! intent(in) : 
         & history=vars_tmp1%gt_history   ) ! intent(inout) : GT_HISTORY

    call EndSub( subname, &
         & 'This is Just Output Step. ' // &
         & '[CurrentLoop=<%d>, StepInterval=<%d>, OutputStep=<%d>]', &
         & c1=trim(subname), &
         & i=(/CurrentLoop, StepIntervalTmp, OutputStepTmp/) )
  end subroutine io_gt4_out_Put0Double


                                                                 !=begin
  !=== Terminate module
  !
  !((< io_gt4_out_init>)) ꤵ줿ͤ˴
  !ǥեȤ᤹ͤ
  !ޤHistoryClose ˤäơHistoryCreate б뽪λ
  !Ԥʤ
  !
  subroutine io_gt4_out_end
  !==== Dependency
    use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use gt4_history, only : HistoryClose
    use dc_trace,    only : SetDebug, BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    type(IO_GT4_OUT_VARS), pointer:: vars_tmp1
    character(STRING),  parameter:: subname = "io_gt4_out_end"
  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. io_gt4_out_initialized) then
       call EndSub( subname, 'io_gt4_out_init was not called', &
            &       c1=trim(subname) )
       return
    else
       io_gt4_out_initialized = .false.
    endif

    !-----------------------------------------------------------------
    !   HistoryClose [in gt4f90io] ˤ뽪λ
    !
    !   vars_output 11õĤĽλƤ
    !-----------------------------------------------------------------
    vars_tmp1 => vars_output%next
    do 
       if ( .not. associated(vars_tmp1) ) then
          exit
       elseif ( vars_tmp1%created ) then
          call HistoryClose(history=vars_tmp1%gt_history)
          vars_tmp1%created = .false.
       endif

       vars_tmp1 => vars_tmp1%next
    enddo

    !-----------------------------------------------------------------
    !   Initialize axes_store
    !-----------------------------------------------------------------
    if ( allocated(axes_store) ) then
       deallocate(axes_store)
    endif
    axes_store_used = .false.

    !-----------------------------------------------------------------
    !   Initialize vars_output
    !-----------------------------------------------------------------
    deallocate( vars_output )
    nullify( vars_output )
    vars_output_used = .false.

    !-----------------------------------------------------------------
    !   Initialize netCDF global attribute information
    !-----------------------------------------------------------------
    file_save         = 'result.nc'       ! ϥե̾ (ǥե)
    title_save        = 'GCM Test'        ! ȥ
    source_save       = 'DCPAM'           ! ǥ̾ ()
    institution_save  = 'GFD Dennou Club' ! ¹Լ̾ ()

    call EndSub(subname)
  end subroutine io_gt4_out_end

end module io_gt4_out_mod
