!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module grid_3d_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: grid_3d.f90,v 1.7 2005/01/19 08:52:30 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!This module set 3 Dimensional Grid Information.
!
!3 γʻԤΥ⥸塼Ǥ롣
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!⤷ȡ֣פȤȤǤϤʤ줾μʬ
!⥸塼ˤ٤Τʤ
!
                                                                 !=end

module grid_3d_mod
                                                                 !=begin
  !== Dependency
  use type_mod, only : INTKIND, STRING
                                                                 !=end
  implicit none

                                                                 !=begin
  !== Public Interface
  private
  public :: grid_3d_init, grid_3d_end ! subroutines
  public :: im, jm, km                ! variables
                                                                 !=end

  logical,          save :: grid_3d_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: grid_3d.f90,v 1.7 2005/01/19 08:52:30 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'
                                                                 !=begin
  !== Public Data
  !
  !grid_3d_init ˤͤꤵ롣ʲϥǥե͡
  !
  integer(INTKIND), save :: im = 64 , &  ! ʻ(X)
       &                    jm = 32 , &  ! ʻ(Y)
       &                    km = 12      ! ʻ(Y)
                                                                 !=end


contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !NAMELIST  x  y  z γʻ롣
  !Ǥʤ硢ޤϥʲͤͿ줿硢
  !嵭ΥǥեͤŪꤵ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  !
  subroutine grid_3d_init
  !
  !==== Dependency
  !
    use type_mod,   only: INTKIND
    use nmlfile_mod,only: nmlfile_init, nmlfile_open, nmlfile_close
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
    use dc_message, only: MessageNotify
                                                                 !=end
    implicit none

    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
    logical                     :: invalid_grid = .false.
    logical                     :: nmlreadable
    integer(INTKIND)            :: nmlunit, nmlstat
    character(STRING), parameter:: subname = "grid_3d_init"

                                                                 !=begin
    !==== NAMELIST
    !
    namelist /grid_3d_nml/ & 
         & im , &      ! ʻ
         & jm , &      ! ̳ʻ
         & km          ! ľʻ
                                                                 !=end
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (grid_3d_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       grid_3d_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read grid_3d_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=grid_3d_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST grid_3d_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=grid_3d_nml)
    else
       call DbgMessage('Not Read NAMELIST grid_3d_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST grid_3d_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    !----------------------------------------------------------------
    !   Exception handling
    !----------------------------------------------------------------
    invalid_grid = .false.
    if (im < 1) then
       im = 64 ; invalid_grid = .true.
    end if
    if (jm < 1) then
       jm = 32 ; invalid_grid = .true.
    end if
    if (km < 1) then
       km = 12 ; invalid_grid = .true.
    end if

    if (invalid_grid) then
       call MessageNotify('W', subname, &
            & 'Invalid grid number is exist. Force Set im=<%d>, jm=<%d>, km=<%d>', &
            & i=(/im, jm, km/) )
       call DbgMessage( &
            & 'Invalid grid number is exist. Force Set im=<%d>, jm=<%d>, km=<%d>', &
            & i=(/im, jm, km/) )
    endif

    call EndSub( subname, 'im=<%d>, jm=<%d>, km=<%d>', &
         &       i=(/im, jm, km/) )
  end subroutine grid_3d_init


                                                                 !=begin
  !=== Terminate module
  !
  !NAMELIST ɤ߹ͤ˴ǥեȤ᤹ͤ
  !
  subroutine grid_3d_end
  !==== Dependency
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none

    character(STRING), parameter:: subname = "grid_3d_end"

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. grid_3d_initialized) then
       call EndSub( subname, 'grid_3d_init was not called', &
            &       c1=trim(subname) )
       return
    else
       grid_3d_initialized = .false.
    endif

    !----------------------------------------------------------------
    !   Reset to default value
    !----------------------------------------------------------------
    im = 64
    jm = 32
    km = 12

    call EndSub( subname, 'im=<%d>, jm=<%d>, km=<%d>', &
         &       i=(/im, jm, km/) )
  end subroutine grid_3d_end

end module grid_3d_mod
