!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module dynamics_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: dynamics.f90,v 1.20 2005/01/22 09:30:59 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!Calculate Dynamical Core.
!
!ϳإʬ黻⥸塼롣黻Ƥϡ
!Υμˡϰʲ̤ꡣ
!
! *  : Governing Equations
!   * ɸץߥƥ :
!     Primitive Equations in Spherical Coordinate
!
! * ʿΥ : Horizontal Discretization
!   * ڥȥˡ : Spectral Method
!     * ѷ   : Triangle Truncation
!     * Ѵˡ       : Transform Method
!
! * ľΥ : Vertical Discretization
!   * Һɸ    : Sigma Coordinate (Arakawa and Suarez(1983))
!     * Lorenz ʻ : Lorenz Grid
!
! * ʬ : Time Integral
!   * leap frog : ꡼ץեå
!
!== Reference
!
!* Arakawa, A., Suarez, M. J., 1983:
!  Vertical differencing of the primitive equations
!  in sigma coordinates.
!  Mon. Wea. Rev., 111, 34--35.
!
!== Error Handling
!
!== Known Bugs
!
!* Ǵ׻ wa_NumVis_wa  wa_NumVisScaler_wa Ȥꤢ SPMODEL
!  ܿᡢ̾ΤʤɤΤޤޤǤ롣
!  ϥ⥸塼ΤΤȤ̾Τ¾θƤɬפǤ
!
!== Note
!
!== Future Plans
!
!ߡϳإƤΥ⥸塼ˤ롣ʤС
!μˤäƥ⥸塼벽ʤ٤Ǥ롣
!
                                                                 !=end
module dynamics_mod
                                                                 !=begin
  !== Dependency
  use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: dynamics_init, dynamics_leapfrog  ! subroutines
  public :: dynamics_diagnostic, dynamics_end ! subroutines
  public :: dynamics_diffusion                ! subroutines
                                                                 !=end

  !-------------------------------------------------------------------
  !   dynamics_init ˤͤꤹ
  !-------------------------------------------------------------------
  real(DBKIND) :: Kappa               ! =ҡã (/갵Ǯ)
  real(DBKIND), pointer, save :: &
    &
    & xy_Coli(:,:)       =>null() , & ! ʻǡ(ꥪ)
    & xy_UVFact(:,:)     =>null() , & ! uU, vV Υե
    & z_DelSigma(:)      =>null() , & ! (٥)
    &
    & wz_DiffVorDiv(:,:) =>null() , & ! ư (ȯ) ʿȻ
    & wz_DiffTherm(:,:)  =>null() , & ! Ǯ漾 ʿȻ
    &
    & z_TempAve(:)       =>null() , & ! ʿѲ (٥)
    & z_TempAveHalf(:)   =>null() , & ! ʿѲ (Ⱦ٥)
    &
    & z_HydroAlpha(:)    =>null() , & ! ſ尵μη 
    & z_HydroBeta(:)     =>null() , & ! ſ尵μη 
    & z_TempInpolKappa(:)=>null() , & ! ٱľ֤η
    & z_TempInpolA(:)    =>null() , & ! ٱľ֤η
    & z_TempInpolB(:)    =>null() , & ! ٱľ֤η
    &
    ! semi-implicitѹ
    & zz_DivMtx(:,:)   =>null() , & ! :ȯμǤβ 
    &                               !    (ȹθ)
    & zz_TempMtx(:,:)  =>null() , & ! : ѣ (Ұή) - 
    & zz_TempMtxQ(:,:) =>null() , & ! : d/d (ȹθ)
    & zz_TempMtxS(:,:) =>null() , & ! : d/d (ȹθ)
    & zz_TempMtxR(:,:) =>null()     ! : ң =
                                    !      ʣԡʢߦ/ߣܣ/ҡ
                                    !     Ѳθ̤η
                                    !     (ȹθ)


  !-------------------------------------------------------------------
  !   dynamics_leapfrog ˤѤ
  !-------------------------------------------------------------------
  real(DBKIND), pointer, save :: &
    &
    & xy_lnPs(:,:)   =>null() , & ! С ln s           (t)
    & xy_lnPs_T(:,:) =>null() , & ! ФλѲ d/dt   (t)
    & w_lnPs_T(:)    =>null() , & ! ФλѲ (ڥȥ) (t)
    & w_lnPs_a(:)    =>null() , & !  (t+t)
    &
    & xyz_lnPsAdv(:,:,:)    =>null() , & !  ΰή 
    & xyz_lnPsAdvSum(:,:,:) =>null() , & ! аήѲ [kK]()
    & xyz_DivSum(:,:,:)     =>null() , & ! ȯѲ [kK] Ħ
    & xyz_VSigmaHalf(:,:,:) =>null() , & ! ľ®(Ⱦ٥) (t)
    & xyz_VSigmaHalfNonG(:,:,:) => null() , & ! ľ® ʬ 
    &                                         !         (Ⱦ٥) (t)
    &
    & xyz_TempEdd(:,:,:)     =>null() , & ! ' ٤ξ (٥) (t)
    & xyz_TempEddHalf(:,:,:) =>null() , & ! ' ٤ξ (Ⱦ٥)(t)
    & xyz_TempVir(:,:,:)     =>null() , & ! v        (t)
    & xyz_TempVirEdd(:,:,:)  =>null() , & ! v'٤ξ (t)
    &
    & xyz_UA_T(:,:,:) =>null() , & ! ưѲգ
    & xyz_VA_T(:,:,:) =>null() , & ! ̱ưѲ֣
    &
    & wz_Vor_T(:,:)   =>null() , & ! ѲΥڥȥǡ (t)
    & wz_Vor_a(:,:)   =>null() , & ! ٤Υڥȥǡ    (t+t)
    &
    & xyz_KE(:,:,:)   =>null() , & ! ưͥ륮 + 
    &                              ! **2+**2    + (v-)
    & xy_Phi(:,:)     =>null() , & ! ɽݥƥ󥷥릵
    &
    & wz_Div_T(:,:) =>null() , & ! ȯΥڥȥǡ (t)
    & wz_Div_a(:,:) =>null() , & ! ȯΥڥȥǡ (t+t)
    & wz_PresTendTemp(:,:) =>null() , & ! ٤ˤ밵Ϸ٤Υڥȥǡ
    & wz_PresTendPs(:,:)   =>null() , & ! ɽϤˤ밵Ϸ٤Υڥȥǡ
    &
    & xyz_TempLocal_T(:,:,:) => null(), & ! ٤ζɽѲ  
    &                                     ! (ʿȯ ' + Ұή
    &                                     !  + Ѳθ) (ȹ)
    &
    & wz_Temp_T(:,:) =>null() , & ! ٤Ѳڥȥǡ (t)
    & wz_Temp_a(:,:) =>null() , & ! ٤Υڥȥǡ   (t+t)
    &
    & xyz_QVapDivVSigmaAdv(:,:,:) => null() , & ! ҡġܦҰή
    & wz_QVap_T(:,:) =>null() , & ! 漾Ѳڥȥǡ (t)
    & wz_QVap_a(:,:) =>null()     ! 漾Υڥȥǡ   (t+t)

  !-------------------------------------------------------------------
  !   dynamics_diagnostic Ƿ׻ѿ
  !-------------------------------------------------------------------
  real(DBKIND), pointer :: &
       & wz_Psi_a(:,:) =>null() , & ! ڥȥ(ήؿ)     (t+t)
       & wz_Chi_a(:,:) =>null()     ! ڥȥ(ݥƥ󥷥) (t+t)


  logical, save :: dynamics_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: dynamics.f90,v 1.20 2005/01/22 09:30:59 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and Calculate Non-Predictional Value.
  !
  !ʹߤΥ֥롼Ѥѿ allocate 
  !ȯŸʤ̤α黻Ԥʤ
  !ޤѿǡϤΤνԤʤ
  !
  subroutine dynamics_init(x_Lon, y_Lat, z_Sigma, r_Sigma)
  !==== Dependency
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use grid_3d_mod,         only: im, jm, km
    use grid_wavenumber_mod, only: nm
    use constants_mod, only: constants_init, R0, Omega, Cp, RAir, &
         &                   TempAve, VisOrder, EFoldTime
    use time_mod,    only: DelTime
    use spml_mod,    only: spml_init, xy_Lat, rn
    use io_gt4_out_mod,only: io_gt4_out_init, io_gt4_out_SetVars
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    use dc_string,   only: toChar
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & x_Lon(:)           , & ! intent(in): ٺɸ
         & y_Lat(:)           , & ! intent(in): ٺɸ
         & z_Sigma(:)         , & ! intent(in): ҥ٥()ɸ
         & r_Sigma(:)             ! intent(in): ҥ٥(Ⱦ)ɸ
                                                                 !=end

    !----- Ȼ׻ѿ -----
    real(DBKIND)          :: VisCoef             ! ĶǴ
    real(DBKIND), pointer :: wz_rn(:,:) =>null() ! ץ饷η -n*(n+1)

    !----- ѿ -----
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)   :: i, j, k, kk, l

    character(STRING),  parameter:: subname = "dynamics_init"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (dynamics_initialized) then
       call EndSub( subname, '%c is already called.', c1=trim(subname) )
       return
    else
       dynamics_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !-------------------------------------------------------------------
    !   ʪμ
    !-------------------------------------------------------------------
    call constants_init

    !-------------------------------------------------------------------
    !   SPMODEL ν
    !-------------------------------------------------------------------
    call spml_init

    !-------------------------------------------------------------------
    !   io_gt4_out ν
    !-------------------------------------------------------------------
    call io_gt4_out_init

    !-------------------------------------------------------------------
    !   ꥪϤ
    !-------------------------------------------------------------------
    allocate( xy_Coli(im, jm) )
    xy_Coli(:,:) = 2.0 * Omega * sin(xy_Lat(:,:))

!!$    call DataDump('xy_Coli', xy_Coli(:,:), strlen=80)
!!$    call DataDump('xy_Lat', xy_Lat(:,:), strlen=80)

    !-------------------------------------------------------------------
    !   uU, vV Υեη׻
    !-------------------------------------------------------------------
    allocate( xy_UVFact(im, jm) )
    xy_UVFact(:,:) = cos( xy_Lat(:,:) )

!!$    call DataDump('xy_UVFact', xy_UVFact(:,:), strlen=80)

    !-------------------------------------------------------------------
    !    (Ⱦ) η׻
    !-------------------------------------------------------------------
    allocate( z_DelSigma(km) )

    do k = 1, km
       z_DelSigma(k) = r_Sigma(k) - r_Sigma(k+1)
    enddo

!!$    call DataDump('z_Delsigma', z_DelSigma(:), strlen=80)

    !-------------------------------------------------------------------
    !   ư (ȯ) Ȼ wz_DiffVorDiv, 
    !   ǮȻ wz_DiffTherm η׻
    !-------------------------------------------------------------------
    allocate( wz_DiffVorDiv((nm+1)*(nm+1), km) )
    allocate( wz_DiffTherm ((nm+1)*(nm+1), km) )
    allocate( wz_rn        ((nm+1)*(nm+1), km) )

    do k = 1, km
       wz_rn(:,k) = rn(:,1)
    enddo

    ! Ǵη׻ (ȿ e-folding time  EFoldTime Ȥʤ褦)
    VisCoef = (   real(  ( nm*(nm+1) ), DBKIND  )  &
         &          / R0**2   )**(-VisOrder/2) &
         &     / EFoldTime

    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))

    wz_DiffTherm  =   &
         & - VisCoef * ( ( - wz_rn / R0**2 )**(VisOrder/2) )

    wz_DiffVorDiv = &
         & wz_DiffTherm  &
         &   - VisCoef                  &
         &      * (  - (2.0d0/R0**2)**(VisOrder/2)  )

!!$    call DataDump('wz_DiffTherm' , wz_DiffTherm,  strlen=80)
!!$    call DataDump('wz_DiffVorDiv', wz_DiffVorDiv, strlen=80)

    deallocate(wz_rn)


    !-------------------------------------------------------------------
    !   ſ尵μη¤η׻
    !-------------------------------------------------------------------
    allocate(z_HydroAlpha(km))
    allocate(z_HydroBeta(km))

    Kappa = RAir / Cp    ! =ҡã (/갵Ǯ)
    do k = 1, km
       z_HydroAlpha(k) = &
            & ( r_Sigma(k)/z_Sigma(k) )**Kappa - 1.0

       z_HydroBeta(k) = &
            & 1.0 - ( r_Sigma(k+1)/z_Sigma(k) )**Kappa
    enddo

!!$    call DbgMessage('Kappa=<%f>',  d=(/Kappa/) )
!!$    call DataDump('z_HydroAlpha', z_HydroAlpha(:), strlen=80)
!!$    call DataDump('z_HydroBeta', z_HydroBeta(:), strlen=80)

    !-------------------------------------------------------------------
    !   ٱľ֤ηᡢη׻
    !-------------------------------------------------------------------
    allocate(z_TempInpolA(km))
    allocate(z_TempInpolB(km))
    allocate(z_TempInpolKappa(km))

    do k = 1, km
       z_TempInpolA(k) = z_HydroAlpha(k) &
            & / ( 1.0 - (z_Sigma(k) / z_Sigma(k-1))**Kappa )

       z_TempInpolB(k) = z_HydroBeta(k) &
            & / ( (z_Sigma(k) / z_Sigma(k+1))**Kappa - 1.0 )

       z_TempInpolKappa(k) = &
            & ( &
            &    r_Sigma(k)   * z_HydroAlpha(k) &
            &  + r_Sigma(k+1) * z_HydroBeta(k)  &
            & ) / z_DelSigma(k)
    enddo
    z_TempInpolA(1) = 0.0
    z_TempInpolB(km) = 0.0

!!$    call DataDump('z_TempInpolA', z_TempInpolA(:), strlen=80)
!!$    call DataDump('z_TempInpolB', z_TempInpolB(:), strlen=80)
!!$    call DataDump('z_TempInpolKappa', z_TempInpolKappa(:), strlen=80)

    !-------------------------------------------------------------------
    !   ʿѲ (٥롢Ⱦ٥) η׻
    !-------------------------------------------------------------------
    allocate( z_TempAve(km) )
    allocate( z_TempAveHalf(km+1) )

    z_TempAve(:) = TempAve

    !----- üʿѲ -----
    !  ̯Ѥͤʤ褦
    z_TempAveHalf(:) = 0.0d0

    do k = 2, km
       z_TempAveHalf(k) = &
            &   z_TempInpolA(k)   * z_TempAve(k)   &
            & + z_TempInpolB(k-1) * z_TempAve(k-1)
    enddo

!!$    call DataDump('z_TempAve', z_TempAve(:), strlen=80)
!!$    call DataDump('z_TempAveHalf', z_TempAveHalf(:), strlen=80)


    !-------------------------------------------------------------------
    !   semi-implicit ѹη׻
    !-------------------------------------------------------------------
    allocate( zz_DivMtx(km,km) )
    allocate( zz_TempMtx(km,km) )
    allocate( zz_TempMtxQ(km,km) )
    allocate( zz_TempMtxS(km,km) )
    allocate( zz_TempMtxR(km,km) )

    ! :ȯμǤβ (ȹθ)

    ! 
    zz_DivMtx(:,:) = 0.0

    do k = 1, km
       do kk = 1, k
          zz_DivMtx(k, kk) = Cp * z_HydroAlpha(kk)
       enddo

       do kk = 1, k-1
          zz_DivMtx(k, kk) = zz_DivMtx(k, kk) + Cp * z_HydroBeta(kk)
       enddo
    enddo

    ! : d/d (ȹθ)

    ! 
    zz_TempMtxS(:,:) = 0.0

    do k = 1, km
       do kk = 1, km
          zz_TempMtxS(k,kk) = r_Sigma(k) * z_DelSigma(kk)
       enddo

       do kk = k, km
          zz_TempMtxS(k,kk) = zz_TempMtxS(k,kk) - z_DelSigma(kk)
       enddo

    enddo
!!$    call DataDump('zz_TempMtxS', zz_TempMtxS(:,:), strlen=80)

    ! : d/d (ȹθ)

    ! 
    zz_TempMtxQ(:,:) = 0.0

    do k = 1, km
       zz_TempMtxQ(k,k) = ( z_TempAveHalf(k) - z_TempAve(k) ) / z_DelSigma(k)
    enddo
    do k = 1, km - 1
       zz_TempMtxQ(k,k+1) = ( z_TempAve(k) - z_TempAveHalf(k+1) ) / z_DelSigma(k)
    enddo
!!$    call DataDump('zz_TempMtxQ', zz_TempMtxQ(:,:), strlen=80)

    ! : ң = ʣԡʢߦ/ߣܣ/ҡ
    !     Ѳθ̤η  (ȹθ)

    ! 
    zz_TempMtxR(:,:) = 0.0

    do k = 1, km
       do kk = k, km
          zz_TempMtxR(k,kk) = &
               & - z_HydroAlpha(k) / z_DelSigma(k) &
               &     * z_DelSigma(kk) * z_TempAve(k)
       enddo

       do kk = k+1, km
          zz_TempMtxR(k,kk) = zz_TempMtxR(k,kk)  &
               & - z_HydroBeta(k) / z_DelSigma(k)  &
               &     * z_DelSigma(kk) * z_TempAve(k)
       enddo
    enddo
!!$    call DataDump('zz_TempMtxR', zz_TempMtxR(:,:), strlen=80)

    ! : ѣ (Ұή) - 

    ! 
    zz_TempMtx(:,:) = 0.0

    zz_TempMtx(:,:) = &
         & matmul(zz_TempMtxQ(:,:), zz_TempMtxS(:,:)) - zz_TempMtxR(:,:)

!!$    call DataDump('zz_TempMtx', zz_TempMtx(:,:), strlen=80)

    !-------------------------------------------------------------------
    !   ǡѤν
    !-------------------------------------------------------------------
    call io_gt4_out_SetVars('xyz_DivSum')
    call io_gt4_out_SetVars('xyz_lnPsAdv')
    call io_gt4_out_SetVars('xyz_lnPsAdvSum')
    call io_gt4_out_SetVars('xyz_UA_T')
    call io_gt4_out_SetVars('xyz_VA_T')
    call io_gt4_out_SetVars('xyz_KE')
    call io_gt4_out_SetVars('xyz_PresTendTemp')
    call io_gt4_out_SetVars('xyz_PresTendPs')
    call io_gt4_out_SetVars('xyz_VSigmaHalf')
    call io_gt4_out_SetVars('xyz_VSigmaHalfNonG')
    call io_gt4_out_SetVars('xyz_TempLocal_T')
    call io_gt4_out_SetVars('xyz_TempAdv')
    call io_gt4_out_SetVars('xyz_TempEddHalf')
    call io_gt4_out_SetVars('xyz_Temp_T')
    call io_gt4_out_SetVars('xyz_TempLocal_T_lnPsAdvSum')

    call io_gt4_out_SetVars('TotalMass')

    call io_gt4_out_SetVars('xyz_Vor_Diffusion')
    call io_gt4_out_SetVars('xyz_Div_Diffusion')
    call io_gt4_out_SetVars('xyz_Temp_Diffusion')
    call io_gt4_out_SetVars('xyz_QVap_Diffusion')

    !-------------------------------------------------------------------
    !   dynamics_leapfrog Ƿ׻ѿ allocate 
    !-------------------------------------------------------------------
    allocate  & 
      & ( xy_lnPs (im, jm)          , & ! С ln s           (t)
      &   xyz_lnPsAdv(im, jm, km)   , & !  ΰή 
      &   xyz_lnPsAdvSum(im, jm, km), & ! аήѲ [kK]()
      &   xyz_DivSum(im, jm, km)    , & ! ȯѲ [kK] Ħ
      &
      &   xy_lnPs_T( im, jm )       , & ! ФλѲ d/dt   (t)
      &   w_lnPs_T( (nm+1)*(nm+1) ) , & ! ФλѲ (ڥȥ) (t)
      &   w_lnPs_a( (nm+1)*(nm+1) ) , & !  (t+t)
      &
      &   xyz_VSigmaHalf(im, jm, km+1) , & ! ľ®(Ⱦ٥) (t)
      &   xyz_VSigmaHalfNonG(im, jm, km+1) , & ! ľ® ʬ (Ⱦ٥) (t)
      &
      &   xyz_TempEdd(im, jm, km)   , & ! ' ٤ξ (٥) (t)
      &   xyz_TempVir(im, jm, km)   , & ! v  (virtual temperature)(t)
      &   xyz_TempVirEdd(im, jm, km ), &! v'٤ξ               (t)
      &   xyz_TempEddHalf(im, jm, km+1), &! ' ٤ξ (Ⱦ٥)   (t)
      &
      &   xyz_UA_T(im, jm, km)      , & ! ưѲգ
      &   xyz_VA_T(im, jm, km)      , & ! ̱ưѲ֣
      &
      &   wz_Vor_T( (nm+1)*(nm+1), km ) , & ! ѲΥڥȥǡ (t) 
      &   wz_Vor_a( (nm+1)*(nm+1), km ) , & ! ٤Υڥȥǡ    (t+t)
      &
      &   xyz_KE(im, jm, km)      , & ! ưͥ륮 + 
      &                               ! **2+**2    + (v-)
      &
      &   wz_Div_T( (nm+1)*(nm+1), km) , & ! ȯΥڥȥǡ (t)
      &   wz_Div_a( (nm+1)*(nm+1), km) , & ! ȯΥڥȥǡ (t+t)
      &   wz_PresTendTemp( (nm+1)*(nm+1), km) , & ! ٤ˤ밵Ϸ٤Υڥȥǡ
      &   wz_PresTendPs( (nm+1)*(nm+1), km) , & ! ɽϤˤ밵Ϸ٤Υڥȥǡ
      &
      &   xyz_TempLocal_T(im, jm, km)  , & ! ٤ζɽѲ  
      &                                    ! (ʿȯ ' + Ұή
      &                                    !  + Ѳθ) (ȹ)
      &
      &   wz_Temp_T( (nm+1)*(nm+1), km ) , & ! ٤Ѳڥȥǡ (t)
      &   wz_Temp_a( (nm+1)*(nm+1), km ) , & ! ٤Υڥȥǡ   (t+t)
      &
      &   xyz_QVapDivVSigmaAdv( im, jm, km), & ! ҡġܦҰή
      &   wz_QVap_T( (nm+1)*(nm+1), km) , & ! 漾Ѳڥȥǡ (t)
      &   wz_QVap_a( (nm+1)*(nm+1), km)   & ! 漾Υڥȥǡ   (t+t)
      & )


    !-------------------------------------------------------------------
    !   dynamics_diagnostic Ƿ׻ѿ allocate 
    !-------------------------------------------------------------------
    allocate  &
      & ( wz_Psi_a( (nm+1)*(nm+1), km) , & ! ڥȥ(ήؿ)
      &   wz_Chi_a( (nm+1)*(nm+1), km) )   ! ڥȥ(ݥƥ󥷥)


    call EndSub(subname)
  end subroutine dynamics_init


                                                                 !=begin
  !=== Calculate Predictional Values.
  !
  !ȯŸ̤α黻Ԥʤ
  !黻ǡνϤԤʤ
  !
  subroutine dynamics_leapfrog                                &
       & ( x_Lon       , y_Lat       , z_Sigma  , r_Sigma   , &
       &
       &   xyz_VelLon_b, xyz_VelLat_b, xyz_Vor_b, xyz_Div_b , &
       &   xyz_Temp_b  , xyz_QVap_b  , xy_Ps_b  ,             &
       &
       &   xyz_VelLon_n, xyz_VelLat_n, xyz_Vor_n, xyz_Div_n , &
       &   xyz_Temp_n  , xyz_QVap_n  , xy_Ps_n  ,             &
       &
       &   xyz_VelLon_a, xyz_VelLat_a, xyz_Vor_a, xyz_Div_a , &
       &   xyz_Temp_a  , xyz_QVap_a  , xy_Ps_a             )

  !==== Dependency
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use grid_3d_mod,         only: im, jm, km
    use grid_wavenumber_mod, only: nm
    use constants_mod, only: R0, Cp, EpsVT
    use time_mod,    only: DelTime, CurrentTime
    use spml_mod,    only: w_xy, xy_w , xy_GradLon_w, xy_GradLat_w, &
         &                 w_Div_xy_xy, w_LaplaInv_w,               &
         &                 wa_xya, xya_wa, wa_Div_xya_xya, wa_Lapla_wa
    use io_gt4_out_mod,only: io_gt4_out_Put
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    use dc_string,   only: toChar
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & x_Lon(:)          , & ! intent(in): ٺɸ
         & y_Lat(:)          , & ! intent(in): ٺɸ
         & z_Sigma(:)        , & ! intent(in): ҥ٥()ɸ
         & r_Sigma(:)        , & ! intent(in): ҥ٥(Ⱦ)ɸ
         &
         & xyz_VelLon_b(:,:,:) , & ! intent(in): ®ٷʬ (t-t)
         & xyz_VelLat_b(:,:,:) , & ! intent(in): ®ٰʬ (t-t)
         & xyz_Vor_b(:,:,:)    , & ! intent(in):          (t-t)
         & xyz_Div_b(:,:,:)    , & ! intent(in): ȯ         (t-t)
         & xyz_Temp_b(:,:,:)   , & ! intent(in):          (t-t)
         & xyz_QVap_b(:,:,:)   , & ! intent(in): 漾         (t-t)
         & xy_Ps_b(:,:)        , & ! intent(in): ɽ̵   (t-t)
         &
         & xyz_VelLon_n(:,:,:) , & ! intent(in): ®ٷʬ (t)
         & xyz_VelLat_n(:,:,:) , & ! intent(in): ®ٰʬ (t)
         & xyz_Vor_n(:,:,:)    , & ! intent(in):          (t)
         & xyz_Div_n(:,:,:)    , & ! intent(in): ȯ         (t)
         & xyz_Temp_n(:,:,:)   , & ! intent(in):          (t)
         & xyz_QVap_n(:,:,:)   , & ! intent(in): 漾         (t)
         & xy_Ps_n(:,:)            ! intent(in): ɽ̵   (t)

    !==== Output
    !
    real(DBKIND), intent(out) :: &
         & xyz_VelLon_a(:,:,:) , & ! intent(out): ®ٷʬ (t+t)
         & xyz_VelLat_a(:,:,:) , & ! intent(out): ®ٰʬ (t+t)
         & xyz_Vor_a(:,:,:)  , & ! intent(out):          (t+t)
         & xyz_Div_a(:,:,:)  , & ! intent(out): ȯ         (t+t)
         & xyz_Temp_a(:,:,:) , & ! intent(out):          (t+t)
         & xyz_QVap_a(:,:,:) , & ! intent(out): 漾         (t+t)
         & xy_Ps_a(:,:)          ! intent(out): ɽ̵   (t+t)
                                                                 !=end

    !----- ѿ -----
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)   :: i, j, k, kk, l


    character(STRING),  parameter:: subname = "dynamics_leapfrog"

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dynamics_initialized) then
       call EndSub( subname, 'Call dynamics_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    !-------------------------------------------------------------------
    !   ɽѲľ®٤η׻  (Ϣ³μǮμѤ)
    !-------------------------------------------------------------------

    xy_lnPs(:,:) = log( xy_Ps_n(:,:) )

    ! ɽ̵  ΰή = 
    do k = 1, km
       xyz_lnPsAdv(:,:,k) = &
            &  (  &
            &   xyz_VelLon_n(:,:,k)                         &
            &      * xy_GradLon_w( w_xy(xy_lnPs(:,:)) ) &
            &
            &   + xyz_VelLat_n(:,:,k)                       &
            &      * xy_GradLat_w( w_xy(xy_lnPs(:,:)) ) &
            &
            &  ) / R0
    enddo
    call io_gt4_out_Put('xyz_lnPsAdv', xyz_lnPsAdv(:,:,:))
!!$    call DataDump('xyz_lnPsAdv', xyz_lnPsAdv(:,:,:), strlen=80)


    ! аήѤ߲ [kK] () 
    xyz_lnPsAdvSum(:,:,km) = xyz_lnPsAdv(:,:, km ) * z_DelSigma( km )

    do k = km-1 , 1, -1
       xyz_lnPsAdvSum(:,:,k) = &
            &   xyz_lnPsAdvSum(:,:,k+1)          &
            & + xyz_lnPsAdv(:,:,k) * z_DelSigma(k)
    enddo
    call io_gt4_out_Put('xyz_lnPsAdvSum', xyz_lnPsAdvSum(:,:,:))
!!$    call DataDump('xyz_lnPsAdvSum', xyz_lnPsAdvSum(:,:,:), strlen=80)


    ! ȯѲ [kK] Ħ
    xyz_DivSum(:,:,km) = &
         & xyz_Div_n(:,:, km ) * z_DelSigma( km )

    do k = km -1 , 1, -1
       xyz_DivSum(:,:,k) = &
            &   xyz_DivSum(:,:,k+1)           &
            & + xyz_Div_n(:,:,k) * z_DelSigma(k)
    enddo

    call io_gt4_out_Put('xyz_DivSum', xyz_DivSum(:,:,:))
!!$    call DataDump('xyz_DivSum', xyz_DivSum(:,:,:), strlen=80)

    !-------------------------------------------------------------------
    !   Ps η׻Ϣ³μ
    !-------------------------------------------------------------------

    !-----  = lns λѲ d/dt η׻ -----
    !
    ! аήѤ߲ [1K] ()  ʻǲ򤯡
    !
    xy_lnPs_T(:,:) =                 &
         & - xyz_lnPsAdvSum(:,:,1)   ! - [1K]()

!!$    call DataDump('xy_lnPs_T', xy_lnPs_T(:,:), strlen=80)


    !----- ȯѤ߲ -[1K] Ħ 򥹥ڥȥ֤ǲä롣-----
    w_lnPs_T(:) = w_xy( xy_lnPs_T(:,:) ) - w_xy( xyz_DivSum(:,:,1) )

    !----- A = B + 2t * T-----
    w_lnPs_a(:) = &
         & w_xy(  log( xy_Ps_b(:,:) )  ) &
         & + 2.0*DelTime * ( w_lnPs_T(:) )

!!$    call DataDump('xy_Ps_b', xy_Ps_b(:,:), strlen=80)
!!$    call DataDump('w_lnPs_b', w_xy(  log( xy_Ps_b(:,:) )  ), strlen=80)
!!$    call DataDump('w_lnPs_a', w_lnPs_a(:), strlen=80)

    !----- xy_Ps_a -----
    xy_Ps_a(:,:) = exp(  xy_w( w_lnPs_a(:) )  )

!!$    call DataDump('xy_Ps_a', xy_Ps_a(:,:), strlen=80)

    !-------------------------------------------------------------------
    !   ľ® (Ⱦ٥) ξ徺ήη׻
    !-------------------------------------------------------------------

    ! ® (3/2  K-1/2)
    do k = 2, km+1 - 1
       xyz_VSigmaHalf(:,:,k) =  &
            &
            ! - [k-1/2]  ( [1K]( + ) )
            & r_Sigma(k) &
            &     * ( xyz_lnPsAdvSum(:,:,1) + xyz_DivSum(:,:,1) ) &
            &
            ! - [kK] ( + ) 
            & - ( xyz_lnPsAdvSum(:,:,k) + xyz_DivSum(:,:,k) )

       xyz_VSigmaHalfNonG(:,:,k) =  &
            &
            ! - [k-1/2]  ( [1K]() )
            & r_Sigma(k) * xyz_lnPsAdvSum(:,:,1) &
            &
            ! - [kK] () 
            & - xyz_lnPsAdvSum(:,:,k)
    enddo

    ! ® (1/2, K+1/2)
    xyz_VSigmaHalf(:,:,1) = 0.0
    xyz_VSigmaHalf(:,:,km+1) = 0.0
    xyz_VSigmaHalfNonG(:,:,1) = 0.0
    xyz_VSigmaHalfNonG(:,:,km+1) = 0.0

    call io_gt4_out_Put('xyz_VSigmaHalf', xyz_VSigmaHalf(:,:,:))
    call io_gt4_out_Put('xyz_VSigmaHalfNonG', xyz_VSigmaHalfNonG(:,:,:))
!!$    call DataDump('xyz_VSigmaHalf', xyz_VSigmaHalf(:,:,:), strlen=80)

    !-------------------------------------------------------------------
    !   ١٤δܾ줫Τ  (ʹߤ գգ֡ȤʤɤƤ)
    !-------------------------------------------------------------------
    do k = 1, km
       xyz_TempVir(:,:,k)   = xyz_Temp_n(:,:,k) &
            & * ( 1.0 + (EpsVT * xyz_QVap_n(:,:,k)) )

       xyz_TempEdd(:,:,k)   = xyz_Temp_n(:,:,k) - z_TempAve(k)
       xyz_TempVirEdd(:,:,k) = xyz_TempVir(:,:,k) - z_TempAve(k)

    enddo

!!$    call DataDump('xyz_Temp', xyz_Temp(:,:,:), strlen=80)
!!$    call DataDump('xyz_TempEdd', xyz_TempEdd(:,:,:), strlen=80)
!!$    call DataDump('xyz_TempVir', xyz_TempVir(:,:,:), strlen=80)
!!$    call DataDump('xyz_TempVirEdd', xyz_TempVirEdd(:,:,:), strlen=75)

    !-------------------------------------------------------------------
    !   Ⱦ٥β٤ξ  (ʹߤ գգ֡ȤʤɤƤ)
    !-------------------------------------------------------------------

    do k = 2, km+1 - 1
       xyz_TempEddHalf(:,:,k) = &
            &   z_TempInpolA(k)   * xyz_Temp_n(:,:,k)   &
            & + z_TempInpolB(k-1) * xyz_Temp_n(:,:,k-1) &
            & - z_TempAveHalf(k)
    enddo

    call io_gt4_out_Put('xyz_TempEddHalf', xyz_TempEddHalf(:,:,:))
!!$    call DataDump('xyz_TempEddHalf', xyz_TempEddHalf(:,:,:), strlen=80)

    !-------------------------------------------------------------------
    !   գ֦ơܦҰή֣զơܦҰή (٤ȯμ)
    !    AGCM5 Υޥ˥奢 գ ȰۤʤꡢUVFact = cosդ
    !      ݤäƤʤΤա
    !-------------------------------------------------------------------

    do k = 1, km
       xyz_UA_T(:,:,k) = &
            ! ( + ) 
            & ( xyz_Vor_n(:,:,k) + xy_Coli(:,:) ) * xyz_VelLat_n(:,:,k) &
            &
            ! - (p  (1/) 'v (d/d) ) / cos
            & - Cp * z_TempInpolKappa(k) &
            &           * xyz_TempVirEdd(:,:,k)  &
            &             * xy_GradLon_w(  w_xy( xy_lnPs(:,:) )  ) &
            &                / R0

       xyz_VA_T(:,:,k) = &
            ! - ( + ) 
            & - ( xyz_Vor_n(:,:,k) + xy_Coli(:,:) ) * xyz_VelLon_n(:,:,k) &
            &
            ! - (p  (1/) 'v (d/d) ) / cos
            & - Cp * z_TempInpolKappa(k) &
            &           * xyz_TempVirEdd(:,:,k) &
            &             * xy_GradLat_w(  w_xy( xy_lnPs(:,:) )  ) &
            &               / R0 
    enddo

!!$    do k = 1, km
!!$       call DataDump('xyz_Div(pi)', &
!!$            & xy_w( &
!!$            & w_Div_xy_xy( &
!!$            & - Cp * z_TempInpolKappa(k) &
!!$            &           * xyz_TempVirEdd(:,:,k)  &
!!$            &             * xy_GradLon_w(  w_xy( xy_lnPs(:,:) )  ) &
!!$            &                / R0 &
!!$            & , &
!!$            &
!!$            & - Cp * z_TempInpolKappa(k) &
!!$            &           * xyz_TempVirEdd(:,:,k) &
!!$            &             * xy_GradLat_w(  w_xy( xy_lnPs(:,:) )  ) &
!!$            &               / R0 &
!!$            &
!!$            &     )  &
!!$            &    ) / R0 &
!!$            &
!!$            & , strlen=80, multi=(/k/))
!!$    enddo

!!$    call DataDump('xyz_VelLon', xyz_VelLon(:,:,:), strlen=80)
!!$    call DataDump('xyz_VelLat', xyz_VelLat(:,:,:), strlen=80)
!!$    call DataDump('xyz_VA_T', xyz_VA_T(1,1,:), strlen=80, multi=(/-1/))
!!$    call DataDump('xyz_UA_T', xyz_UA_T(1,1,:), strlen=80, multi=(/-1/))
!!$    call DataDump('xyz_VA_T', xyz_VA_T(1,1,:), strlen=80, multi=(/-1/))

    do k = 2, km

       xyz_UA_T(:,:,k) = xyz_UA_T(:,:,k) &
            ! - (1/2[k]) * (d/dt)[k-1/2] * ([k-1] - [k])
            & - 1.0 / (2.0 * z_DelSigma(k)) &
            &    * xyz_VSigmaHalf(:,:,k)  &
            &       * ( xyz_VelLon_n(:,:,k-1) - xyz_VelLon_n(:,:,k) )

       xyz_VA_T(:,:,k) = xyz_VA_T(:,:,k) &
            ! - (1/2[k]) * (d/dt)[k-1/2] * ([k-1] - [k])
            & - 1.0 / (2.0 * z_DelSigma(k)) &
            &    * xyz_VSigmaHalf(:,:,k)  &
            &       * ( xyz_VelLat_n(:,:,k-1) - xyz_VelLat_n(:,:,k) )
    enddo

!!$    call DataDump('xyz_UA_T', xyz_UA_T(1,1,:), strlen=80, multi=(/-2/))
!!$    call DataDump('xyz_VA_T', xyz_VA_T(1,1,:), strlen=80, multi=(/-2/))

    do k = 1, km - 1

       xyz_UA_T(:,:,k) = xyz_UA_T(:,:,k) &
            ! - (1/2[k]) * (d/dt)[k+1/2] * ([k] - [k+1])
            & - 1.0 / (2.0 * z_DelSigma(k)) &
            &    * xyz_VSigmaHalf(:,:,k+1) &
            &       * ( xyz_VelLon_n(:,:,k) - xyz_VelLon_n(:,:,k+1) )

       xyz_VA_T(:,:,k) = xyz_VA_T(:,:,k) &
            ! - (1/2[k]) * (d/dt)[k+1/2] * ([k] - [k+1])
            & - 1.0 / (2.0 * z_DelSigma(k)) &
            &    * xyz_VSigmaHalf(:,:,k+1)  &
            &       * ( xyz_VelLat_n(:,:,k) - xyz_VelLat_n(:,:,k+1) )
    enddo

!!$    call DataDump('xyz_UA_T', xyz_UA_T(1,1,:), strlen=80, multi=(/-3/))
!!$    call DataDump('xyz_VA_T', xyz_VA_T(1,1,:), strlen=80, multi=(/-3/))

!!$    call DataDump('xyz_UA_T', xyz_UA_T(:,:,:), strlen=80)
!!$    call DataDump('xyz_VA_T', xyz_VA_T(:,:,:), strlen=80)

    call io_gt4_out_Put('xyz_UA_T', xyz_UA_T(:,:,:))
    call io_gt4_out_Put('xyz_VA_T', xyz_VA_T(:,:,:))

    !-------------------------------------------------------------------
    !    Vor η׻
    !-------------------------------------------------------------------

    ! d/dt η׻
    wz_Vor_T(:,:) = &
         & wa_Div_xya_xya( xyz_VA_T(:,:,:), - xyz_UA_T(:,:,:) ) / R0
         !& + w_DiffV(k) * wa_xya(xyz_Vor(:,:,k))
         !  ȻƳФʤΤǸ

    !----- A = B + 2t * T-----
    wz_Vor_a(:,:) = &
         & wa_xya( xyz_Vor_b(:,:,:) )              &
         & + 2.0d0*DelTime * ( wz_Vor_T(:,:) )
!!!         & + 2.0d0*DelTime * wa_NumVis_wa(  wa_xya( xyz_Vor_b(:,:,:) )  )


    !----- xyz_Vor_a -----
    xyz_Vor_a(:,:,:) = xya_wa( wz_Vor_a(:,:) )

!!$    call DataDump('wz_Vor_T', wz_Vor_T(:,:), strlen=70)
!!$    call DataDump('xyz_Vor_b', xyz_Vor_b(:,:,:), strlen=80)
!!$    call DataDump('xyz_Vor', xyz_Vor(:,:,:), strlen=80)
!!$    call DataDump('xyz_Vor_T', xya_wa(wz_Vor_T(:,:)), strlen=80)
!!$    call DataDump('xyz_Vor_a', xyz_Vor_a(:,:,:), strlen=80)

    !-------------------------------------------------------------------
    !   =**2+**2 +  ( (v-) )  (ȯμ)
    !-------------------------------------------------------------------

    !  ( (v-) ) η׻ʻѤ߾夲

    ! 
    xyz_KE(:,:,:) = 0.0

    xyz_KE(:,:,1) = Cp * z_HydroAlpha(1) &
         & * ( xyz_TempVir(:,:,1) - xyz_Temp_n(:,:,1) )

    do k = 2, km
       xyz_KE(:,:,k) = xyz_KE(:,:,k-1)   &
            & + Cp * z_HydroAlpha(k) &
            &     * ( xyz_TempVir(:,:,k) - xyz_Temp_n(:,:,k) ) &
            & + Cp * z_HydroBeta(k-1) &
            &     * ( xyz_TempVir(:,:,k-1) - xyz_Temp_n(:,:,k-1) )
    enddo

!!$    call DataDump('xyz_Temp', xyz_Temp(:,:,:), strlen=80)
!!$    call DataDump('xyz_TempVir', xyz_TempVir(:,:,:), strlen=80)
!!$    call DataDump('xyz_KE-w(Tv-T)', xyz_KE(:,:,:), strlen=80)

    ! ưͥ륮 **2+**2 βû

    xyz_KE(:,:,:) = xyz_KE(:,:,:) &
         & + ( &
         &     xyz_VelLon_n(:,:,:)**2   &
         &     + xyz_VelLat_n(:,:,:)**2 &
         &   ) / 2.0

!!$    call DataDump('xyz_KE-u**2+v**2', xyz_KE(:,:,:), strlen=80)
    call io_gt4_out_Put('xyz_KE', xyz_KE(:,:,:))

    !-------------------------------------------------------------------
    !   ȯ Div η׻ȯ
    !-------------------------------------------------------------------

    ! ף = p  [k] + p  [k-1] 򥹥ڥȥ֤Ѥ߾夲

    ! 
    wz_PresTendTemp(:,:) = 0.0

    wz_PresTendTemp(:,1) = Cp * z_HydroAlpha(1) * w_xy( xyz_Temp_n(:,:,1) )

    do k = 2, km
       wz_PresTendTemp(:,k) = wz_PresTendTemp(:,k-1) &
            & + Cp * z_HydroAlpha(k)  * w_xy( xyz_Temp_n(:,:,k) )   &
            & + Cp * z_HydroBeta(k-1) * w_xy( xyz_Temp_n(:,:,k-1) )
    enddo

!!$    call io_gt4_out_Put('xyz_PresTendTemp', xya_wa(wa_Lapla_wa(wz_PresTendTemp(:,:)))/R0**2)


!!$    call DataDump('wz_PresTendTemp', wz_PresTendTemp(:,:), strlen=70)
!!$    call DataDump('xyz_Lapla(wz_PresTendTemp)/R0**2', &
!!$         & xya_wa(  wa_Lapla_wa( wz_PresTendTemp(:,:) )  )/R0**2, strlen=60)


    ! Ǧ = (p  ) 
    do k = 1, km
       wz_PresTendPs(:,k) = &
            & Cp * z_TempInpolKappa(k) * z_TempAve(k) &
            &   * w_xy(  log( xy_Ps_n(:,:) )  )
    enddo

!!$    call io_gt4_out_Put('xyz_PresTendPs', xya_wa(wa_Lapla_wa(wz_PresTendPs(:,:)))/R0**2)

!!$    call DataDump('wz_PresTendPs', wz_PresTendPs(:,:), strlen=70)
!!$    call DataDump('xyz_Lapla(wz_PresTendPs)/R0**2', &
!!$         & xya_wa(  wa_Lapla_wa( wz_PresTendPs(:,:) )  )/R0**2, strlen=60)

!!$    call DataDump('Div(wz_UA_T - wz_VA_T)', &
!!$         & wa_Div_xya_xya( xyz_UA_T(:,:,:), - xyz_VA_T(:,:,:) ), &
!!$         & strlen=70)
!!$    call DataDump('Div(wz_UA_T - wz_VA_T)/R0', &
!!$         & wa_Div_xya_xya( xyz_UA_T(:,:,:), - xyz_VA_T(:,:,:) ) /R0, &
!!$         & strlen=70)
!!$    call DataDump('xyz_Div(wz_UA_T - wz_VA_T)/R0', &
!!$         & xya_wa(  wa_Div_xya_xya( xyz_UA_T(:,:,:), - xyz_VA_T(:,:,:) )  ) /R0, &
!!$         & strlen=70)
!!$    call DataDump('Lapla(wz_KE)', &
!!$         & wa_Lapla_wa( wa_xya(xyz_KE(:,:,:)) ), strlen=70)

    ! d/dt η׻
    wz_Div_T(:,:) = &
         & wa_Div_xya_xya( xyz_UA_T(:,:,:), xyz_VA_T(:,:,:) ) / R0 &
         & - wa_Lapla_wa( wa_xya(xyz_KE(:,:,:)) ) / R0**2 &
         !& + w_DiffV(k) * wa_xya(xyz_Div(:,:,k))
         !  ȻƳФʤΤǸ
         &
         ! semi-implicitȤˤ̵ã
         !  - **2 ( + ף + Ǧ)
         & - wa_Lapla_wa( &
         !&    w_xy( xy_Phi(:,:) )  &  ! ɽݥƥ󥷥릵ϸ
         &    wz_PresTendTemp(:,:)   & ! ף
         &    + wz_PresTendPs(:,:)   & ! Ǧ = (p  )
         &   ) / R0**2

    !----- A = B + 2t * T-----
    wz_Div_a(:,:) = &
         & wa_xya( xyz_Div_b(:,:,:) )          &
         & + 2.0d0*DelTime * ( wz_Div_T(:,:) )
!!!         & + 2.0d0*DelTime * wa_NumVis_wa(  wa_xya( xyz_Div_b(:,:,:) )  )

    !----- xyz_Div_a -----
    xyz_Div_a(:,:,:) = xya_wa( wz_Div_a(:,:) )

!!$    call DataDump('xyz_Div_b', xyz_Div_b(:,:,:), strlen=80)
!!$    call DataDump('xyz_Div', xyz_Div(:,:,:), strlen=80)
!!$    call DataDump('xyz_Div_T', xya_wa(wz_Div_T(:,:)), strlen=80)
!!$    call DataDump('xyz_Div_a', xyz_Div_a(:,:,:), strlen=80)


    !-------------------------------------------------------------------
    !   ȡʿȯ ' + Ұή + Ѳθ  (Ǯϳؤμ)
    !-------------------------------------------------------------------

    ! ٤ζɽѲ   η׻
    do k = 1, km
       xyz_TempLocal_T(:,:,k) = &
            &
            ! ' 
            & xyz_TempEdd(:,:,k) * xyz_Div_n(:,:,k) &
            &
            ! ʣv ()  : Фΰήθ
            & + z_TempInpolKappa(k) * xyz_TempVir(:,:,k)  &
            &    * xyz_lnPsAdv(:,:,k)                   &
            &
            ! - (/) {v [kK] () + v' [kK] (Ħ)}
            & - z_HydroAlpha(k) / z_DelSigma(k)                 &
            &    * (                                            &
            &       xyz_TempVir(:,:,k) * xyz_lnPsAdvSum(:,:,k)  &
            &       + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k) &
            &      )
    enddo

    do k = 2, km
       xyz_TempLocal_T(:,:,k) = xyz_TempLocal_T(:,:,k) &
            &
            ! - (d/dt) * (/) * ('[k-1/2]  '[k])
            & - xyz_VSigmaHalf(:,:,k) / z_DelSigma(k)               &
            &     * ( xyz_TempEddHalf(:,:,k) - xyz_TempEdd(:,:,k) ) &
            &
            ! - (d/dt)^NG * (/) * (ԡ[k-1/2]  ԡ[k])
            & - xyz_VSigmaHalfNonG(:,:,k) / z_DelSigma(k)           &
            &     * ( z_TempAveHalf(k) - z_TempAve(k) )
    enddo

    do k = 1, km - 1
       xyz_TempLocal_T(:,:,k) = xyz_TempLocal_T(:,:,k) &
            &
            ! - (d/dt) * (/) * ('[k]  '[k+1/2])
            & - xyz_VSigmaHalf(:,:,k+1) / z_DelSigma(k)               &
            &     * ( xyz_TempEdd(:,:,k) - xyz_TempEddHalf(:,:,k+1) ) &
            &
            ! - (d/dt)^NG * (/) * (ԡ[k]  ԡ[k+1/2])
            & - xyz_VSigmaHalfNonG(:,:,k+1) / z_DelSigma(k)           &
            &     * ( z_TempAve(k) - z_TempAveHalf(k+1) )             &
            &
            ! - (/) {   v  [k+1K] ()
            !               + v' [k+1K] (Ħ)}
            & - z_HydroBeta(k) / z_DelSigma(k)                        &
            &    * (                                                  &
            &       xyz_TempVir(:,:,k) * xyz_lnPsAdvSum(:,:,k+1)      &
            &       + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k+1)     &
            &      )
    enddo

!!$    call io_gt4_out_Put('xyz_TempLocal_T_lnPsAdvSum',             &
!!$            & - z_HydroAlpha(2) / z_DelSigma(2)                   &
!!$            &    * (                                              &
!!$            &       xyz_TempVir(:,:,2) * xyz_lnPsAdvSum(:,:,2)    &
!!$            &      )                                              &
!!$            & - z_HydroBeta(2) / z_DelSigma(2)                    &
!!$            &    * (                                              &
!!$            &       xyz_TempVir(:,:,2) * xyz_lnPsAdvSum(:,:,2+1)  &
!!$            &      )                                              &
!!$            & )


!!$    call DataDump('xyz_DivSum*TempVirEdd*(Alpha+Beta)', &
!!$            & - z_HydroAlpha(k) / z_DelSigma(k)                    &
!!$            &    * ( xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k) )   &
!!$            & - z_HydroBeta(k) / z_DelSigma(k)                     &
!!$            &    * ( xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k+1) ) &
!!$            & , strlen=70)

!!$    call DataDump('xyz_TempLocal_T', xyz_TempLocal_T(:,:,:), strlen=80)
    call io_gt4_out_Put('xyz_TempLocal_T',  xyz_TempLocal_T(:,:,:))


    !-------------------------------------------------------------------
    !   գ' ֣'   (Ǯϳؤμ)
    !-------------------------------------------------------------------
!!$      DO 5100 K = 1, KMAX
!!$         DO 5100 IJ = 1, IDIM*JDIM
!!$            GTUT( IJ,K ) =  GAU ( IJ,K ) * GATED ( IJ,K )
!!$     &                                   * UVFACT ( IJ )
!!$            GTVT( IJ,K ) =  GAV ( IJ,K ) * GATED ( IJ,K )
!!$     &                                   * UVFACT ( IJ )
!!$ 5100 CONTINUE

    !-------------------------------------------------------------------
    !     η׻Ǯϳؤμ
    !-------------------------------------------------------------------

    ! ȹʬ () ʬ˴ؤ벹Ѳ׻
    do k = 1, km
       wz_Temp_T(:,k) = &
            &
            ! dգ'/d + d֣'/d
            & - w_Div_xy_xy( &
            &               xyz_VelLon_n(:,:,k) * xyz_TempEdd(:,:,k), &
            &               xyz_VelLat_n(:,:,k) * xyz_TempEdd(:,:,k)  &
            &              ) / R0                                 &
            &
            ! ٤ζɽѲ 
            & + w_xy( xyz_TempLocal_T(:,:,k) )
            !&
            ! ǮǮ  ޤäƤʤ
            !&
            ! ໤ǮǮȻϸ
    enddo

!!$    call DataDump('xyz_Temp_T_NonGrav', xya_wa(wz_Temp_T(:,:)), strlen=70)


    ! ȹʬ () ʬ˴ؤ벹Ѳ׻
    do k = 1, km
       do kk = 1, km
          wz_Temp_T(:,k) = wz_Temp_T(:,k) &
               &
               !  (ȹʬˤѲθ)
               & - zz_TempMtx(k,kk) * w_xy( xyz_Div_n(:,:,kk) )
               !&
               ! Ȼϸ
       enddo
    enddo


    !----- A = B + 2t * T-----
    wz_Temp_a(:,:) = &
         & wa_xya( xyz_Temp_b(:,:,:) )          &
         & + 2.0d0*DelTime * ( wz_Temp_T(:,:) )
!!!         & + 2.0d0*DelTime * wa_NumVisScaler_wa(  wa_xya( xyz_Temp_b(:,:,:) )  )

    !----- xyz_Temp_a -----
    xyz_Temp_a(:,:,:) = xya_wa( wz_Temp_a(:,:) )


    call io_gt4_out_Put(  'xyz_Temp_T', xya_wa( wz_Temp_T(:,:) )  )
!!$    call DataDump('xyz_Temp_b', xyz_Temp_b(:,:,:), strlen=80)
!!$    call DataDump('xyz_Temp', xyz_Temp(:,:,:), strlen=80)
!!$    call DataDump('xyz_Temp_T', xya_wa(wz_Temp_T(:,:)), strlen=80)
!!$    call DataDump('xyz_Temp_a', xyz_Temp_a(:,:,:), strlen=80)

    !-------------------------------------------------------------------
    !   漾 QVap η׻μ򤯡
    !-------------------------------------------------------------------

    ! ҡġܦҰή (ȹ) ʻǷ׻
    xyz_QVapDivVSigmaAdv(:,:,:) = xyz_QVap_n(:,:,:) * xyz_Div_n(:,:,:)

    do k = 2, km
       xyz_QVapDivVSigmaAdv(:,:,k) = xyz_QVapDivVSigmaAdv(:,:,k) &
            & - xyz_VSigmaHalf(:,:,k) / ( 2.0 * z_DelSigma(k) )  &
            &      * ( xyz_QVap_n(:,:,k-1)  - xyz_QVap_n(:,:,k) )
    enddo

    do k = 1, km - 1
       xyz_QVapDivVSigmaAdv(:,:,k) = xyz_QVapDivVSigmaAdv(:,:,k)  &
            & - xyz_VSigmaHalf(:,:,k+1) / ( 2.0 * z_DelSigma(k) ) &
            &      * ( xyz_QVap_n(:,:,k) - xyz_QVap_n(:,:,k+1) )
    enddo

    ! ʿή dգ/d + d֣/d ȿʿȻࡢ׻
    do k = 1, km
       wz_QVap_T(:,k) = &
            &
            ! dգ/d + d֣/d
            & - w_Div_xy_xy( &
            &               xyz_VelLon_n(:,:,k) * xyz_QVap_n(:,:,k), &
            &               xyz_VelLat_n(:,:,k) * xyz_QVap_n(:,:,k)  &
            &              ) / R0                              &
            &
            ! ҡġܦҰή
            & + w_xy( xyz_QVapDivVSigmaAdv(:,:,k) )
            !&
            ! ʿȻࡢϸ
    enddo

    !----- A = B + 2t * T-----
    wz_QVap_a(:,:) = &
         & wa_xya( xyz_QVap_b(:,:,:) )          &
         & + 2.0d0*DelTime * ( wz_QVap_T(:,:) )
!!!         & + 2.0d0*DelTime * wa_NumVisScaler_wa(  wa_xya( xyz_QVap_b(:,:,:) )  )

    !----- xyz_QVap_a -----
    xyz_QVap_a(:,:,:) = xya_wa( wz_QVap_a(:,:) )

!!$    call DataDump('xyz_QVap_b', xyz_QVap_b(:,:,:), strlen=80)
!!$    call DataDump('xyz_QVap', xyz_QVap(:,:,:), strlen=80)
!!$    call DataDump('xyz_QVap_T', xya_wa(wz_QVap_T(:,:)), strlen=80)
!!$    call DataDump('xyz_QVap_a', xyz_QVap_a(:,:,:), strlen=80)

    call EndSub(subname)
  end subroutine dynamics_leapfrog


                                                                 !=begin
  !=== Calculate Diffusion Term
  !
  !t-t ͤʿȻᡢ t+t ͤ˲ä롣
  !
  subroutine dynamics_diffusion(                         &
    & xyz_Vor_b , xyz_Div_b , xyz_Temp_b , xyz_QVap_b  , &
    & xyz_Vor_a , xyz_Div_a , xyz_Temp_a , xyz_QVap_a        )

  !==== Dependency
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use time_mod,    only: DelTime, CurrentTime
    use grid_3d_mod, only: km
    use grid_wavenumber_mod, only: nm
    use spml_mod,    only: wa_xya, xya_wa, l_nm
    use io_gt4_out_mod,only: io_gt4_out_Put
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & xyz_Vor_b(:,:,:)  , & !  (t-t)
         & xyz_Div_b(:,:,:)  , & ! ȯ (t-t)
         & xyz_Temp_b(:,:,:) , & !  (t-t)
         & xyz_QVap_b(:,:,:)     ! 漾 (t-t)

    !==== In/Out
    !
    real(DBKIND), intent(inout) :: &
         & xyz_Vor_a(:,:,:)  , & !  (t+t)
         & xyz_Div_a(:,:,:)  , & ! ȯ (t+t)
         & xyz_Temp_a(:,:,:) , & !  (t+t)
         & xyz_QVap_a(:,:,:)     ! 漾 (t+t)
                                                                 !=end

    real(DBKIND)    :: &
         & wz_Vor_a((nm+1)**2, km)  , & !  (t+t)
         & wz_Div_a((nm+1)**2, km)  , & ! ȯ (t+t)
         & wz_Temp_a((nm+1)**2, km) , & !  (t+t)
         & wz_QVap_a((nm+1)**2, km)     ! 漾 (t+t)
    integer(INTKIND) :: i
    character(STRING),  parameter:: subname = "dynamics_diffusion"
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dynamics_initialized) then
       call EndSub( subname, 'Call dynamics_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    !-------------------------------------------------------------------
    !   줾̤γȻ׻
    !-------------------------------------------------------------------
    xyz_Vor_a  = &
         & xya_wa(  &
         &    wa_xya(xyz_Vor_a) &
         &    + 2.0d0*DelTime   &
         &      * wz_DiffVorDiv * wa_xya( xyz_Vor_b ) &
         & )

!!$    call io_gt4_out_Put('xyz_Vor_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffVorDiv * wa_xya( xyz_Vor_b )  )    )

    xyz_Div_a  = &
         & xya_wa(  &
         &    wa_xya(xyz_Div_a) &
         &    + 2.0d0*DelTime   &
         &      * wz_DiffVorDiv * wa_xya( xyz_Div_b ) &
         & )

!!$    call io_gt4_out_Put('xyz_Div_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffVorDiv * wa_xya( xyz_Div_b )   )    )

    xyz_Temp_a  = &
         & xya_wa(  &
         &    wa_xya(xyz_Temp_a) &
         &    + 2.0d0*DelTime    &
         &      * wz_DiffTherm * wa_xya( xyz_Temp_b )  &
         & )

!!$    call io_gt4_out_Put('xyz_Temp_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffTherm * wa_xya( xyz_Temp_b )   )    )

    xyz_QVap_a  = &
         & xya_wa(  &
         &    wa_xya(xyz_QVap_a) &
         &    + 2.0d0*DelTime    &
         &      * wz_DiffTherm * wa_xya( xyz_QVap_b )  &
         & )

!!$    call io_gt4_out_Put('xyz_QVap_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffTherm * wa_xya( xyz_QVap_b )   )   )


    ! ڥȥǡȤƸƳȻƤ뤫ǧ뤿
    ! ǡϤ򵭽Ҥܷ׻ˤϤޤäɬפǤʤ
    !!wz_Vor_a  = wa_xya(xyz_Vor_a )
    !!wz_Div_a  = wa_xya(xyz_Div_a )
    !!wz_Temp_a = wa_xya(xyz_Temp_a)
    !!wz_QVap_a = wa_xya(xyz_QVap_a)
    !!
    !!write(80, *) CurrentTime, &
    !!     &       wz_Vor_a( l_nm(21,0), 1) , wz_Div_a( l_nm(21,0), 1) , &
    !!     &       wz_Temp_a( l_nm(21,0), 1) , wz_QVap_a( l_nm(21,0), 1)
    !!call flush(80)

    call EndSub(subname)
  end subroutine dynamics_diffusion


                                                                 !=begin
  !=== Calculate Diagnostic Values.
  !
  !Ṳ̄α黻Ԥʤ
  !ߤϱȯ®ʬ () α黻ԤʤΤߤǤ롣
  !
  subroutine dynamics_diagnostic                              &
       & ( x_Lon       , y_Lat       , z_Sigma  , r_Sigma   , &
       &
       &   xyz_VelLon_a, xyz_VelLat_a, xyz_Vor_a, xyz_Div_a , &
       &   xyz_Temp_a  , xyz_QVap_a  , xy_Ps_a               )

  !==== Dependency
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use grid_3d_mod,         only: im, jm, km
    use grid_wavenumber_mod, only: nm
    use constants_mod, only: R0, Grav
    use spml_mod,    only: wa_xya, xya_GradLon_wa, xya_GradLat_wa, &
         &                 wa_LaplaInv_wa, IntLonLat_xy
    use io_gt4_out_mod,only: io_gt4_out_Put
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    use dc_string,   only: toChar
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & x_Lon(:)          , & ! intent(in): ٺɸ
         & y_Lat(:)          , & ! intent(in): ٺɸ
         & z_Sigma(:)        , & ! intent(in): ҥ٥()ɸ
         & r_Sigma(:)    , & ! intent(in): ҥ٥(Ⱦ)ɸ
         &
         & xyz_Vor_a(:,:,:)  , & ! intent(in):          (t+t)
         & xyz_Div_a(:,:,:)  , & ! intent(in): ȯ         (t+t)
         & xyz_Temp_a(:,:,:) , & ! intent(in):          (t+t)
         & xyz_QVap_a(:,:,:) , & ! intent(in): 漾         (t+t)
         & xy_Ps_a(:,:)          ! intent(in): ɽ̵   (t+t)

    !==== In/Output
    !
    real(DBKIND), intent(out) :: &
         & xyz_VelLon_a(:,:,:) , & ! intent(out): ®ٷʬ (t+t)
         & xyz_VelLat_a(:,:,:)     ! intent(out): ®ٰʬ (t+t)
                                                                 !=end

    real(DBKIND) :: TotalMass      ! 

    !----- ѿ -----
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)   :: i, j, k, l

    character(STRING),  parameter:: subname = "dynamics_diagnostic"
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dynamics_initialized) then
       call EndSub( subname, 'Call dynamics_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

    !-------------------------------------------------------------------
    !      
    !-------------------------------------------------------------------
    wz_Psi_a(:,:) = wa_LaplaInv_wa(  wa_xya( xyz_Vor_a(:,:,:) )  ) * R0**2
    wz_Chi_a(:,:) = wa_LaplaInv_wa(  wa_xya( xyz_Div_a(:,:,:) )  ) * R0**2

    xyz_VelLon_a(:,:,:) = (  xya_GradLon_wa( wz_Chi_a(:,:) ) &
         &                - xya_GradLat_wa( wz_Psi_a(:,:) )  ) / R0

    xyz_VelLat_a(:,:,:) = (  xya_GradLon_wa( wz_Psi_a(:,:) ) &
         &                + xya_GradLat_wa( wz_Chi_a(:,:) )  ) / R0

!!$    call DataDump('xyz_VelLon_a', xyz_VelLon_a(:,:,:), strlen=80)
!!$    call DataDump('xyz_VelLat_a', xyz_VelLat_a(:,:,:), strlen=80)

    !-------------------------------------------------------------------
    !   xy_Ps ̤롣
    !-------------------------------------------------------------------
    TotalMass = IntLonLat_xy( xy_Ps_a / Grav )

    call io_gt4_out_Put('TotalMass', TotalMass)

    call EndSub(subname)
  end subroutine dynamics_diagnostic


                                                                 !=begin
  !=== Terminate module
  !
  !((<dynamics_init>))  allocate ѿ deallocate 
  !黻ͤ˴롣
  !
  subroutine dynamics_end
  !==== Dependency
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use dc_trace,    only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dynamics_end"

  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. dynamics_initialized) then
       call EndSub( subname, 'dynamics_init was not called', &
            &       c1=trim(subname) )
       return
    else
       dynamics_initialized = .false.
    endif

    !-----------------------------------------------------------------
    !   allocate ѿ nullify Ȥ
    !-----------------------------------------------------------------
    deallocate( xy_Coli          , &
         &      xy_UVFact        , &
         &      z_DelSigma       , &
         &      wz_DiffVorDiv    , &
         &      wz_DiffTherm     , &
         &      z_HydroAlpha     , &
         &      z_HydroBeta      , &
         &      z_TempInpolA     , &
         &      z_TempInpolB     , &
         &      z_TempInpolKappa , &
         &      z_TempAve        , &
         &      z_TempAveHalf    , &
         &      zz_DivMtx        , &
         &      zz_TempMtx       , &
         &      zz_TempMtxQ      , &
         &      zz_TempMtxS      , &
         &      zz_TempMtxR      )


    deallocate  & 
      & ( xy_lnPs           , & ! С ln s           (t)
      &   xyz_lnPsAdv   , & !  ΰή 
      &   xyz_lnPsAdvSum, & ! аήѲ [kK]()
      &   xyz_DivSum    , & ! ȯѲ [kK] Ħ
      &
      &   xy_lnPs_T       , & ! ФλѲ d/dt   (t)
      &   w_lnPs_T , & ! ФλѲ (ڥȥ) (t)
      &   w_lnPs_a , & !  (t+t)
      &
      &   xyz_VSigmaHalf , & ! ľ®(Ⱦ٥) (t)
      &   xyz_VSigmaHalfNonG , & ! ľ® ʬ (Ⱦ٥) (t)
      &
      &   xyz_TempEdd   , & ! ' ٤ξ (٥) (t)
      &   xyz_TempVir   , & ! v  (virtual temperature)(t)
      &   xyz_TempVirEdd, &! v'٤ξ               (t)
      &   xyz_TempEddHalf, &! ' ٤ξ (Ⱦ٥)   (t)
      &
      &   xyz_UA_T      , & ! ưѲգ
      &   xyz_VA_T      , & ! ̱ưѲ֣
      &
      &   wz_Vor_T , & ! ѲΥڥȥǡ (t) 
      &   wz_Vor_a , & ! ٤Υڥȥǡ    (t+t)
      &
      &   xyz_KE      , & ! ưͥ륮 + 
      &                               ! **2+**2    + (v-)
      &
      &   wz_Div_T , & ! ȯΥڥȥǡ (t)
      &   wz_Div_a , & ! ȯΥڥȥǡ (t+t)
      &   wz_PresTendTemp , & ! ٤ˤ밵Ϸ٤Υڥȥǡ
      &   wz_PresTendPs , & ! ɽϤˤ밵Ϸ٤Υڥȥǡ
      &
      &   xyz_TempLocal_T  , & ! ٤ζɽѲ  
      &                                    ! (ʿȯ ' + Ұή
      &                                    !  + Ѳθ) (ȹ)
      &
      &   wz_Temp_T , & ! ٤Ѳڥȥǡ (t)
      &   wz_Temp_a , & ! ٤Υڥȥǡ   (t+t)
      &
      &   xyz_QVapDivVSigmaAdv, & ! ҡġܦҰή
      &   wz_QVap_T , & ! 漾Ѳڥȥǡ (t)
      &   wz_QVap_a   & ! 漾Υڥȥǡ   (t+t)
      & )

    deallocate  &
      & ( wz_Psi_a , & ! ڥȥ(ήؿ)
      &   wz_Chi_a   & ! ڥȥ(ݥƥ󥷥)
      & )

    call EndSub(subname)
  end subroutine dynamics_end


!!                                                                 !=begin
!!  !=== Function wa_NumVis_wa : Ǵη׻
!!  !
!!  !Ǵ׻ؿǤ롣
!!  !
!!  function wa_NumVis_wa(wa_data)
!!  !==== Dependency
!!    use type_mod           , only: STRING, REKIND, DBKIND, INTKIND
!!    use constants_mod      , only: R0, VisOrder, EFoldTime
!!    use grid_3d_mod        , only: km
!!    use grid_wavenumber_mod, only: nm
!!    use dc_trace           , only: BeginSub, EndSub, DbgMessage, DataDump
!!                                                                 !=end
!!    implicit none
!!                                                                 !=begin
!!    !==== Input
!!    !
!!    real(DBKIND), intent(in) :: wa_data((nm+1)*(nm+1), km)
!!    !
!!    !==== Output
!!    !
!!    real(DBKIND)             :: wa_NumVis_wa((nm+1)*(nm+1), km)
!!                                                                 !=end
!!
!!    real(DBKIND)      :: VisCoef   ! ĶǴ
!!    character(STRING),  parameter:: subname = "wa_NumVis_wa"
!!  continue
!!    call BeginSub(subname)
!!
!!    VisCoef = (   real(  ( nm*(nm+1) ), DBKIND  )  &
!!         &          / R0**2   )**(-VisOrder/2) &
!!         &     / EFoldTime
!!
!!!!$    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))
!!
!!    wa_NumVis_wa = &
!!         & wa_NumVisScaler_wa(wa_data)  &
!!         &   - VisCoef                  &
!!         &      * (  - (2.0d0/R0**2)**(VisOrder/2)  ) * wa_data
!!
!!!!$    call DbgMessage('-VisCoef*(2/R0**2)**(VisOrder/2)=<%f>', &
!!!!$         & d=(/ - VisCoef * (  - (2.0d0/R0**2)**(VisOrder/2)  ) /)   )
!!
!!
!!!!!$  hdc    = ( dble( (hdmaxn*(hdmaxn+1) ) ) / pradisq )**(-hdord/2) &
!!!!!$       / hdts
!!!!!$
!!!!!$  hdord   : ʿȻμʥʥ֥ hdord 衢ץ饷 hdord/2 
!!!!!$  hdmaxn  : Ǥڤȿ T21 ʤ 21T42 ʤ 42... 
!!!!!$  pradisq : Ⱦ¤ [m2]
!!!!!$  hdts    : ȿ hdmaxn ˤ븺λ [s]
!!
!!    call EndSub(subname)
!!  end function wa_NumVis_wa
!!
!!  !=== Function wa_NumVisScaler_wa : 顼ФǴη׻
!!  !
!!  !顼ФǴ׻ؿǤ롣
!!  !
!!  function wa_NumVisScaler_wa(wa_data)
!!    !==== Dependency
!!    use type_mod           , only: STRING, REKIND, DBKIND, INTKIND
!!    use constants_mod      , only: R0, VisOrder, EFoldTime
!!    use grid_3d_mod        , only: km
!!    use grid_wavenumber_mod, only: nm
!!    use spml_mod           , only: rn
!!    use dc_trace           , only: BeginSub, EndSub, DbgMessage, DataDump
!!                                                                 !=end
!!    implicit none
!!                                                                 !=begin
!!    !==== Input
!!    !
!!    real(DBKIND), intent(in) :: wa_data((nm+1)*(nm+1), km)
!!    !
!!    !==== Output
!!    !
!!    real(DBKIND)             :: wa_NumVisScaler_wa((nm+1)*(nm+1), km)
!!                                                                 !=end
!!
!!    real(DBKIND)             :: VisCoef   ! ĶǴ
!!    real(DBKIND)             :: wa_rn((nm+1)*(nm+1), km)
!!    integer(INTKIND)         :: k
!!    character(STRING),  parameter:: subname = "wa_NumVisScaler_wa"
!!    continue
!!    call BeginSub(subname)
!!
!!    do k = 1, km
!!       wa_rn(:,k) = rn(:,1)
!!    enddo
!!
!!    VisCoef = (   real(  ( nm*(nm+1) ), DBKIND  )  &
!!         &          / R0**2   )**(-VisOrder/2) &
!!         &     / EFoldTime
!!
!!!!$    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))
!!
!!    wa_NumVisScaler_wa  =   &
!!         & - VisCoef * ( ( - wa_rn / R0**2 )**(VisOrder/2) ) * wa_data
!!
!!    call EndSub(subname)
!!  end function wa_NumVisScaler_wa

end module dynamics_mod
