!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module axis_z_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: axis_z.f90,v 1.9 2005/01/19 08:52:24 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!This module set axis Z or axis Altitude.
!
!Z ޤϹټꤹ롣
!
!== Error Handling
!
!== Known Bugs
!
!* netCDF ǡ Z Ϥ axis_z_netcdf ˤơ
!   axis_z_half_netcdf ˤơǡ units ˤ餺
!  ǡϤƤ뤬Ƚꤹ٤
!  (ä˰Ϻɸ򰷤ˤɬܤȤʤϤ)
!
!* ߤȾ٥⤳Υ⥸塼ɤ߹Ǥ뤬
!  ̥⥸塼ˤ٤Τʤ(֥ХפȰ㤦)
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end

module axis_z_mod
                                                                 !=begin
  !== Dependency
  use type_mod,      only : INTKIND, STRING
  use axis_type_mod, only : AXISINFO
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: axis_z_init, axis_z_end       ! subroutines
  public :: axis_z_manual, axis_z_netcdf  ! subroutines
  public :: axis_z_sigmahalf_manual       ! subroutines
  public :: axis_z_sigmahalf_netcdf       ! subroutines
  public :: axis_z_half_manual            ! subroutines
  public :: axis_z_half_netcdf            ! subroutines
                                                                 !=end

  type(AXISINFO)   ,save:: z_Dim      ! 礹ѿ
  type(AXISINFO)   ,save:: z_DimHalf  ! Ⱦ٥μ礹ѿ

  logical          ,save:: axis_z_data_from_sigmahalf = .false.
  logical          ,save:: axis_z_data_from_manual   = .false.
  character(STRING),save:: axis_z_data_from_netcdf   = ''

  logical          ,save:: axis_z_half_data_from_manual = .false.
  character(STRING),save:: axis_z_half_data_from_netcdf = ''

  logical          ,save:: axis_z_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: axis_z.f90,v 1.9 2005/01/19 08:52:24 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine axis_z_init
  !==== Dependency
    use type_mod   ,only: STRING, TOKEN, INTKIND, REKIND, DBKIND, NMLARRAY
    use nmlfile_mod,only: nmlfile_init, nmlfile_open, nmlfile_close
    use grid_3d_mod,only: km, grid_3d_init
    use axis_type_mod, only : axis_attrs_copy, axis_attrs_init
    use constants_mod,only: constants_init
    use gt4_history, only: GT_HISTORY_ATTR
    use dc_types,  only: GT_TOKEN => TOKEN, GT_STRING => STRING
    use dc_url     ,only: GT_ATMARK, GT_QUESTION
    use dc_string  ,only: toChar
    use dc_trace   ,only: DbgMessage, BeginSub, EndSub
    use dc_message ,only: MessageNotify
                                                                 !=end
    implicit none

    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
                                                                 !=begin
    !
    !==== NAMELIST axis_z_nml
    !
    !axis_z_nml ˤϡZ μѿ˴ؤͿ롣
    !ͤͿʤΤ˴ؤƤϰʲΥǥեȤͤѤ롣
    !
    !ѿ decision ˤ Z ΥǡɤΤ褦Ϳ뤫ꤹ롣
    !
    !* (({ 'manual' }))
    !  * Data ˳Ǽǡ򤽤Τޤ Z ȤͿ롣
    !
    !* (({ 'sigmahalf' }))
    !  * Z ҥ٥Ǥꤷ axis_z_half_nml 
    !    ͿȾҥ٥ͤ顢ưŪ
    !    Z Υǡ롣
    !    äơaxis_z_half_nml ͭʥǡͿʤ
    !    ˤϥǡޤʤ
    !
    !* gtool4 ѿ (㤨 (({ 'foo.nc@lon' })) ʤ)
    !  * ѿ Z Υǡ롣
    !
    !* 嵭ʳ
    !  * ߤ (({ 'sigmahalf' })) ξƱͤꤵ
    !
    !ѿ length ˤϡ ((<grid_3d_mod>)) θ ((< km >)) Ʊ
    !ͤͿʤФʤʤ
    !
    character(TOKEN)  :: name     = 'sigma'       ! ѿ̾
    integer(INTKIND)  :: length   = 12            ! Ĺ (󥵥)
    character(STRING) :: longname = 'sigma at full level' ! ѿεŪ̾
    character(STRING) :: units    = 'sigma_level' ! ѿñ
    character(TOKEN)  :: xtype    = 'float'       ! ѿη
    character(STRING) :: decision = 'sigmahalf'   ! ǡμˡ
    real(REKIND)      :: Data(NMLARRAY)   = 0.0! ǡ

    namelist /axis_z_nml/ &
         & name         , &  ! ѿ̾
         & length       , &  ! Ĺ (󥵥)
         & longname     , &  ! ѿεŪ̾
         & units        , &  ! ѿñ
         & xtype        , &  ! ѿη
         & decision     , &  ! ǡμˡ
         & Data              ! ǡ


    !==== NAMELIST axis_z_half_nml
    !
    !axiz_z_half_nml ˤϡZ Ⱦ٥μѿ˴ؤ
    !Ϳ롣
    !ͤͿʤΤ˴ؤƤϰʲΥǥեȤͤѤ롣
    !
    !ѿ decision ˤ Z ΥǡɤΤ褦Ϳ뤫ꤹ롣
    !
    !* (({ 'manual' }))
    !  * Data ˳Ǽǡ򤽤Τޤ 
    !    Z Ⱦ٥ȤͿ롣
    !
    !* gtool4 ѿ (㤨 (({ 'foo.nc@lon' })) ʤ)
    !  * ѿ Z Υǡ롣
    !
    !* 嵭ʳ
    !  * ߤ (({ 'manual' })) ξƱͤꤵ
    !
    !ѿ length ˤϡ ((<grid_3d_mod>)) θ ((< km >)) 
    !ץ饹  ͤͿʤФʤʤ
    !
!    name        = 'sigmahalf'   ! ѿ̾
!    length      = 13            ! Ĺ (󥵥)
!    longname    = 'sigma at half level' ! ѿεŪ̾
!    units       = 'sigma_level' ! ѿñ
!    xtype       = 'float'       ! ѿη
!    decision    = 'manual'      ! ǡμˡ
!    Data(1:13)  = (/1, 0.99, 0.97, 0.93, 0.85, 0.75, 0.63, 0.5, &
!         &             0.36, 0.22, 0.1, 0.05, 0/)  ! ǡ

    namelist /axis_z_half_nml/ &
         & name         , &  ! ѿ̾
         & length       , &  ! Ĺ (󥵥)
         & longname     , &  ! ѿεŪ̾
         & units        , &  ! ѿñ
         & xtype        , &  ! ѿη
         & decision     , &  ! ǡμˡ
         & Data              ! ǡ
                                                                 !=end
                                                                 !=begin
    !==== NAMELIST axis_z_attr_nml
    !
    !Z μѿ°˴ؤͿ롣
    !NAMELIST ʣ axis_z_attr_nml ѰդƤ
    !ʣξͿǽǤ롣
    !Ϳʤˤ°ղäʤ
    !
    !attrtype ˤͿ°ͤμꤹ롣
    !((<URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
    !򻲾Ȥ衣ʤarraysize  1 ʾͤꤹȡ
    !ǡͥ褵°ͤꤵ롣
    !
    character(GT_TOKEN)  :: attrname = '' ! °̾
    character(GT_TOKEN)  :: attrtype = '' ! °ͤη
    character(GT_STRING) :: cvalue   = '' ! ° (ʸ)
    integer(INTKIND)     :: ivalue   = 0      ! ° ()
    real(REKIND)         :: rvalue   = 0.0    ! ° (ñټ¿)
    real(DBKIND)         :: dvalue   = 0.0d0  ! ° (ټ¿)
    logical              :: lvalue   = .false.! ° ()
    integer(INTKIND)     :: arraysize= 0      ! Υ
    integer(INTKIND) :: iarray(NMLARRAY)  = 0    ! ° ()
    real(REKIND)     :: rarray(NMLARRAY)  = 0.0  ! ° (ñټ¿)
    real(DBKIND)     :: darray(NMLARRAY)  = 0.0d0! ° (ټ¿)

    namelist /axis_z_attr_nml/ &
         & attrname     , &  ! °̾
         & attrtype     , &  ! °ͤη
         & cvalue       , &  ! ° (ʸ)
         & ivalue       , &  ! ° ()
         & rvalue       , &  ! ° (ñټ¿)
         & dvalue       , &  ! ° (ټ¿)
         & lvalue       , &  ! ° ()
         & arraysize    , &  ! Υ
         & iarray       , &  ! ° ()
         & rarray       , &  ! ° (ñټ¿)
         & darray            ! ° (ټ¿)

    !==== NAMELIST axis_z_half_attr_nml
    !
    !Z Ⱦ٥μѿ°˴ؤͿ롣
    !NAMELIST ʣ axis_z_half_attr_nml ѰդƤ
    !ʣξͿǽǤ롣
    !Ϳʤˤ°ղäʤ
    !
    !attrtype ˤͿ°ͤμꤹ롣
    !((<URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
    !򻲾Ȥ衣ʤarraysize  1 ʾͤꤹȡ
    !ǡͥ褵°ͤꤵ롣
    !
    namelist /axis_z_half_attr_nml/ &
         & attrname     , &  ! °̾
         & attrtype     , &  ! °ͤη
         & cvalue       , &  ! ° (ʸ)
         & ivalue       , &  ! ° ()
         & rvalue       , &  ! ° (ñټ¿)
         & dvalue       , &  ! ° (ټ¿)
         & lvalue       , &  ! ° ()
         & arraysize    , &  ! Υ
         & iarray       , &  ! ° ()
         & rarray       , &  ! ° (ñټ¿)
         & darray            ! ° (ټ¿)
                                                                 !=end


    !-----------------------------------------------------------------
    !   ѿΰǼѿ
    !-----------------------------------------------------------------
    type(GT_HISTORY_ATTR), allocatable :: attrs_tmp(:)

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    integer(INTKIND)            :: i, k
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable, next
    character(TOKEN)            :: position

    character(STRING), parameter:: subname = "axis_z_init"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (axis_z_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       axis_z_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read axis_z_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=axis_z_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST axis_z_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=axis_z_nml)
    else
       call DbgMessage('Not Read NAMELIST axis_z_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_z_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    z_Dim%stored   = .false.
    !  ѿξ¤ѿ z_Dim ؤ
    z_Dim%axisinfo%name     = name
    z_Dim%axisinfo%length   = length
    z_Dim%axisinfo%longname = longname
    z_Dim%axisinfo%units    = units
    z_Dim%axisinfo%xtype    = xtype
    allocate( z_Dim%a_Dim(z_Dim%axisinfo%length) )
    call DbgMessage('z_Dim-length=<%d>', i=(/z_Dim%axisinfo%length/))


    !  ѿξ¤ѿ z_Dim ؤ
    select case(decision)

    ! manual: NAMELIST  Data 
    case('manual')
       z_Dim%a_Dim(:)                       = 0
       z_Dim%a_Dim(1:z_Dim%axisinfo%length) = Data(1:z_Dim%axisinfo%length)
       z_Dim%stored                         = .true.
       axis_z_data_from_manual              = .true.

    ! sigmahalf: Ⱦ٥
    case('sigmahalf')
       axis_z_data_from_sigmahalf = .true.
       z_Dim%stored               = .false.

    ! foo.nc@lon: foo.nc ե lon ѿ
    ! ¾    : sigmahalf Ʊ
    case default
       ! ʸ '@'  '?' ޤޤ gtool4 ѿȤ
       ! ǧ nc ե뤫ѿ򥳥ԡ롣
       if (   index(decision, GT_ATMARK)   > 0 .or.  &
            & index(decision, GT_QUESTION) > 0) then
          axis_z_data_from_netcdf  = decision
          z_Dim%stored             = .false.
       ! ʳ 'sigmahalf' Ʊ褦˽
       else
          axis_z_data_from_sigmahalf = .true.
          z_Dim%stored         = .false.
       endif
    end select

    !----------------------------------------------------------------
    !   read axis_z_attr_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)

    if (.not. nmlreadable) then
       call DbgMessage('Not Read NAMELIST axis_z_attr_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_z_attr_nml.')
    else

       i = 0
       next = .false.
       axis_z_attr_nml_input : do
          i = i + 1
          call DbgMessage('NAMELIST axis_z_attr_nml Input, <%d> time', i=(/i/))
          ! 
          attrname  = ''     ! °̾
          attrtype  = ''     ! °ͤη
          cvalue    = ''     ! ° (ʸ)
          ivalue    = 0      ! ° ()
          rvalue    = 0.0    ! ° (ñټ¿)
          dvalue    = 0.0d0  ! ° (ټ¿)
          lvalue    = .false.! ° ()
          arraysize = 0      ! Υ
          iarray(:) = 0      ! ° ()
          rarray(:) = 0.0    ! ° (ñټ¿)
          darray(:) = 0.0d0  ! ° (ټ¿)

          ! read nml
          read(nmlunit, nml=axis_z_attr_nml, iostat=nmlstat)
          call DbgMessage('Stat of NAMELIST axis_z_attr_nml Input is <%d>', &
               &           i=(/nmlstat/))
          write(0, nml=axis_z_attr_nml)

          ! Inquire access position
          inquire(nmlunit, position=position)
          if ( trim(position) /= 'APPEND' ) then
             next = .true.
          else
             next = .false.
          endif

          ! ͭǤʤͤޤΤ˴ؤƤ̵롣
          if (attrname == '') then
             call DbgMessage('attrname is blank. so this axis_z_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          elseif (attrtype == '') then
             call DbgMessage('attrtype is blank. so this axis_z_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          endif

          !-----------------------------------------------------------
          ! z_Dim%attrs ؤγǼ
          !-----------------------------------------------------------
          ! attrs(:) γĥ
          if ( .not. allocated(z_Dim%attrs) ) then
             allocate( z_Dim%attrs(1) )
             k = 1
          else
             k = size( z_Dim%attrs ) + 1
             ! ǡΰ
             allocate( attrs_tmp(k-1) )
             call axis_attrs_copy(from=z_Dim%attrs(1:k-1), to=attrs_tmp(1:k-1))
             deallocate( z_Dim%attrs )
             allocate( z_Dim%attrs(k) )
             call axis_attrs_copy(from=attrs_tmp(1:k-1), to=z_Dim%attrs(1:k-1))
             deallocate( attrs_tmp )
          endif

          if (arraysize > 0) then
             call axis_attrs_init(z_Dim%attrs(k))

             deallocate(  z_Dim%attrs(k)%iarray  )
             deallocate(  z_Dim%attrs(k)%rarray  )
             deallocate(  z_Dim%attrs(k)%darray  )

             allocate(  z_Dim%attrs(k)%iarray( arraysize )  )
             allocate(  z_Dim%attrs(k)%rarray( arraysize )  )
             allocate(  z_Dim%attrs(k)%darray( arraysize )  )

             z_Dim%attrs(k)%array = .true.

          else
             call axis_attrs_init(z_Dim%attrs(k))
          endif

          z_Dim%attrs(k)%attrname  = attrname
          z_Dim%attrs(k)%attrtype  = attrtype
          z_Dim%attrs(k)%cvalue    = cvalue
          z_Dim%attrs(k)%ivalue    = ivalue
          z_Dim%attrs(k)%rvalue    = rvalue
          z_Dim%attrs(k)%dvalue    = dvalue
          z_Dim%attrs(k)%lvalue    = lvalue
          z_Dim%attrs(k)%iarray(1:max(1,arraysize)) = iarray(1:max(1,arraysize))
          z_Dim%attrs(k)%rarray(1:max(1,arraysize)) = rarray(1:max(1,arraysize))
          z_Dim%attrs(k)%darray(1:max(1,arraysize)) = darray(1:max(1,arraysize))

          call DbgMessage('z_Dim-attrs(%d) [attrname=<%c> '            // &
               & 'attrtype=<%c> array=<%b> cvalue=<%c>  '         // &
               & 'ivalue=<%d> rvalue=<%r> dvalue=<%f> '           // &
               & 'iarray(1:%d)=<%d, ...> '                        // &
               & 'rarray(1:%d)=<%r, ...> darray(1:%d)=<%f, ...>'   , &
               & c1=trim( z_Dim%attrs(k)%attrname )                  , &
               & c2=trim( z_Dim%attrs(k)%attrtype )                  , &
               & c3=trim( z_Dim%attrs(k)%cvalue )                    , &
               & i=(/ k, z_Dim%attrs(k)%ivalue    ,                    &
               &      size(z_Dim%attrs(k)%iarray) ,                    &
               &      z_Dim%attrs(k)%iarray       ,                    &
               &      size(z_Dim%attrs(k)%rarray) ,                    &
               &      size(z_Dim%attrs(k)%darray)                      &
               &   /)                                                , &
               & r=(/z_Dim%attrs(k)%rvalue, z_Dim%attrs(k)%rarray/)    , &
               & d=(/z_Dim%attrs(k)%dvalue, z_Dim%attrs(k)%darray/)    , &
               & l=(/z_Dim%attrs(k)%lvalue/)                      )

          if (.not. next) exit axis_z_attr_nml_input
          next      = .false.  ! Τν

       enddo axis_z_attr_nml_input
    end if
    call nmlfile_close


    !----------------------------------------------------------------
    !   read axis_z_half_nml
    !----------------------------------------------------------------
    ! Initialize
    name        = 'sigmahalf'   ! ѿ̾
    length      = 13            ! Ĺ (󥵥)
    longname    = 'sigma at half level' ! ѿεŪ̾
    units       = 'sigma_level' ! ѿñ
    xtype       = 'float'       ! ѿη
    decision    = 'manual'      ! ǡμˡ
    Data(1:13)  = (/1.0, 0.99, 0.97, 0.93, 0.85, 0.75, 0.63, 0.5, &
         &          0.36, 0.22, 0.1, 0.05, 0.0/)  ! ǡ

    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=axis_z_half_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST axis_z_half_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=axis_z_half_nml)
    else
       call DbgMessage('Not Read NAMELIST axis_z_half_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_z_half_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    z_DimHalf%stored   = .false.
    !  ѿξ¤ѿ z_DimHalf ؤ
    z_DimHalf%axisinfo%name     = name
    z_DimHalf%axisinfo%length   = length
    z_DimHalf%axisinfo%longname = longname
    z_DimHalf%axisinfo%units    = units
    z_DimHalf%axisinfo%xtype    = xtype
    allocate( z_DimHalf%a_Dim(z_DimHalf%axisinfo%length) )
    call DbgMessage('z_DimHalf-length=<%d>', i=(/z_DimHalf%axisinfo%length/))


    !  ѿξ¤ѿ z_DimHalf ؤ
    select case(decision)

    ! manual: NAMELIST  Data 
    case('manual')
       z_DimHalf%a_Dim(:)           = 0
       z_DimHalf%a_Dim(1:z_DimHalf%axisinfo%length) &
            &                       = Data(1:z_DimHalf%axisinfo%length)
       z_DimHalf%stored             = .true.
       axis_z_half_data_from_manual = .true.

       call DbgMessage('z_DimHalf(:)=<%c>'                      , &
            &       c1=trim( toChar(z_DimHalf%a_Dim(:)) )  )

    ! foo.nc@lon: foo.nc ե lon ѿ
    ! ¾    : sigmahalf Ʊ
    case default
       ! ʸ '@'  '?' ޤޤ gtool4 ѿȤ
       ! ǧ nc ե뤫ѿ򥳥ԡ롣
       if (   index(decision, GT_ATMARK)   > 0 .or.  &
            & index(decision, GT_QUESTION) > 0) then
          axis_z_half_data_from_netcdf  = decision
          z_DimHalf%stored              = .false.
       ! ʳ 'manual' Ʊ褦˽
       else
          z_DimHalf%a_Dim(:)           = 0
          z_DimHalf%a_Dim(1:z_DimHalf%axisinfo%length) &
               &                       = Data(1:z_DimHalf%axisinfo%length)
          z_DimHalf%stored             = .true.
          axis_z_half_data_from_manual = .true.

          call DbgMessage('z_DimHalf(:)=<%c>'                      , &
               &       c1=trim( toChar(z_DimHalf%a_Dim(:)) )  )
       endif
    end select

    !----------------------------------------------------------------
    !   read axis_z_half_attr_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)

    if (.not. nmlreadable) then
       call DbgMessage('Not Read NAMELIST axis_z_half_attr_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_z_half_attr_nml.')
    else

       i = 0
       next = .false.
       axis_z_half_attr_nml_input : do
          call DbgMessage('NAMELIST axis_z_half_attr_nml Input, <%d> time', i=(/i/))
          i = i + 1
          ! 
          attrname  = ''     ! °̾
          attrtype  = ''     ! °ͤη
          cvalue    = ''     ! ° (ʸ)
          ivalue    = 0      ! ° ()
          rvalue    = 0.0    ! ° (ñټ¿)
          dvalue    = 0.0d0  ! ° (ټ¿)
          lvalue    = .false.! ° ()
          arraysize = 0      ! Υ
          iarray(:) = 0      ! ° ()
          rarray(:) = 0.0    ! ° (ñټ¿)
          darray(:) = 0.0d0  ! ° (ټ¿)

          ! read nml
          read(nmlunit, nml=axis_z_half_attr_nml, iostat=nmlstat)
          call DbgMessage('Stat of NAMELIST axis_z_half_attr_nml Input is <%d>', &
               &           i=(/nmlstat/))
          write(0, nml=axis_z_half_attr_nml)

          ! Inquire access position
          inquire(nmlunit, position=position)
          if ( trim(position) /= 'APPEND' ) then
             next = .true.
          else
             next = .false.
          endif

          ! ͭǤʤͤޤΤ˴ؤƤ̵롣
          if (attrname == '') then
             call DbgMessage('attrname is blank. so this axis_z_half_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          elseif (attrtype == '') then
             call DbgMessage('attrtype is blank. so this axis_z_half_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          endif

          !-----------------------------------------------------------
          ! z_DimHalf%attrs ؤγǼ
          !-----------------------------------------------------------
          ! attrs(:) γĥ
          if ( .not. allocated(z_DimHalf%attrs) ) then
             allocate( z_DimHalf%attrs(1) )
             k = 1
          else
             k = size( z_DimHalf%attrs ) + 1
             ! ǡΰ
             allocate( attrs_tmp(k-1) )
             call axis_attrs_copy(from=z_DimHalf%attrs(1:k-1), to=attrs_tmp(1:k-1))
             deallocate( z_DimHalf%attrs )
             allocate( z_DimHalf%attrs(k) )
             call axis_attrs_copy(from=attrs_tmp(1:k-1), to=z_DimHalf%attrs(1:k-1))
             deallocate( attrs_tmp )
          endif

          if (arraysize > 0) then
             call axis_attrs_init(z_DimHalf%attrs(k))

             deallocate(  z_DimHalf%attrs(k)%iarray  )
             deallocate(  z_DimHalf%attrs(k)%rarray  )
             deallocate(  z_DimHalf%attrs(k)%darray  )

             allocate(  z_DimHalf%attrs(k)%iarray( arraysize )  )
             allocate(  z_DimHalf%attrs(k)%rarray( arraysize )  )
             allocate(  z_DimHalf%attrs(k)%darray( arraysize )  )

             z_DimHalf%attrs(k)%array = .true.

          else
             call axis_attrs_init(z_DimHalf%attrs(k))
          endif

          z_DimHalf%attrs(k)%attrname  = attrname
          z_DimHalf%attrs(k)%attrtype  = attrtype
          z_DimHalf%attrs(k)%cvalue    = cvalue
          z_DimHalf%attrs(k)%ivalue    = ivalue
          z_DimHalf%attrs(k)%rvalue    = rvalue
          z_DimHalf%attrs(k)%dvalue    = dvalue
          z_DimHalf%attrs(k)%lvalue    = lvalue
          z_DimHalf%attrs(k)%iarray(1:max(1,arraysize)) = iarray(1:max(1,arraysize))
          z_DimHalf%attrs(k)%rarray(1:max(1,arraysize)) = rarray(1:max(1,arraysize))
          z_DimHalf%attrs(k)%darray(1:max(1,arraysize)) = darray(1:max(1,arraysize))

          call DbgMessage('z_DimHalf-attrs(%d) [attrname=<%c> '            // &
               & 'attrtype=<%c> array=<%b> cvalue=<%c>  '         // &
               & 'ivalue=<%d> rvalue=<%r> dvalue=<%f> '           // &
               & 'iarray(1:%d)=<%d, ...> '                        // &
               & 'rarray(1:%d)=<%r, ...> darray(1:%d)=<%f, ...>'   , &
               & c1=trim( z_DimHalf%attrs(k)%attrname )                  , &
               & c2=trim( z_DimHalf%attrs(k)%attrtype )                  , &
               & c3=trim( z_DimHalf%attrs(k)%cvalue )                    , &
               & i=(/ k, z_DimHalf%attrs(k)%ivalue    ,                    &
               &      size(z_DimHalf%attrs(k)%iarray) ,                    &
               &      z_DimHalf%attrs(k)%iarray       ,                    &
               &      size(z_DimHalf%attrs(k)%rarray) ,                    &
               &      size(z_DimHalf%attrs(k)%darray)                      &
               &   /)                                                , &
               & r=(/z_DimHalf%attrs(k)%rvalue, z_DimHalf%attrs(k)%rarray/)    , &
               & d=(/z_DimHalf%attrs(k)%dvalue, z_DimHalf%attrs(k)%darray/)    , &
               & l=(/z_DimHalf%attrs(k)%lvalue/)                      )

          if (.not. next) exit axis_z_half_attr_nml_input
          next      = .false.  ! Τν

       enddo axis_z_half_attr_nml_input
    end if
    call nmlfile_close


    !----------------------------------------------------------------
    !   grid_3d_mod Ȥå
    !----------------------------------------------------------------
    call grid_3d_init
    if (z_Dim%axisinfo%length /= km) then
       call MessageNotify('E', subname, &
            & message='axis length is inconsistent with km in grid_3d_mod')
    endif

    if (z_DimHalf%axisinfo%length /= z_Dim%axisinfo%length + 1) then
       call MessageNotify('E', subname, &
            & message='Sigma length should be SigmaHalf length - 1.')
    endif

    !-----------------------------------------------------------------
    !   constants ⥸塼ν
    !-----------------------------------------------------------------
    call constants_init

    !----------------------------------------------------------------
    !   㳰
    !----------------------------------------------------------------
    if (length < 1) then
       call MessageNotify('E', subname, message='Invalid grid number.')
    endif

    call EndSub( subname )
  end subroutine axis_z_init



                                                                 !=begin
  !=== Return Sigma Full Level and Sigma Half Level (from NAMELIST) as Data of axis Z
  !
  !NAMELIST Ⱦҥ٥Υǡȡ
  !Ⱦҥ٥뤫ҥ٥ǡ֤
  !
  !((< axis_z_init >))  NAMELIST axis_z_nml  decision ѿ
  !(({ 'sigmahalf' })) Ϳ졢
  !NAMELIST axis_z_half_nml  decision ѿ
  !(({ 'manual' }))ͿƤʳϡͤ˲֤
  !
  subroutine axis_z_sigmahalf_manual(Dim, DimHalf)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim, DimHalf  ! 礹ѿ
                                                                 !=end
    character(STRING), parameter:: subname = "axis_z_sigmahalf_manual"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   axis_z_nml  decision  'sigmahalf' Ǥʤ
    !   axis_z_sigmahalf_nml  decision  'manual' Ǥʤ
    !----------------------------------------------------------------
    if (   .not. axis_z_data_from_sigmahalf .or. &
         & .not. axis_z_half_data_from_manual ) then
       call EndSub( subname, &
            & 'In axis_z_nml and in axis_z_sigmahalf_nml, configurated to not generate from sigmahalf (which is generated from NAMELIST)')
       return
    endif

    !----------------------------------------------------------------
    !   DimHalf ͤ Dim 
    !----------------------------------------------------------------
    call gen_sigma_from_half(z_DimHalf, z_Dim)

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(z_Dim, Dim)
    call axis_type_copy(z_DimHalf, DimHalf)
    call EndSub(subname)
  end subroutine axis_z_sigmahalf_manual


                                                                 !=begin
  !=== Return Sigma Full Level and Sigma Half Level (from netCDF Data) as Data of axis Z
  !
  !netCDF ǡȾҥ٥Υǡȡ
  !Ⱦҥ٥뤫ҥ٥ǡ֤
  !
  !((< axis_z_init >))  NAMELIST axis_z_nml  decision ѿ
  !(({ 'sigmahalf' })) Ϳ졢
  !NAMELIST axis_z_half_nml  decision ѿ
  !gtool4ѿͿƤʳϡͤ˲֤
  !
  subroutine axis_z_sigmahalf_netcdf(Dim, DimHalf)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use gt4_history,only: HistoryGet
    use dc_url  ,   only: UrlSplit
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim, DimHalf  ! 礹ѿ
                                                                 !=end
    character(STRING)           :: file
    character(STRING)           :: varname

    character(STRING), parameter:: subname = "axis_z_sigmahalf_netcdf"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   axis_z_nml  decision  'sigmahalf' Ǥʤ
    !   axis_z_sigmahalf_nml  decision  '***@lon' Ǥʤ
    !----------------------------------------------------------------
    if (   .not. axis_z_data_from_sigmahalf .or. &
         & .not. axis_z_half_data_from_netcdf /= '') then
       call EndSub( subname, &
            & 'In axis_z_nml and in axis_z_sigmahalf_nml, configurated to not generate from sigmahalf (which is generated from netcdf data)')
       return
    endif

    !----------------------------------------------------------------
    !   HistoryGet ˤǡ
    !----------------------------------------------------------------
    call UrlSplit(axis_z_half_data_from_netcdf, file=file, var=varname)
    call HistoryGet(file, varname, z_DimHalf%a_Dim)
    z_Dim%stored   = .true.

    !----------------------------------------------------------------
    !   DimHalf ͤ Dim 
    !----------------------------------------------------------------
    call gen_sigma_from_half(z_DimHalf, z_Dim)

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(z_Dim, Dim)
    call axis_type_copy(z_DimHalf, DimHalf)
    call EndSub(subname)
  end subroutine axis_z_sigmahalf_netcdf


                                                                 !=begin
  !=== Return Data of axis Z from NAMELIST
  !
  !NAMELIST 줿ǡ Z ǡȤ֤
  !
  !((< axis_z_init >))  NAMELIST axis_z_nml  decision ѿ
  !(({ 'manual' })) ʳͿ줿ͤʤ֤
  !
  subroutine axis_z_manual(Dim)
    use axis_type_mod, only: axis_type_copy
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING), parameter:: subname = "axis_z_manual"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'manual' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_z_data_from_manual) then
       call EndSub( subname, &
            & 'In axis_z_nml, configurated to not generate from manual')
       return
    endif

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(z_Dim, Dim)
    call EndSub(subname)
  end subroutine axis_z_manual


                                                                 !=begin
  !=== Return Data of axis Z from netCDF file
  !
  !netCDF ǡǡ Z ΥǡȤ֤
  !
  !((< axis_z_init >))  NAMELIST axis_z_nml  decision ѿ
  !gtool4 ѿʳͿ줿ͤʤ֤
  !
  subroutine axis_z_netcdf(Dim)
  !==== Dependency
    use type_mod,      only: STRING
    use axis_type_mod, only: axis_type_copy
    use gt4_history,only: HistoryGet
    use dc_url  ,   only: UrlSplit
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end

    character(STRING)           :: file
    character(STRING)           :: varname

    character(STRING), parameter:: subname = "axis_z_netcdf"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  '***@lon' ʤɤǤʤߤ֤
    !----------------------------------------------------------------
    if (axis_z_data_from_netcdf == '') then
       call EndSub( subname, &
            & 'In axis_z_nml, configurated to not generate from netcdf data')
       return
    endif

    !----------------------------------------------------------------
    !   HistoryGet ˤǡ
    !----------------------------------------------------------------
    call UrlSplit(axis_z_data_from_netcdf, file=file, var=varname)
    call HistoryGet(file, varname, z_Dim%a_Dim)
    z_Dim%stored   = .true.

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(z_Dim, Dim)
    call EndSub(subname)
  end subroutine axis_z_netcdf


                                                                 !=begin
  !=== Return Half Level Data of axis Z from NAMELIST
  !
  !NAMELIST 줿Ⱦ٥ΥǡȾ٥
  !Z ǡȤ֤
  !
  !((< axis_z_init >))  NAMELIST axis_z_half_nml  decision ѿ
  !(({ 'manual' })) ʳͿ줿ͤʤ֤
  !
  subroutine axis_z_half_manual(DimHalf)
    use axis_type_mod, only: axis_type_copy
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: DimHalf        ! 礹ѿ
                                                                 !=end
    character(STRING), parameter:: subname = "axis_z_half_manual"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'manual' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_z_half_data_from_manual) then
       call EndSub( subname, &
            & 'In axis_z_half_nml, configurated to not generate from manual')
       return
    endif

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(z_DimHalf, DimHalf)
    call EndSub(subname)
  end subroutine axis_z_half_manual



                                                                 !=begin
  !=== Return Half Level Data of axis Z from netCDF file
  !
  !netCDF ǡȾ٥ǡȾ٥
  !Z ΥǡȤ֤
  !
  !((< axis_z_init >))  NAMELIST axis_z_half_nml  decision ѿ
  !gtool4 ѿʳͿ줿ͤʤ֤
  !
  subroutine axis_z_half_netcdf(DimHalf)
  !==== Dependency
    use type_mod,      only: STRING
    use axis_type_mod, only: axis_type_copy
    use gt4_history,only: HistoryGet
    use dc_url  ,   only: UrlSplit
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: DimHalf        ! 礹ѿ
                                                                 !=end

    character(STRING)           :: file
    character(STRING)           :: varname

    character(STRING), parameter:: subname = "axis_z_half_netcdf"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  '***@lon' ʤɤǤʤߤ֤
    !----------------------------------------------------------------
    if (axis_z_half_data_from_netcdf == '') then
       call EndSub( subname, &
            & 'In axis_z_half_nml, configurated to not generate from netcdf data')
       return
    endif

    !----------------------------------------------------------------
    !   HistoryGet ˤǡ
    !----------------------------------------------------------------
    call UrlSplit(axis_z_half_data_from_netcdf, file=file, var=varname)
    call HistoryGet(file, varname, z_DimHalf%a_Dim)
    z_DimHalf%stored   = .true.

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(z_DimHalf, DimHalf)
    call EndSub(subname)
  end subroutine axis_z_half_netcdf


                                                                 !=begin
  !=== Generate Sigma Level from Sigma Half Level.
  !
  !axis_z_mod ֥롼
  !
  ! DimHalf Ⱦҥ٥Ȥơͤҥ٥
  ! Dim Ȥ֤
  !
  subroutine gen_sigma_from_half(DimHalf, Dim)
  !==== Dependency
    use type_mod,   only: DBKIND, STRING, REKIND
    use constants_mod,only: RAir, Cp
    use dc_string,  only: toChar
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(AXISINFO), intent(in)   :: DimHalf ! Ⱦҥ٥

    !==== In/Out
    !
    type(AXISINFO), intent(inout):: Dim     ! ҥ٥
                                                                 !=end
    !----- ѿ -----
    real(REKIND), allocatable :: z_DelSigma(:) ! (٥)
    real(DBKIND)              :: Kappa  ! =ҡã (/갵Ǯ)

    ! do 롼Ѻѿ
    integer(INTKIND)   :: k

    character(STRING), parameter:: subname = "gen_sigma_from_half"
  continue
    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_z_initialized) then
       call EndSub( subname, 'Call axis_z_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !-----------------------------------------------------------------
    !   z_DelSigma () 
    !-----------------------------------------------------------------
    allocate( z_DelSigma(Dim%axisinfo%length) )

    do k = 1, Dim%axisinfo%length
       z_DelSigma(k) = z_DimHalf%a_Dim(k) - z_DimHalf%a_Dim(k+1)
    enddo

    call DbgMessage( 'DimHalf-a_Dim(:)=<%c>', c1=trim( toChar(DimHalf%a_Dim(:)) ) )
    call DbgMessage( 'Dim-length=<%c>', c1=trim( toChar(Dim%axisinfo%length) )  )
    call DbgMessage( 'z_DelSigma(:)=<%c>', c1=trim( toChar(z_DelSigma(:)) ) )

    !-----------------------------------------------------------------
    !   =ҡã (/갵Ǯ) 
    !-----------------------------------------------------------------
    Kappa = RAir / Cp

    call DbgMessage( 'Kappa=<%c>', c1=trim( toChar(Kappa) ) )

    !-----------------------------------------------------------------
    !   ٥
    !-----------------------------------------------------------------
    if (.not. allocated(Dim%a_Dim) ) then
       allocate( Dim%a_Dim(Dim%axisinfo%length) )
    endif

    do k = 1, Dim%axisinfo%length
       Dim%a_Dim(k)= (                                             &
            &           (  z_DimHalf%a_Dim ( k )**( 1. + Kappa )   &
            &            - z_DimHalf%a_Dim (k+1)**( 1. + Kappa ) ) &
            &                                                      &
            &           / (   z_DelSigma ( k ) *  ( 1. + Kappa ) ) &
            &       )                                              &
            &        **( 1. /Kappa )
    enddo

    call DbgMessage( 'z_Sigma(:)=<%c>', c1=trim( toChar(Dim%a_Dim(:)) ) )
    call EndSub(subname)
  end subroutine gen_sigma_from_half


                                                                 !=begin
  !=== Terminate module
  !
  !((<axis_z_init>)) ꤵ줿ͤ˴ǥեȤ᤹
  !
  subroutine axis_z_end
  !==== Dependency
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "axis_z_end"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. axis_z_initialized) then
       call EndSub( subname, 'axis_z_init was not called', &
            &       c1=trim(subname) )
       return
    else
       axis_z_initialized = .false.
       axis_z_data_from_sigmahalf = .false.
       axis_z_data_from_manual   = .false.
       axis_z_data_from_netcdf   = ''
       axis_z_half_data_from_manual   = .false.
       axis_z_half_data_from_netcdf   = ''

       !--------------------------------------------------------------
       !   Initialize z_Dim
       !--------------------------------------------------------------
       z_Dim%stored   = .false.
       z_Dim%axisinfo%name     = ''
       z_Dim%axisinfo%length   = 0
       z_Dim%axisinfo%longname = ''
       z_Dim%axisinfo%units    = ''
       z_Dim%axisinfo%xtype    = ''
       if ( allocated(z_Dim%a_Dim) ) then
          deallocate( z_Dim%a_Dim )
       endif

       if ( allocated(z_Dim%attrs) ) then
          deallocate( z_Dim%attrs )
       end if

       !--------------------------------------------------------------
       !   Initialize z_DimHalf
       !--------------------------------------------------------------
       z_DimHalf%stored   = .false.
       z_DimHalf%axisinfo%name     = ''
       z_DimHalf%axisinfo%length   = 0
       z_DimHalf%axisinfo%longname = ''
       z_DimHalf%axisinfo%units    = ''
       z_DimHalf%axisinfo%xtype    = ''
       if ( allocated(z_DimHalf%a_Dim) ) then
          deallocate( z_DimHalf%a_Dim )
       endif

       if ( allocated(z_DimHalf%attrs) ) then
          deallocate( z_DimHalf%attrs )
       end if

    endif

    call EndSub( subname )
  end subroutine axis_z_end

end module axis_z_mod
