!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module axis_y_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: axis_y.f90,v 1.9 2005/01/19 08:52:24 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!This module set axis Y or axis Latitude.
!
!Y ޤϰټꤹ롣
!
!== Error Handling
!
!== Known Bugs
!
!netCDF ǡ Y Ϥ axis_y_netcdf ˤơ
!ǡ radians Ǥ degrees Ǥ⡢ΤޤϤ褦
!ʤäƤ롣ϸǡ units Ƚꤹ٤
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module axis_y_mod
                                                                 !=begin
  !== Dependency
  use type_mod,      only : INTKIND, STRING
  use axis_type_mod, only : AXISINFO
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: axis_y_init, axis_y_weight, axis_y_spectral ! subroutines
  public :: axis_y_manual, axis_y_netcdf, axis_y_end    ! subroutines
                                                                 !=end

  type(AXISINFO)   ,save:: y_Dim        ! 礹ѿ
  type(AXISINFO)   ,save:: y_Dim_Weight ! Ť߾礹ѿ

  logical          ,save:: axis_y_data_from_spectral = .false.
  logical          ,save:: axis_y_data_from_manual   = .false.
  character(STRING),save:: axis_y_data_from_netcdf   = ''

  logical          ,save:: axis_y_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: axis_y.f90,v 1.9 2005/01/19 08:52:24 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine axis_y_init
  !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND, REKIND, DBKIND, NMLARRAY
    use nmlfile_mod,only: nmlfile_init, nmlfile_open, nmlfile_close
    use grid_3d_mod,only: jm, grid_3d_init
    use spml_mod,   only: spml_init
    use axis_type_mod, only : axis_attrs_copy, axis_attrs_init
    use gt4_history, only: GT_HISTORY_ATTR
    use dc_types,  only: GT_TOKEN => TOKEN, GT_STRING => STRING
    use dc_url,    only: GT_ATMARK, GT_QUESTION
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
    use dc_message,only: MessageNotify
                                                                 !=end
    implicit none
    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
                                                                 !=begin
    !
    !==== NAMELIST
    !
    !Y μѿ˴ؤͿ롣
    !ͤͿʤΤ˴ؤƤϰʲΥǥեȤͤѤ롣
    !
    !ѿ decision ˤ Y ΥǡɤΤ褦Ϳ뤫ꤹ롣
    !
    !* (({ 'manual' }))
    !  * Data ˳Ǽǡ򤽤Τޤ Y ȤͿ롣
    !
    !* (({ 'spectral' }))
    !  * ڥȥˡѤꤷ length ˱ƼưŪ
    !    Y Υǡޤ롣
    !
    !* gtool4 ѿ (㤨 (({ 'foo.nc@lon' })) ʤ)
    !  * ѿ Y Υǡ롣
    !
    !ѿ length ˤϡ ((<grid_3d_mod>)) θ ((< jm >)) Ʊ
    !ͤͿʤФʤʤ
    !
    character(TOKEN)  :: name     = 'lat'           ! ѿ̾
    integer(INTKIND)  :: length   = 32              ! Ĺ (󥵥)
    character(STRING) :: longname = 'Latitude'      ! ѿεŪ̾
    character(STRING) :: units    = 'degrees_north' ! ѿñ
    character(TOKEN)  :: xtype    = 'float'         ! ѿη
    character(STRING) :: decision = 'spectral'      ! ǡμˡ
    real(REKIND)      :: Data(NMLARRAY)  = 0.0      ! ǡ

    namelist /axis_y_nml/ &
         & name         , &  ! ѿ̾
         & length       , &  ! Ĺ (󥵥)
         & longname     , &  ! ѿεŪ̾
         & units        , &  ! ѿñ
         & xtype        , &  ! ѿη
         & decision     , &  ! ǡμˡ
         & Data              ! ǡ
                                                                 !=end
                                                                 !=begin
    !
    !Y μѿ°˴ؤͿ롣
    !NAMELIST ʣ axis_y_attr_nml ѰդƤ
    !ʣξͿǽǤ롣
    !Ϳʤˤ°ղäʤ
    !
    !attrtype ˤͿ°ͤμꤹ롣
    !((<URL:http://www.gfd-dennou.org/arch/gtool4/gt4f90io-current/doc/gt_history.htm#derived_gthistoryattr>))
    !򻲾Ȥ衣ʤarraysize  1 ʾͤꤹȡ
    !ǡͥ褵°ͤꤵ롣
    !
    character(GT_TOKEN)  :: attrname = '' ! °̾
    character(GT_TOKEN)  :: attrtype = '' ! °ͤη
    character(GT_STRING) :: cvalue   = '' ! ° (ʸ)
    integer(INTKIND)     :: ivalue   = 0      ! ° ()
    real(REKIND)         :: rvalue   = 0.0    ! ° (ñټ¿)
    real(DBKIND)         :: dvalue   = 0.0d0  ! ° (ټ¿)
    logical              :: lvalue   = .false.! ° ()
    integer(INTKIND)     :: arraysize= 0      ! Υ
    integer(INTKIND) :: iarray(NMLARRAY)  = 0    ! ° ()
    real(REKIND)     :: rarray(NMLARRAY)  = 0.0  ! ° (ñټ¿)
    real(DBKIND)     :: darray(NMLARRAY)  = 0.0d0! ° (ټ¿)

    namelist /axis_y_attr_nml/ &
         & attrname     , &  ! °̾
         & attrtype     , &  ! °ͤη
         & cvalue       , &  ! ° (ʸ)
         & ivalue       , &  ! ° ()
         & rvalue       , &  ! ° (ñټ¿)
         & dvalue       , &  ! ° (ټ¿)
         & lvalue       , &  ! ° ()
         & arraysize    , &  ! Υ
         & iarray       , &  ! ° ()
         & rarray       , &  ! ° (ñټ¿)
         & darray            ! ° (ټ¿)
                                                                 !=end

    !-----------------------------------------------------------------
    !   ѿΰǼѿ
    !-----------------------------------------------------------------
    type(GT_HISTORY_ATTR), allocatable :: attrs_tmp(:)

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    integer(INTKIND)            :: i, k
    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable, next
    character(TOKEN)            :: position
    character(STRING), parameter:: subname = "axis_y_init"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (axis_y_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       axis_y_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !-----------------------------------------------------------------
    !   Initialize Dependent Modules
    !-----------------------------------------------------------------
    call grid_3d_init
    call spml_init

    !----------------------------------------------------------------
    !   read axis_y_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=axis_y_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST axis_y_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=axis_y_nml)
    else
       call DbgMessage('Not Read NAMELIST axis_y_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_y_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    y_Dim%stored   = .false.
    !  ѿξ¤ѿ y_Dim ؤ
    y_Dim%axisinfo%name     = name
    y_Dim%axisinfo%length   = length
    y_Dim%axisinfo%longname = longname
    y_Dim%axisinfo%units    = units
    y_Dim%axisinfo%xtype    = xtype
    allocate( y_Dim%a_Dim(y_Dim%axisinfo%length) )

    !  ѿξ¤ѿ y_Dim ؤ
    select case(decision)

    ! manual: NAMELIST  Data 
    case('manual')
       y_Dim%a_Dim(:)                       = 0
       y_Dim%a_Dim(1:y_Dim%axisinfo%length) = Data(1:y_Dim%axisinfo%length)
       y_Dim%stored                         = .true.
       axis_y_data_from_manual              = .true.

    ! spectral: SPMODEL  wa_module ˤ
    case('spectral')
       axis_y_data_from_spectral = .true.
       y_Dim%stored              = .false.

    ! foo.nc@lon: foo.nc ե lon ѿ
    ! ¾    : spectral Ʊ
    case default
       ! ʸ '@'  '?' ޤޤ gtool4 ѿȤ
       ! ǧ nc ե뤫ѿ򥳥ԡ롣
       if (   index(decision, GT_ATMARK)   > 0 .or.  &
            & index(decision, GT_QUESTION) > 0) then
          axis_y_data_from_netcdf  = decision
          y_Dim%stored             = .false.
       ! ʳ 'spectral' Ʊ褦˽
       else
          axis_y_data_from_spectral = .true.
          y_Dim%stored         = .false.
       endif
    end select

    !----------------------------------------------------------------
    !   read axis_y_attr_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)

    if (.not. nmlreadable) then
       call DbgMessage('Not Read NAMELIST axis_y_attr_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST axis_y_attr_nml.')
    else

       i = 0
       next = .false.
       axis_y_attr_nml_input : do
          i = i + 1
          call DbgMessage('NAMELIST axis_y_attr_nml Input, <%d> time', i=(/i/))
          ! 
          attrname  = ''     ! °̾
          attrtype  = ''     ! °ͤη
          cvalue    = ''     ! ° (ʸ)
          ivalue    = 0      ! ° ()
          rvalue    = 0.0    ! ° (ñټ¿)
          dvalue    = 0.0d0  ! ° (ټ¿)
          lvalue    = .false.! ° ()
          arraysize = 0      ! Υ
          iarray(:) = 0      ! ° ()
          rarray(:) = 0.0    ! ° (ñټ¿)
          darray(:) = 0.0d0  ! ° (ټ¿)

          ! read nml
          read(nmlunit, nml=axis_y_attr_nml, iostat=nmlstat)
          call DbgMessage('Stat of NAMELIST axis_y_attr_nml Input is <%d>', &
               &           i=(/nmlstat/))
          write(0, nml=axis_y_attr_nml)

          ! Inquire access position
          inquire(nmlunit, position=position)
          if ( trim(position) /= 'APPEND' ) then
             next = .true.
          else
             next = .false.
          endif

          ! ͭǤʤͤޤΤ˴ؤƤ̵롣
          if (attrname == '') then
             call DbgMessage('attrname is blank. so this axis_y_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          elseif (attrtype == '') then
             call DbgMessage('attrtype is blank. so this axis_y_attr_nml is ignored.')
             if (next) cycle
             if (.not. next) exit
          endif

          !-----------------------------------------------------------
          ! y_Dim%attrs ؤγǼ
          !-----------------------------------------------------------
          ! attrs(:) γĥ
          if ( .not. allocated(y_Dim%attrs) ) then
             allocate( y_Dim%attrs(1) )
             k = 1
          else
             k = size( y_Dim%attrs ) + 1
             ! ǡΰ
             allocate( attrs_tmp(k-1) )
             call axis_attrs_copy(from=y_Dim%attrs(1:k-1), to=attrs_tmp(1:k-1))
             deallocate( y_Dim%attrs )
             allocate( y_Dim%attrs(k) )
             call axis_attrs_copy(from=attrs_tmp(1:k-1), to=y_Dim%attrs(1:k-1))
             deallocate( attrs_tmp )
          endif

          if (arraysize > 0) then
             call axis_attrs_init(y_Dim%attrs(k))

             deallocate(  y_Dim%attrs(k)%iarray  )
             deallocate(  y_Dim%attrs(k)%rarray  )
             deallocate(  y_Dim%attrs(k)%darray  )

             allocate(  y_Dim%attrs(k)%iarray( arraysize )  )
             allocate(  y_Dim%attrs(k)%rarray( arraysize )  )
             allocate(  y_Dim%attrs(k)%darray( arraysize )  )

             y_Dim%attrs(k)%array = .true.

          else
             call axis_attrs_init(y_Dim%attrs(k))
          endif

          y_Dim%attrs(k)%attrname  = attrname
          y_Dim%attrs(k)%attrtype  = attrtype
          y_Dim%attrs(k)%cvalue    = cvalue
          y_Dim%attrs(k)%ivalue    = ivalue
          y_Dim%attrs(k)%rvalue    = rvalue
          y_Dim%attrs(k)%dvalue    = dvalue
          y_Dim%attrs(k)%lvalue    = lvalue
          y_Dim%attrs(k)%iarray(1:max(1,arraysize)) = iarray(1:max(1,arraysize))
          y_Dim%attrs(k)%rarray(1:max(1,arraysize)) = rarray(1:max(1,arraysize))
          y_Dim%attrs(k)%darray(1:max(1,arraysize)) = darray(1:max(1,arraysize))

          call DbgMessage('y_Dim-attrs(%d) [attrname=<%c> '            // &
               & 'attrtype=<%c> array=<%b> cvalue=<%c>  '         // &
               & 'ivalue=<%d> rvalue=<%r> dvalue=<%f> '           // &
               & 'iarray(1:%d)=<%d, ...> '                        // &
               & 'rarray(1:%d)=<%r, ...> darray(1:%d)=<%f, ...>'   , &
               & c1=trim( y_Dim%attrs(k)%attrname )                  , &
               & c2=trim( y_Dim%attrs(k)%attrtype )                  , &
               & c3=trim( y_Dim%attrs(k)%cvalue )                    , &
               & i=(/ k, y_Dim%attrs(k)%ivalue    ,                    &
               &      size(y_Dim%attrs(k)%iarray) ,                    &
               &      y_Dim%attrs(k)%iarray       ,                    &
               &      size(y_Dim%attrs(k)%rarray) ,                    &
               &      size(y_Dim%attrs(k)%darray)                      &
               &   /)                                                , &
               & r=(/y_Dim%attrs(k)%rvalue, y_Dim%attrs(k)%rarray/)    , &
               & d=(/y_Dim%attrs(k)%dvalue, y_Dim%attrs(k)%darray/)    , &
               & l=(/y_Dim%attrs(k)%lvalue/)                      )

          if (.not. next) exit axis_y_attr_nml_input
          next      = .false.  ! Τν

       enddo axis_y_attr_nml_input

    end if

    call nmlfile_close

    !----------------------------------------------------------------
    !   grid_3d_mod Ȥå
    !----------------------------------------------------------------
    if (y_Dim%axisinfo%length /= jm) then
       call MessageNotify('E', subname, &
            & message='axis length is inconsistent with im in grid_3d_mod')
    endif

    !----------------------------------------------------------------
    !   㳰
    !----------------------------------------------------------------
    if (length < 1) then
       call MessageNotify('E', subname, message='Invalid grid number.')
    endif


    call EndSub( subname )
  end subroutine axis_y_init


                                                                 !=begin
  !=== Return Weight of axis Y
  !
  !ŤߥǡȤղþ֤
  !((< axis_y_init >))  NAMELIST axis_y_nml  decision ѿ
  !(({ 'spectral' })) ʳͿ줿ͤʤ֤
  !
  !ޤY μѿ˽Ťߥǡ˴ؤղþä롣
  !
  subroutine axis_y_weight(Dim_Weight)
  !==== Dependency
    use constants_mod, only: constants_init, pi
    use axis_type_mod, only: axis_type_copy, axis_attrs_copy, axis_attrs_init
    use spml_mod,   only: wa_module_y_Lat_Weight => y_Lat_Weight
    use grid_3d_mod,only: jm
    use gt4_history,only: GT_HISTORY_ATTR
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Output
    !
    type(AXISINFO), intent(out) :: Dim_Weight ! 礹ѿ
                                                                 !=end
    type(GT_HISTORY_ATTR), allocatable :: attrs_tmp(:) ! Ǽ

    character(STRING), parameter:: subname = "axis_y_weight"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_y_initialized) then
       call EndSub( subname, 'Call axis_y_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'spectral' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_y_data_from_spectral) then
       call EndSub( subname, &
            & 'In axis_y_nml, configurated to not generate from spmodel')
       return
    endif

    !----------------------------------------------------------------
    !   Initialize Dependent module
    !----------------------------------------------------------------
    call constants_init()

    !----------------------------------------------------------------
    !   y_Dim ξ󤫤 y_Dim_Weight ξ
    !----------------------------------------------------------------
    y_Dim_Weight%axisinfo%name     = trim(y_Dim%axisinfo%name) // '_weight'
    y_Dim_Weight%axisinfo%length   = y_Dim%axisinfo%length
    y_Dim_Weight%axisinfo%longname = trim(y_Dim%axisinfo%longname) // ' weight'
    y_Dim_Weight%axisinfo%units    = trim(y_Dim%axisinfo%units)
    y_Dim_Weight%axisinfo%xtype    = trim(y_Dim%axisinfo%xtype)
    if ( allocated(y_Dim_Weight%attrs) ) then
       deallocate( y_Dim_Weight%attrs )
    endif

    ! y_Dim ˤղ
    if ( allocated(y_Dim%attrs) ) then
       allocate( attrs_tmp(size(y_Dim%attrs)) )
       call axis_attrs_copy(from=y_Dim%attrs(:), to=attrs_tmp(:))
       deallocate( y_Dim%attrs )
       allocate( y_Dim%attrs(size(attrs_tmp)+1) )
       call axis_attrs_copy(from=attrs_tmp(:), to=y_Dim%attrs(1:size(attrs_tmp)) )

       call axis_attrs_init( y_Dim%attrs(size(attrs_tmp)+1) )
       y_Dim%attrs(size(attrs_tmp)+1)%attrname = 'gt_calc_weight'
       y_Dim%attrs(size(attrs_tmp)+1)%attrtype = 'char'
       y_Dim%attrs(size(attrs_tmp)+1)%cvalue   = y_Dim_Weight%axisinfo%name
       y_Dim%attrs(size(attrs_tmp)+1)%array    = .false.
    else
       allocate( y_Dim%attrs(1) )
       call axis_attrs_init( y_Dim%attrs(1) )
       y_Dim%attrs(1)%attrname = 'gt_calc_weight'
       y_Dim%attrs(1)%attrtype = 'char'
       y_Dim%attrs(1)%cvalue   = y_Dim_Weight%axisinfo%name
       y_Dim%attrs(1)%array    = .false.
    endif

    !----------------------------------------------------------------
    !   wa_module 饹ڥȥǡ롣
    !----------------------------------------------------------------
    allocate( y_Dim_Weight%a_Dim(jm) )
    ! 饸ٿѴ
    y_Dim_Weight%a_Dim(:) = wa_module_y_Lat_Weight(:) * 180. / pi
    y_Dim_Weight%stored   = .true.

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(y_Dim_Weight, Dim_Weight)
    call EndSub( subname )
  end subroutine axis_y_weight


                                                                 !=begin
  !=== Return Data of axis Y for Spectral Method.
  !
  !ڥȥˡѤꤷ Y Υǡ֤
  !
  !((< axis_y_init >))  NAMELIST axis_y_nml  units 
  !(({ 'radian' })) ޤ (({ 'rad.' })) Ϳˤ
  !ñ̤饸ǥǡ֤롣ʳǤٿǥǡ֤롣
  !
  !((< axis_y_init >))  NAMELIST axis_y_nml  decision ѿ
  !(({ 'spectral' })) ʳͿ줿ͤʤ֤
  !
  subroutine axis_y_spectral(Dim)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use constants_mod, only: constants_init, pi
    use spml_mod,   only: wa_module_y_Lat => y_Lat
    use dc_string,  only: toChar, StrHead, LChar
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING), parameter:: subname = "axis_y_spectral"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_y_initialized) then
       call EndSub( subname, 'Call axis_y_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'spectral' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_y_data_from_spectral) then
       call EndSub( subname, &
            & 'In axis_y_nml, configurated to not generate from spmodel')
       return
    endif

    !----------------------------------------------------------------
    !   Initialize Dependent module
    !----------------------------------------------------------------
    call constants_init()

    !----------------------------------------------------------------
    !   wa_module 饹ڥȥǡ롣
    !----------------------------------------------------------------
    if (  StrHead( 'radians', trim(LChar(y_Dim%axisinfo%units)) ) .or. &
         & StrHead( 'rad.', trim(LChar(y_Dim%axisinfo%units)) )  ) then
       ! radian ǤΤޤ
       y_Dim%a_Dim(:) = wa_module_y_Lat(:)
    else
       ! radian  degree Ѵ
       y_Dim%a_Dim(:) = wa_module_y_Lat(:) * 180. / pi
    end if

    y_Dim%stored   = .true.

    call DbgMessage('y_Lat=<%c>', c1=trim(toChar(y_Dim%a_Dim)) )

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(y_Dim, Dim)
    call EndSub( subname )
  end subroutine axis_y_spectral


                                                                 !=begin
  !=== Return Data of axis Y from NAMELIST
  !
  !NAMELIST 줿ǡ Y ǡȤ֤
  !
  !((< axis_y_init >))  NAMELIST axis_y_nml  decision ѿ
  !(({ 'manual' })) ʳͿ줿ͤʤ֤
  !
  subroutine axis_y_manual(Dim)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use spml_mod,   only: wa_module_y_Lat => y_Lat
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING), parameter:: subname = "axis_y_manual"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_y_initialized) then
       call EndSub( subname, 'Call axis_y_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  'manual' Ǥʤߤ֤
    !----------------------------------------------------------------
    if (.not. axis_y_data_from_manual) then
       call EndSub( subname, &
            & 'In axis_y_nml, configurated to not generate from manual')
       return
    endif

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(y_Dim, Dim)
    call EndSub( subname )
  end subroutine axis_y_manual


                                                                 !=begin
  !=== Return Data of axis Y from netCDF file
  !
  !netCDF ǡǡ Y ΥǡȤ֤
  !
  !ߡΥǡñ̤˴ؤ餺Τޤޥǡ
  !Ϥ롣((<Known Bugs>)) ȡ
  !
  !((< axis_y_init >))  NAMELIST axis_y_nml  decision ѿ
  !gtool4 ѿʳͿ줿ͤʤ֤
  !
  subroutine axis_y_netcdf(Dim)
  !==== Dependency
    use axis_type_mod, only: axis_type_copy
    use gt4_history,only: HistoryGet
    use dc_url  ,   only: UrlSplit
    use dc_trace,   only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== In/Out
    !
    type(AXISINFO), intent(inout) :: Dim        ! 礹ѿ
                                                                 !=end
    character(STRING)           :: file
    character(STRING)           :: varname

    character(STRING), parameter:: subname = "axis_y_netcdf"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )
    if (.not. axis_y_initialized) then
       call EndSub( subname, 'Call axis_y_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   decision  '***@lon' ʤɤǤʤߤ֤
    !----------------------------------------------------------------
    if (axis_y_data_from_netcdf == '') then
       call EndSub( subname, &
            & 'In axis_y_nml, configurated to not generate from netcdf data')
       return
    endif

    !----------------------------------------------------------------
    !   HistoryGet ˤǡ
    !----------------------------------------------------------------
    call UrlSplit(axis_y_data_from_netcdf, file=file, var=varname)
    call HistoryGet(file, varname, y_Dim%a_Dim)
    y_Dim%stored   = .true.

    !  Ϥǡ units  'degree'  'radian' Ĵ١
    !  'radian' Ѵθ塢y_Dim%axisinfo%units 
    ! 'degree'  'radian' ˱ 180. / pi ݤ뤫ɤ
    ! Ƚꤹ٤

    !----------------------------------------------------------------
    !   intent(out) ΰ˥ǡϤ
    !----------------------------------------------------------------
    call axis_type_copy(y_Dim, Dim)
    call EndSub( subname )
  end subroutine axis_y_netcdf


                                                                 !=begin
  !=== Terminate module
  !
  !((<axis_y_init>)) ꤵ줿ͤ˴ǥեȤ᤹
  !
  subroutine axis_y_end()
  !==== Dependency
    use dc_trace,  only: DbgMessage, BeginSub, EndSub
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "axis_y_end"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. axis_y_initialized) then
       call EndSub( subname, 'axis_y_init was not called', &
            &       c1=trim(subname) )
       return
    else
       axis_y_initialized = .false.
       axis_y_data_from_spectral = .false.
       axis_y_data_from_manual   = .false.
       axis_y_data_from_netcdf   = ''

       !--------------------------------------------------------------
       !   Initialize y_Dim
       !--------------------------------------------------------------
       y_Dim%stored   = .false.
       y_Dim%axisinfo%name     = ''
       y_Dim%axisinfo%length   = 0
       y_Dim%axisinfo%longname = ''
       y_Dim%axisinfo%units    = ''
       y_Dim%axisinfo%xtype    = ''
       if ( allocated(y_Dim%a_Dim) ) then
          deallocate( y_Dim%a_Dim )
       endif

       if ( allocated(y_Dim%attrs) ) then
          deallocate( y_Dim%attrs )
       end if

       !--------------------------------------------------------------
       !   Initialize y_Dim_Weight
       !--------------------------------------------------------------
       y_Dim_Weight%axisinfo%name     = ''
       y_Dim_Weight%axisinfo%length   = 0
       y_Dim_Weight%axisinfo%longname = ''
       y_Dim_Weight%axisinfo%units    = ''
       y_Dim_Weight%axisinfo%xtype    = ''

       if ( allocated(y_Dim%a_Dim) ) then
          deallocate( y_Dim%a_Dim )
       end if

       if ( allocated(y_Dim%attrs) ) then
          deallocate( y_Dim%attrs )
       end if

    endif

    call EndSub( subname )
  end subroutine axis_y_end

end module axis_y_mod
