!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module dycore_out_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: dycore_out.f90,v 1.8 2005/01/09 16:47:33 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!gtool4 netCDF data Output module directly called by GCM run program.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
module dycore_out_mod
                                                                 !=begin
  !== Dependency
  use dycore_type_mod, only : STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: dycore_out_init, dycore_out_put, dycore_out_end ! subroutines
                                                                 !=end

  logical, save :: dycore_out_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: dycore_out.f90,v 1.8 2005/01/09 16:47:33 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module
  !
  !((< io_gt4_out_mod >)) νȡꤪ
  !ȯŸ̤νϤνԤʤ
  !
  subroutine dycore_out_init(Dims)
    use dycore_type_mod, only: DYCORE_DIMS
    use io_gt4_out_mod , only: io_gt4_out_init, io_gt4_out_SetDims, &
         &                     io_gt4_out_SetVars
    use dc_trace       , only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(DYCORE_DIMS), intent(in):: Dims  ! ǡ
                                                                 !=end
    !----- ѿ -----
    character(len = *),  parameter:: subname = "dycore_out_init"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (dycore_out_initialized) then
       call EndSub( subname, '%c is already called.', c1=trim(subname) )
       return
    else
       dycore_out_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !-----------------------------------------------------------------
    !   io_gt4_out_mod ν
    !-----------------------------------------------------------------
    call io_gt4_out_init       ! ǡϤν

    !-----------------------------------------------------------------
    !   Ѥμǡ
    !-----------------------------------------------------------------
    call io_gt4_out_SetDims(Dims%x_Lon)       ! ٺɸŤߥǡ
    call io_gt4_out_SetDims(Dims%y_Lat)       ! ٺɸŤߥǡ
    call io_gt4_out_SetDims(Dims%z_Sigma)     ! ҥ٥ɸǡ
    call io_gt4_out_SetDims(Dims%r_Sigma) ! Ⱦҥ٥ɸǡ

    !-----------------------------------------------------------------
    !   Ѥѿǡ
    !-----------------------------------------------------------------
    call io_gt4_out_SetVars('VelLon')
    call io_gt4_out_SetVars('VelLat')
    call io_gt4_out_SetVars('Vor')
    call io_gt4_out_SetVars('Div')
    call io_gt4_out_SetVars('Temp')
    call io_gt4_out_SetVars('QVap')
    call io_gt4_out_SetVars('Ps')

    call EndSub(subname)
  end subroutine dycore_out_init


                                                                 !=begin
  !=== Put DYCORE_VARS Data.
  !
  !ʻǡ Vars Ϥ롣
  !
  subroutine dycore_out_put(Vars)
  !==== Dependency
    use dycore_type_mod, only : DYCORE_VARS, DBKIND, REKIND
    use io_gt4_out_mod,  only : io_gt4_out_Put
    use dc_trace,        only : BeginSub, EndSub, DbgMessage, DataDump
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    type(DYCORE_VARS), intent(in):: Vars  ! ʻǡ
                                                                 !=end
    !----- ѿ -----
    character(len = *),  parameter:: subname = "dycore_out_put"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_out_initialized) then
       call EndSub( subname, 'Call dycore_out_init before call %c',  &
            &       c1=trim(subname) )
       return
    endif

!!$    call io_gt4_out_Put(  'VelLon', real(Vars%xyz_VelLon(:,:,:), REKIND)  )
!!$    call io_gt4_out_Put(  'VelLat', real(Vars%xyz_VelLat(:,:,:), REKIND)  )
!!$    call io_gt4_out_Put(  'Vor' , real(Vars%xyz_Vor(:,:,:) , REKIND)  )
!!$    call io_gt4_out_Put(  'Div' , real(Vars%xyz_Div(:,:,:) , REKIND)  )
!!$    call io_gt4_out_Put(  'Temp', real(Vars%xyz_Temp(:,:,:), REKIND)  )
!!$    call io_gt4_out_Put(  'QVap', real(Vars%xyz_QVap(:,:,:), REKIND)  )
!!$    call io_gt4_out_Put(  'Ps'  , real(Vars%xy_Ps(:,:)     , REKIND)  )

    call io_gt4_out_Put(  'VelLon', real(Vars%xyz_VelLon(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'VelLat', real(Vars%xyz_VelLat(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'Vor' , real(Vars%xyz_Vor(:,:,:) , DBKIND)  )
    call io_gt4_out_Put(  'Div' , real(Vars%xyz_Div(:,:,:) , DBKIND)  )
    call io_gt4_out_Put(  'Temp', real(Vars%xyz_Temp(:,:,:), DBKIND)  )
    call io_gt4_out_Put(  'QVap', real(Vars%xyz_QVap(:,:,:), DBKIND)  )
!!$    call io_gt4_out_Put(  'Ps'  , real(Vars%xy_Ps(:,:)     , DBKIND)  )

    ! ƥѤˡ hPa ǽ
    call io_gt4_out_Put(  'Ps'  , real(Vars%xy_Ps(:,:)     , DBKIND)/100.0d0  )

    call EndSub(subname)
  end subroutine dycore_out_put



                                                                 !=begin
  !=== Terminate module
  !
  !((< io_gt4_out_mod >)) νλԤʤ
  !
  subroutine dycore_out_end
  !==== Dependency
    use io_gt4_out_mod, only : io_gt4_out_end
    use dc_trace,       only : BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-------------------------------------------------------------------
    !   ѿ
    !-------------------------------------------------------------------
    !----- ѿ -----
    character(len = *),  parameter:: subname = "dycore_out_end"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. dycore_out_initialized) then
       call EndSub( subname, 'dycore_out_init was not called', &
            &       c1=trim(subname) )
       return
    else
       dycore_out_initialized = .false.
    endif

    call io_gt4_out_end

    call EndSub(subname)
  end subroutine dycore_out_end

end module dycore_out_mod
