!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module dycore_in_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: dycore_in.f90,v 1.5 2005/01/09 15:14:24 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!gtool4 netCDF data Input module directly called by GCM run program.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!ޤƥȥʤ⥸塼Ȳ⥸塼ڤʬ
!٤Τʤʬ¿ĤäƤ롣
!ڤʬŪˤϤ٤Ǥ롣
!
                                                                 !=end
module dycore_in_mod
                                                                 !=begin
  !== Dependency
  use dycore_type_mod, only : STRING, DBKIND
  use dycore_grid_mod, only : im, jm, km
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: dycore_in_init, dycore_in_dims  ! subroutines
  public :: dycore_in_vars, dycore_in_end   ! subroutines
                                                                 !=end

  !-------------------------------------------------------------------
  !   dycore_in_init ˤͤꤹ
  !-------------------------------------------------------------------
  character(STRING), save :: &
    &
    & input_file_save   , &  ! ͥե
    &
    & vlonname_save     , &  ! ®ٷʬѿ̾
    & vlatname_save     , &  ! ®ٰʬѿ̾
    & vorname_save      , &  ! ٤ѿ̾
    & divname_save      , &  ! ȯѿ̾
    & psname_save       , &  ! ɽ̵ѿ̾
    & tempname_save     , &  ! ٤ѿ̾
    & qvapname_save          ! 漾ѿ̾

  real(DBKIND), save :: input_time_save(2)  ! ϥǡλ


  logical, save :: dycore_in_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: dycore_in.f90,v 1.5 2005/01/09 15:14:24 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name: dcpam2-20050405 $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine dycore_in_init
  !==== Dependency
    use dycore_type_mod, only : STRING, DBKIND, INTKIND
    use nmlfile_mod, only : nmlfile_init, nmlfile_open, nmlfile_close
    use axis_x_mod, only: axis_x_init
    use axis_y_mod, only: axis_y_init
    use axis_z_mod, only: axis_z_init
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
    use dc_message,only: MessageNotify
    use dc_string, only: toChar
                                                                 !=end
    implicit none
                                                                 !=begin
    !
    !==== NAMELIST
    !
    character(STRING) :: &
         &
         & input_file = 'init.nc'  , &  ! ͥե
         &
         & vlonname   = 'vlon'     , &  ! ®ٷʬѿ̾
         & vlatname   = 'vlat'     , &  ! ®ٰʬѿ̾
         & vorname    = 'vor'      , &  ! ٤ѿ̾
         & divname    = 'div'      , &  ! ȯѿ̾
         & psname     = 'ps'       , &  ! ɽ̵ѿ̾
         & tempname   = 'temp'     , &  ! ٤ѿ̾
         & qvapname   = 'qvap'          ! 漾ѿ̾

    real(DBKIND) :: input_time(2) = (/0,0/)  ! ϥǡλ

    namelist /dycore_in_nml/ &
         &
         & input_file   , &  ! ͥե
         & input_time   , &  ! ϥǡλ (t-t, t)
         &
         & vlonname     , &  ! ®ٷʬѿ̾
         & vlatname     , &  ! ®ٰʬѿ̾
         & vorname      , &  ! ٤ѿ̾
         & divname      , &  ! ȯѿ̾
         & psname       , &  ! ɽ̵ѿ̾
         & tempname     , &  ! ٤ѿ̾
         & qvapname          ! 漾ѿ̾
                                                                 !=end

    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable
    character(STRING), parameter:: subname = "dycore_in_init"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (dycore_in_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       dycore_in_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   axis_x_mod, axis_y_mod, axis_z_mod ν
    !----------------------------------------------------------------
    call axis_x_init
    call axis_y_init
    call axis_z_init

    !----------------------------------------------------------------
    !   read dycore_in_nml
    !----------------------------------------------------------------
    ! Initialization
    input_file    = 'init.nc' ! ͥե
    vlonname      = 'vlon'    ! ®ٷʬѿ̾
    vlatname      = 'vlat'    ! ®ٰʬѿ̾
    vorname       = 'vor'     ! ٤ѿ̾
    divname       = 'div'     ! ȯѿ̾
    psname        = 'ps'      ! ɽ̵ѿ̾
    tempname      = 'temp'    ! ٤ѿ̾
    qvapname      = 'qvap'    ! 漾ѿ̾
    input_time(:) = 0.0d0  ! ϥǡλ

    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=dycore_in_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST dycore_in_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=dycore_in_nml)
    else
       call DbgMessage('Not Read NAMELIST dycore_in_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST dycore_in_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    !----------------------------------------------------------------
    !   receive NAMELIST information
    !----------------------------------------------------------------
    input_file_save = input_file
    vlonname_save   = vlonname  
    vlatname_save   = vlatname  
    vorname_save    = vorname   
    divname_save    = divname   
    psname_save     = psname    
    tempname_save   = tempname  
    qvapname_save   = qvapname  
    input_time_save = input_time

    !----------------------------------------------------------------
    !   㳰
    !----------------------------------------------------------------
    if (input_file == '') then
       call MessageNotify('E', subname, &
            &             message='Input File Name is Vacancy.')
    endif

!!$    if (vloname == '' .or. vlatname == '' .or. vorname == '' &
!!$         & divname == '' .or. psname == '' .or. tempname == '' &
!!$         & qvapname == '') then
!!$       ! ѿ̾Ϥ̵äǥեȤͤ褦ˤ롣
!!$       !call MessageNotify('E', subname, 'Variable Name is Vacancy.')
!!$    endif

    call EndSub( subname, '[%c], [%c]', &
         & c1='input_file=<'      // trim(input_file)  // '>, ' // &
         &    'input_time=<' // trim(toChar(input_time)) // '>, ', &
         & c2='vlonname=<' // trim(vlonname) // '>, ' // &
         &    'vlatname=<' // trim(vlatname) // '>, ' // &
         &    'vorname=<'  // trim(vorname)  // '>, ' // &
         &    'divname=<'  // trim(divname)  // '>, ' // &
         &    'psname=<'   // trim(psname)   // '>, ' // &
         &    'tempname=<' // trim(tempname) // '>, ' // &
         &    'qvapname=<' // trim(qvapname) // '>, ' )
  end subroutine dycore_in_init


                                                                 !=begin
  !=== Return Data and Information of Dimensions
  !
  !((< axis_x_mod >)), ((< axis_y_mod >)), ((< axis_z_mod >))
  !ɸDims ˳Ǽ֤
  !
  subroutine dycore_in_dims(Dims)
  !==== Dependency
    use dycore_type_mod, only: DYCORE_DIMS
    use dycore_grid_mod, only: im, jm, km
    use axis_x_mod, only: axis_x_spectral, axis_x_manual, axis_x_netcdf
    use axis_y_mod, only: axis_y_spectral, axis_y_manual, axis_y_netcdf
    use axis_z_mod, only: axis_z_manual, axis_z_netcdf, &
         &                axis_z_sigmahalf_manual, axis_z_sigmahalf_netcdf
    use gt4_history,only: HistoryGetPointer
    use dc_trace,   only: BeginSub, EndSub, DbgMessage
    use dc_string,  only: toChar
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Output
    !
    type(DYCORE_DIMS), intent(out):: Dims  ! ǡ
                                                                 !=end
    !----- ѿ -----
    character(len = *),  parameter:: subname = "dycore_in_dims"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_in_initialized) then
       call EndSub( subname, 'Call dycocre_in_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   ǡ
    !----------------------------------------------------------------
    call axis_x_spectral(Dims%x_Lon) ! ٺɸǡ
    call axis_x_manual(Dims%x_Lon)   ! ٺɸǡ
    call axis_x_netcdf(Dims%x_Lon)   ! ٺɸǡ

    call axis_y_spectral(Dims%y_Lat) ! ٺɸǡ
    call axis_y_manual(Dims%y_Lat) ! ٺɸǡ
    call axis_y_netcdf(Dims%y_Lat) ! ٺɸǡ

    call axis_z_sigmahalf_manual &
         & ( Dims%z_Sigma      , &   ! ҥ٥ɸǡ
         &   Dims%r_Sigma  )     ! Ⱦҥ٥ɸǡ
    call axis_z_sigmahalf_netcdf &
         & ( Dims%z_Sigma      , &   ! ҥ٥ɸǡ
         &   Dims%r_Sigma  )     ! Ⱦҥ٥ɸǡ

    call axis_z_manual &
         & ( Dims%z_Sigma      )     ! ҥ٥ɸǡ
    call axis_z_netcdf &
         & ( Dims%z_Sigma      )     ! ҥ٥ɸǡ

    call EndSub(subname)
  end subroutine dycore_in_dims


                                                                 !=begin
  !=== Return Data and Information of Dimensions
  !
  !((< dycore_in_init >))  NAMELIST ((< dycore_in_nml >))
  !ξ˽ѿǡΥǡϤơ
  !Vars_B  Vars ֤
  !
  subroutine dycore_in_vars(Vars_B, Vars)
  !==== Dependency
    use dycore_type_mod, only: DYCORE_VARS
    use dycore_grid_mod, only: im, jm, km
    use gt4_history,     only: HistoryGetPointer
    use dc_trace,        only: BeginSub, EndSub, DbgMessage
    use dc_string,       only: toChar
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Output
    !
    type(DYCORE_VARS), intent(out):: Vars_B  ! ʻǡ (t-t)
    type(DYCORE_VARS), intent(out):: Vars    ! ʻǡ (t)
                                                                 !=end
    !----- ѿ -----
    character(len = *),  parameter:: subname = "dycore_in_vars"

  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (.not. dycore_in_initialized) then
       call EndSub( subname, 'Call dycocre_in_init before call %c', &
            &       c1=trim(subname) )
       return
    endif

    !---------------------------------------------------------------------
    !  HistoryGetPointer [in gt4f90io] ˤ (Vars_B )
    !---------------------------------------------------------------------
    !----- ʻǡ(®ٷʬ) -----
    if (.not. trim(vlonname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(vlonname_save)         , &
            & array=Vars_B%xyz_VelLon          , &
            & time=input_time_save(1)       )
       call DbgMessage('Input VelLon_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(vlonname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input VelLon_B data')
    endif

    !----- ʻǡ(®ٰʬ) -----
    if (.not. trim(vlatname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(vlatname_save)         , &
            & array=Vars_B%xyz_VelLat          , &
            & time=input_time_save(1)       )
       call DbgMessage('Input VelLat_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(vlatname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input VelLat_B data')
    endif

    !----- ʻǡ(ʬ) -----
    if (.not. trim(vorname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(vorname_save)          , &
            & array=Vars_B%xyz_Vor           , &
            & time=input_time_save(1)       )
       call DbgMessage('Input Vor_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(vorname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input Vor_B data')
    endif

    !----- ʻǡ(ȯʬ) -----
    if (.not. trim(divname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(divname_save)          , &
            & array=Vars_B%xyz_Div           , &
            & time=input_time_save(1)       )
       call DbgMessage('Input Div_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(divname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input Div_B data')
    endif

    !----- ʻǡ(ʬ) -----
    if (.not. trim(tempname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(tempname_save)         , &
            & array=Vars_B%xyz_Temp          , &
            & time=input_time_save(1)       )
       call DbgMessage('Input Temp_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(tempname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input Temp_B data')
    endif

    !----- ʻǡ(漾ʬ) -----
    if (.not. trim(qvapname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(qvapname_save)         , &
            & array=Vars_B%xyz_QVap          , &
            & time=input_time_save(1)       )
       call DbgMessage('Input QVap_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(qvapname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input QVap_B data')
    endif

    !----- ʻǡ(ɽ̵ʬ) -----
    if (.not. trim(psname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(psname_save)           , &
            & array=Vars_B%xy_Ps             , &
            & time=input_time_save(1)       )
       call DbgMessage('Input Ps_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(psname_save)  , &
            &        c3=toChar( input_time_save(1) )             )
    else
       call DbgMessage('Not Input Ps_B data')
    endif


    !---------------------------------------------------------------------
    !  HistoryGetPointer [in gt4f90io] ˤ (Vars )
    !---------------------------------------------------------------------
    !----- ʻǡ(®ٷʬ) -----
    if (.not. trim(vlonname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(vlonname_save)         , &
            & array=Vars%xyz_VelLon            , &
            & time=input_time_save(2)       )
       call DbgMessage('Input VelLon_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(vlonname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input VelLon_B data')
    endif

    !----- ʻǡ(®ٰʬ) -----
    if (.not. trim(vlatname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(vlatname_save)         , &
            & array=Vars%xyz_VelLat            , &
            & time=input_time_save(2)       )
       call DbgMessage('Input VelLat_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(vlatname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input VelLat_B data')
    endif

    !----- ʻǡ(ʬ) -----
    if (.not. trim(vorname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(vorname_save)          , &
            & array=Vars%xyz_Vor             , &
            & time=input_time_save(2)       )
       call DbgMessage('Input Vor_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(vorname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input Vor_B data')
    endif

    !----- ʻǡ(ȯʬ) -----
    if (.not. trim(divname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(divname_save)          , &
            & array=Vars%xyz_Div             , &
            & time=input_time_save(2)       )
       call DbgMessage('Input Div_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(divname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input Div_B data')
    endif

    !----- ʻǡ(ʬ) -----
    if (.not. trim(tempname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(tempname_save)         , &
            & array=Vars%xyz_Temp            , &
            & time=input_time_save(2)       )
       call DbgMessage('Input Temp_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(tempname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input Temp_B data')
    endif

    !----- ʻǡ(漾ʬ) -----
    if (.not. trim(qvapname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(qvapname_save)         , &
            & array=Vars%xyz_QVap            , &
            & time=input_time_save(2)       )
       call DbgMessage('Input QVap_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(qvapname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input QVap_B data')
    endif

    !----- ʻǡ(ɽ̵ʬ) -----
    if (.not. trim(psname_save) == '') then
       call HistoryGetPointer(                 &
            & file=trim(input_file_save)     , &
            & varname=trim(psname_save)           , &
            & array=Vars%xy_Ps               , &
            & time=input_time_save(2)       )
       call DbgMessage('Input Ps_B data from %c@%c,time=%c'   , &
            &        c1=trim(input_file_save), c2=trim(psname_save)  , &
            &        c3=toChar( input_time_save(2) )             )
    else
       call DbgMessage('Not Input Ps_B data')
    endif


    call EndSub(subname)
  end subroutine dycore_in_vars


                                                                 !=begin
  !=== Terminate module
  !
  !((< dycore_in_init>)) ꤵ줿ͤ˴
  !ǥեȤͤᤷޤ
  !
  subroutine dycore_in_end
  !==== Dependency
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
    use dc_error,  only: StoreError, USR_ECHAR
    use dc_string, only: toChar
                                                                 !=end
    implicit none
    character(STRING), parameter:: subname = "dycore_in_end"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. dycore_in_initialized) then
       call EndSub( subname, 'dycore_in_init was not called', &
            &       c1=trim(subname) )
       return
    else
       dycore_in_initialized = .false.
    endif

    !-----------------------------------------------------------------
    !   Initialize information for data input
    !-----------------------------------------------------------------
    input_file_save = 'init.nc'
    vlonname_save   = 'vlon'
    vlatname_save   = 'vlat'
    vorname_save    = 'vor' 
    divname_save    = 'div' 
    psname_save     = 'ps'  
    tempname_save   = 'temp'
    qvapname_save   = 'qvap'
    input_time_save = 0.0d0

    call EndSub(subname)
  end subroutine dycore_in_end


!!$  !----------------------------------------------------------------
!!$  !   ǡΥå
!!$  !----------------------------------------------------------------
!!$  subroutine arraysize_check
!!$
!!$  end subroutine arraysize_check
  
end module dycore_in_mod
