!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Program init
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: init.f90,v 1.12 2005/01/20 16:37:40 morikawa Exp $
!   * Tag Name: $Name: dcpam2-20050405 $
!   * Change History: 
!
!== Overview
!
!Generate Various Initial Data
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end
program init
                                                                 !=begin
  !== Dependency
  !----- ¤λȥ⥸塼 -----
  use type_mod, only: STRING, INTKIND, REKIND, DBKIND
  use nmlfile_mod, only: nmlfile_init, nmlfile_open, nmlfile_close
  use constants_mod, only: constants_init, pi, R0

  !----- ʻ⥸塼 -----
  use grid_3d_mod,         only: grid_3d_init, im, jm, km, grid_3d_end
  use grid_wavenumber_mod, only: grid_wavenumber_init, nm, grid_wavenumber_end

  !----- ɸǡ⥸塼 -----
  use axis_type_mod, only: AXISINFO
  use axis_x_mod, only: axis_x_init, axis_x_weight, axis_x_spectral, axis_x_end
  use axis_y_mod, only: axis_y_init, axis_y_weight, axis_y_spectral, axis_y_end
  use axis_z_mod, only: axis_z_init, axis_z_sigmahalf_manual, axis_z_end

  !----- ǡI/O⥸塼 -----
  use io_gt4_out_mod, only : io_gt4_out_init   , io_gt4_out_SetDims, &
       &                     io_gt4_out_SetVars, io_gt4_out_Put    , &
       &                     io_gt4_out_end

  !----- ⥸塼 -----
  use time_mod, only: time_init, tvar, ttype, tname, tunit, time_end

  !----- SPMODEL ⥸塼  -----
  use spml_mod,  only: spml_init, xya_wa, wa_Div_xya_xya &
       &              ,wa_LaplaInv_wa, wa_xya, xya_GradLat_wa, xya_GradLon_wa

  !----- ǥХåѥġ -----
  use dc_trace,  only: SetDebug, DbgMessage, BeginSub, EndSub, DataDump
  use dc_string, only: toChar, StriEq, LChar, StrHead
  use dc_message,only: MessageNotify
                                                                 !=end
  implicit none
                                                                 !=begin
  !== NAMELIST
  !
  !ͤμԤʤ
  ! condition ͿͭʤΤϰʲͤǤ롣
  !
  !  * (({ rigid body rotation })) 
  !    * βžήͿ롣®κͤ VelLonMax_rbr Ϳ롣
  !      * 򤷤硢Ū VorDiv_Priority  .false. 
  !        ꤵ롣
  !
  !  * (({ convex of surface pressure }))
  !    * ɽ̵ΡֻפͿ롣֤ȥϡٿͿ
  !      Lon_Center_Dig, Lat_Center_Dig, LonLatRadius_Dig Ѥ
  !      饸Ϳ Lon_Center_Rad, Lat_Center_Rad,
  !      LonLatRadius_Rad Ѥ (Rad_Priority  .true.
  !      ˤɬפ) ͤ PsMax Ϳ롣
  !
  !  * (({ convex of temperature }))
  !    * ٤ΡֻפͿ롣֤ȥϡٿͿ
  !      Lon_Center_Dig, Lat_Center_Dig, LonLatRadius_Dig Ѥ
  !      饸Ϳ Lon_Center_Rad, Lat_Center_Rad,
  !      LonLatRadius_Rad Ѥ (Rad_Priority  .true.
  !      ˤɬפ) ͤ TempMax Ϳ롣
  !
  !  * ¾
  !    * ̵νͤͿ롣
  !
  !VelLonAve, VelLonAve, VelLatAve, VorAve, DivAve, TempAve, QVapAve, PsAve
  !ˤϡ줾ʿͤͿ롣
  !
  !ǥեȤǤ®鱲ȯ뤬
  !VorDiv_Priority  .true. ˤǡȯ®롣
  !
  character(STRING) :: condition = ''      ! ͤμ

  real(DBKIND)      :: VelLonAve = 0.0d0   ! ®ٷʬʿ
  real(DBKIND)      :: VelLatAve = 0.0d0   ! ®ٰʬʿ
  real(DBKIND)      :: VorAve    = 0.0d0   ! ʿ
  real(DBKIND)      :: DivAve    = 0.0d0   ! ȯʿ
  real(DBKIND)      :: TempAve   = 273.0d0 ! ʿ
  real(DBKIND)      :: QVapAve   = 0.0d0   ! 漾ʿ
  real(DBKIND)      :: PsAve     = 1.0d5   ! ɽ̰ʿ

  logical           :: VorDiv_Priority = .false. ! ȯ®

  !  !for 'rigid body rotation'
  real(DBKIND)      :: VelLonMax_rbr = 1.0d2    ! Maximum of 'VelLon'

  !  !for 'convex of surface pressure' or 'convex of temperature'
  real(DBKIND)      :: LonLat_Radius_Deg  = 20.0   ! Ⱦ (ٿ)
  real(DBKIND)      :: LonLat_Radius_Rad  = 0.349  ! Ⱦ (饸)

  real(DBKIND)      :: Lat_Center_Deg = 45.0  ! ٤濴 (ٿ)
  real(DBKIND)      :: Lon_Center_Deg = 100.0 ! ٤濴 (ٿ)
  real(DBKIND)      :: Lat_Center_Rad = 0.785 ! ٤濴 (饸)
  real(DBKIND)      :: Lon_Center_Rad = 1.745 ! ٤濴 (饸)

  logical           :: Rad_Priority   = .false. ! 饸ɽͥ

  !  !for 'convex of surface pressure'
  real(DBKIND)      :: PsMax   = -200.0d2       ! Maximum of 'Ps'

  !  !for 'convex of temperature'
  real(DBKIND)      :: TempMax = 10.0d0         ! Maximum of 'Temp'

  namelist /init_nml/ &
       & condition           , & ! ͤμ
       &
       & VelLonAve           , & ! ®ٷʬʿ
       & VelLatAve           , & ! ®ٰʬʿ
       & VorAve              , & ! ʿ        
       & DivAve              , & ! ȯʿ        
       & TempAve             , & ! ʿ        
       & QVapAve             , & ! 漾ʿ        
       & PsAve               , & ! ɽ̰ʿ  
       &
       & VorDiv_Priority     , & ! ȯ®
       &
       & VelLonMax_rbr       , & ! ®ٷʬ (βžή)
       &
       & LonLat_Radius_Deg   , & ! Ⱦ (ٿ)
       & LonLat_Radius_Rad   , & ! Ⱦ (饸)
       &
       & Lat_Center_Deg      , & ! ٤濴 (ٿ)
       & Lon_Center_Deg      , & ! ٤濴 (ٿ)
       & Lat_Center_Rad      , & ! ٤濴 (饸)
       & Lon_Center_Rad      , & ! ٤濴 (饸)
       &
       & Rad_Priority        , & ! 饸ɽͥ
       &
       & PsMax               , & ! Maximum of 'Ps'
       &
       & TempMax                 ! Maximum of 'Temp'
                                                                 !=end

  !For Generate AXES
  type(AXISINFO)::          &
       & x_Lon            , & ! ٺɸ
       & x_Lon_Weight     , & ! ٽŤߺɸ
       & y_Lat            , & ! ٺɸ
       & y_Lat_Weight     , & ! ٽŤߺɸ
       & z_Sigma          , & ! ҥ٥()ɸ
       & r_Sigma              ! ҥ٥(Ⱦ)ɸ

  !For Generate Initial Data
  real(DBKIND), pointer     ::  &
       & xyz_VelLon(:,:,:)    , & ! ʻǡ(®ٷʬ)
       & xyz_VelLat(:,:,:)    , & ! ʻǡ(®ٰʬ)
       & xyz_Vor(:,:,:)       , & ! ʻǡ()
       & xyz_Div(:,:,:)       , & ! ʻǡ(ȯ)
       & xyz_Temp(:,:,:)      , & ! ʻǡ()
       & xyz_QVap(:,:,:)      , & ! ʻǡ(漾)
       & 
       & xyz_Ps(:,:,:)               ! ʻǡ(ɽ̵)

  !Axes data (for Use as 3-dimensional data)
  real(DBKIND), allocatable :: &
       & xyz_Lon(:,:,:)      , & ! ٺɸ (饸ɽ)
       & xyz_Lat(:,:,:)      , & ! ٺɸ (饸ɽ)
       & xyz_Sigma(:,:,:)    , & ! ҥ٥()ɸ  
       & xyr_Sigma(:,:,:)        ! ҥ٥(Ⱦ)ɸ
  real(DBKIND) :: RadDegFact     ! 饸ٿѴ뷸

  !for Generate Velocity from Vorticity and Divergence
  real(DBKIND), allocatable :: &
       & wz_Psi(:,:)         , & ! ڥȥ(ήؿ)
       & wz_Chi(:,:)             ! ڥȥ(ݥƥ󥷥)

  !for nmlfile_mod
  integer(INTKIND)   :: nmlstat, nmlunit
  logical            :: nmlreadable

  !----- ѿ -----
  integer(INTKIND)   :: i,j,k

  character(STRING),  parameter:: version = &
       & '$Id: init.f90,v 1.12 2005/01/20 16:37:40 morikawa Exp $'
  character(STRING),  parameter:: tagname = '$Name: dcpam2-20050405 $'
  character(STRING),  parameter:: subname = "init"

  !-------------------------------------------------------------------
  !   Set Debug Mode
  !-------------------------------------------------------------------
  call SetDebug

  call BeginSub(subname)

  !----------------------------------------------------------------
  !   Version identifier
  !----------------------------------------------------------------
  call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

  !-------------------------------------------------------------------
  !   NAMELIST file Setting
  !-------------------------------------------------------------------
  call nmlfile_init('init.nml')

  !----------------------------------------------------------------
  !   Read init_nml
  !----------------------------------------------------------------
  call nmlfile_open(nmlunit, nmlreadable)
  if (nmlreadable) then
     read(nmlunit, nml=init_nml, iostat=nmlstat)
     call DbgMessage('Stat of NAMELIST init_nml Input is <%d>', &
          &           i=(/nmlstat/))
     write(0, nml=init_nml)
  else
     call DbgMessage('Not Read NAMELIST init_nml')
     call MessageNotify('W', subname, &
          & 'Can not Read NAMELIST init_nml. Force Use Default Value.')
  end if
  call nmlfile_close

  !-------------------------------------------------------------------
  !   Initialize Dependent Modules
  !-------------------------------------------------------------------
  call constants_init        ! 
  call grid_3d_init          ! ֳʻμ
  call grid_wavenumber_init  ! ȿʻμ
  call axis_x_init           ! ɸǡ
  call axis_y_init           ! ɸǡ
  call axis_z_init           ! ɸǡ
  call io_gt4_out_init       ! ǡϤν
  call constants_init        ! ʪμ
  call spml_init             ! SPMODEL ν

  !-------------------------------------------------------------------
  !  ǡ
  !-------------------------------------------------------------------
!!$  call axis_x_weight(x_Lon_Weight)    ! ٺɸŤߥǡ
  call axis_x_spectral(x_Lon)         ! ٺɸǡ
!!$  call axis_y_weight(y_Lat_Weight)    ! ٺɸŤߥǡ
  call axis_y_spectral(y_Lat)         ! ٺɸǡ
  call axis_z_sigmahalf_manual &
       & ( z_Sigma           , &      ! ҥ٥ɸǡ
       &   r_Sigma  )                 ! Ⱦҥ٥ɸǡ

  !-------------------------------------------------------------------
  !   Ѥμǡ
  !-------------------------------------------------------------------
  call io_gt4_out_SetDims(x_Lon)        ! ٺɸŤߥǡ
!!$  call io_gt4_out_SetDims(x_Lon_Weight) ! ٺɸǡ
  call io_gt4_out_SetDims(y_Lat)        ! ٺɸŤߥǡ
!!$  call io_gt4_out_SetDims(y_Lat_Weight) ! ٺɸǡ
  call io_gt4_out_SetDims(z_Sigma)      ! ҥ٥ɸǡ
  call io_gt4_out_SetDims(r_Sigma)  ! Ⱦҥ٥ɸǡ

  !-------------------------------------------------------------------
  !   Ѥѿǡ
  !-------------------------------------------------------------------
  call io_gt4_out_SetVars('VelLon')
  call io_gt4_out_SetVars('VelLat')
  call io_gt4_out_SetVars('Vor')
  call io_gt4_out_SetVars('Div')
  call io_gt4_out_SetVars('Temp')
  call io_gt4_out_SetVars('QVap')
  call io_gt4_out_SetVars('Ps')

  !-------------------------------------------------------------------
  !   Allocate Variable
  !-------------------------------------------------------------------
  allocate( xyz_VelLon(im,jm,km) )
  allocate( xyz_VelLat(im,jm,km) )
  allocate( xyz_Vor(im,jm,km)  )
  allocate( xyz_Div(im,jm,km)  )
  allocate( xyz_Temp(im,jm,km) )
  allocate( xyz_QVap(im,jm,km) )
  allocate( xyz_Ps(im,jm,km)   )

  allocate( xyz_Lon(im,jm,km) )
  allocate( xyz_Lat(im,jm,km) )
  allocate( xyz_Sigma(im,jm,km) )
  allocate( xyr_Sigma(im,jm,km+1) )

  allocate( wz_Psi((nm+1)*(nm+1), km) )
  allocate( wz_Chi((nm+1)*(nm+1), km) )

  !-------------------------------------------------------------------
  !   Set Average Value
  !-------------------------------------------------------------------
  xyz_VelLon = VelLonAve
  xyz_VelLat = VelLatAve
  xyz_Vor    = VorAve
  xyz_Div    = DivAve
  xyz_Temp   = TempAve
  xyz_QVap   = QVapAve
  xyz_Ps     = PsAve

  !-------------------------------------------------------------------
  !  Create 3-dimentional axis data
  !-------------------------------------------------------------------
  if (  StrHead( 'radians', trim(LChar(x_Lon%axisinfo%units)) ) .or.&
       & StrHead( 'rad.', trim(LChar(x_Lon%axisinfo%units)) ) ) then
     RadDegFact = 1.
  else
     RadDegFact = 180. / pi
  end if

  do i = 1, im
     xyz_Lon(i,:,:) = x_Lon%a_Dim(i) / RadDegFact
  end do

  if (  StrHead( 'radians', trim(LChar(y_Lat%axisinfo%units)) ) .or.&
       & StrHead( 'rad.', trim(LChar(y_Lat%axisinfo%units)) ) ) then
     RadDegFact = 1.
  else
     RadDegFact = 180. / pi
  end if
  do j = 1, jm
     xyz_Lat(:,j,:) = y_Lat%a_Dim(j) / RadDegFact
  end do

  do k = 1, km
     xyz_Sigma(:,:,k) = z_Sigma%a_Dim(k)
  end do

  do k = 1, km + 1
     xyr_Sigma(:,:,k) = r_Sigma%a_Dim(k)
  end do

!!$  call DataDump('x_Lon1', x_Lon%a_Dim, strlen=70)
!!$  call DataDump('x_Lon2', x_Lon%a_Dim * RadDegFact , strlen=70)
!!$  call DataDump('x_Lon3', xyz_Lon / RadDegFact , strlen=70)
!!$  call DataDump('xyz_Lon', xyz_Lon, strlen=70)
!!$  call DataDump('xyz_Lat', xyz_Lat, strlen=70)
!!$  call DataDump('xyz_Sigma', xyz_Sigma, strlen=70)

  !-------------------------------------------------------------------
  !   Set Various Conditions
  !-------------------------------------------------------------------
  if (  StriEq( 'rigid body rotation', trim(condition) )  ) then
     ! βžή
     xyz_VelLon = xyz_VelLon + VelLonMax_rbr * cos( xyz_Lat )
     VorDiv_Priority = .false.

     call MessageNotify('M', subname, &
          & 'Selected <%c>.', c1=trim(LChar(condition))  )

!!$     call DataDump('xyz_Lat', xyz_Lat, strlen=80)
!!$     call DataDump('y_Lat', y_Lat%a_Dim, strlen=80)
!!$     call DataDump('xyz_VelLon', xyz_VelLon, strlen=80)

  elseif (  StriEq( 'convex of surface pressure', &
       &             trim(condition) )  ) then

     ! ٿ饸Ѵ뤿
     RadDegFact = 180. / pi
     if (.not. Rad_Priority) then
        LonLat_Radius_Rad = LonLat_Radius_Deg / RadDegFact
        Lat_Center_Rad    = Lat_Center_Deg    / RadDegFact
        Lon_Center_Rad    = Lon_Center_Deg    / RadDegFact
     end if

     xyz_Ps = xyz_Ps &
          & + PsMax &
          &   * ( 1.0d0 &
          &        - sqrt(  &
          &               min(  LonLat_Radius_Rad**2 ,              &
          &                     ( xyz_Lon - Lon_Center_Rad )**2     &
          &                       + ( xyz_Lat - Lat_Center_Rad )**2 &
          &                  )     &
          &              ) / LonLat_Radius_Rad  &
          &      )

     call MessageNotify('M', subname, &
          & 'Selected <%c>.', c1=trim(LChar(condition))  )

  elseif (  StriEq( 'convex of temperature', &
       &             trim(condition) )  ) then

     ! ٿ饸Ѵ뤿
     RadDegFact = 180. / pi
     if (.not. Rad_Priority) then
        LonLat_Radius_Rad = LonLat_Radius_Deg / RadDegFact
        Lat_Center_Rad    = Lat_Center_Deg    / RadDegFact
        Lon_Center_Rad    = Lon_Center_Deg    / RadDegFact
     end if

     xyz_Temp = xyz_Temp &
          & + TempMax &
          &   * ( 1.0D0 &
          &        - sqrt(  &
          &               min(  LonLat_Radius_Rad**2 ,              &
          &                     ( xyz_Lon - Lon_Center_Rad )**2     &
          &                       + ( xyz_Lat - Lat_Center_Rad )**2 &
          &                  )     &
          &              ) / LonLat_Radius_Rad  &
          &      )

!!!     xyz_VelLon = xyz_VelLon &
!!!          & + TempMax &
!!!          &   * ( 1.0D0 &
!!!          &        - sqrt(  &
!!!          &               min(  LonLat_Radius_Rad**2 ,              &
!!!          &                     ( xyz_Lon - Lon_Center_Rad )**2     &
!!!          &                       + ( xyz_Lat - Lat_Center_Rad )**2 &
!!!          &                  )     &
!!!          &              ) / LonLat_Radius_Rad  &
!!!          &      )
!!!
!!!     xyz_VelLat = xyz_VelLat &
!!!          & + TempMax &
!!!          &   * ( 1.0D0 &
!!!          &        - sqrt(  &
!!!          &               min(  LonLat_Radius_Rad**2 ,              &
!!!          &                     ( xyz_Lon - Lon_Center_Rad )**2     &
!!!          &                       + ( xyz_Lat - Lat_Center_Rad )**2 &
!!!          &                  )     &
!!!          &              ) / LonLat_Radius_Rad  &
!!!          &      )
!!!
!!!     xyz_QVap = xyz_QVap &
!!!          & + TempMax &
!!!          &   * ( 1.0D0 &
!!!          &        - sqrt(  &
!!!          &               min(  LonLat_Radius_Rad**2 ,              &
!!!          &                     ( xyz_Lon - Lon_Center_Rad )**2     &
!!!          &                       + ( xyz_Lat - Lat_Center_Rad )**2 &
!!!          &                  )     &
!!!          &              ) / LonLat_Radius_Rad  &
!!!          &      )

     call MessageNotify('M', subname, &
          & 'Selected <%c>.', c1=trim(LChar(condition))  )

  else
     call MessageNotify('M', subname, &
          & 'Selected Isothermal and Nowind (Default).'  )
  end if


  !-------------------------------------------------------------------
  !   Generate Vorticity and Divergence from Velocity
  !-------------------------------------------------------------------
  if ( .not. VorDiv_Priority ) then
     xyz_Vor = &
          & xya_wa(                                            &
          &   wa_Div_xya_xya( xyz_VelLat , - xyz_VelLon ) / R0 &
          & )

     xyz_Div = &
          & xya_wa(                                            &
          &   wa_Div_xya_xya( xyz_VelLon ,   xyz_VelLat ) / R0 &
          & )
  end if


  !-------------------------------------------------------------------
  !   Generate Velocity from Vorticity and Divergence
  !-------------------------------------------------------------------
  if ( VorDiv_Priority ) then
     wz_Psi = wa_LaplaInv_wa(  wa_xya( xyz_Vor )  ) * R0**2
     wz_Chi = wa_LaplaInv_wa(  wa_xya( xyz_Div )  ) * R0**2

     xyz_VelLon = (  xya_GradLon_wa( wz_Chi ) &
          &                - xya_GradLat_wa( wz_Psi )  ) / R0

     xyz_VelLat = (  xya_GradLon_wa( wz_Psi ) &
          &                + xya_GradLat_wa( wz_Chi )  ) / R0
  end if


  !-------------------------------------------------------------------
  !   ǡν (t-t)
  !-------------------------------------------------------------------
  call io_gt4_out_Put('VelLon' , real(xyz_VelLon(:,:,:), REKIND) )
  call io_gt4_out_Put('VelLat' , real(xyz_VelLat(:,:,:), REKIND) )
  call io_gt4_out_Put('Vor'  , real(xyz_Vor(:,:,:) , REKIND) )
  call io_gt4_out_Put('Div'  , real(xyz_Div(:,:,:) , REKIND) )
  call io_gt4_out_Put('Temp' , real(xyz_Temp(:,:,:), REKIND) )
  call io_gt4_out_Put('QVap' , real(xyz_QVap(:,:,:), REKIND) )
  call io_gt4_out_Put('Ps'   , real(xyz_Ps(:,:,1)  , REKIND) )


  !-------------------------------------------------------------------
  !   ǡν (t)
  !-------------------------------------------------------------------
  call io_gt4_out_Put('VelLon' , real(xyz_VelLon(:,:,:), REKIND) )
  call io_gt4_out_Put('VelLat' , real(xyz_VelLat(:,:,:), REKIND) )
  call io_gt4_out_Put('Vor'  , real(xyz_Vor(:,:,:) , REKIND) )
  call io_gt4_out_Put('Div'  , real(xyz_Div(:,:,:) , REKIND) )
  call io_gt4_out_Put('Temp' , real(xyz_Temp(:,:,:), REKIND) )
  call io_gt4_out_Put('QVap' , real(xyz_QVap(:,:,:), REKIND) )
  call io_gt4_out_Put('Ps'   , real(xyz_Ps(:,:,1)  , REKIND) )

  !-------------------------------------------------------------------
  !   λ
  !-------------------------------------------------------------------
  call grid_3d_end          ! ֳʻμ
  call grid_wavenumber_end  ! ȿʻμ
  call axis_x_end           ! ɸǡ
  call axis_y_end           ! ɸǡ
  call axis_z_end           ! ɸǡ
  call io_gt4_out_end       ! ǡϤν

  call EndSub(subname)
end program init
