!= ͥǡ
!
!= Prepare initial data
!
! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. TAKAHASHI (code by Taro KITANO is included)
! Version::   $Id: initial_data.f90,v 1.14 2014/05/07 09:39:20 murashin Exp $ 
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module initial_data
  !
  != ͥǡ
  !
  != Prepare initial data
  !
  ! ͥǡΥץ󶡤ޤ. 
  ! 
  ! ߤϰʲΥǡ󶡤ޤ. 
  ! 
  ! * Small Disturbance of Temperature
  !   * ®: 0 [m/s], ɽ̵: 1.0e+5 [Pa], 漾: 1.0e-10 [kg kg-1]
  !   * : 250 [K] ä
  !
  ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
  !   * ®: 0 [m/s], ɽ̵: 1.0e+5 [Pa], 漾: 1.0e-10 [kg kg-1]
  !   * : 250 [K] ä
  ! 
  ! * Sugiyama et al. (2008)
  !   * 絤ꤷ, Sugiyama et al. (2008) ѤƤ
  !     ͤ魯. 
  !   * ®: 0 [m/s], ɽ̵: 3.0e+6 [Pa]
  !   * : $ \sigma = 1 $  490 [K] Ȥ,  1.0e+4 Ȥʤ٤ޤ, 
  !     ̰ (Ǯ˱ä) ٤ȼ٤򸺾. 
  !      1.0e+4 ʲι٤ǤϲٰȤ. 
  !   * 漾: $ \sigma = 1 $  6.11641e-3 [kg kg-1] Ȥ, 
  !     漾˰漾 75 % Ȥʤ٤ޤǤϰȤ. 
  !     ιٰʾǤ, 漾˰漾 75 % Ȥ. 
  !
  ! Prepare sample data of initial data (restart data)
  !
  ! Now, following data are provided. 
  ! 
  ! * Small Disturbance of Temperature
  !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa], 
  !     Specific humidity: 1.0e-10 [kg kg-1]
  !   * Temperature: 250 [K] and perturbation
  !
  ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
  !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa], 
  !     Specific humidity: 1.0e-10 [kg kg-1]
  !   * Temperature: 250 [K] and perturbation
  ! 
  ! * Sugiyama et al. (2008)
  !   * Initial data like a Jovian atmosphere  
  !     that is used in Sugiyama et al. (2008) is imitated. 
  !   * Velocity: 0 [m/s], Surface pressure: 3.0e+6 [Pa]
  !   * Temperature: 490 [K] at $ \sigma = 1 $ . 
  !     And it is declined with constant potential temperature
  !     (along dry adiabat line) 
  !     below where air pressure is 1.0e+4. 
  !     It is constant above where air pressure is 1.0e+4. 
  !   * Specific humidity: 6.11641e-3 [kg kg-1] at $ \sigma = 1 $ .
  !     And it is constant below where it is same as 75 % of 
  !     saturation specific humidity. 
  !     Above that, specific humidity is 75 % of saturation specific humidity. 
  !
  !== Procedures List
  !
  ! SetInitData   :: ͥǡ
  ! ------------  :: ------------
  ! SetInitData   :: Get initial data
  !
  !== NAMELIST
  !
  ! NAMELIST#initial_data_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetInitData
  public:: InitDataInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: initial_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(STRING), save, public:: Pattern
                              ! ͥǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Initial data pattern
                              ! Available patterns are as follows.
                              ! 
                              ! * "Small Disturbance of Temperature" (default value)
                              ! * "AGCM 5.3 Default"
                              ! * "Sugiyama et al. (2008)"
                              ! 
  real(DP), save, public:: TempAvr
                              ! $ \bar{T} $ .     ʿ. Mean temperature
  real(DP), save, public:: PsAvr
                              ! $ \bar{p_s} $ .   ɽ̵ʿ. Mean surface pressure
  real(DP), save, public:: QVapAvr
                              ! $ \bar{q} $ .     漾ʿ. Mean specific humidity
  real(DP), save, public:: Ueq
                              ! $ u_{eq} $ .      ƻ®. Eastward wind on the equator
  real(DP), save, public:: UGeos
                              ! $ u_{g} $ .       Eastward geostrophic wind
  real(DP), save, public:: VGeos
                              ! $ v_{g} $ .       Northward geostrophic wind

  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'initial_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: initial_data.f90,v 1.14 2014/05/07 09:39:20 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetInitData( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
    & )
    !
    ! ͥǡΥץ󶡤ޤ. 
    ! 
    ! Prepare sample data of initial data
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm

    ! ߥ饰ήƥѽͺ
    ! Preparation of initial condition for SLTT advection
    !
    use sltt_debug, only : SLTTDebugSetUV, SLTTDebugSetQ


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. initial_data_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( LChar( trim(Pattern) ) )
    case ( 'small disturbance of temperature' )
      !
      ! ʲپΤŻ߾
      ! Stationary field with small disturbance of temperature
      !

      xyz_U    = 0.0_DP
      xyz_V    = 0.0_DP
      xyz_Temp = TempAvr
      xy_Ps    = PsAvr
      xyz_QVap = QVapAvr

      ! ٤˾Ϳ
      ! Add perturbation to temperature
      !
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax - 1
            xyz_Temp(i,j,k) = &
              &    xyz_Temp(i,j,k) &
              &  + 0.1_DP * sin ( x_Lon(i) * y_Lat(j) ) &
              &  - 0.1_DP * ( 1.0_DP - z_Sigma(k) )
          end do
        end do
      end do

      ! ®Ϳ
      ! Add eastward wind
      !
      do j = 1, jmax
        xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
      end do

    case ( 'agcm 5.3 default' )
      !
      ! AGCM5.3 ΥǥեȽ
      ! AGCM5.3 default initial values
      !

      xyz_U    = 0.0_DP
      xyz_V    = 0.0_DP
      xyz_Temp = TempAvr
      xy_Ps    = PsAvr
      xyz_QVap = QVapAvr

      ! ٤˾Ϳ
      ! Add perturbation to temperature
      !
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax - 1
            xyz_Temp(i,j,k) = &
              &    xyz_Temp(i,j,k) &
              &  + 0.1_DP &
              &    * sin ( real( ( i + 1 ) &
              &                  * ( jmax - j + 1 ) &
              &                  * ( kmax - k ), DP ) &
              &            / real( imax &
              &                    * jmax &
              &                    * kmax, DP ) * 10.0_DP &
              &                 )
          end do
        end do
      end do

      ! ®Ϳ
      ! Add eastward wind
      !
      do j = 1, jmax
        xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
      end do

    case ( 'sugiyama et al. (2008)' )
      !
      ! Sugiyama et al. (2008) ν
      ! Initial values of Sugiyama et al. (2008)
      !
      call Sugiyamaetal2008InitData( &
        & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
        & )

    case ( 'polvani et al. (2004)' )
      !
      ! Polvani et al. (2004) ν
      ! Initial values of Polvani et al. (2004)
      !
      call Polvanietal2004InitData( &
        & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
        & )

    case ( 'venus' )

      call VenusInitData( &
        & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps & ! (out)
        & )

    case ( '1-d profile' )

      xyz_U = UGeos
      xyz_V = VGeos

      call Set1DProfilePs( &
        & xy_Ps &
        & )

      do k = 1, kmax
        xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
      end do
      call Set1DProfileAtm(      &
        & xyz_Press,                   &
        & xyz_Temp, xyz_QVap           &
        & )

    case ( 'sltt debug' )

      call SLTTDebugSetUV( &
        & Ueq,             & ! (in)
        & xyz_U, xyz_V     & ! (out)
        & )
      xyz_Temp = TempAvr
      xy_Ps    = PsAvr
      call SLTTDebugSetQ( &
        & xyz_QVap        & ! (out)
        & )

    end select

  end subroutine SetInitData

  !--------------------------------------------------------------------------------------

  subroutine Sugiyamaetal2008InitData( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
    & )
    !
    ! Sugiyama et al. (2008) ν
    ! Initial values of Sugiyama et al. (2008)
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & CpDry, &              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & GasRDry               ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure

    ! Sugiyama et al. (2008) Ѻѿ
    ! Work variables for Sugiyama et al. (2008)
    !
    real(DP):: xyz_PotTemp (0:imax-1, 1:jmax, 1:kmax)
                              ! . Potential temperature
    real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! . Air pressure
    real(DP):: xy_TempMin (0:imax-1, 1:jmax)
                              ! ٤κǾ. Minimum value of temperature
    real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
                              ! ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. initial_data_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_U    = 0.0_DP
    xyz_V    = 0.0_DP
    xyz_Temp = TempAvr
    xy_Ps    = PsAvr
    xyz_QVap = QVapAvr

    ! ٤η׻
    ! Calculate temperature
    !
    xyz_PotTemp = TempAvr
    xy_TempMin  = TempAvr

    do k = 1, kmax
      xyz_Temp(:,:,k) = xyz_PotTemp(:,:,k) &
        &                  * ( z_Sigma(k) )**( GasRDry / CpDry )

      if ( PsAvr * z_Sigma(k) < 1.0e+4_DP ) then
        xyz_Temp(:,:,k) = xy_TempMin
      else
        xy_TempMin = xyz_Temp(:,:,k)
      end if
    end do

    ! ٤˾Ϳ
    ! Add perturbation to temperature
    !
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax - 1
          xyz_Temp(i,j,k) = &
            &    xyz_Temp(i,j,k) &
            &  + 0.1_DP &
            &    * sin ( real( ( i + 1 ) &
            &                  * ( jmax - j + 1 ) &
            &                  * ( kmax - k ), DP ) &
            &            / real( imax &
            &                    * jmax &
            &                    * kmax, DP ) * 10.0_DP &
            &                 )
        end do
      end do
    end do

    ! ˰漾׻
    ! Calculate saturation specific humidity
    !
    do k = 1, kmax
      xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
    end do

    xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )

    ! 漾η׻
    ! Calculate specific humidity
    !
    where ( xyz_QVap > xyz_QVapSat * 0.75_DP )
      xyz_QVap = xyz_QVapSat * 0.75_DP
    end where


  end subroutine Sugiyamaetal2008InitData

  !--------------------------------------------------------------------------------------

  subroutine Polvanietal2004InitData( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
    & )
    !
    ! Polvani et al. (2004) ν
    !
    ! initial data by Polvani et al. (2004)
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $.
                              ! ߼Ψ. Circular constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &            ! $ a $ [m].
                              ! Ⱦ.
                              ! Radius of planet
      & Omega, &              ! $ \Omega $ [s-1].
                              ! ž®.
                              ! Angular velocity
      & GasRDry               ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] .
                              ! ٺɸŤ.
                              ! Weight of latitude

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! Ť, ʬη׻
    ! Calculate Gauss node and Gaussian weight
    !
    use gauss_quad, only : GauLeg


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure


    ! ѿ
    ! Work variables
    !

    ! ѥ᥿
    ! 
    !
    !
    real(DP), parameter:: dz0 = 5.0e3_DP
                              ! dz_0 [m].
    real(DP), parameter:: z0  = 22.0e3_DP
                              ! z_0 [m]
    real(DP), parameter:: z1  = 30.0e3_DP
                              ! z_1 [m]
    real(DP), parameter:: U0  = 50.0_DP
                              ! u_0 [m s^-1]

    real(DP), parameter:: ScaleHeight = 7.34e3_DP
                              ! ScaleHeight [m]

    real(DP):: z_Height (1:kmax)
                              ! height [m]
    real(DP):: z_F (1:kmax)
                              ! function used to calculate zonal wind and temperature
    real(DP):: z_DFDZ (1:kmax)
                              ! z derivative of z_F
    real(DP):: z_TempUSStd(1:kmax)
                              ! Temperature by US Standard atmosphere [K]


    integer, parameter :: NGauQuad = 100
    real(DP)           :: a_GauQuadLat( 1:NGauQuad )
    real(DP)           :: a_GauWeight ( 1:NGauQuad )
    real(DP)           :: az_U        ( 1:NGauQuad, 1:kmax )
    real(DP)           :: az_DUDZ     ( 1:NGauQuad, 1:kmax )
    real(DP)           :: az_DTempDPhi( 1:NGauQuad, 1:kmax )
    real(DP)           :: z_Temp0     (1:kmax)


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: l               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ¹ʸ ; Executable statement

    if ( .not. initial_data_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ٤η׻
    ! Calculate height
    !

    do k = 1, kmax
      z_Height = - ScaleHeight * log( z_Sigma )
    end do

    do k = 1, kmax
      if      ( z_Height(k) * 1.0e-3_DP < 11.0_DP ) then
        z_TempUSStd(k) = 288.15_DP - 6.5_DP * z_Height(k) * 1.0e-3_DP
      else if ( z_Height(k) * 1.0e-3_DP < 20.0_DP ) then
        z_TempUSStd(k) = 216.65_DP
      else if ( z_Height(k) * 1.0e-3_DP < 32.0_DP ) then
        z_TempUSStd(k) = 216.65_DP + 1.0_DP * ( z_Height(k) * 1.0e-3_DP - 20.0_DP )
      else if ( z_Height(k) * 1.0e-3_DP < 47.0_DP ) then
        z_TempUSStd(k) = 228.65_DP + 2.8_DP * ( z_Height(k) * 1.0e-3_DP - 32.0_DP )
      else if ( z_Height(k) * 1.0e-3_DP < 51.0_DP ) then
        z_TempUSStd(k) = 270.65_DP
      else if ( z_Height(k) * 1.0e-3_DP < 71.0_DP ) then
        z_TempUSStd(k) = 270.65_DP - 2.8_DP * ( z_Height(k) * 1.0e-3_DP - 51.0_DP )
      else if ( z_Height(k) * 1.0e-3_DP < 80.0_DP ) then
        z_TempUSStd(k) = 214.65_DP - 2.0_DP * ( z_Height(k) * 1.0e-3_DP - 71.0_DP )
      else
        z_TempUSStd(k) = 196.65_DP
      end if
    end do

    z_F =                                                        &
      &   0.5_DP * ( 1.0_DP - tanh( ( z_Height - z0 ) / dz0 )**3 ) &
      & * sin( PI * z_Height / z1 )
    z_DFDZ =                                                                         &
      & - 1.5_DP / dz0                                                               &
      &   * tanh( ( z_Height - z0 ) / dz0 )**2 / cosh( ( z_Height - z0 ) / dz0 )**2  &
      &   * sin( PI * z_Height / z1 )                                                &
      & + 0.5_DP                                                                     &
      &   * ( 1.0_DP - tanh( ( z_Height - z0 ) / dz0 )**3 )                          &
      &   * PI / z1 * cos( PI * z_Height / z1 )



    xyz_U    = 0.0_DP
    xyz_V    = 0.0_DP
    xyz_Temp = 0.0_DP
    xy_Ps    = PsAvr
    xyz_QVap = QVapAvr


    ! ®η׻
    ! Calculate eastward wind
    !
    do k = 1, kmax
      do j = 1, jmax
        if ( y_Lat(j) > 0.0_DP ) then
          xyz_U(:,j,k) = U0 * sin( PI * sin( y_Lat(j) )**2 )**3 * z_F(k)
        else
          xyz_U(:,j,k) =0.0_DP
        end if
      end do
    end do


    ! ٤η׻
    ! Calculate temperature
    !
    do j = 1, jmax

      call GauLeg( -PI/2.0_DP, y_Lat(j), NGauQuad, a_GauQuadLat, a_GauWeight )

      do k = 1, kmax
        do l = 1, NGauQuad
          if ( a_GauQuadLat(l) > 0.0_DP ) then
            az_U   (l,k) = U0 * sin( PI * sin( a_GauQuadLat(l) )**2 )**3 * z_F(k)
            az_DUDZ(l,k) = U0 * sin( PI * sin( a_GauQuadLat(l) )**2 )**3 * z_DFDZ(k)
          else
            az_U   (l,k) =0.0_DP
            az_DUDZ(l,k) =0.0_DP
          end if
        end do
      end do

      do k = 1, kmax
        do l = 1, NGauQuad
          if ( a_GauQuadLat(l) > 0.0_DP ) then
            az_DTempDPhi(l,k) = - ScaleHeight / GasRDry                  &
              & * (  2.0_DP * RPlanet * Omega * sin( a_GauQuadLat(l) )   &
              &    + 2.0_DP * az_U(l,k) * tan( a_GauQuadLat(l) ) )       &
              & * az_DUDZ(l,k)
          else
            az_DTempDPhi(l,k) = 0.0_DP
          end if
        end do
      end do

      do k = 1, kmax
        xyz_Temp(:,j,k) = 0.0_DP
      end do
      do k = 1, kmax
        do l = 1, NGauQuad
          xyz_Temp(:,j,k) = xyz_Temp(:,j,k) + az_DTempDPhi(l,k) * a_GauWeight(l)
        end do
      end do

    end do

    !  Calculate T0
    !
    do k = 1, kmax
      z_Temp0(k) = 0.0_DP
      do j = 1, jmax
        z_Temp0(k) = z_Temp0(k) + xyz_Temp(0,j,k) * y_Lat_weight(j)
      end do
    end do
    z_Temp0 = z_Temp0 / 2.0_DP
    !
    !  add T0
    !
    do k = 1, kmax
      xyz_Temp(:,:,k) = xyz_Temp(:,:,k) - z_Temp0(k) + z_TempUSStd(k)
    end do


    ! Code for debug
!!$    do k = 1, kmax
!!$      z_Temp0(k) = 0.0_DP
!!$      do j = 1, jmax
!!$        z_Temp0(k) = z_Temp0(k) + xyz_Temp(0,j,k) * y_Lat_weight(j)
!!$      end do
!!$    end do
!!$    z_Temp0 = z_Temp0 / 2.0_DP
!!$    do k = 1, kmax
!!$      write( 6, * ) k, z_Temp0(k), z_TempUSStd(k), z_Temp0(k)-z_TempUSStd(k)
!!$    end do
!!$    stop



    ! ٤˾Ϳ
    ! Add perturbation to temperature
    !
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( ( x_Lon(i) >= 0 ) .and. ( x_Lon(i) < PI ) ) then
            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                             &
              & + 1.0_DP / cosh( 3.0_DP * ( x_Lon(i)               ) )**2 &
              & * 1.0_DP / cosh( 6.0_DP * ( y_Lat(j) - PI / 4.0_DP ) )**2
          else if ( ( x_Lon(i) >= PI ) .and. ( x_Lon(i) < 2.0_DP * PI ) ) then
            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                             &
              & + 1.0_DP / cosh( 3.0_DP * ( x_Lon(i) - 2.0_DP * PI ) )**2 &
              & * 1.0_DP / cosh( 6.0_DP * ( y_Lat(j) - PI / 4.0_DP ) )**2
          end if
        end do
      end do
    end do


  end subroutine Polvanietal2004InitData

  !--------------------------------------------------------------------------------------

  subroutine VenusInitData( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps & ! (out)
    & )

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: DP, &      ! ټ¿. Double precision.
      &                 STRING     ! ʸ.       Strings.


    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure
      & GasRDry               ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    use axesset, only: &
      & y_Lat, &              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma, &            ! $ \sigma $ ٥ ().
                              ! Full $ \sigma $ level
      & r_Sigma, &            ! $ \sigma $ ٥ (Ⱦ).
                              ! Half $ \sigma $ level
      & r_DelSigma            ! $ \Delta \sigma $ (Ⱦ).
                              ! $ \Delta \sigma $ (half)

    real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure


    !
    ! local variables
    !
    real(DP) :: SurfTemp
    real(DP) :: xyr_Temp     (0:imax-1,1:jmax,0:kmax)
    real(DP) :: xy_SurfHeight(0:imax-1,1:jmax)
    real(DP) :: xyz_Height   (0:imax-1,1:jmax,1:kmax)
    real(DP) :: z( 5 ), a( 6 ), ah( 5 ), d( 5 )
    integer  :: j
    integer  :: k
    integer  :: l
    integer  :: m


    ! Coefficients for thermal structure by Hou and Farrel (1987)
    !
    z ( 1 ) =   0.0e3_DP
    z ( 2 ) =  10.0e3_DP
    z ( 3 ) =  25.0e3_DP
    z ( 4 ) =  55.0e3_DP
    z ( 5 ) = 100.0e3_DP

    ah( 1 ) =  -1.0e-3_DP
    ah( 2 ) =  -1.0e-3_DP
    ah( 3 ) =  -3.1e-3_DP
    ah( 4 ) =  -6.75e-3_DP
    ah( 5 ) =  10.0e-3_DP

    d ( 1 ) =  10.0e3_DP
    d ( 2 ) =  10.0e3_DP
    d ( 3 ) =   8.0e3_DP
    d ( 4 ) =   5.0e3_DP
    d ( 5 ) =  70.0e3_DP


    a ( 1 ) =   0.0_DP
    do l = 2, 6
      a( l ) = 2.0_DP * ah( l-1 ) * d( l-1 ) + a( l-1 )
    end do


    SurfTemp      = 750.0_DP
    xy_SurfHeight =   0.0_DP


    ! Initialization
    xyz_Temp = 200.0_DP

    ! Iteration
    do m = 1, 10

      xyr_Temp(:,:,0) = xyz_Temp(:,:,1)
      do k = 1, kmax-1
        xyr_Temp(:,:,k) = ( xyz_Temp(:,:,k) + xyz_Temp(:,:,k+1) ) / 2.0_DP
      end do
      xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)


      xyz_Height(:,:,1) = &
        &   xy_SurfHeight &
        & + GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )
      do k = 2, kmax
        xyz_Height(:,:,k) = &
          &   xyz_Height(:,:,k-1) &
          & + GasRDry / Grav * xyr_Temp(:,:,k-1) &
          &   * r_DelSigma(k-1) / r_Sigma(k-1)
      end do

      xyz_Temp = SurfTemp - Grav / CpDry * xyz_Height
      do l = 1, 5
        xyz_Temp = xyz_Temp &
          & - ( a(l+1) - a(l) ) * 0.5_DP &
          &   * ( 1.0_DP + tanh( ( 0.0_DP      - z(l) ) / d(l) ) )
        xyz_Temp = xyz_Temp &
          & + ( a(l+1) - a(l) ) * 0.5_DP &
          &   * ( 1.0_DP + tanh( ( xyz_Height - z(l) ) / d(l) ) )
      end do

    end do

    ! add perturbation
    xyz_Temp(0,1,1) = xyz_Temp(0,1,1) + 1.0_DP


    do k = 1, kmax
      do j = 1, jmax
        xyz_U(:,j,k) = Ueq * cos(y_Lat(j))
      end do
    end do
    xyz_V    = 0.0_DP
    xyz_QVap = QVapAvr
    xy_Ps    = PsAvr


  end subroutine VenusInitData

  !--------------------------------------------------------------------------------------

  subroutine InitDataInit

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: SaturateInit


    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /initial_data_nml/ Pattern, &
      & TempAvr, PsAvr, QVapAvr, Ueq, UGeos, VGeos
          !
          ! ǥեͤˤĤƤϽ³ "initial_data#InitDataInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "initial_data#InitDataInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement

    if ( initial_data_inited ) return


    ! ǥեͤ (ޤ Pattern Τ)
    ! Default values settings (At first, "Pattern" only)
    !
    Pattern = 'Small Disturbance of Temperature'
    !Pattern = 'AGCM 5.3 Default'

    ! NAMELIST ɤ߹ (ޤ Pattern Τ)
    ! NAMELIST is input (At first, "Pattern" only)
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = initial_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ǥեͤ
    ! Default values settings
    !
    select case ( LChar( trim(Pattern) ) )
    case ( 'small disturbance of temperature' )
      TempAvr = 250.0_DP
      PsAvr   = 1.0e+5_DP
!!$      QVapAvr = 1.0e-10_DP
      QVapAvr = 0.0e0_DP
      Ueq     = 0.0_DP
      UGeos   = 0.0_DP
      VGeos   = 0.0_DP
    case ( 'agcm 5.3 default' )
      TempAvr = 250.0_DP
      PsAvr   = 1.0e+5_DP
      QVapAvr = 1.0e-10_DP
      Ueq     = 0.0_DP
      UGeos   = 0.0_DP
      VGeos   = 0.0_DP
    case ( 'sugiyama et al. (2008)' )
      TempAvr = 490.0_DP
      PsAvr   = 3.0e+6_DP
      QVapAvr = 6.11641e-3_DP
      Ueq     = 0.0_DP
      UGeos   = 0.0_DP
      VGeos   = 0.0_DP
    case ( 'polvani et al. (2004)' )
      TempAvr = 0.0_DP
      PsAvr   = 1.0e+5_DP
      QVapAvr = 0.0_DP
      Ueq     = 0.0_DP
      UGeos   = 0.0_DP
      VGeos   = 0.0_DP
    case ( 'venus' )
      TempAvr = 0.0_DP
      PsAvr   = 90.0e+5_DP
      QVapAvr = 0.0_DP
      Ueq     = 0.0_DP
      UGeos   = 0.0_DP
      VGeos   = 0.0_DP
    case ( '1-d profile' )
      TempAvr = 1.0e+100_DP
      PsAvr   = 1.0e+100_DP
      QVapAvr = 0.0_DP
      Ueq     = 0.0_DP
      UGeos   = 0.0_DP
      VGeos   = 0.0_DP
    case ( 'sltt debug' )
      TempAvr = 300.0_DP
      PsAvr   =   1.0e+5_DP
      QVapAvr =   0.0e0_DP
      Ueq     =  30.0_DP
      UGeos   =   0.0_DP
      VGeos   =   0.0_DP
    case default
      call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
        & c1 = trim(Pattern) )
    end select

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = initial_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! Initialization of modules used in this module
    !
    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    call SaturateInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
    call MessageNotify( 'M', module_name, '  TempAvr = %f', d = (/ TempAvr  /) )
    call MessageNotify( 'M', module_name, '  PsAvr   = %f', d = (/ PsAvr  /) )
    call MessageNotify( 'M', module_name, '  QVapAvr = %f', d = (/ QVapAvr  /) )
    call MessageNotify( 'M', module_name, '  Ueq     = %f', d = (/ Ueq  /) )
    call MessageNotify( 'M', module_name, '  UGeos   = %f', d = (/ UGeos /) )
    call MessageNotify( 'M', module_name, '  VGeos   = %f', d = (/ VGeos /) )
    call MessageNotify( 'M', module_name, '' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    initial_data_inited = .true.

  end subroutine InitDataInit

  !--------------------------------------------------------------------------------------

end module initial_data
