require 'rbconfig'
require 'find'
require 'ftools'
require 'optparse'

include Config

opt = OptionParser.new
libdir = nil
opt.on('--libdir=VAL') {|v| libdir  = v}
opt.parse!(ARGV)

libdir = File.expand_path(libdir) if libdir

if libdir
  sitedir = libdir
else
  sitedir = CONFIG["sitelibdir"]
  unless sitedir
    version = CONFIG["MAJOR"]+"."+CONFIG["MINOR"]
    libdir = File.join(CONFIG["libdir"], "ruby", version)
    sitedir = $:.find {|x| x =~ /site_ruby/}
    if !sitedir
      sitedir = File.join(libdir, "site_ruby")
    elsif sitedir !~ Regexp.quote(version)
      sitedir = File.join(sitedir, version)
    end
  end
end

unless /^\// =~ sitedir.strip
  sitedir = File.join("..", sitedir)
end

if !File.directory?(sitedir)
  $stderr.puts "Cannot find sitedir #{sitedir}"
  exit 1
end

rdoc_dest = File.join(sitedir, "rdoc")

dest = File.join(rdoc_dest, "markup")

File.mkpath(dest, true)

Find.find("simple_markup.rb",
          "simple_markup",
          "sample",
          "test") do |fname|
  if File.directory?(fname)
    next if fname =~ /CVS/
    File.mkpath(File.join(dest, fname), true)
  else
    next unless fname =~ /\.rb$/
    next if fname =~ /install.rb$/
    File.install(fname, File.join(dest, fname), 0444, true)
  end
end
