# This class is MathML module wrapper.
# If MathML module can not be loaded, methods in this module return
# raw argument without modification.

class MathMLWrapper
  def initialize
    @load_error_flag = false
    begin
      require "mathml"
    rescue LoadError
      @load_error_flag = true
    end
  end
  def parse(formula, block=false)
    return formula if @load_error_flag
    mathml_formula = MathML::LaTeX::Parser.new
    begin
      mathml_formula_str = mathml_formula.parse(formula, block).to_s
    rescue MathML::LaTeX::ParseError
      return formula, 1
    end
    return mathml_formula_str, 0
  end
end
