*-----------------------------------------------------------------------
*     uvSUT / uvDUT
*-----------------------------------------------------------------------
      SUBROUTINE uvSUT(CSIDE,CTTL)

      CHARACTER CSIDE*(*),CTTL*(*)

      PARAMETER (MAXTTL=10,MAXLEN=32)

      REAL      RSZ(MAXTTL)
      CHARACTER CSIDEZ(MAXTTL)*1,CTTLZ(MAXTTL)*(MAXLEN),CS1*1

      EQUIVALENCE ( RSIZE  , IRSIZE )

      SAVE


*     / CHECK INPUT ARGUMENTS /

      CS1=CSIDE(1:1)
      CALL CUPPER(CS1)

      IF (.NOT.(CS1.EQ.'X' .OR. CS1.EQ.'Y')) THEN
         CALL MSGDMP('W','uvSUT ','SIDE PARAMETER IS INVALID.')
         CALL MSGDMP('M','-CNT.-','DO NOTHING.')
         RETURN
      END IF

      IF (LENZ(CTTL).GT.MAXLEN) THEN
         CALL MSGDMP('W','uvSUT ','LENGTH OF TITLE IS TOO LONG.')
         CALL MSGDMP('M','-CNT.-','DO NOTHING.')
         RETURN
      END IF

      CALL uvPGET('IUNDEF',IUNDEF)
      CALL uvPGET('IUNTTL',NTTL)
      CALL uvPGET('RHFACT',RHFACT)

      NTTL=NTTL+1

      IF (NTTL.EQ.1) THEN
         CALL uvPGET('VXUOFF',VXUOFF)
         CALL uvPGET('VYUOFF',VYUOFF)
         CALL uvPGET('VUTOFF',VUTOFF)
         XTOFF=VXUOFF+VUTOFF
         YTOFF=VYUOFF+VUTOFF
      ELSE
         CALL uvPGET('VXUOFF',XTOFF)
         CALL uvPGET('VYUOFF',YTOFF)
      END IF

      CSIDEZ(NTTL)=CS1
      CTTLZ(NTTL)=CTTL
      CALL uvPGET('RSIZEUT',RSIZE)

      IF (IRSIZE.EQ.IUNDEF) THEN
         CALL UZPGET('RSIZEC2',RSZ(NTTL))
         CALL uvPSET('RSIZEUT',RSZ(NTTL))
      ELSE
         RSZ(NTTL)=RSIZE
      END IF

      IF (CS1.EQ.'X') THEN
         YTOFF=YTOFF+RSZ(NTTL)*RHFACT
      ELSE IF (CS1.EQ.'Y') THEN
         XTOFF=XTOFF+RSZ(NTTL)*RHFACT
      END IF

      CALL uvPSET('IUNTTL',NTTL)
      CALL uvPSET('VXUOFF',XTOFF)
      CALL uvPSET('VYUOFF',YTOFF)

      RETURN
*-----------------------------------------------------------------------
      ENTRY uvDUT

*     / DRAW TITLES FOR UNIT VECTOR /

      CALL uvPGET('IUNTTL',NTTL)
      CALL uvPGET('RHFACT',RHFACT)

      IF (NTTL.LE.0) THEN
         RETURN
      ELSE
         CALL uvPGET('VXULOC',VXULOC)
         CALL uvPGET('VYULOC',VYULOC)
         CALL uvPGET('VXUNIT',VXUNIT)
         CALL uvPGET('VYUNIT',VYUNIT)
         CALL uvPGET('UXUNIT',UXUNIT)
         CALL uvPGET('UYUNIT',UYUNIT)
         CALL uvPGET('IUINDX',IUINDX)
         CALL uvPGET('VUTOFF',VUTOFF)
         XOFF=VXULOC-VUTOFF
         YOFF=VYULOC-VUTOFF
         DO 10 ITTL=1,NTTL
            CALL SGSTXS(RSZ(ITTL))
            IF (CSIDEZ(ITTL).EQ.'X') THEN
               XX=VXULOC+VXUNIT*0.5
               YY=YOFF-RSZ(ITTL)*RHFACT/2
               YOFF=YOFF-RSZ(ITTL)*RHFACT
               CALL uvPGET('IUTXRO',IUTXRO)
               IF (IUTXRO.NE.0 .AND. LENZ(CTTLZ(ITTL)).GE.2) THEN
                  CALL MSGDMP('W','uvDUT ',
     &                 'LENGTH OF TITLE IS TOO LONG TO CHANGE ROT')
                  CALL SGSTXR(0)
               ELSE
                  CALL SGSTXR(IUTXRO)
               END IF
            ELSE IF (CSIDEZ(ITTL).EQ.'Y') THEN
               XX=XOFF-RSZ(ITTL)*RHFACT/2
               YY=VYULOC+VYUNIT*0.5
               XOFF=XOFF-RSZ(ITTL)*RHFACT
               CALL uvPGET('IUTYRO',IUTYRO)
               IF (IUTYRO.NE.90 .AND. LENZ(CTTLZ(ITTL)).GE.2) THEN
                  CALL MSGDMP('W','uvDUT ',
     &                 'LENGTH OF TITLE IS TOO LONG TO CHANGE ROT')
                  CALL SGSTXR(90)
               ELSE
                  CALL SGSTXR(IUTYRO)
               END IF
            END IF
            
            CALL SGSTXI(IUINDX)

*     / deactivate viewport clipping if active /

            call sgqclp ( icnow )
            if ( icnow .eq. 1 ) then
               call sgsclp ( 0 )
            end if
            
            CALL SGTXV(XX,YY,CTTLZ(ITTL))
            
*     / reset clipping status as before /
            call sgsclp ( icnow )

 10      CONTINUE

      END IF
      
      CALL uvPSET('IUNTTL',0)
      CALL uvPSET('VXUOFF',VXUOFF)
      CALL uvPSET('VYUOFF',VYUOFF)

      RETURN
      END
