/*
 *     dcl graphic driver for tektronix emulator
 *
 *                         91/08/10 by S. Takehiro
 *                         91/10/15 by M. Shiotani
 *                         93/04/15 by A. Numaguti (wait option)
 *                         01/08/11 by E. Toyoda
 *
 *    Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
 *
 */

#include <unistd.h>
#include "../../../config.h"

#define WSXMNZ   30.0        /* x-coord. of w.s. window lower-left  corner */
#define WSXMXZ 1000.0        /* y-coord. of w.s. window lower-left  corner */
#define WSYMNZ   30.0        /* x-coord. of w.s. window upper-right corner */
#define WSYMXZ  750.0        /* y-coord. of w.s. window upper-right corner */
#define FACTZ     2.0        /* scaling factor */
#define TRUE   1             /* numeric value for true  */
#define FALSE  0             /* numeric value for false */
#define LWDATR TRUE          /* line width  capability */
#define LCLATR FALSE         /* line color  capability */
#define LTNATR FALSE         /* hard fill   capability */
#define LIMATR FALSE         /* bit image   capability */
#define LPTATR FALSE         /* mouse point capability */

#define FF   12
#define CR   13
#define ES   27
#define GS   29
#define OP   "[?38h"
#define EX   "[?38l"
#define CL    3

#define fgetc sys_etc
#define fputc sys_ptc
#define fputs sys_puts
#define puts  sys_putln

static int iwdidz, iclidz, iwtroz, lwait;

/* system call input/output, avoid stdio */

#define stdin 0
#define stdout 1

int fgetc(int handle) {
  char dummy;
  if (read(handle, &dummy, 1) < 1)
    return -1;
  return dummy;
}

int fputc(int ch, int handle) {
  char c;
  c = ch;
  if (write(handle, &c, 1) < 1)
    return -1;
  return c;
}

void fputs(const char *c, int handle) {
  size_t len, strlen();
  len = strlen(c);
  write(handle, c, len);
}

void puts(const char *c) {
  size_t len, strlen();
  len = strlen(c);
  write(1, c, len);
  write(1, "\n", 1);
}

/*---------------------internal function ------------------*/

void ztixiy(int ix, int iy)
{
    fputc ((iy / 32) + 32, stdout);
    fputc ((iy % 32) + 96, stdout);
    fputc ((ix / 32) + 32, stdout);
    fputc ((ix % 32) + 64, stdout);
}

/*------------------------- device ------------------------*/

void ztdopn_(DCL_INT *iwait)
{
    int C;

/* open ( and activate ) workstation */

    lwait = *iwait;
    if (lwait) {
	puts("<CR> to start Tek");
	C = fgetc (stdin);
    }
    fputc (ES, stdout);
    fputs (OP, stdout);
    fputc (CR, stdout);
}

void ztdcls_(void)
{

/* ( deactivate and ) close workstation */

    fputc (ES, stdout);
    fputc (CL, stdout);
    fputc (CR, stdout);

    fputc (ES, stdout);
    fputc (FF, stdout);
    fputc (CR, stdout);

    fputc (ES, stdout);
    fputs (EX, stdout);
    fputc (CR, stdout);
}

/*------------------------- page --------------------------*/

void ztpopn_(void)
{

/* open page ( or screen ) */

    fputc (ES, stdout);
    fputc (FF, stdout);
    fputc (CR, stdout);
}

void ztpcls_(void)
{
    int C;
    void ztixiy();

/* close page ( or screen ) */

    fputc (GS, stdout);
    ztixiy (0, 50);
    if (lwait) {
	puts ("\n<CR> to continue");
	C = fgetc (stdin);
    }
}

/*------------------------- object ------------------------*/

void ztoopn_(char *objname, char *comment)
{

}

void ztocls_(char *objname)
{

}

/*------------------------- line --------------------------*/

void ztswdi_(DCL_INT *iwdidx)
{

/* set line width index */

}

void ztscli_(DCL_INT *iclidx)
{

/* set line color index */

}

void ztgopn_(void)
{

/* open graphic segment */

}

void ztgmov_(DCL_REAL *wx, DCL_REAL *wy)
{
    int iwx, iwy;
    void ztixiy();

/* pen-up move */

    iwx = *wx;
    iwy = *wy;
    fputc (GS, stdout);
    ztixiy (iwx, iwy);
}

void ztgplt_(DCL_REAL *wx, DCL_REAL *wy)
{
    int iwx, iwy;
    void ztixiy();

/* pen-down move */

    iwx = *wx;
    iwy = *wy;
    ztixiy (iwx, iwy);
}

void ztgcls_(void)
{

/* close graphic segment */

    fputc (CR, stdout);
}

/*------------------------- tone --------------------------*/

void ztgton_(DCL_INT *np, DCL_REAL wpx[], DCL_REAL wpy[], DCL_INT *itpat)
{

/* hard fill */

}

/*------------------------- image -------------------------*/

void ztiopn_(DCL_INT *iwx, DCL_INT *iwy, DCL_INT *iwidth, DCL_INT *iheight)
{

}

void ztidat_(DCL_INT image[], DCL_INT *nlen)
{

}

void zticls_(void)
{

}

/*------------------------- mouse -------------------------*/

void ztqpnt_(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *mb)
{

}

/*---------------------- transformation -------------------*/

void ztfint_(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *iwx, DCL_INT *iwy)
{
    *iwx = *wx;
    *iwy = *wy;
}

void ztiint_(DCL_INT *iwx, DCL_INT *iwy, DCL_REAL *wx, DCL_REAL *wy)
{
    *wx = *iwx;
    *wy = *iwy;
}

/*------------------------- inquiry -----------------------*/

void ztqwdc_(DCL_INT *lwdatr)
{

/* inquire line width capability */

    *lwdatr = LWDATR;
}

void ztqclc_(DCL_INT *lclatr)
{

/* inquire line color capability */

    *lclatr = LCLATR;
}

void ztqtnc_(DCL_INT *ltnatr)
{

/* inquire hard fill capability */

    *ltnatr = LTNATR;
}

void ztqimc_(DCL_INT *limatr)
{

/* inquire bit image capability */

    *limatr = LIMATR;
}

void ztqptc_(DCL_INT *lptatr)
{

/* inquire mouse point capability */

    *lptatr = LPTATR;
}

void ztqrct_(DCL_REAL *wsxmn, DCL_REAL *wsxmx, DCL_REAL *wsymn, DCL_REAL *wsymx, DCL_REAL *fact)
{

/* inquire workstation rectangle */

    *wsxmn = WSXMNZ;
    *wsxmx = WSXMXZ;
    *wsymn = WSYMNZ;
    *wsymx = WSYMXZ;
    *fact  = FACTZ;
}

void ztsrot_(DCL_INT *iwtrot)
{

/* set frame rotation flag */

    iwtroz = *iwtrot;
}
