*=======================================================================
*     Conversion of bitmap data for Laser Shot
*     Aug. 22, 1991;  S. Sakai
*=======================================================================

      PARAMETER (NPAT=500)
      INTEGER*2 IPAT1, IPAT2, IPOS0, ILEN, IWDTH
      CHARACTER CPAT*32,  CBFL1*32,  CBFL2*32

      WRITE(6,*) ' INPUT & OUTPUT FILE > '
      READ (5,*) CBFL1, CBFL2
      OPEN(1, FILE= CBFL1)
      OPEN(2, FILE= CBFL2, ACCESS='DIRECT', RECL=4)

      READ (2, REC=1) NREC1

      READ (1,'(I4)') NREC
      NREC2 = NREC1+NREC
      WRITE(2, REC=1) NREC2
      IPOS = 1+NPAT+NREC1
      READ (2, REC=IPOS) IPOS0, ILEN

      IPOS0 = IPOS0+ILEN+1
      DO 100 I=NREC1+1, NREC2
        READ(1,'(4I4)') IPAT1, IPAT2, IWDTH, ILEN

        IP1 = MOD(IPAT1, 100)
        IP2 = MOD(IPAT2, 100)
        IF(IP1.NE.IP2) THEN
          WRITE(6,*) 'PATTERN NUMBER MAY BE WRONG ! '
          PAUSE
        ENDIF

        WRITE(2, REC=I+1     ) IPAT1, IPAT2
        WRITE(2, REC=I+NPAT+1) IPOS0, ILEN
        DO 110 J=1, ILEN
          READ(1, '(A32)') CPAT
          CALL BITPCI(CPAT, IPTN)
          WRITE(2, REC=IPOS0) IPTN
          IPOS0 = IPOS0+1
  110   CONTINUE

  100 CONTINUE

      WRITE(6,*) 'LAST POSITION = ', IPOS0-1
      CLOSE(1)
      CLOSE(2)

      STOP
      END
