/* src/math2/fftlib/rffti.f -- translated by f2c (version 20020621).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "libtinyf2c.h"

/* ----------------------------------------------------------------------- */
/*     SUBROUTINE RFFTI(N,WSAVE) */

/*     SUBROUTINE RFFTI INITIALIZES THE ARRAY WSAVE WHICH IS USED IN */
/*     BOTH RFFTF AND RFFTB. THE PRIME FACTORIZATION OF N TOGETHER WITH */
/*     A TABULATION OF THE TRIGONOMETRIC FUNCTIONS ARE COMPUTED AND */
/*     STORED IN WSAVE. */

/*     INPUT PARAMETER */

/*     N       THE LENGTH OF THE SEQUENCE TO BE TRANSFORMED. */

/*     OUTPUT PARAMETER */

/*     WSAVE   A WORK ARRAY WHICH MUST BE DIMENSIONED AT LEAST 2*N+15. */
/*             THE SAME WORK ARRAY CAN BE USED FOR BOTH RFFTF AND RFFTB */
/*             AS LONG AS N REMAINS UNCHANGED. DIFFERENT WSAVE ARRAYS */
/*             ARE REQUIRED FOR DIFFERENT VALUES OF N. THE CONTENTS OF */
/*             WSAVE MUST NOT BE CHANGED BETWEEN CALLS OF RFFTF OR RFFTB. */

/* Subroutine */ int rffti_(integer *n, real *wsave)
{
    extern /* Subroutine */ int rffti1_(integer *, real *, real *);


    /* Parameter adjustments */
    --wsave;

    /* Function Body */
    if (*n == 1) {
	return 0;
    }
    rffti1_(n, &wsave[*n + 1], &wsave[(*n << 1) + 1]);
    return 0;
} /* rffti_ */

