program solver
! ƻ 2007 Υޥ󱲥ǥ
  use gtool_history
  use Derivation
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use file_operate
  use Basis
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use time_scheme
  use make_init
  use sub_calc
  use force_solv

  implicit none

!-- do loop ѿ
  integer :: i, j, it

!-- namelist ɤ߹

  call read_name()

!-- allocating array

  call val_allocate()

!-- ʻκ

  call val_coordinate()

write(*,*) "starting initialization."

!-- ͺ

  call make_initialize()

  write(*,*) "normally pass the initialization."

!-- ϥեν
  call HistoryCreate( file=trim(foname), title='RE87 result data', &
  & source='test', institution='test', dims=(/'r', 'z', 't'/),  &
  & dimsizes=(/nr, nz, 0/),  & 
  & longnames=(/'R-coordinate','Z-coordinate', 'time        '/),  &
  & units=(/'m', 'm', 's'/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'r', r_s(1:nr) )
  call HistoryPut( 'z', z_s(1:nz) )
  
  call HistoryAddVariable( varname='u', dims=(/'r','z','t'/), &
    & longname='R wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'r','z','t'/), &
    & longname='T wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='w', dims=(/'r','z','t'/), &
    & longname='Z wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='p', dims=(/'r','z','t'/), &
    & longname='Pressure', units='Pa', xtype='float')

  call HistoryAddVariable( varname='pt', dims=(/'r','z','t'/), &
    & longname='Potential Temperature', units='K', xtype='float')

  call HistoryAddVariable( varname='qv', dims=(/'r','z','t'/), &
    & longname='Vapor Mixing Ratio', units='kg kg-1', xtype='float')

  call HistoryAddVariable( varname='qt', dims=(/'r','z','t'/), &
    & longname='Condensation Mixing Ratio', units='kg kg-1', xtype='float')

  write(*,*) "time integration start."

  !-- ν (ͤν)

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call dmp_val( r_u, r_s, z_w, z_s,  &
  &             u_old, v_old, w_old, p_old, pb_s, t_old, qv_old, qt_old,  &
  &             u_dmp, v_dmp, w_dmp, p_dmp, t_dmp, qv_dmp, qt_dmp )

  call HistoryPut( 'u', u_dmp(1:nr,1:nz) )
  call HistoryPut( 'v', v_dmp(1:nr,1:nz) )
  call HistoryPut( 'w', w_dmp(1:nr,1:nz) )
  call HistoryPut( 'p', p_dmp(1:nr,1:nz) )
  call HistoryPut( 'pt', t_dmp(1:nr,1:nz) )
  call HistoryPut( 'qv', qv_dmp(1:nr,1:nz) )
  call HistoryPut( 'qt', qt_dmp(1:nr,1:nz) )

!-- solver 

  do it=1,nt

     call time_schematic( it )

  !-- ƥåפοʤ߶
     write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."

     !-- ν (2)
     if(mod(it,dmpstp)==0)then

        call dmp_val( r_u, r_s, z_w, z_s,  &
  &                   u_old, v_old, w_old, p_old, pb_s, t_old, qv_old, qt_old,  &
  &                   u_dmp, v_dmp, w_dmp, p_dmp, t_dmp, qv_dmp, qt_dmp )

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dt, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'u', u_dmp(1:nr,1:nz) )
        call HistoryPut( 'v', v_dmp(1:nr,1:nz) )
        call HistoryPut( 'w', w_dmp(1:nr,1:nz) )
        call HistoryPut( 'p', p_dmp(1:nr,1:nz) )
        call HistoryPut( 'pt', t_dmp(1:nr,1:nz) )
        call HistoryPut( 'qv', qv_dmp(1:nr,1:nz) )
        call HistoryPut( 'qt', qt_dmp(1:nr,1:nz) )

     end if

  end do

!-- solver ȥå

  write(*,*) "solver is normally."

end program
